#include <esyscall.h>
#include <ioshm.h>

#include <unistd.h>
#include <linux/unistd.h>

#include "svio.h"

struct ioshm_hdr* __svio_hdr;
void* __svio_ioshm;
void* __svio_icursor;
void* __svio_iend;
void* __svio_obegin;
void* __svio_ocursor;
void* __svio_olimit;

static int svio_syscall(int sysnr, int param)
{
    asm volatile (
        "int $0x80"
        : : "a" (sysnr), "b" (param)
    );
}

static void svio_exit(int code)
{
    svio_syscall(__NR_exit, code);
}

static void svio_err(const char* msg)
{
    //fprintf(stderr, "svio error: %s\n", msg);
    svio_exit(121);
}

static int svio_memcmp(const char* a, const char* b, int len)
{
    int i;
    for (i=0; i<len; i++)
        if (a[i] != b[i])
            return 1;
    return 0;
}

void __attribute__((constructor)) __svio_init(void)
{
    int res = svio_syscall(__NRe_ioshmget, 0);
    if (res < 0)
        svio_err("e_ioshmget failed");
    res = svio_syscall(__NRe_ioshmat, (int)&__svio_ioshm);
    if (res < 0)
        svio_err("e_ioshmat failed");

    __svio_hdr = (struct ioshm_hdr*)__svio_ioshm;
    if (svio_memcmp(__svio_hdr->magic, "IOSHM", 5))
        svio_err("invalid ioshm signature");

    __svio_obegin = __svio_ioshm + __svio_hdr->odata_offset;
    __svio_olimit = __svio_obegin + __svio_hdr->odata_bufsize;
    __svio_ocursor = __svio_obegin;
}

void __svio_refill(void)
{
    //fprintf(stderr, "svio: refill\n");
    svio_syscall(__NRe_iochunk, 0);
    __svio_icursor = __svio_ioshm + __svio_hdr->idata_offset;
    __svio_iend = __svio_icursor + __svio_hdr->idata_bufsize;
}

void __svio_flush(void)
{
    __svio_hdr->odata_bufsize = __svio_ocursor - __svio_obegin;
    svio_syscall(__NRe_ioflush, 0);
    __svio_ocursor = __svio_obegin;
}

void __svio_formaterror(void)
{
    /*fprintf(stderr, "svio: data format mismatch (%p %p %c)\n",
            __svio_icursor, __svio_iend,
            *(char*)__svio_icursor);*/
    svio_exit(120);
}

void __attribute__((destructor)) __svio_exit(void)
{
    write_newline();
    __svio_flush();
}

