#include <sys/mman.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>

#include "supervisor.h"
#include "prototypes.h"

void* iomap_data;
int   iomap_size;

static void read_entire_stdin(void)
{
    size_t bufsize = 2048;
    size_t off = 0;
    void* buf = malloc(bufsize);
    if (buf == NULL)
        fail_tracker("OOM allocating input buffer");
    for (;;) {
        ssize_t r = read(0, buf+off, bufsize-off);
        if (r == 0) break;
        if (r < 0)
            fail_tracker("error reading from stdin");
        off += r;
        if (off == bufsize) {
            bufsize *= 2;
            buf = realloc(buf, bufsize);
            if (buf == NULL)
                fail_tracker("OOM while growing input buffer");
        }
    }
    iomap_data = buf;
    iomap_size = off;
}

void iomap_entire_stdin(void)
{
    struct stat st;
    int res, ps;
    void* mem;

    ps = getpagesize();

    res = fstat(0, &st);
    if (res < 0)
        fail_tracker("callot fstat() standard input");

    mem = mmap(NULL, (st.st_size/ps + 1)*ps, PROT_READ, MAP_SHARED, 0, 0);
    if (mem == (void*)-1) {
        dbgprintf(stderr, 
                "mmapped input not available, switching to memory buffer\n");
        read_entire_stdin();
        return;
    }
    iomap_data = mem;
    iomap_size = st.st_size;
}

