(*
% File     : TOP022+1 : ILTP v1.1.2
% Domain   : Topology (Homotopy theory)
% Problem  : Homotopy groups
% Version  : [Shu96] axioms : Especial.
% English  :
% Refs     : [Mun75] Munkres (1975), Topology: A First Course
%          : [Sch96] Shults (1996), Email to Geoff Sutcliffe
% Source   : [Sch96]
% Names    :
% Status   : Theorem
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.1.0
% Syntax   : Number of formulae    :    4 (   0 unit)
%            Number of atoms       :   12 (   0 equality)
%            Maximal formula depth :    7 (   6 average)
%            Number of connectives :    8 (   0 ~  ;   0  |;   3  &)
%                                         (   2 <=>;   3 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    5 (   0 propositional; 1-4 arity)
%            Number of functors    :    3 (   1 constant; 0-2 arity)
%            Number of variables   :   14 (   0 singleton;  12 !;   2 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments :
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable path_connected_ : Universe -> Prop.
Variable isomorphic_groups_ : Universe -> Universe -> Prop.
Variable a_path_from_to_in_ : Universe -> Universe -> Universe -> Universe -> Prop.
Variable a_member_of_ : Universe -> Universe -> Prop.
Variable a_group_isomorphism_from_to_ : Universe -> Universe -> Universe -> Prop.

Variable first_homotop_grp_ : Universe -> Universe -> Universe.
Variable alpha_hat_ : Universe -> Universe.

Variable isomorphic_groups_defn_1 : (forall A B : Universe, (isomorphic_groups_ A B <-> (exists F : Universe, a_group_isomorphism_from_to_ F A B))).
Variable path_connected_defn_2 : (forall X X0 X1 : Universe, (path_connected_ X <-> ((a_member_of_ X0 X /\ a_member_of_ X1 X) -> (exists P : Universe, a_path_from_to_in_ P X0 X1 X)))).
Variable m_8_2_1_3 : (forall A X0 X1 X : Universe, (a_path_from_to_in_ A X0 X1 X -> a_group_isomorphism_from_to_ (alpha_hat_ A) (first_homotop_grp_ X X0) (first_homotop_grp_ X X1))).

Theorem m_8_2_2_4 : (forall X X0 X1 : Universe, ((path_connected_ X /\ (a_member_of_ X0 X /\ a_member_of_ X1 X)) -> isomorphic_groups_ (first_homotop_grp_ X X0) (first_homotop_grp_ X X1))).
Proof.
  time hprover.
Qed.

End FOFProblem.
