(*
% File     : TOP021+1 : ILTP v1.1.2
% Domain   : Topology
% Problem  : Locally compact tological space
% Version  : [Shu96] axioms : Especial.
% English  :
% Refs     : [Kel55] Kelley (1955), General Topology
%          : [Sch96] Shults (1996), Email to Geoff Sutcliffe
% Source   : [Sch96]
% Names    :
% Status   : Theorem
% Rating   : 0.00 v3.1.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.1.0
% Syntax   : Number of formulae    :    4 (   2 unit)
%            Number of atoms       :    8 (   0 equality)
%            Maximal formula depth :    7 (   6 average)
%            Number of connectives :    4 (   0 ~  ;   0  |;   2  &)
%                                         (   0 <=>;   2 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    3 (   0 propositional; 1-3 arity)
%            Number of functors    :    3 (   0 constant; 2-3 arity)
%            Number of variables   :   14 (   1 singleton;  14 !;   0 ?)
%            Maximal term depth    :    2 (   2 average)
% Comments :
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable an_open_function_from_onto_ : Universe -> Universe -> Universe -> Prop.
Variable a_locally_compact_top_space_ : Universe -> Prop.
Variable a_continuous_function_from_onto_ : Universe -> Universe -> Universe -> Prop.

Variable the_projection_function_ : Universe -> Universe -> Universe -> Universe.
Variable the_product_top_space_over_ : Universe -> Universe -> Universe.
Variable apply_ : Universe -> Universe -> Universe.

Variable kelley_p90a_1 : (forall A X A1 : Universe, a_continuous_function_from_onto_ (the_projection_function_ A X A1) (the_product_top_space_over_ X A1) (apply_ X A)).
Variable kelley_3_2_2 : (forall A X A1 X1 : Universe, an_open_function_from_onto_ (the_projection_function_ A X A1) (the_product_top_space_over_ X1 A1) (apply_ X1 A)).
Variable kelley_p_147e_3 : (forall F A B : Universe, ((an_open_function_from_onto_ F A B /\ (a_continuous_function_from_onto_ F A B /\ a_locally_compact_top_space_ A)) -> a_locally_compact_top_space_ B)).

Theorem kelley_5_19a_4 : (forall X1 A1 : Universe, (a_locally_compact_top_space_ (the_product_top_space_over_ X1 A1) -> (forall A : Universe, a_locally_compact_top_space_ (apply_ X1 A)))).
Proof.
  time hprover.
Qed.

End FOFProblem.
