(*
% File     : TOP020+1 : ILTP v1.1.2
% Domain   : Topology
% Problem  : Property of a Hausdorff topological space
% Version  : [AMR93] axioms : Especial.
% English  : In a Hausdorff topological space, the diagonal of the space 
%            is closed in the product of the space with itself.
% Refs     : [AMR93] Abraham et al. (1993), Manifolds, Tensor Analysis, and
%            [Shu04] Shults (2004), Email to G. Sutcliffe
% Source   : [Shu04]
% Names    : 
% Status   : Unsatisfiable
% Rating   : 1.00 v3.1.0
% Status (intuit.) : Unsolved
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :    9 (   0 unit)
%            Number of atoms       :   37 (   7 equality)
%            Maximal formula depth :   12 (   8 average)
%            Number of connectives :   31 (   3 ~  ;   0  |;  17  &)
%                                         (   3 <=>;   8 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   0 propositional; 1-2 arity)
%            Number of functors    :    5 (   0 constant; 1-2 arity)
%            Number of variables   :   34 (   0 singleton;  25 !;   9 ?)
%            Maximal term depth    :    3 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable open_in_ : Universe -> Universe -> Prop.
Variable disjoint_ : Universe -> Universe -> Prop.
Variable closed_in_ : Universe -> Universe -> Prop.
Variable a_member_of_ : Universe -> Universe -> Prop.
Variable a_hausdorff_top_space_ : Universe -> Prop.

Variable the_product_top_space_of_ : Universe -> Universe -> Universe.
Variable the_product_of_ : Universe -> Universe -> Universe.
Variable the_ordered_pair_ : Universe -> Universe -> Universe.
Variable the_diagonal_top_ : Universe -> Universe.
Variable coerce_to_class_ : Universe -> Universe.

Variable closed_subset_thm_1 : (forall X A : Universe, ((forall Y : Universe, ((a_member_of_ Y (coerce_to_class_ X) /\ ~(a_member_of_ Y A)) -> (exists G : Universe, (a_member_of_ Y G /\ (open_in_ G X /\ disjoint_ G A))))) -> closed_in_ A X)).
Variable hausdorff_2 : (forall X : Universe, (a_hausdorff_top_space_ X -> (forall A B : Universe, ((a_member_of_ A (coerce_to_class_ X) /\ (a_member_of_ B (coerce_to_class_ X) /\ A <> B)) -> (exists G1 G2 : Universe, (open_in_ G1 X /\ (open_in_ G2 X /\ (a_member_of_ A G1 /\ (a_member_of_ B G2 /\ disjoint_ G1 G2))))))))).
Variable product_of_open_sets_3 : (forall A X B Y : Universe, ((open_in_ A X /\ open_in_ B Y) -> open_in_ (the_product_of_ A B) (the_product_top_space_of_ X Y))).
Variable product_top_4 : (forall S T X : Universe, (a_member_of_ X (coerce_to_class_ (the_product_top_space_of_ S T)) -> (exists A B : Universe, (a_member_of_ A (coerce_to_class_ S) /\ (a_member_of_ B (coerce_to_class_ T) /\ X = (the_ordered_pair_ A B)))))).
Variable product_5 : (forall X S T : Universe, (a_member_of_ X (the_product_of_ S T) <-> (exists A B : Universe, (a_member_of_ A S /\ (a_member_of_ B T /\ X = (the_ordered_pair_ A B)))))).
Variable disjoint_defn_6 : (forall A B : Universe, (disjoint_ A B <-> ~((exists Y : Universe, (a_member_of_ Y A /\ a_member_of_ Y B))))).
Variable ordered_pair_7 : (forall A B C D : Universe, ((the_ordered_pair_ A B) = (the_ordered_pair_ C D) -> (A = C /\ B = D))).
Variable diagonal_top_8 : (forall X S : Universe, (a_member_of_ X (coerce_to_class_ (the_diagonal_top_ S)) <-> (exists A : Universe, (a_member_of_ A (coerce_to_class_ S) /\ X = (the_ordered_pair_ A A))))).

Theorem challenge_AMR_1_4_4_9 : (forall S : Universe, (a_hausdorff_top_space_ S -> closed_in_ (coerce_to_class_ (the_diagonal_top_ S)) (the_product_top_space_of_ S S))).
Proof.
  time hprover.
Qed.

End FOFProblem.
