(*
% File     : SYN722+1 : ILTP v1.1.2
% Domain   : Syntactic
% Problem  : Peter Andrews Problem THM119
% Version  : Especial.
% English  : 
% Refs     : [And97] Andrews (1994), Email to G. Sutcliffe
% Source   : [And97]
% Names    : THM119 [And97]
% Status   : Theorem
% Rating   : 0.22 v3.1.0, 0.00 v2.5.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.50 v1.0.0
% Syntax   : Number of formulae    :    1 (   0 unit)
%            Number of atoms       :   10 (   0 equality)
%            Maximal formula depth :   11 (  11 average)
%            Number of connectives :   16 (   7 ~  ;   6  |;   3  &)
%                                         (   0 <=>;   0 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    3 (   0 propositional; 1-1 arity)
%            Number of functors    :    4 (   4 constant; 0-0 arity)
%            Number of variables   :    3 (   0 singleton;   2 !;   1 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable r_ : Universe -> Prop.
Variable q_ : Universe -> Prop.
Variable p_ : Universe -> Prop.

Variable d_ : Universe.
Variable c_ : Universe.
Variable b_ : Universe.
Variable a_ : Universe.


Theorem thm119_1 : ~(((forall Z : Universe, ((p_ Z \/ r_ Z) /\ q_ Z)) /\ ((forall X : Universe, (exists Y : Universe, (p_ X \/ (~(q_ X) \/ (~(q_ Y) \/ (~(q_ c_) \/ ~(q_ d_))))))) /\ (~(p_ a_) \/ ~(p_ b_))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
