(*
% File     : SYN549+1 : ILTP v1.1.2
% Domain   : Syntactic (Translated)
% Problem  : dia box(dia(p or dia q) <=> (dia p or dia q))
% Version  : Especial.
% English  : 
% Refs     : [Wei94] Weidenbach (1994), Email to G. Sutcliffe
%          : [Che80] Chellas (1980), Modal Logic
% Source   : [Wei94]
% Names    : 
% Status   : Theorem
% Rating   : 0.33 v3.1.0, 0.17 v2.7.0, 0.00 v2.5.0, 0.33 v2.4.0, 0.33 v2.2.1
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.0.0
% Syntax   : Number of formulae    :    3 (   1 unit)
%            Number of atoms       :   14 (   0 equality)
%            Maximal formula depth :   11 (   6 average)
%            Number of connectives :   11 (   0 ~  ;   2  |;   6  &)
%                                         (   1 <=>;   2 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    3 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :   10 (   0 singleton;   5 !;   5 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : These are modal logic problems translated to FOF. The problems 
%            can be easily solved by theorem proving methods for modal logic, 
%            but their (naive) translation into first-order logic results in 
%            hard first-order problems. The first-order translation of the 
%            box, diamond operators is:
%                [box P]x  :=  (all y R(x,y) -> [P]y)
%                [dia P]x  :=  (exists R(x,y) & [P]y)
%                [P]x  :=  P(x)  if P is an atom
%            where we start with some initial context 'o' (the initial world),
%            i.e. we translate a formula P into [P]o. [Wei94]
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable reachable_ : Universe -> Universe -> Prop.
Variable q_ : Universe -> Prop.
Variable p_ : Universe -> Prop.

Variable initial_world_ : Universe.

Variable reflexivity_of_reachable_1 : (forall X : Universe, reachable_ X X).
Variable transitivity_of_reachable_2 : (forall X Y Z : Universe, ((reachable_ X Y /\ reachable_ Y Z) -> reachable_ X Z)).

Theorem prove_this_3 : (exists X : Universe, (reachable_ initial_world_ X /\ (forall Y : Universe, (reachable_ X Y -> ((exists Z : Universe, (reachable_ Y Z /\ (p_ Z \/ (exists V : Universe, (reachable_ Z V /\ q_ V))))) <-> ((exists W : Universe, (reachable_ Y W /\ p_ W)) \/ (exists W : Universe, (reachable_ Y W /\ q_ W)))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
