(*
% File     : SYN515+1 : ILTP v1.1.2
% Domain   : Syntactic (Translated)
% Problem  : ALC, N=5, R=1, L=15, K=3, D=2, P=0, Index=016
% Version  : Especial.
% English  : 
% Refs     : [OS95]  Ohlbach & Schmidt (1995), Functional Translation and S
%          : [HS97]  Hustadt & Schmidt (1997), On Evaluating Decision Proce
%          : [Wei97] Weidenbach (1997), Email to G. Sutcliffe
% Source   : [Wei97]
% Names    : alc-5-1-15-3-2-016.dfg [Wei97]
% Status   : CounterSatisfiable
% Rating   : 0.00 v3.1.0, 0.17 v2.6.0, 0.25 v2.5.0, 0.33 v2.4.0, 0.00 v2.1.0
% Status (intuit.) : Unsolved
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :    1 (   0 unit)
%            Number of atoms       :  178 (   0 equality)
%            Maximal formula depth :   25 (  25 average)
%            Number of connectives :  248 (  71 ~  ;  68  |;  84  &)
%                                         (   0 <=>;  25 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   17 (   6 propositional; 0-2 arity)
%            Number of functors    :   26 (  26 constant; 0-0 arity)
%            Number of variables   :   25 (   0 singleton;  25 !;   0 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : These ALC problems have been translated from propositional 
%            multi-modal K logic formulae generated according to the scheme
%            described in [HS97], using the optimized functional translation
%            described in [OS95]. The finite model property holds, the
%            Herbrand Universe is finite, they are decidable (the complexity
%            is PSPACE-complete), resolution + subsumption + condensing is a
%            decision procedure, and the translated formulae belong to the
%            (CNF-translation of the) Bernays-Schoenfinkel class [Wei97].
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable ndr1_1_ : Universe -> Prop.
Variable ndr1_0_ : Prop.
Variable c5_2_ : Universe -> Universe -> Prop.
Variable c5_1_ : Universe -> Prop.
Variable c5_0_ : Prop.
Variable c4_2_ : Universe -> Universe -> Prop.
Variable c4_1_ : Universe -> Prop.
Variable c4_0_ : Prop.
Variable c3_2_ : Universe -> Universe -> Prop.
Variable c3_1_ : Universe -> Prop.
Variable c3_0_ : Prop.
Variable c2_2_ : Universe -> Universe -> Prop.
Variable c2_1_ : Universe -> Prop.
Variable c2_0_ : Prop.
Variable c1_2_ : Universe -> Universe -> Prop.
Variable c1_1_ : Universe -> Prop.
Variable c1_0_ : Prop.

Variable a9_ : Universe.
Variable a8_ : Universe.
Variable a7_ : Universe.
Variable a6_ : Universe.
Variable a5_ : Universe.
Variable a4_ : Universe.
Variable a3_ : Universe.
Variable a26_ : Universe.
Variable a25_ : Universe.
Variable a24_ : Universe.
Variable a23_ : Universe.
Variable a22_ : Universe.
Variable a21_ : Universe.
Variable a20_ : Universe.
Variable a2_ : Universe.
Variable a19_ : Universe.
Variable a18_ : Universe.
Variable a17_ : Universe.
Variable a16_ : Universe.
Variable a15_ : Universe.
Variable a14_ : Universe.
Variable a13_ : Universe.
Variable a12_ : Universe.
Variable a11_ : Universe.
Variable a10_ : Universe.
Variable a1_ : Universe.


Theorem co1_1 : ~((((forall U : Universe, (ndr1_0_ -> ((ndr1_1_ U /\ (~(c3_2_ U a1_) /\ (c5_2_ U a1_ /\ ~(c1_2_ U a1_)))) \/ ((ndr1_1_ U /\ (c3_2_ U a2_ /\ ~(c5_2_ U a2_))) \/ ~(c1_1_ U))))) \/ (~(c3_0_) \/ c5_0_)) /\ (((ndr1_0_ /\ ((forall V : Universe, (ndr1_1_ a3_ -> (~(c5_2_ a3_ V) \/ (~(c1_2_ a3_ V) \/ c3_2_ a3_ V)))) /\ (~(c5_1_ a3_) /\ ~(c3_1_ a3_)))) \/ (c1_0_ \/ (forall W : Universe, (ndr1_0_ -> (~(c3_1_ W) \/ (~(c5_1_ W) \/ (forall X : Universe, (ndr1_1_ W -> (~(c5_2_ W X) \/ (~(c3_2_ W X) \/ ~(c4_2_ W X))))))))))) /\ ((c4_0_ \/ ((ndr1_0_ /\ ((forall Y : Universe, (ndr1_1_ a4_ -> (~(c4_2_ a4_ Y) \/ (~(c5_2_ a4_ Y) \/ c3_2_ a4_ Y)))) /\ ((forall Z : Universe, (ndr1_1_ a4_ -> (c3_2_ a4_ Z \/ ~(c2_2_ a4_ Z)))) /\ (forall X1 : Universe, (ndr1_1_ a4_ -> (c4_2_ a4_ X1 \/ (~(c3_2_ a4_ X1) \/ ~(c5_2_ a4_ X1)))))))) \/ (forall X2 : Universe, (ndr1_0_ -> (~(c3_1_ X2) \/ ((ndr1_1_ X2 /\ (~(c5_2_ X2 a5_) /\ (c4_2_ X2 a5_ /\ ~(c1_2_ X2 a5_)))) \/ (ndr1_1_ X2 /\ (c3_2_ X2 a6_ /\ (c2_2_ X2 a6_ /\ ~(c5_2_ X2 a6_)))))))))) /\ ((~(c4_0_) \/ (~(c1_0_) \/ c5_0_)) /\ ((~(c1_0_) \/ ((ndr1_0_ /\ (~(c1_1_ a7_) /\ (~(c3_1_ a7_) /\ c4_1_ a7_))) \/ c2_0_)) /\ (((ndr1_0_ /\ (~(c3_1_ a8_) /\ (c1_1_ a8_ /\ (ndr1_1_ a8_ /\ (~(c2_2_ a8_ a9_) /\ (c3_2_ a8_ a9_ /\ c1_2_ a8_ a9_)))))) \/ ((ndr1_0_ /\ (c5_1_ a10_ /\ (ndr1_1_ a10_ /\ (c5_2_ a10_ a11_ /\ (c2_2_ a10_ a11_ /\ (~(c1_2_ a10_ a11_) /\ c1_1_ a10_)))))) \/ ~(c4_0_))) /\ ((c4_0_ \/ ((ndr1_0_ /\ (c4_1_ a12_ /\ (c3_1_ a12_ /\ ~(c5_1_ a12_)))) \/ (ndr1_0_ /\ (~(c4_1_ a13_) /\ ((forall X3 : Universe, (ndr1_1_ a13_ -> (c1_2_ a13_ X3 \/ (c3_2_ a13_ X3 \/ ~(c5_2_ a13_ X3))))) /\ (forall X4 : Universe, (ndr1_1_ a13_ -> (c4_2_ a13_ X4 \/ c3_2_ a13_ X4)))))))) /\ (((forall X5 : Universe, (ndr1_0_ -> (c2_1_ X5 \/ c5_1_ X5))) \/ ((ndr1_0_ /\ ((forall X6 : Universe, (ndr1_1_ a14_ -> (c5_2_ a14_ X6 \/ ~(c3_2_ a14_ X6)))) /\ (c5_1_ a14_ /\ (ndr1_1_ a14_ /\ (~(c3_2_ a14_ a15_) /\ (c1_2_ a14_ a15_ /\ ~(c2_2_ a14_ a15_))))))) \/ (ndr1_0_ /\ ((forall X7 : Universe, (ndr1_1_ a16_ -> (~(c4_2_ a16_ X7) \/ (~(c1_2_ a16_ X7) \/ ~(c3_2_ a16_ X7))))) /\ (~(c3_1_ a16_) /\ ~(c5_1_ a16_)))))) /\ (((forall X8 : Universe, (ndr1_0_ -> (~(c5_1_ X8) \/ (~(c2_1_ X8) \/ (ndr1_1_ X8 /\ (c5_2_ X8 a17_ /\ (c1_2_ X8 a17_ /\ ~(c4_2_ X8 a17_)))))))) \/ (~(c5_0_) \/ (forall X9 : Universe, (ndr1_0_ -> ((ndr1_1_ X9 /\ (c2_2_ X9 a18_ /\ c3_2_ X9 a18_)) \/ (c1_1_ X9 \/ (forall X10 : Universe, (ndr1_1_ X9 -> (~(c4_2_ X9 X10) \/ (c3_2_ X9 X10 \/ c1_2_ X9 X10)))))))))) /\ ((~(c4_0_) \/ ((forall X11 : Universe, (ndr1_0_ -> (~(c4_1_ X11) \/ (~(c3_1_ X11) \/ ~(c2_1_ X11))))) \/ (ndr1_0_ /\ (~(c2_1_ a19_) /\ (ndr1_1_ a19_ /\ (c3_2_ a19_ a20_ /\ (~(c4_2_ a19_ a20_) /\ (forall X12 : Universe, (ndr1_1_ a19_ -> (~(c3_2_ a19_ X12) \/ ~(c4_2_ a19_ X12))))))))))) /\ ((~(c3_0_) \/ ((forall X13 : Universe, (ndr1_0_ -> (~(c5_1_ X13) \/ ((ndr1_1_ X13 /\ (~(c1_2_ X13 a21_) /\ (~(c4_2_ X13 a21_) /\ c5_2_ X13 a21_))) \/ (forall X14 : Universe, (ndr1_1_ X13 -> (~(c2_2_ X13 X14) \/ (~(c4_2_ X13 X14) \/ ~(c1_2_ X13 X14))))))))) \/ c4_0_)) /\ ((forall X15 : Universe, (ndr1_0_ -> ((ndr1_1_ X15 /\ (c4_2_ X15 a22_ /\ (c5_2_ X15 a22_ /\ c2_2_ X15 a22_))) \/ ((ndr1_1_ X15 /\ (c2_2_ X15 a23_ /\ (c4_2_ X15 a23_ /\ ~(c5_2_ X15 a23_)))) \/ (forall X16 : Universe, (ndr1_1_ X15 -> (c5_2_ X15 X16 \/ c4_2_ X15 X16))))))) \/ ((ndr1_0_ /\ ((forall X17 : Universe, (ndr1_1_ a24_ -> (~(c1_2_ a24_ X17) \/ (~(c2_2_ a24_ X17) \/ c4_2_ a24_ X17)))) /\ (ndr1_1_ a24_ /\ (c1_2_ a24_ a25_ /\ (c3_2_ a24_ a25_ /\ (forall X18 : Universe, (ndr1_1_ a24_ -> (~(c4_2_ a24_ X18) \/ (c1_2_ a24_ X18 \/ ~(c3_2_ a24_ X18)))))))))) \/ (ndr1_0_ /\ (~(c5_1_ a26_) /\ (forall X19 : Universe, (ndr1_1_ a26_ -> (c2_2_ a26_ X19 \/ (c4_2_ a26_ X19 \/ ~(c1_2_ a26_ X19))))))))))))))))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
