(*
% File     : SYN465+1 : ILTP v1.1.2
% Domain   : Syntactic (Translated)
% Problem  : ALC, N=4, R=1, L=68, K=3, D=1, P=0, Index=010
% Version  : Especial.
% English  : 
% Refs     : [OS95]  Ohlbach & Schmidt (1995), Functional Translation and S
%          : [HS97]  Hustadt & Schmidt (1997), On Evaluating Decision Proce
%          : [Wei97] Weidenbach (1997), Email to G. Sutcliffe
% Source   : [Wei97]
% Names    : alc-4-1-68-3-1-010.dfg [Wei97]
% Status   : Theorem
% Rating   : 0.33 v3.1.0, 0.67 v2.7.0, 0.33 v2.6.0, 0.00 v2.5.0, 0.33 v2.4.0, 0.33 v2.2.1, 0.50 v2.2.0, 0.00 v2.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :    1 (   0 unit)
%            Number of atoms       :  668 (   0 equality)
%            Maximal formula depth :  103 ( 103 average)
%            Number of connectives :  913 ( 246 ~  ; 370  |; 195  &)
%                                         (   0 <=>; 102 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   37 (  33 propositional; 0-1 arity)
%            Number of functors    :   32 (  32 constant; 0-0 arity)
%            Number of variables   :  102 (   0 singleton; 102 !;   0 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : These ALC problems have been translated from propositional 
%            multi-modal K logic formulae generated according to the scheme
%            described in [HS97], using the optimized functional translation
%            described in [OS95]. The finite model property holds, the
%            Herbrand Universe is finite, they are decidable (the complexity
%            is PSPACE-complete), resolution + subsumption + condensing is a
%            decision procedure, and the translated formulae belong to the
%            (CNF-translation of the) Bernays-Schoenfinkel class [Wei97].
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable ndr1_0_ : Prop.
Variable hskp9_ : Prop.
Variable hskp8_ : Prop.
Variable hskp7_ : Prop.
Variable hskp6_ : Prop.
Variable hskp5_ : Prop.
Variable hskp4_ : Prop.
Variable hskp31_ : Prop.
Variable hskp30_ : Prop.
Variable hskp3_ : Prop.
Variable hskp29_ : Prop.
Variable hskp28_ : Prop.
Variable hskp27_ : Prop.
Variable hskp26_ : Prop.
Variable hskp25_ : Prop.
Variable hskp24_ : Prop.
Variable hskp23_ : Prop.
Variable hskp22_ : Prop.
Variable hskp21_ : Prop.
Variable hskp20_ : Prop.
Variable hskp2_ : Prop.
Variable hskp19_ : Prop.
Variable hskp18_ : Prop.
Variable hskp17_ : Prop.
Variable hskp16_ : Prop.
Variable hskp15_ : Prop.
Variable hskp14_ : Prop.
Variable hskp13_ : Prop.
Variable hskp12_ : Prop.
Variable hskp11_ : Prop.
Variable hskp10_ : Prop.
Variable hskp1_ : Prop.
Variable hskp0_ : Prop.
Variable c3_1_ : Universe -> Prop.
Variable c2_1_ : Universe -> Prop.
Variable c1_1_ : Universe -> Prop.
Variable c0_1_ : Universe -> Prop.

Variable a9_ : Universe.
Variable a8_ : Universe.
Variable a76_ : Universe.
Variable a7_ : Universe.
Variable a65_ : Universe.
Variable a6_ : Universe.
Variable a57_ : Universe.
Variable a54_ : Universe.
Variable a52_ : Universe.
Variable a5_ : Universe.
Variable a42_ : Universe.
Variable a40_ : Universe.
Variable a4_ : Universe.
Variable a39_ : Universe.
Variable a36_ : Universe.
Variable a35_ : Universe.
Variable a33_ : Universe.
Variable a32_ : Universe.
Variable a30_ : Universe.
Variable a29_ : Universe.
Variable a28_ : Universe.
Variable a26_ : Universe.
Variable a24_ : Universe.
Variable a21_ : Universe.
Variable a20_ : Universe.
Variable a2_ : Universe.
Variable a17_ : Universe.
Variable a15_ : Universe.
Variable a13_ : Universe.
Variable a12_ : Universe.
Variable a10_ : Universe.
Variable a1_ : Universe.


Theorem co1_1 : ~(((~(hskp0_) \/ (ndr1_0_ /\ (c0_1_ a1_ /\ (~(c1_1_ a1_) /\ ~(c2_1_ a1_))))) /\ ((~(hskp1_) \/ (ndr1_0_ /\ (c0_1_ a4_ /\ (c2_1_ a4_ /\ ~(c1_1_ a4_))))) /\ ((~(hskp2_) \/ (ndr1_0_ /\ (c2_1_ a5_ /\ (~(c0_1_ a5_) /\ ~(c1_1_ a5_))))) /\ ((~(hskp3_) \/ (ndr1_0_ /\ (c0_1_ a6_ /\ (c3_1_ a6_ /\ ~(c2_1_ a6_))))) /\ ((~(hskp4_) \/ (ndr1_0_ /\ (c1_1_ a7_ /\ (c3_1_ a7_ /\ ~(c0_1_ a7_))))) /\ ((~(hskp5_) \/ (ndr1_0_ /\ (~(c0_1_ a9_) /\ (~(c1_1_ a9_) /\ ~(c2_1_ a9_))))) /\ ((~(hskp6_) \/ (ndr1_0_ /\ (c2_1_ a10_ /\ (~(c1_1_ a10_) /\ ~(c3_1_ a10_))))) /\ ((~(hskp7_) \/ (ndr1_0_ /\ (c0_1_ a12_ /\ (c1_1_ a12_ /\ ~(c3_1_ a12_))))) /\ ((~(hskp8_) \/ (ndr1_0_ /\ (c1_1_ a13_ /\ (c2_1_ a13_ /\ ~(c0_1_ a13_))))) /\ ((~(hskp9_) \/ (ndr1_0_ /\ (~(c1_1_ a15_) /\ (~(c2_1_ a15_) /\ ~(c3_1_ a15_))))) /\ ((~(hskp10_) \/ (ndr1_0_ /\ (c1_1_ a17_ /\ (~(c0_1_ a17_) /\ ~(c2_1_ a17_))))) /\ ((~(hskp11_) \/ (ndr1_0_ /\ (c0_1_ a21_ /\ (~(c2_1_ a21_) /\ ~(c3_1_ a21_))))) /\ ((~(hskp12_) \/ (ndr1_0_ /\ (c1_1_ a24_ /\ (c3_1_ a24_ /\ ~(c2_1_ a24_))))) /\ ((~(hskp13_) \/ (ndr1_0_ /\ (c3_1_ a26_ /\ (~(c0_1_ a26_) /\ ~(c1_1_ a26_))))) /\ ((~(hskp14_) \/ (ndr1_0_ /\ (c2_1_ a28_ /\ (c3_1_ a28_ /\ ~(c0_1_ a28_))))) /\ ((~(hskp15_) \/ (ndr1_0_ /\ (c1_1_ a29_ /\ (~(c2_1_ a29_) /\ ~(c3_1_ a29_))))) /\ ((~(hskp16_) \/ (ndr1_0_ /\ (c2_1_ a30_ /\ (c3_1_ a30_ /\ ~(c1_1_ a30_))))) /\ ((~(hskp17_) \/ (ndr1_0_ /\ (c0_1_ a32_ /\ (c2_1_ a32_ /\ ~(c3_1_ a32_))))) /\ ((~(hskp18_) \/ (ndr1_0_ /\ (c1_1_ a33_ /\ (c2_1_ a33_ /\ ~(c3_1_ a33_))))) /\ ((~(hskp19_) \/ (ndr1_0_ /\ (c1_1_ a35_ /\ (~(c0_1_ a35_) /\ ~(c3_1_ a35_))))) /\ ((~(hskp20_) \/ (ndr1_0_ /\ (c0_1_ a36_ /\ (c1_1_ a36_ /\ ~(c2_1_ a36_))))) /\ ((~(hskp21_) \/ (ndr1_0_ /\ (c2_1_ a39_ /\ (~(c0_1_ a39_) /\ ~(c3_1_ a39_))))) /\ ((~(hskp22_) \/ (ndr1_0_ /\ (~(c0_1_ a40_) /\ (~(c2_1_ a40_) /\ ~(c3_1_ a40_))))) /\ ((~(hskp23_) \/ (ndr1_0_ /\ (c0_1_ a42_ /\ (~(c1_1_ a42_) /\ ~(c3_1_ a42_))))) /\ ((~(hskp24_) \/ (ndr1_0_ /\ (c3_1_ a52_ /\ (~(c0_1_ a52_) /\ ~(c2_1_ a52_))))) /\ ((~(hskp25_) \/ (ndr1_0_ /\ (c0_1_ a54_ /\ (c3_1_ a54_ /\ ~(c1_1_ a54_))))) /\ ((~(hskp26_) \/ (ndr1_0_ /\ (~(c0_1_ a57_) /\ (~(c1_1_ a57_) /\ ~(c3_1_ a57_))))) /\ ((~(hskp27_) \/ (ndr1_0_ /\ (c3_1_ a65_ /\ (~(c1_1_ a65_) /\ ~(c2_1_ a65_))))) /\ ((~(hskp28_) \/ (ndr1_0_ /\ (c0_1_ a2_ /\ (c1_1_ a2_ /\ c2_1_ a2_)))) /\ ((~(hskp29_) \/ (ndr1_0_ /\ (c1_1_ a8_ /\ (c2_1_ a8_ /\ c3_1_ a8_)))) /\ ((~(hskp30_) \/ (ndr1_0_ /\ (c0_1_ a20_ /\ (c2_1_ a20_ /\ c3_1_ a20_)))) /\ ((~(hskp31_) \/ (ndr1_0_ /\ (c0_1_ a76_ /\ (c1_1_ a76_ /\ c3_1_ a76_)))) /\ (((forall U : Universe, (ndr1_0_ -> (c0_1_ U \/ (c1_1_ U \/ c2_1_ U)))) \/ ((forall V : Universe, (ndr1_0_ -> (c0_1_ V \/ (~(c2_1_ V) \/ ~(c3_1_ V))))) \/ (forall W : Universe, (ndr1_0_ -> (c2_1_ W \/ (~(c1_1_ W) \/ ~(c3_1_ W))))))) /\ (((forall X : Universe, (ndr1_0_ -> (c0_1_ X \/ (c1_1_ X \/ c2_1_ X)))) \/ ((forall Y : Universe, (ndr1_0_ -> (c1_1_ Y \/ (~(c0_1_ Y) \/ ~(c2_1_ Y))))) \/ hskp0_)) /\ (((forall Z : Universe, (ndr1_0_ -> (c0_1_ Z \/ (c1_1_ Z \/ c2_1_ Z)))) \/ (hskp28_ \/ hskp0_)) /\ (((forall X1 : Universe, (ndr1_0_ -> (c0_1_ X1 \/ (c1_1_ X1 \/ c3_1_ X1)))) \/ ((forall X2 : Universe, (ndr1_0_ -> (c0_1_ X2 \/ (c2_1_ X2 \/ ~(c3_1_ X2))))) \/ hskp1_)) /\ (((forall X3 : Universe, (ndr1_0_ -> (c0_1_ X3 \/ (c1_1_ X3 \/ c3_1_ X3)))) \/ ((forall X4 : Universe, (ndr1_0_ -> (c2_1_ X4 \/ (c3_1_ X4 \/ ~(c1_1_ X4))))) \/ hskp2_)) /\ (((forall X5 : Universe, (ndr1_0_ -> (c0_1_ X5 \/ (c1_1_ X5 \/ ~(c2_1_ X5))))) \/ ((forall X6 : Universe, (ndr1_0_ -> (c0_1_ X6 \/ (c2_1_ X6 \/ ~(c1_1_ X6))))) \/ (forall X7 : Universe, (ndr1_0_ -> (c0_1_ X7 \/ (c3_1_ X7 \/ ~(c2_1_ X7))))))) /\ (((forall X8 : Universe, (ndr1_0_ -> (c0_1_ X8 \/ (c1_1_ X8 \/ ~(c3_1_ X8))))) \/ ((forall X9 : Universe, (ndr1_0_ -> (c2_1_ X9 \/ (~(c0_1_ X9) \/ ~(c1_1_ X9))))) \/ hskp3_)) /\ (((forall X10 : Universe, (ndr1_0_ -> (c0_1_ X10 \/ (c2_1_ X10 \/ c3_1_ X10)))) \/ ((forall X11 : Universe, (ndr1_0_ -> (c0_1_ X11 \/ (c2_1_ X11 \/ ~(c3_1_ X11))))) \/ hskp4_)) /\ (((forall X12 : Universe, (ndr1_0_ -> (c0_1_ X12 \/ (c2_1_ X12 \/ c3_1_ X12)))) \/ (hskp29_ \/ hskp5_)) /\ (((forall X13 : Universe, (ndr1_0_ -> (c0_1_ X13 \/ (c2_1_ X13 \/ ~(c1_1_ X13))))) \/ ((forall X14 : Universe, (ndr1_0_ -> (c0_1_ X14 \/ (c3_1_ X14 \/ ~(c1_1_ X14))))) \/ hskp6_)) /\ (((forall X15 : Universe, (ndr1_0_ -> (c0_1_ X15 \/ (c2_1_ X15 \/ ~(c1_1_ X15))))) \/ ((forall X16 : Universe, (ndr1_0_ -> (c3_1_ X16 \/ (~(c0_1_ X16) \/ ~(c1_1_ X16))))) \/ (forall X17 : Universe, (ndr1_0_ -> (~(c0_1_ X17) \/ (~(c1_1_ X17) \/ ~(c3_1_ X17))))))) /\ (((forall X18 : Universe, (ndr1_0_ -> (c0_1_ X18 \/ (c2_1_ X18 \/ ~(c1_1_ X18))))) \/ ((forall X19 : Universe, (ndr1_0_ -> (~(c0_1_ X19) \/ (~(c2_1_ X19) \/ ~(c3_1_ X19))))) \/ hskp28_)) /\ (((forall X20 : Universe, (ndr1_0_ -> (c0_1_ X20 \/ (c2_1_ X20 \/ ~(c1_1_ X20))))) \/ (hskp7_ \/ hskp8_)) /\ (((forall X21 : Universe, (ndr1_0_ -> (c0_1_ X21 \/ (c2_1_ X21 \/ ~(c1_1_ X21))))) \/ (hskp0_ \/ hskp9_)) /\ (((forall X22 : Universe, (ndr1_0_ -> (c0_1_ X22 \/ (c2_1_ X22 \/ ~(c3_1_ X22))))) \/ ((forall X23 : Universe, (ndr1_0_ -> (c0_1_ X23 \/ (~(c1_1_ X23) \/ ~(c2_1_ X23))))) \/ (forall X24 : Universe, (ndr1_0_ -> (~(c1_1_ X24) \/ (~(c2_1_ X24) \/ ~(c3_1_ X24))))))) /\ (((forall X25 : Universe, (ndr1_0_ -> (c0_1_ X25 \/ (c2_1_ X25 \/ ~(c3_1_ X25))))) \/ ((forall X26 : Universe, (ndr1_0_ -> (c1_1_ X26 \/ (c3_1_ X26 \/ ~(c0_1_ X26))))) \/ hskp7_)) /\ (((forall X27 : Universe, (ndr1_0_ -> (c0_1_ X27 \/ (c2_1_ X27 \/ ~(c3_1_ X27))))) \/ ((forall X28 : Universe, (ndr1_0_ -> (c1_1_ X28 \/ (c3_1_ X28 \/ ~(c0_1_ X28))))) \/ hskp10_)) /\ (((forall X29 : Universe, (ndr1_0_ -> (c0_1_ X29 \/ (c2_1_ X29 \/ ~(c3_1_ X29))))) \/ ((forall X30 : Universe, (ndr1_0_ -> (c3_1_ X30 \/ (~(c0_1_ X30) \/ ~(c1_1_ X30))))) \/ hskp5_)) /\ (((forall X31 : Universe, (ndr1_0_ -> (c0_1_ X31 \/ (c2_1_ X31 \/ ~(c3_1_ X31))))) \/ ((forall X32 : Universe, (ndr1_0_ -> (~(c0_1_ X32) \/ (~(c1_1_ X32) \/ ~(c3_1_ X32))))) \/ hskp5_)) /\ (((forall X33 : Universe, (ndr1_0_ -> (c0_1_ X33 \/ (c2_1_ X33 \/ ~(c3_1_ X33))))) \/ (hskp30_ \/ hskp11_)) /\ (((forall X34 : Universe, (ndr1_0_ -> (c0_1_ X34 \/ (c3_1_ X34 \/ ~(c1_1_ X34))))) \/ (hskp30_ \/ hskp8_)) /\ (((forall X35 : Universe, (ndr1_0_ -> (c0_1_ X35 \/ (c3_1_ X35 \/ ~(c1_1_ X35))))) \/ hskp12_) /\ (((forall X36 : Universe, (ndr1_0_ -> (c0_1_ X36 \/ (c3_1_ X36 \/ ~(c2_1_ X36))))) \/ ((forall X37 : Universe, (ndr1_0_ -> (c1_1_ X37 \/ (~(c2_1_ X37) \/ ~(c3_1_ X37))))) \/ hskp8_)) /\ (((forall X38 : Universe, (ndr1_0_ -> (c0_1_ X38 \/ (c3_1_ X38 \/ ~(c2_1_ X38))))) \/ ((forall X39 : Universe, (ndr1_0_ -> (c2_1_ X39 \/ (c3_1_ X39 \/ ~(c0_1_ X39))))) \/ (forall X40 : Universe, (ndr1_0_ -> (c3_1_ X40 \/ (~(c0_1_ X40) \/ ~(c1_1_ X40))))))) /\ (((forall X41 : Universe, (ndr1_0_ -> (c0_1_ X41 \/ (c3_1_ X41 \/ ~(c2_1_ X41))))) \/ ((forall X42 : Universe, (ndr1_0_ -> (c2_1_ X42 \/ (c3_1_ X42 \/ ~(c1_1_ X42))))) \/ hskp13_)) /\ (((forall X43 : Universe, (ndr1_0_ -> (c0_1_ X43 \/ (c3_1_ X43 \/ ~(c2_1_ X43))))) \/ (hskp3_ \/ hskp14_)) /\ (((forall X44 : Universe, (ndr1_0_ -> (c0_1_ X44 \/ (c3_1_ X44 \/ ~(c2_1_ X44))))) \/ (hskp15_ \/ hskp16_)) /\ (((forall X45 : Universe, (ndr1_0_ -> (c0_1_ X45 \/ (~(c1_1_ X45) \/ ~(c2_1_ X45))))) \/ ((forall X46 : Universe, (ndr1_0_ -> (c0_1_ X46 \/ (~(c1_1_ X46) \/ ~(c3_1_ X46))))) \/ (forall X47 : Universe, (ndr1_0_ -> (c1_1_ X47 \/ (c3_1_ X47 \/ ~(c0_1_ X47))))))) /\ (((forall X48 : Universe, (ndr1_0_ -> (c0_1_ X48 \/ (~(c1_1_ X48) \/ ~(c2_1_ X48))))) \/ ((forall X49 : Universe, (ndr1_0_ -> (c3_1_ X49 \/ (~(c0_1_ X49) \/ ~(c1_1_ X49))))) \/ hskp30_)) /\ (((forall X50 : Universe, (ndr1_0_ -> (c0_1_ X50 \/ (~(c1_1_ X50) \/ ~(c2_1_ X50))))) \/ (hskp17_ \/ hskp18_)) /\ (((forall X51 : Universe, (ndr1_0_ -> (c0_1_ X51 \/ (~(c1_1_ X51) \/ ~(c3_1_ X51))))) \/ (hskp11_ \/ hskp19_)) /\ (((forall X52 : Universe, (ndr1_0_ -> (c0_1_ X52 \/ (~(c2_1_ X52) \/ ~(c3_1_ X52))))) \/ (hskp20_ \/ hskp4_)) /\ (((forall X53 : Universe, (ndr1_0_ -> (c1_1_ X53 \/ (c2_1_ X53 \/ c3_1_ X53)))) \/ ((forall X54 : Universe, (ndr1_0_ -> (c1_1_ X54 \/ (~(c0_1_ X54) \/ ~(c2_1_ X54))))) \/ (forall X55 : Universe, (ndr1_0_ -> (~(c0_1_ X55) \/ (~(c2_1_ X55) \/ ~(c3_1_ X55))))))) /\ (((forall X56 : Universe, (ndr1_0_ -> (c1_1_ X56 \/ (c2_1_ X56 \/ c3_1_ X56)))) \/ ((forall X57 : Universe, (ndr1_0_ -> (c1_1_ X57 \/ (~(c2_1_ X57) \/ ~(c3_1_ X57))))) \/ hskp8_)) /\ (((forall X58 : Universe, (ndr1_0_ -> (c1_1_ X58 \/ (c2_1_ X58 \/ c3_1_ X58)))) \/ ((forall X59 : Universe, (ndr1_0_ -> (c3_1_ X59 \/ (~(c0_1_ X59) \/ ~(c1_1_ X59))))) \/ hskp21_)) /\ (((forall X60 : Universe, (ndr1_0_ -> (c1_1_ X60 \/ (c2_1_ X60 \/ ~(c0_1_ X60))))) \/ ((forall X61 : Universe, (ndr1_0_ -> (~(c0_1_ X61) \/ (~(c1_1_ X61) \/ ~(c3_1_ X61))))) \/ hskp22_)) /\ (((forall X62 : Universe, (ndr1_0_ -> (c1_1_ X62 \/ (c2_1_ X62 \/ ~(c0_1_ X62))))) \/ (hskp30_ \/ hskp23_)) /\ (((forall X63 : Universe, (ndr1_0_ -> (c1_1_ X63 \/ (c2_1_ X63 \/ ~(c3_1_ X63))))) \/ (hskp17_ \/ hskp6_)) /\ (((forall X64 : Universe, (ndr1_0_ -> (c1_1_ X64 \/ (c3_1_ X64 \/ ~(c0_1_ X64))))) \/ ((forall X65 : Universe, (ndr1_0_ -> (c1_1_ X65 \/ (~(c0_1_ X65) \/ ~(c3_1_ X65))))) \/ hskp2_)) /\ (((forall X66 : Universe, (ndr1_0_ -> (c1_1_ X66 \/ (c3_1_ X66 \/ ~(c2_1_ X66))))) \/ ((forall X67 : Universe, (ndr1_0_ -> (c2_1_ X67 \/ (c3_1_ X67 \/ ~(c1_1_ X67))))) \/ hskp9_)) /\ (((forall X68 : Universe, (ndr1_0_ -> (c1_1_ X68 \/ (c3_1_ X68 \/ ~(c2_1_ X68))))) \/ ((forall X69 : Universe, (ndr1_0_ -> (~(c1_1_ X69) \/ (~(c2_1_ X69) \/ ~(c3_1_ X69))))) \/ hskp3_)) /\ (((forall X70 : Universe, (ndr1_0_ -> (c1_1_ X70 \/ (~(c0_1_ X70) \/ ~(c3_1_ X70))))) \/ ((forall X71 : Universe, (ndr1_0_ -> (~(c0_1_ X71) \/ (~(c1_1_ X71) \/ ~(c3_1_ X71))))) \/ (forall X72 : Universe, (ndr1_0_ -> (~(c0_1_ X72) \/ (~(c2_1_ X72) \/ ~(c3_1_ X72))))))) /\ (((forall X73 : Universe, (ndr1_0_ -> (c1_1_ X73 \/ (~(c0_1_ X73) \/ ~(c3_1_ X73))))) \/ (hskp8_ \/ hskp21_)) /\ (((forall X74 : Universe, (ndr1_0_ -> (c1_1_ X74 \/ (~(c2_1_ X74) \/ ~(c3_1_ X74))))) \/ ((forall X75 : Universe, (ndr1_0_ -> (c2_1_ X75 \/ (~(c0_1_ X75) \/ ~(c1_1_ X75))))) \/ hskp15_)) /\ (((forall X76 : Universe, (ndr1_0_ -> (c2_1_ X76 \/ (c3_1_ X76 \/ ~(c0_1_ X76))))) \/ (hskp3_ \/ hskp24_)) /\ (((forall X77 : Universe, (ndr1_0_ -> (c2_1_ X77 \/ (c3_1_ X77 \/ ~(c1_1_ X77))))) \/ ((forall X78 : Universe, (ndr1_0_ -> (~(c0_1_ X78) \/ (~(c2_1_ X78) \/ ~(c3_1_ X78))))) \/ hskp12_)) /\ (((forall X79 : Universe, (ndr1_0_ -> (c2_1_ X79 \/ (c3_1_ X79 \/ ~(c1_1_ X79))))) \/ (hskp25_ \/ hskp3_)) /\ (((forall X80 : Universe, (ndr1_0_ -> (c2_1_ X80 \/ (~(c0_1_ X80) \/ ~(c1_1_ X80))))) \/ (hskp28_ \/ hskp26_)) /\ (((forall X81 : Universe, (ndr1_0_ -> (c2_1_ X81 \/ (~(c0_1_ X81) \/ ~(c3_1_ X81))))) \/ ((forall X82 : Universe, (ndr1_0_ -> (c3_1_ X82 \/ (~(c1_1_ X82) \/ ~(c2_1_ X82))))) \/ hskp17_)) /\ (((forall X83 : Universe, (ndr1_0_ -> (c2_1_ X83 \/ (~(c1_1_ X83) \/ ~(c3_1_ X83))))) \/ (hskp28_ \/ hskp7_)) /\ (((forall X84 : Universe, (ndr1_0_ -> (c2_1_ X84 \/ (~(c1_1_ X84) \/ ~(c3_1_ X84))))) \/ hskp16_) /\ (((forall X85 : Universe, (ndr1_0_ -> (~(c0_1_ X85) \/ (~(c1_1_ X85) \/ ~(c2_1_ X85))))) \/ (hskp28_ \/ hskp9_)) /\ (((forall X86 : Universe, (ndr1_0_ -> (~(c0_1_ X86) \/ (~(c1_1_ X86) \/ ~(c2_1_ X86))))) \/ (hskp18_ \/ hskp27_)) /\ (((forall X87 : Universe, (ndr1_0_ -> (~(c0_1_ X87) \/ (~(c1_1_ X87) \/ ~(c3_1_ X87))))) \/ ((forall X88 : Universe, (ndr1_0_ -> (~(c0_1_ X88) \/ (~(c2_1_ X88) \/ ~(c3_1_ X88))))) \/ hskp21_)) /\ (((forall X89 : Universe, (ndr1_0_ -> (~(c0_1_ X89) \/ (~(c1_1_ X89) \/ ~(c3_1_ X89))))) \/ (hskp0_ \/ hskp2_)) /\ (((forall X90 : Universe, (ndr1_0_ -> (~(c0_1_ X90) \/ (~(c1_1_ X90) \/ ~(c3_1_ X90))))) \/ (hskp29_ \/ hskp19_)) /\ (((forall X91 : Universe, (ndr1_0_ -> (~(c0_1_ X91) \/ (~(c1_1_ X91) \/ ~(c3_1_ X91))))) \/ (hskp12_ \/ hskp26_)) /\ (((forall X92 : Universe, (ndr1_0_ -> (~(c0_1_ X92) \/ (~(c1_1_ X92) \/ ~(c3_1_ X92))))) \/ (hskp14_ \/ hskp24_)) /\ (((forall X93 : Universe, (ndr1_0_ -> (~(c0_1_ X93) \/ (~(c2_1_ X93) \/ ~(c3_1_ X93))))) \/ (hskp28_ \/ hskp31_)) /\ (((forall X94 : Universe, (ndr1_0_ -> (~(c0_1_ X94) \/ (~(c2_1_ X94) \/ ~(c3_1_ X94))))) \/ (hskp15_ \/ hskp13_)) /\ (((forall X95 : Universe, (ndr1_0_ -> (~(c1_1_ X95) \/ (~(c2_1_ X95) \/ ~(c3_1_ X95))))) \/ (hskp25_ \/ hskp9_)) /\ (((forall X96 : Universe, (ndr1_0_ -> (~(c1_1_ X96) \/ (~(c2_1_ X96) \/ ~(c3_1_ X96))))) \/ (hskp12_ \/ hskp2_)) /\ ((hskp31_ \/ (hskp12_ \/ hskp24_)) /\ ((hskp7_ \/ (hskp30_ \/ hskp26_)) /\ ((hskp3_ \/ (hskp2_ \/ hskp13_)) /\ ((hskp3_ \/ (hskp27_ \/ hskp26_)) /\ ((hskp12_ \/ (hskp6_ \/ hskp27_)) /\ (hskp21_ \/ (hskp24_ \/ hskp5_)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
