(*
% File     : SYN459+1 : ILTP v1.1.2
% Domain   : Syntactic (Translated)
% Problem  : ALC, N=4, R=1, L=60, K=3, D=1, P=0, Index=073
% Version  : Especial.
% English  : 
% Refs     : [OS95]  Ohlbach & Schmidt (1995), Functional Translation and S
%          : [HS97]  Hustadt & Schmidt (1997), On Evaluating Decision Proce
%          : [Wei97] Weidenbach (1997), Email to G. Sutcliffe
% Source   : [Wei97]
% Names    : alc-4-1-60-3-1-073.dfg [Wei97]
% Status   : Theorem
% Rating   : 0.33 v3.1.0, 0.67 v2.7.0, 0.33 v2.6.0, 0.00 v2.5.0, 0.33 v2.4.0, 0.33 v2.2.1, 0.50 v2.2.0, 0.00 v2.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :    1 (   0 unit)
%            Number of atoms       :  605 (   0 equality)
%            Maximal formula depth :   89 (  89 average)
%            Number of connectives :  826 ( 222 ~  ; 342  |; 163  &)
%                                         (   0 <=>;  99 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   31 (  27 propositional; 0-1 arity)
%            Number of functors    :   26 (  26 constant; 0-0 arity)
%            Number of variables   :   99 (   0 singleton;  99 !;   0 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : These ALC problems have been translated from propositional 
%            multi-modal K logic formulae generated according to the scheme
%            described in [HS97], using the optimized functional translation
%            described in [OS95]. The finite model property holds, the
%            Herbrand Universe is finite, they are decidable (the complexity
%            is PSPACE-complete), resolution + subsumption + condensing is a
%            decision procedure, and the translated formulae belong to the
%            (CNF-translation of the) Bernays-Schoenfinkel class [Wei97].
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable ndr1_0_ : Prop.
Variable hskp9_ : Prop.
Variable hskp8_ : Prop.
Variable hskp7_ : Prop.
Variable hskp6_ : Prop.
Variable hskp5_ : Prop.
Variable hskp4_ : Prop.
Variable hskp3_ : Prop.
Variable hskp25_ : Prop.
Variable hskp24_ : Prop.
Variable hskp23_ : Prop.
Variable hskp22_ : Prop.
Variable hskp21_ : Prop.
Variable hskp20_ : Prop.
Variable hskp2_ : Prop.
Variable hskp19_ : Prop.
Variable hskp18_ : Prop.
Variable hskp17_ : Prop.
Variable hskp16_ : Prop.
Variable hskp15_ : Prop.
Variable hskp14_ : Prop.
Variable hskp13_ : Prop.
Variable hskp12_ : Prop.
Variable hskp11_ : Prop.
Variable hskp10_ : Prop.
Variable hskp1_ : Prop.
Variable hskp0_ : Prop.
Variable c3_1_ : Universe -> Prop.
Variable c2_1_ : Universe -> Prop.
Variable c1_1_ : Universe -> Prop.
Variable c0_1_ : Universe -> Prop.

Variable a259_ : Universe.
Variable a257_ : Universe.
Variable a233_ : Universe.
Variable a230_ : Universe.
Variable a225_ : Universe.
Variable a223_ : Universe.
Variable a222_ : Universe.
Variable a221_ : Universe.
Variable a215_ : Universe.
Variable a214_ : Universe.
Variable a210_ : Universe.
Variable a209_ : Universe.
Variable a206_ : Universe.
Variable a202_ : Universe.
Variable a200_ : Universe.
Variable a199_ : Universe.
Variable a198_ : Universe.
Variable a197_ : Universe.
Variable a195_ : Universe.
Variable a194_ : Universe.
Variable a193_ : Universe.
Variable a192_ : Universe.
Variable a191_ : Universe.
Variable a190_ : Universe.
Variable a189_ : Universe.
Variable a188_ : Universe.


Theorem co1_1 : ~(((~(hskp0_) \/ (ndr1_0_ /\ (~(c0_1_ a188_) /\ (~(c1_1_ a188_) /\ ~(c3_1_ a188_))))) /\ ((~(hskp1_) \/ (ndr1_0_ /\ (c0_1_ a190_ /\ (c2_1_ a190_ /\ ~(c3_1_ a190_))))) /\ ((~(hskp2_) \/ (ndr1_0_ /\ (~(c1_1_ a191_) /\ (~(c2_1_ a191_) /\ ~(c3_1_ a191_))))) /\ ((~(hskp3_) \/ (ndr1_0_ /\ (c0_1_ a192_ /\ (c1_1_ a192_ /\ ~(c3_1_ a192_))))) /\ ((~(hskp4_) \/ (ndr1_0_ /\ (c1_1_ a193_ /\ (~(c0_1_ a193_) /\ ~(c3_1_ a193_))))) /\ ((~(hskp5_) \/ (ndr1_0_ /\ (c0_1_ a194_ /\ (~(c1_1_ a194_) /\ ~(c2_1_ a194_))))) /\ ((~(hskp6_) \/ (ndr1_0_ /\ (c0_1_ a195_ /\ (~(c1_1_ a195_) /\ ~(c3_1_ a195_))))) /\ ((~(hskp7_) \/ (ndr1_0_ /\ (c1_1_ a197_ /\ (~(c0_1_ a197_) /\ ~(c2_1_ a197_))))) /\ ((~(hskp8_) \/ (ndr1_0_ /\ (c1_1_ a198_ /\ (c3_1_ a198_ /\ ~(c2_1_ a198_))))) /\ ((~(hskp9_) \/ (ndr1_0_ /\ (c2_1_ a199_ /\ (~(c0_1_ a199_) /\ ~(c1_1_ a199_))))) /\ ((~(hskp10_) \/ (ndr1_0_ /\ (c0_1_ a200_ /\ (c3_1_ a200_ /\ ~(c1_1_ a200_))))) /\ ((~(hskp11_) \/ (ndr1_0_ /\ (c0_1_ a202_ /\ (~(c2_1_ a202_) /\ ~(c3_1_ a202_))))) /\ ((~(hskp12_) \/ (ndr1_0_ /\ (~(c0_1_ a206_) /\ (~(c2_1_ a206_) /\ ~(c3_1_ a206_))))) /\ ((~(hskp13_) \/ (ndr1_0_ /\ (c1_1_ a209_ /\ (c3_1_ a209_ /\ ~(c0_1_ a209_))))) /\ ((~(hskp14_) \/ (ndr1_0_ /\ (c2_1_ a210_ /\ (c3_1_ a210_ /\ ~(c1_1_ a210_))))) /\ ((~(hskp15_) \/ (ndr1_0_ /\ (c2_1_ a214_ /\ (~(c0_1_ a214_) /\ ~(c3_1_ a214_))))) /\ ((~(hskp16_) \/ (ndr1_0_ /\ (~(c0_1_ a221_) /\ (~(c1_1_ a221_) /\ ~(c2_1_ a221_))))) /\ ((~(hskp17_) \/ (ndr1_0_ /\ (c1_1_ a222_ /\ (c2_1_ a222_ /\ ~(c3_1_ a222_))))) /\ ((~(hskp18_) \/ (ndr1_0_ /\ (c3_1_ a223_ /\ (~(c1_1_ a223_) /\ ~(c2_1_ a223_))))) /\ ((~(hskp19_) \/ (ndr1_0_ /\ (c3_1_ a225_ /\ (~(c0_1_ a225_) /\ ~(c1_1_ a225_))))) /\ ((~(hskp20_) \/ (ndr1_0_ /\ (c2_1_ a233_ /\ (c3_1_ a233_ /\ ~(c0_1_ a233_))))) /\ ((~(hskp21_) \/ (ndr1_0_ /\ (c2_1_ a257_ /\ (~(c1_1_ a257_) /\ ~(c3_1_ a257_))))) /\ ((~(hskp22_) \/ (ndr1_0_ /\ (c3_1_ a259_ /\ (~(c0_1_ a259_) /\ ~(c2_1_ a259_))))) /\ ((~(hskp23_) \/ (ndr1_0_ /\ (c0_1_ a189_ /\ (c1_1_ a189_ /\ c3_1_ a189_)))) /\ ((~(hskp24_) \/ (ndr1_0_ /\ (c1_1_ a215_ /\ (c2_1_ a215_ /\ c3_1_ a215_)))) /\ ((~(hskp25_) \/ (ndr1_0_ /\ (c0_1_ a230_ /\ (c1_1_ a230_ /\ c2_1_ a230_)))) /\ (((forall U : Universe, (ndr1_0_ -> (c0_1_ U \/ (c1_1_ U \/ c2_1_ U)))) \/ ((forall V : Universe, (ndr1_0_ -> (c0_1_ V \/ (c2_1_ V \/ ~(c3_1_ V))))) \/ (forall W : Universe, (ndr1_0_ -> (c1_1_ W \/ (c2_1_ W \/ c3_1_ W)))))) /\ (((forall X : Universe, (ndr1_0_ -> (c0_1_ X \/ (c1_1_ X \/ c2_1_ X)))) \/ ((forall Y : Universe, (ndr1_0_ -> (c2_1_ Y \/ (~(c0_1_ Y) \/ ~(c3_1_ Y))))) \/ hskp0_)) /\ (((forall Z : Universe, (ndr1_0_ -> (c0_1_ Z \/ (c1_1_ Z \/ c3_1_ Z)))) \/ ((forall X1 : Universe, (ndr1_0_ -> (c0_1_ X1 \/ (c2_1_ X1 \/ ~(c1_1_ X1))))) \/ hskp23_)) /\ (((forall X2 : Universe, (ndr1_0_ -> (c0_1_ X2 \/ (c1_1_ X2 \/ c3_1_ X2)))) \/ hskp1_) /\ (((forall X3 : Universe, (ndr1_0_ -> (c0_1_ X3 \/ (c1_1_ X3 \/ ~(c2_1_ X3))))) \/ ((forall X4 : Universe, (ndr1_0_ -> (c0_1_ X4 \/ (~(c1_1_ X4) \/ ~(c2_1_ X4))))) \/ (forall X5 : Universe, (ndr1_0_ -> (c1_1_ X5 \/ (c2_1_ X5 \/ ~(c3_1_ X5))))))) /\ (((forall X6 : Universe, (ndr1_0_ -> (c0_1_ X6 \/ (c1_1_ X6 \/ ~(c2_1_ X6))))) \/ ((forall X7 : Universe, (ndr1_0_ -> (c0_1_ X7 \/ (~(c1_1_ X7) \/ ~(c3_1_ X7))))) \/ (forall X8 : Universe, (ndr1_0_ -> (c1_1_ X8 \/ (c2_1_ X8 \/ ~(c0_1_ X8))))))) /\ (((forall X9 : Universe, (ndr1_0_ -> (c0_1_ X9 \/ (c1_1_ X9 \/ ~(c3_1_ X9))))) \/ ((forall X10 : Universe, (ndr1_0_ -> (c3_1_ X10 \/ (~(c0_1_ X10) \/ ~(c1_1_ X10))))) \/ hskp2_)) /\ (((forall X11 : Universe, (ndr1_0_ -> (c0_1_ X11 \/ (c1_1_ X11 \/ ~(c3_1_ X11))))) \/ (hskp3_ \/ hskp4_)) /\ (((forall X12 : Universe, (ndr1_0_ -> (c0_1_ X12 \/ (c2_1_ X12 \/ c3_1_ X12)))) \/ (hskp5_ \/ hskp6_)) /\ (((forall X13 : Universe, (ndr1_0_ -> (c0_1_ X13 \/ (c2_1_ X13 \/ c3_1_ X13)))) \/ hskp6_) /\ (((forall X14 : Universe, (ndr1_0_ -> (c0_1_ X14 \/ (c2_1_ X14 \/ ~(c1_1_ X14))))) \/ ((forall X15 : Universe, (ndr1_0_ -> (~(c1_1_ X15) \/ (~(c2_1_ X15) \/ ~(c3_1_ X15))))) \/ hskp7_)) /\ (((forall X16 : Universe, (ndr1_0_ -> (c0_1_ X16 \/ (c2_1_ X16 \/ ~(c1_1_ X16))))) \/ (hskp8_ \/ hskp9_)) /\ (((forall X17 : Universe, (ndr1_0_ -> (c0_1_ X17 \/ (c2_1_ X17 \/ ~(c3_1_ X17))))) \/ ((forall X18 : Universe, (ndr1_0_ -> (c0_1_ X18 \/ (~(c1_1_ X18) \/ ~(c2_1_ X18))))) \/ (forall X19 : Universe, (ndr1_0_ -> (c1_1_ X19 \/ (~(c0_1_ X19) \/ ~(c3_1_ X19))))))) /\ (((forall X20 : Universe, (ndr1_0_ -> (c0_1_ X20 \/ (c2_1_ X20 \/ ~(c3_1_ X20))))) \/ ((forall X21 : Universe, (ndr1_0_ -> (c1_1_ X21 \/ (c3_1_ X21 \/ ~(c2_1_ X21))))) \/ (forall X22 : Universe, (ndr1_0_ -> (c3_1_ X22 \/ (~(c0_1_ X22) \/ ~(c2_1_ X22))))))) /\ (((forall X23 : Universe, (ndr1_0_ -> (c0_1_ X23 \/ (c2_1_ X23 \/ ~(c3_1_ X23))))) \/ ((forall X24 : Universe, (ndr1_0_ -> (c2_1_ X24 \/ (c3_1_ X24 \/ ~(c0_1_ X24))))) \/ hskp10_)) /\ (((forall X25 : Universe, (ndr1_0_ -> (c0_1_ X25 \/ (c3_1_ X25 \/ ~(c1_1_ X25))))) \/ ((forall X26 : Universe, (ndr1_0_ -> (c0_1_ X26 \/ (c3_1_ X26 \/ ~(c2_1_ X26))))) \/ hskp5_)) /\ (((forall X27 : Universe, (ndr1_0_ -> (c0_1_ X27 \/ (c3_1_ X27 \/ ~(c2_1_ X27))))) \/ ((forall X28 : Universe, (ndr1_0_ -> (c2_1_ X28 \/ (c3_1_ X28 \/ ~(c0_1_ X28))))) \/ (forall X29 : Universe, (ndr1_0_ -> (~(c0_1_ X29) \/ (~(c1_1_ X29) \/ ~(c2_1_ X29))))))) /\ (((forall X30 : Universe, (ndr1_0_ -> (c0_1_ X30 \/ (c3_1_ X30 \/ ~(c2_1_ X30))))) \/ (hskp11_ \/ hskp9_)) /\ (((forall X31 : Universe, (ndr1_0_ -> (c0_1_ X31 \/ (~(c1_1_ X31) \/ ~(c2_1_ X31))))) \/ ((forall X32 : Universe, (ndr1_0_ -> (c1_1_ X32 \/ (c2_1_ X32 \/ ~(c0_1_ X32))))) \/ hskp2_)) /\ (((forall X33 : Universe, (ndr1_0_ -> (c0_1_ X33 \/ (~(c1_1_ X33) \/ ~(c2_1_ X33))))) \/ ((forall X34 : Universe, (ndr1_0_ -> (c2_1_ X34 \/ (~(c1_1_ X34) \/ ~(c3_1_ X34))))) \/ hskp0_)) /\ (((forall X35 : Universe, (ndr1_0_ -> (c0_1_ X35 \/ (~(c1_1_ X35) \/ ~(c2_1_ X35))))) \/ ((forall X36 : Universe, (ndr1_0_ -> (c3_1_ X36 \/ (~(c0_1_ X36) \/ ~(c1_1_ X36))))) \/ hskp12_)) /\ (((forall X37 : Universe, (ndr1_0_ -> (c0_1_ X37 \/ (~(c1_1_ X37) \/ ~(c2_1_ X37))))) \/ ((forall X38 : Universe, (ndr1_0_ -> (~(c0_1_ X38) \/ (~(c2_1_ X38) \/ ~(c3_1_ X38))))) \/ hskp6_)) /\ (((forall X39 : Universe, (ndr1_0_ -> (c0_1_ X39 \/ (~(c1_1_ X39) \/ ~(c3_1_ X39))))) \/ ((forall X40 : Universe, (ndr1_0_ -> (c1_1_ X40 \/ (c2_1_ X40 \/ c3_1_ X40)))) \/ hskp10_)) /\ (((forall X41 : Universe, (ndr1_0_ -> (c0_1_ X41 \/ (~(c2_1_ X41) \/ ~(c3_1_ X41))))) \/ ((forall X42 : Universe, (ndr1_0_ -> (c1_1_ X42 \/ (c2_1_ X42 \/ c3_1_ X42)))) \/ hskp13_)) /\ (((forall X43 : Universe, (ndr1_0_ -> (c0_1_ X43 \/ (~(c2_1_ X43) \/ ~(c3_1_ X43))))) \/ ((forall X44 : Universe, (ndr1_0_ -> (c1_1_ X44 \/ (~(c2_1_ X44) \/ ~(c3_1_ X44))))) \/ hskp14_)) /\ (((forall X45 : Universe, (ndr1_0_ -> (c0_1_ X45 \/ (~(c2_1_ X45) \/ ~(c3_1_ X45))))) \/ ((forall X46 : Universe, (ndr1_0_ -> (~(c0_1_ X46) \/ (~(c1_1_ X46) \/ ~(c2_1_ X46))))) \/ hskp7_)) /\ (((forall X47 : Universe, (ndr1_0_ -> (c0_1_ X47 \/ (~(c2_1_ X47) \/ ~(c3_1_ X47))))) \/ (hskp8_ \/ hskp4_)) /\ (((forall X48 : Universe, (ndr1_0_ -> (c1_1_ X48 \/ (c2_1_ X48 \/ c3_1_ X48)))) \/ ((forall X49 : Universe, (ndr1_0_ -> (c2_1_ X49 \/ (c3_1_ X49 \/ ~(c1_1_ X49))))) \/ hskp15_)) /\ (((forall X50 : Universe, (ndr1_0_ -> (c1_1_ X50 \/ (c2_1_ X50 \/ ~(c0_1_ X50))))) \/ ((forall X51 : Universe, (ndr1_0_ -> (c1_1_ X51 \/ (~(c0_1_ X51) \/ ~(c3_1_ X51))))) \/ hskp24_)) /\ (((forall X52 : Universe, (ndr1_0_ -> (c1_1_ X52 \/ (c2_1_ X52 \/ ~(c0_1_ X52))))) \/ ((forall X53 : Universe, (ndr1_0_ -> (c2_1_ X53 \/ (c3_1_ X53 \/ ~(c0_1_ X53))))) \/ (forall X54 : Universe, (ndr1_0_ -> (~(c0_1_ X54) \/ (~(c1_1_ X54) \/ ~(c2_1_ X54))))))) /\ (((forall X55 : Universe, (ndr1_0_ -> (c1_1_ X55 \/ (c2_1_ X55 \/ ~(c0_1_ X55))))) \/ ((forall X56 : Universe, (ndr1_0_ -> (c3_1_ X56 \/ (~(c0_1_ X56) \/ ~(c2_1_ X56))))) \/ hskp1_)) /\ (((forall X57 : Universe, (ndr1_0_ -> (c1_1_ X57 \/ (c2_1_ X57 \/ ~(c0_1_ X57))))) \/ ((forall X58 : Universe, (ndr1_0_ -> (~(c0_1_ X58) \/ (~(c1_1_ X58) \/ ~(c3_1_ X58))))) \/ hskp9_)) /\ (((forall X59 : Universe, (ndr1_0_ -> (c1_1_ X59 \/ (c2_1_ X59 \/ ~(c3_1_ X59))))) \/ ((forall X60 : Universe, (ndr1_0_ -> (c2_1_ X60 \/ (c3_1_ X60 \/ ~(c0_1_ X60))))) \/ hskp1_)) /\ (((forall X61 : Universe, (ndr1_0_ -> (c1_1_ X61 \/ (c2_1_ X61 \/ ~(c3_1_ X61))))) \/ ((forall X62 : Universe, (ndr1_0_ -> (c3_1_ X62 \/ (~(c0_1_ X62) \/ ~(c1_1_ X62))))) \/ hskp13_)) /\ (((forall X63 : Universe, (ndr1_0_ -> (c1_1_ X63 \/ (c3_1_ X63 \/ ~(c0_1_ X63))))) \/ ((forall X64 : Universe, (ndr1_0_ -> (~(c0_1_ X64) \/ (~(c1_1_ X64) \/ ~(c3_1_ X64))))) \/ (forall X65 : Universe, (ndr1_0_ -> (~(c0_1_ X65) \/ (~(c2_1_ X65) \/ ~(c3_1_ X65))))))) /\ (((forall X66 : Universe, (ndr1_0_ -> (c1_1_ X66 \/ (c3_1_ X66 \/ ~(c0_1_ X66))))) \/ (hskp23_ \/ hskp16_)) /\ (((forall X67 : Universe, (ndr1_0_ -> (c1_1_ X67 \/ (c3_1_ X67 \/ ~(c0_1_ X67))))) \/ (hskp17_ \/ hskp18_)) /\ (((forall X68 : Universe, (ndr1_0_ -> (c1_1_ X68 \/ (c3_1_ X68 \/ ~(c2_1_ X68))))) \/ ((forall X69 : Universe, (ndr1_0_ -> (c2_1_ X69 \/ (~(c0_1_ X69) \/ ~(c1_1_ X69))))) \/ hskp24_)) /\ (((forall X70 : Universe, (ndr1_0_ -> (c1_1_ X70 \/ (c3_1_ X70 \/ ~(c2_1_ X70))))) \/ ((forall X71 : Universe, (ndr1_0_ -> (c3_1_ X71 \/ (~(c0_1_ X71) \/ ~(c2_1_ X71))))) \/ hskp19_)) /\ (((forall X72 : Universe, (ndr1_0_ -> (c1_1_ X72 \/ (~(c0_1_ X72) \/ ~(c2_1_ X72))))) \/ ((forall X73 : Universe, (ndr1_0_ -> (c2_1_ X73 \/ (c3_1_ X73 \/ ~(c0_1_ X73))))) \/ (forall X74 : Universe, (ndr1_0_ -> (~(c0_1_ X74) \/ (~(c1_1_ X74) \/ ~(c2_1_ X74))))))) /\ (((forall X75 : Universe, (ndr1_0_ -> (c1_1_ X75 \/ (~(c2_1_ X75) \/ ~(c3_1_ X75))))) \/ ((forall X76 : Universe, (ndr1_0_ -> (c2_1_ X76 \/ (~(c0_1_ X76) \/ ~(c3_1_ X76))))) \/ (forall X77 : Universe, (ndr1_0_ -> (c3_1_ X77 \/ (~(c0_1_ X77) \/ ~(c1_1_ X77))))))) /\ (((forall X78 : Universe, (ndr1_0_ -> (c2_1_ X78 \/ (c3_1_ X78 \/ ~(c0_1_ X78))))) \/ ((forall X79 : Universe, (ndr1_0_ -> (c3_1_ X79 \/ (~(c1_1_ X79) \/ ~(c2_1_ X79))))) \/ (forall X80 : Universe, (ndr1_0_ -> (~(c0_1_ X80) \/ (~(c1_1_ X80) \/ ~(c3_1_ X80))))))) /\ (((forall X81 : Universe, (ndr1_0_ -> (c2_1_ X81 \/ (c3_1_ X81 \/ ~(c0_1_ X81))))) \/ ((forall X82 : Universe, (ndr1_0_ -> (~(c1_1_ X82) \/ (~(c2_1_ X82) \/ ~(c3_1_ X82))))) \/ hskp13_)) /\ (((forall X83 : Universe, (ndr1_0_ -> (c2_1_ X83 \/ (c3_1_ X83 \/ ~(c1_1_ X83))))) \/ (hskp3_ \/ hskp12_)) /\ (((forall X84 : Universe, (ndr1_0_ -> (c2_1_ X84 \/ (~(c0_1_ X84) \/ ~(c1_1_ X84))))) \/ ((forall X85 : Universe, (ndr1_0_ -> (c3_1_ X85 \/ (~(c1_1_ X85) \/ ~(c2_1_ X85))))) \/ hskp12_)) /\ (((forall X86 : Universe, (ndr1_0_ -> (c2_1_ X86 \/ (~(c0_1_ X86) \/ ~(c1_1_ X86))))) \/ (hskp25_ \/ hskp16_)) /\ (((forall X87 : Universe, (ndr1_0_ -> (c2_1_ X87 \/ (~(c0_1_ X87) \/ ~(c3_1_ X87))))) \/ (hskp4_ \/ hskp20_)) /\ (((forall X88 : Universe, (ndr1_0_ -> (c3_1_ X88 \/ (~(c0_1_ X88) \/ ~(c1_1_ X88))))) \/ (hskp7_ \/ hskp4_)) /\ (((forall X89 : Universe, (ndr1_0_ -> (c3_1_ X89 \/ (~(c0_1_ X89) \/ ~(c1_1_ X89))))) \/ (hskp7_ \/ hskp9_)) /\ (((forall X90 : Universe, (ndr1_0_ -> (c3_1_ X90 \/ (~(c0_1_ X90) \/ ~(c2_1_ X90))))) \/ (hskp10_ \/ hskp24_)) /\ (((forall X91 : Universe, (ndr1_0_ -> (~(c0_1_ X91) \/ (~(c1_1_ X91) \/ ~(c3_1_ X91))))) \/ (hskp1_ \/ hskp2_)) /\ (((forall X92 : Universe, (ndr1_0_ -> (~(c0_1_ X92) \/ (~(c2_1_ X92) \/ ~(c3_1_ X92))))) \/ (hskp23_ \/ hskp5_)) /\ (((forall X93 : Universe, (ndr1_0_ -> (~(c0_1_ X93) \/ (~(c2_1_ X93) \/ ~(c3_1_ X93))))) \/ (hskp16_ \/ hskp12_)) /\ ((hskp25_ \/ (hskp15_ \/ hskp2_)) /\ ((hskp23_ \/ (hskp9_ \/ hskp2_)) /\ ((hskp1_ \/ (hskp9_ \/ hskp0_)) /\ ((hskp5_ \/ (hskp15_ \/ hskp21_)) /\ ((hskp24_ \/ (hskp22_ \/ hskp2_)) /\ ((hskp7_ \/ (hskp14_ \/ hskp9_)) /\ (hskp14_ \/ (hskp15_ \/ hskp12_)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
