(*
% File     : SYN458+1 : ILTP v1.1.2
% Domain   : Syntactic (Translated)
% Problem  : ALC, N=4, R=1, L=60, K=3, D=1, P=0, Index=062
% Version  : Especial.
% English  : 
% Refs     : [OS95]  Ohlbach & Schmidt (1995), Functional Translation and S
%          : [HS97]  Hustadt & Schmidt (1997), On Evaluating Decision Proce
%          : [Wei97] Weidenbach (1997), Email to G. Sutcliffe
% Source   : [Wei97]
% Names    : alc-4-1-60-3-1-062.dfg [Wei97]
% Status   : Theorem
% Rating   : 0.33 v3.1.0, 0.67 v2.7.0, 0.33 v2.6.0, 0.00 v2.5.0, 0.33 v2.4.0, 0.33 v2.2.1, 0.50 v2.2.0, 0.00 v2.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :    1 (   0 unit)
%            Number of atoms       :  596 (   0 equality)
%            Maximal formula depth :   96 (  96 average)
%            Number of connectives :  809 ( 214 ~  ; 321  |; 187  &)
%                                         (   0 <=>;  87 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   37 (  33 propositional; 0-1 arity)
%            Number of functors    :   32 (  32 constant; 0-0 arity)
%            Number of variables   :   87 (   0 singleton;  87 !;   0 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : These ALC problems have been translated from propositional 
%            multi-modal K logic formulae generated according to the scheme
%            described in [HS97], using the optimized functional translation
%            described in [OS95]. The finite model property holds, the
%            Herbrand Universe is finite, they are decidable (the complexity
%            is PSPACE-complete), resolution + subsumption + condensing is a
%            decision procedure, and the translated formulae belong to the
%            (CNF-translation of the) Bernays-Schoenfinkel class [Wei97].
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable ndr1_0_ : Prop.
Variable hskp9_ : Prop.
Variable hskp8_ : Prop.
Variable hskp7_ : Prop.
Variable hskp6_ : Prop.
Variable hskp5_ : Prop.
Variable hskp4_ : Prop.
Variable hskp31_ : Prop.
Variable hskp30_ : Prop.
Variable hskp3_ : Prop.
Variable hskp29_ : Prop.
Variable hskp28_ : Prop.
Variable hskp27_ : Prop.
Variable hskp26_ : Prop.
Variable hskp25_ : Prop.
Variable hskp24_ : Prop.
Variable hskp23_ : Prop.
Variable hskp22_ : Prop.
Variable hskp21_ : Prop.
Variable hskp20_ : Prop.
Variable hskp2_ : Prop.
Variable hskp19_ : Prop.
Variable hskp18_ : Prop.
Variable hskp17_ : Prop.
Variable hskp16_ : Prop.
Variable hskp15_ : Prop.
Variable hskp14_ : Prop.
Variable hskp13_ : Prop.
Variable hskp12_ : Prop.
Variable hskp11_ : Prop.
Variable hskp10_ : Prop.
Variable hskp1_ : Prop.
Variable hskp0_ : Prop.
Variable c3_1_ : Universe -> Prop.
Variable c2_1_ : Universe -> Prop.
Variable c1_1_ : Universe -> Prop.
Variable c0_1_ : Universe -> Prop.

Variable a1164_ : Universe.
Variable a1148_ : Universe.
Variable a1146_ : Universe.
Variable a1125_ : Universe.
Variable a1124_ : Universe.
Variable a1122_ : Universe.
Variable a1121_ : Universe.
Variable a1120_ : Universe.
Variable a1114_ : Universe.
Variable a1113_ : Universe.
Variable a1109_ : Universe.
Variable a1103_ : Universe.
Variable a1102_ : Universe.
Variable a1101_ : Universe.
Variable a1100_ : Universe.
Variable a1098_ : Universe.
Variable a1097_ : Universe.
Variable a1095_ : Universe.
Variable a1094_ : Universe.
Variable a1092_ : Universe.
Variable a1091_ : Universe.
Variable a1090_ : Universe.
Variable a1089_ : Universe.
Variable a1088_ : Universe.
Variable a1087_ : Universe.
Variable a1086_ : Universe.
Variable a1085_ : Universe.
Variable a1084_ : Universe.
Variable a1083_ : Universe.
Variable a1082_ : Universe.
Variable a1081_ : Universe.
Variable a1080_ : Universe.


Theorem co1_1 : ~(((~(hskp0_) \/ (ndr1_0_ /\ (c1_1_ a1080_ /\ (~(c0_1_ a1080_) /\ ~(c2_1_ a1080_))))) /\ ((~(hskp1_) \/ (ndr1_0_ /\ (c3_1_ a1081_ /\ (~(c0_1_ a1081_) /\ ~(c1_1_ a1081_))))) /\ ((~(hskp2_) \/ (ndr1_0_ /\ (~(c0_1_ a1082_) /\ (~(c2_1_ a1082_) /\ ~(c3_1_ a1082_))))) /\ ((~(hskp3_) \/ (ndr1_0_ /\ (c1_1_ a1083_ /\ (~(c2_1_ a1083_) /\ ~(c3_1_ a1083_))))) /\ ((~(hskp4_) \/ (ndr1_0_ /\ (c0_1_ a1084_ /\ (~(c1_1_ a1084_) /\ ~(c3_1_ a1084_))))) /\ ((~(hskp5_) \/ (ndr1_0_ /\ (c2_1_ a1085_ /\ (~(c0_1_ a1085_) /\ ~(c1_1_ a1085_))))) /\ ((~(hskp6_) \/ (ndr1_0_ /\ (c0_1_ a1086_ /\ (c2_1_ a1086_ /\ ~(c1_1_ a1086_))))) /\ ((~(hskp7_) \/ (ndr1_0_ /\ (~(c0_1_ a1087_) /\ (~(c1_1_ a1087_) /\ ~(c2_1_ a1087_))))) /\ ((~(hskp8_) \/ (ndr1_0_ /\ (c0_1_ a1088_ /\ (c3_1_ a1088_ /\ ~(c2_1_ a1088_))))) /\ ((~(hskp9_) \/ (ndr1_0_ /\ (c2_1_ a1089_ /\ (c3_1_ a1089_ /\ ~(c1_1_ a1089_))))) /\ ((~(hskp10_) \/ (ndr1_0_ /\ (~(c0_1_ a1090_) /\ (~(c1_1_ a1090_) /\ ~(c3_1_ a1090_))))) /\ ((~(hskp11_) \/ (ndr1_0_ /\ (c2_1_ a1091_ /\ (~(c0_1_ a1091_) /\ ~(c3_1_ a1091_))))) /\ ((~(hskp12_) \/ (ndr1_0_ /\ (c0_1_ a1094_ /\ (c1_1_ a1094_ /\ ~(c3_1_ a1094_))))) /\ ((~(hskp13_) \/ (ndr1_0_ /\ (c3_1_ a1095_ /\ (~(c1_1_ a1095_) /\ ~(c2_1_ a1095_))))) /\ ((~(hskp14_) \/ (ndr1_0_ /\ (c1_1_ a1097_ /\ (c3_1_ a1097_ /\ ~(c2_1_ a1097_))))) /\ ((~(hskp15_) \/ (ndr1_0_ /\ (c2_1_ a1098_ /\ (~(c1_1_ a1098_) /\ ~(c3_1_ a1098_))))) /\ ((~(hskp16_) \/ (ndr1_0_ /\ (c1_1_ a1100_ /\ (~(c0_1_ a1100_) /\ ~(c3_1_ a1100_))))) /\ ((~(hskp17_) \/ (ndr1_0_ /\ (c3_1_ a1102_ /\ (~(c0_1_ a1102_) /\ ~(c2_1_ a1102_))))) /\ ((~(hskp18_) \/ (ndr1_0_ /\ (c0_1_ a1103_ /\ (c3_1_ a1103_ /\ ~(c1_1_ a1103_))))) /\ ((~(hskp19_) \/ (ndr1_0_ /\ (c0_1_ a1113_ /\ (c1_1_ a1113_ /\ ~(c2_1_ a1113_))))) /\ ((~(hskp20_) \/ (ndr1_0_ /\ (c0_1_ a1114_ /\ (~(c1_1_ a1114_) /\ ~(c2_1_ a1114_))))) /\ ((~(hskp21_) \/ (ndr1_0_ /\ (c1_1_ a1120_ /\ (c2_1_ a1120_ /\ ~(c3_1_ a1120_))))) /\ ((~(hskp22_) \/ (ndr1_0_ /\ (c1_1_ a1121_ /\ (c3_1_ a1121_ /\ ~(c0_1_ a1121_))))) /\ ((~(hskp23_) \/ (ndr1_0_ /\ (c0_1_ a1122_ /\ (c2_1_ a1122_ /\ ~(c3_1_ a1122_))))) /\ ((~(hskp24_) \/ (ndr1_0_ /\ (c1_1_ a1124_ /\ (c2_1_ a1124_ /\ ~(c0_1_ a1124_))))) /\ ((~(hskp25_) \/ (ndr1_0_ /\ (~(c1_1_ a1125_) /\ (~(c2_1_ a1125_) /\ ~(c3_1_ a1125_))))) /\ ((~(hskp26_) \/ (ndr1_0_ /\ (c2_1_ a1146_ /\ (c3_1_ a1146_ /\ ~(c0_1_ a1146_))))) /\ ((~(hskp27_) \/ (ndr1_0_ /\ (c0_1_ a1164_ /\ (~(c2_1_ a1164_) /\ ~(c3_1_ a1164_))))) /\ ((~(hskp28_) \/ (ndr1_0_ /\ (c0_1_ a1092_ /\ (c2_1_ a1092_ /\ c3_1_ a1092_)))) /\ ((~(hskp29_) \/ (ndr1_0_ /\ (c1_1_ a1101_ /\ (c2_1_ a1101_ /\ c3_1_ a1101_)))) /\ ((~(hskp30_) \/ (ndr1_0_ /\ (c0_1_ a1109_ /\ (c1_1_ a1109_ /\ c3_1_ a1109_)))) /\ ((~(hskp31_) \/ (ndr1_0_ /\ (c0_1_ a1148_ /\ (c1_1_ a1148_ /\ c2_1_ a1148_)))) /\ (((forall U : Universe, (ndr1_0_ -> (c0_1_ U \/ (c1_1_ U \/ c2_1_ U)))) \/ ((forall V : Universe, (ndr1_0_ -> (c0_1_ V \/ (c2_1_ V \/ c3_1_ V)))) \/ (forall W : Universe, (ndr1_0_ -> (c1_1_ W \/ (~(c2_1_ W) \/ ~(c3_1_ W))))))) /\ (((forall X : Universe, (ndr1_0_ -> (c0_1_ X \/ (c1_1_ X \/ c2_1_ X)))) \/ ((forall Y : Universe, (ndr1_0_ -> (c0_1_ Y \/ (c2_1_ Y \/ ~(c3_1_ Y))))) \/ (forall Z : Universe, (ndr1_0_ -> (c3_1_ Z \/ (~(c0_1_ Z) \/ ~(c1_1_ Z))))))) /\ (((forall X1 : Universe, (ndr1_0_ -> (c0_1_ X1 \/ (c1_1_ X1 \/ c2_1_ X1)))) \/ ((forall X2 : Universe, (ndr1_0_ -> (c0_1_ X2 \/ (c2_1_ X2 \/ ~(c3_1_ X2))))) \/ hskp0_)) /\ (((forall X3 : Universe, (ndr1_0_ -> (c0_1_ X3 \/ (c1_1_ X3 \/ c2_1_ X3)))) \/ ((forall X4 : Universe, (ndr1_0_ -> (~(c0_1_ X4) \/ (~(c1_1_ X4) \/ ~(c3_1_ X4))))) \/ (forall X5 : Universe, (ndr1_0_ -> (~(c0_1_ X5) \/ (~(c2_1_ X5) \/ ~(c3_1_ X5))))))) /\ (((forall X6 : Universe, (ndr1_0_ -> (c0_1_ X6 \/ (c1_1_ X6 \/ c2_1_ X6)))) \/ (hskp1_ \/ hskp2_)) /\ (((forall X7 : Universe, (ndr1_0_ -> (c0_1_ X7 \/ (c1_1_ X7 \/ c3_1_ X7)))) \/ ((forall X8 : Universe, (ndr1_0_ -> (c2_1_ X8 \/ (c3_1_ X8 \/ ~(c1_1_ X8))))) \/ (forall X9 : Universe, (ndr1_0_ -> (c2_1_ X9 \/ (~(c1_1_ X9) \/ ~(c3_1_ X9))))))) /\ (((forall X10 : Universe, (ndr1_0_ -> (c0_1_ X10 \/ (c1_1_ X10 \/ ~(c2_1_ X10))))) \/ ((forall X11 : Universe, (ndr1_0_ -> (c0_1_ X11 \/ (c2_1_ X11 \/ ~(c1_1_ X11))))) \/ hskp3_)) /\ (((forall X12 : Universe, (ndr1_0_ -> (c0_1_ X12 \/ (c1_1_ X12 \/ ~(c2_1_ X12))))) \/ ((forall X13 : Universe, (ndr1_0_ -> (c0_1_ X13 \/ (c3_1_ X13 \/ ~(c1_1_ X13))))) \/ hskp4_)) /\ (((forall X14 : Universe, (ndr1_0_ -> (c0_1_ X14 \/ (c1_1_ X14 \/ ~(c2_1_ X14))))) \/ ((forall X15 : Universe, (ndr1_0_ -> (c0_1_ X15 \/ (~(c1_1_ X15) \/ ~(c2_1_ X15))))) \/ (forall X16 : Universe, (ndr1_0_ -> (~(c0_1_ X16) \/ (~(c1_1_ X16) \/ ~(c2_1_ X16))))))) /\ (((forall X17 : Universe, (ndr1_0_ -> (c0_1_ X17 \/ (c1_1_ X17 \/ ~(c2_1_ X17))))) \/ ((forall X18 : Universe, (ndr1_0_ -> (c1_1_ X18 \/ (~(c2_1_ X18) \/ ~(c3_1_ X18))))) \/ hskp5_)) /\ (((forall X19 : Universe, (ndr1_0_ -> (c0_1_ X19 \/ (c1_1_ X19 \/ ~(c2_1_ X19))))) \/ ((forall X20 : Universe, (ndr1_0_ -> (c2_1_ X20 \/ (c3_1_ X20 \/ ~(c0_1_ X20))))) \/ (forall X21 : Universe, (ndr1_0_ -> (c2_1_ X21 \/ (~(c0_1_ X21) \/ ~(c1_1_ X21))))))) /\ (((forall X22 : Universe, (ndr1_0_ -> (c0_1_ X22 \/ (c1_1_ X22 \/ ~(c2_1_ X22))))) \/ (hskp6_ \/ hskp7_)) /\ (((forall X23 : Universe, (ndr1_0_ -> (c0_1_ X23 \/ (c1_1_ X23 \/ ~(c2_1_ X23))))) \/ (hskp8_ \/ hskp9_)) /\ (((forall X24 : Universe, (ndr1_0_ -> (c0_1_ X24 \/ (c1_1_ X24 \/ ~(c3_1_ X24))))) \/ ((forall X25 : Universe, (ndr1_0_ -> (~(c0_1_ X25) \/ (~(c1_1_ X25) \/ ~(c2_1_ X25))))) \/ hskp10_)) /\ (((forall X26 : Universe, (ndr1_0_ -> (c0_1_ X26 \/ (c1_1_ X26 \/ ~(c3_1_ X26))))) \/ ((forall X27 : Universe, (ndr1_0_ -> (~(c0_1_ X27) \/ (~(c2_1_ X27) \/ ~(c3_1_ X27))))) \/ hskp11_)) /\ (((forall X28 : Universe, (ndr1_0_ -> (c0_1_ X28 \/ (c1_1_ X28 \/ ~(c3_1_ X28))))) \/ (hskp28_ \/ hskp1_)) /\ (((forall X29 : Universe, (ndr1_0_ -> (c0_1_ X29 \/ (c2_1_ X29 \/ c3_1_ X29)))) \/ (hskp12_ \/ hskp13_)) /\ (((forall X30 : Universe, (ndr1_0_ -> (c0_1_ X30 \/ (c2_1_ X30 \/ ~(c1_1_ X30))))) \/ ((forall X31 : Universe, (ndr1_0_ -> (c1_1_ X31 \/ (~(c0_1_ X31) \/ ~(c3_1_ X31))))) \/ hskp5_)) /\ (((forall X32 : Universe, (ndr1_0_ -> (c0_1_ X32 \/ (c2_1_ X32 \/ ~(c1_1_ X32))))) \/ (hskp14_ \/ hskp15_)) /\ (((forall X33 : Universe, (ndr1_0_ -> (c0_1_ X33 \/ (c2_1_ X33 \/ ~(c1_1_ X33))))) \/ (hskp0_ \/ hskp16_)) /\ (((forall X34 : Universe, (ndr1_0_ -> (c0_1_ X34 \/ (c3_1_ X34 \/ ~(c1_1_ X34))))) \/ ((forall X35 : Universe, (ndr1_0_ -> (c1_1_ X35 \/ (~(c2_1_ X35) \/ ~(c3_1_ X35))))) \/ hskp29_)) /\ (((forall X36 : Universe, (ndr1_0_ -> (c0_1_ X36 \/ (c3_1_ X36 \/ ~(c2_1_ X36))))) \/ ((forall X37 : Universe, (ndr1_0_ -> (~(c0_1_ X37) \/ (~(c1_1_ X37) \/ ~(c3_1_ X37))))) \/ hskp17_)) /\ (((forall X38 : Universe, (ndr1_0_ -> (c0_1_ X38 \/ (c3_1_ X38 \/ ~(c2_1_ X38))))) \/ hskp18_) /\ (((forall X39 : Universe, (ndr1_0_ -> (c0_1_ X39 \/ (c3_1_ X39 \/ ~(c2_1_ X39))))) \/ (hskp4_ \/ hskp16_)) /\ (((forall X40 : Universe, (ndr1_0_ -> (c0_1_ X40 \/ (~(c1_1_ X40) \/ ~(c2_1_ X40))))) \/ ((forall X41 : Universe, (ndr1_0_ -> (c1_1_ X41 \/ (c3_1_ X41 \/ ~(c2_1_ X41))))) \/ hskp9_)) /\ (((forall X42 : Universe, (ndr1_0_ -> (c0_1_ X42 \/ (~(c1_1_ X42) \/ ~(c2_1_ X42))))) \/ (hskp15_ \/ hskp17_)) /\ (((forall X43 : Universe, (ndr1_0_ -> (c0_1_ X43 \/ (~(c1_1_ X43) \/ ~(c3_1_ X43))))) \/ (hskp30_ \/ hskp18_)) /\ (((forall X44 : Universe, (ndr1_0_ -> (c0_1_ X44 \/ (~(c1_1_ X44) \/ ~(c3_1_ X44))))) \/ (hskp9_ \/ hskp2_)) /\ (((forall X45 : Universe, (ndr1_0_ -> (c0_1_ X45 \/ (~(c2_1_ X45) \/ ~(c3_1_ X45))))) \/ hskp19_) /\ (((forall X46 : Universe, (ndr1_0_ -> (c0_1_ X46 \/ (~(c2_1_ X46) \/ ~(c3_1_ X46))))) \/ (hskp20_ \/ hskp3_)) /\ (((forall X47 : Universe, (ndr1_0_ -> (c1_1_ X47 \/ (c2_1_ X47 \/ c3_1_ X47)))) \/ ((forall X48 : Universe, (ndr1_0_ -> (c3_1_ X48 \/ (~(c0_1_ X48) \/ ~(c1_1_ X48))))) \/ hskp9_)) /\ (((forall X49 : Universe, (ndr1_0_ -> (c1_1_ X49 \/ (c2_1_ X49 \/ c3_1_ X49)))) \/ ((forall X50 : Universe, (ndr1_0_ -> (~(c1_1_ X50) \/ (~(c2_1_ X50) \/ ~(c3_1_ X50))))) \/ hskp20_)) /\ (((forall X51 : Universe, (ndr1_0_ -> (c1_1_ X51 \/ (c2_1_ X51 \/ c3_1_ X51)))) \/ (hskp6_ \/ hskp8_)) /\ (((forall X52 : Universe, (ndr1_0_ -> (c1_1_ X52 \/ (c2_1_ X52 \/ ~(c0_1_ X52))))) \/ (hskp21_ \/ hskp22_)) /\ (((forall X53 : Universe, (ndr1_0_ -> (c1_1_ X53 \/ (c2_1_ X53 \/ ~(c3_1_ X53))))) \/ ((forall X54 : Universe, (ndr1_0_ -> (c2_1_ X54 \/ (c3_1_ X54 \/ ~(c1_1_ X54))))) \/ hskp23_)) /\ (((forall X55 : Universe, (ndr1_0_ -> (c1_1_ X55 \/ (c2_1_ X55 \/ ~(c3_1_ X55))))) \/ ((forall X56 : Universe, (ndr1_0_ -> (c2_1_ X56 \/ (~(c0_1_ X56) \/ ~(c1_1_ X56))))) \/ hskp1_)) /\ (((forall X57 : Universe, (ndr1_0_ -> (c1_1_ X57 \/ (c2_1_ X57 \/ ~(c3_1_ X57))))) \/ (hskp24_ \/ hskp25_)) /\ (((forall X58 : Universe, (ndr1_0_ -> (c1_1_ X58 \/ (c3_1_ X58 \/ ~(c0_1_ X58))))) \/ (hskp14_ \/ hskp13_)) /\ (((forall X59 : Universe, (ndr1_0_ -> (c1_1_ X59 \/ (c3_1_ X59 \/ ~(c2_1_ X59))))) \/ ((forall X60 : Universe, (ndr1_0_ -> (c1_1_ X60 \/ (~(c0_1_ X60) \/ ~(c2_1_ X60))))) \/ hskp17_)) /\ (((forall X61 : Universe, (ndr1_0_ -> (c1_1_ X61 \/ (~(c0_1_ X61) \/ ~(c2_1_ X61))))) \/ ((forall X62 : Universe, (ndr1_0_ -> (~(c0_1_ X62) \/ (~(c1_1_ X62) \/ ~(c2_1_ X62))))) \/ hskp25_)) /\ (((forall X63 : Universe, (ndr1_0_ -> (c1_1_ X63 \/ (~(c0_1_ X63) \/ ~(c2_1_ X63))))) \/ hskp14_) /\ (((forall X64 : Universe, (ndr1_0_ -> (c1_1_ X64 \/ (~(c0_1_ X64) \/ ~(c2_1_ X64))))) \/ (hskp0_ \/ hskp2_)) /\ (((forall X65 : Universe, (ndr1_0_ -> (c1_1_ X65 \/ (~(c2_1_ X65) \/ ~(c3_1_ X65))))) \/ hskp21_) /\ (((forall X66 : Universe, (ndr1_0_ -> (c1_1_ X66 \/ (~(c2_1_ X66) \/ ~(c3_1_ X66))))) \/ (hskp14_ \/ hskp11_)) /\ (((forall X67 : Universe, (ndr1_0_ -> (c1_1_ X67 \/ (~(c2_1_ X67) \/ ~(c3_1_ X67))))) \/ (hskp9_ \/ hskp11_)) /\ (((forall X68 : Universe, (ndr1_0_ -> (c2_1_ X68 \/ (c3_1_ X68 \/ ~(c0_1_ X68))))) \/ (hskp22_ \/ hskp5_)) /\ (((forall X69 : Universe, (ndr1_0_ -> (c2_1_ X69 \/ (~(c0_1_ X69) \/ ~(c1_1_ X69))))) \/ (hskp30_ \/ hskp9_)) /\ (((forall X70 : Universe, (ndr1_0_ -> (c2_1_ X70 \/ (~(c0_1_ X70) \/ ~(c1_1_ X70))))) \/ (hskp4_ \/ hskp1_)) /\ (((forall X71 : Universe, (ndr1_0_ -> (c2_1_ X71 \/ (~(c0_1_ X71) \/ ~(c3_1_ X71))))) \/ (hskp28_ \/ hskp9_)) /\ (((forall X72 : Universe, (ndr1_0_ -> (c2_1_ X72 \/ (~(c1_1_ X72) \/ ~(c3_1_ X72))))) \/ ((forall X73 : Universe, (ndr1_0_ -> (~(c0_1_ X73) \/ (~(c2_1_ X73) \/ ~(c3_1_ X73))))) \/ hskp26_)) /\ (((forall X74 : Universe, (ndr1_0_ -> (c3_1_ X74 \/ (~(c0_1_ X74) \/ ~(c1_1_ X74))))) \/ ((forall X75 : Universe, (ndr1_0_ -> (c3_1_ X75 \/ (~(c0_1_ X75) \/ ~(c2_1_ X75))))) \/ hskp5_)) /\ (((forall X76 : Universe, (ndr1_0_ -> (c3_1_ X76 \/ (~(c0_1_ X76) \/ ~(c2_1_ X76))))) \/ ((forall X77 : Universe, (ndr1_0_ -> (c3_1_ X77 \/ (~(c1_1_ X77) \/ ~(c2_1_ X77))))) \/ hskp31_)) /\ (((forall X78 : Universe, (ndr1_0_ -> (~(c0_1_ X78) \/ (~(c1_1_ X78) \/ ~(c2_1_ X78))))) \/ (hskp5_ \/ hskp13_)) /\ (((forall X79 : Universe, (ndr1_0_ -> (~(c0_1_ X79) \/ (~(c1_1_ X79) \/ ~(c3_1_ X79))))) \/ (hskp19_ \/ hskp2_)) /\ (((forall X80 : Universe, (ndr1_0_ -> (~(c1_1_ X80) \/ (~(c2_1_ X80) \/ ~(c3_1_ X80))))) \/ (hskp31_ \/ hskp3_)) /\ (((forall X81 : Universe, (ndr1_0_ -> (~(c1_1_ X81) \/ (~(c2_1_ X81) \/ ~(c3_1_ X81))))) \/ (hskp20_ \/ hskp24_)) /\ ((hskp31_ \/ (hskp12_ \/ hskp13_)) /\ ((hskp28_ \/ (hskp6_ \/ hskp18_)) /\ ((hskp20_ \/ (hskp27_ \/ hskp13_)) /\ (hskp0_ \/ hskp5_))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
