(*
% File     : SYN455+1 : ILTP v1.1.2
% Domain   : Syntactic (Translated)
% Problem  : ALC, N=4, R=1, L=60, K=3, D=1, P=0, Index=056
% Version  : Especial.
% English  : 
% Refs     : [OS95]  Ohlbach & Schmidt (1995), Functional Translation and S
%          : [HS97]  Hustadt & Schmidt (1997), On Evaluating Decision Proce
%          : [Wei97] Weidenbach (1997), Email to G. Sutcliffe
% Source   : [Wei97]
% Names    : alc-4-1-60-3-1-056.dfg [Wei97]
% Status   : Theorem
% Rating   : 0.33 v3.1.0, 0.67 v2.7.0, 0.33 v2.6.0, 0.00 v2.5.0, 0.33 v2.4.0, 0.33 v2.2.1, 0.50 v2.2.0, 0.00 v2.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :    1 (   0 unit)
%            Number of atoms       :  603 (   0 equality)
%            Maximal formula depth :   96 (  96 average)
%            Number of connectives :  811 ( 209 ~  ; 329  |; 183  &)
%                                         (   0 <=>;  90 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   36 (  32 propositional; 0-1 arity)
%            Number of functors    :   31 (  31 constant; 0-0 arity)
%            Number of variables   :   90 (   0 singleton;  90 !;   0 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : These ALC problems have been translated from propositional 
%            multi-modal K logic formulae generated according to the scheme
%            described in [HS97], using the optimized functional translation
%            described in [OS95]. The finite model property holds, the
%            Herbrand Universe is finite, they are decidable (the complexity
%            is PSPACE-complete), resolution + subsumption + condensing is a
%            decision procedure, and the translated formulae belong to the
%            (CNF-translation of the) Bernays-Schoenfinkel class [Wei97].
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable ndr1_0_ : Prop.
Variable hskp9_ : Prop.
Variable hskp8_ : Prop.
Variable hskp7_ : Prop.
Variable hskp6_ : Prop.
Variable hskp5_ : Prop.
Variable hskp4_ : Prop.
Variable hskp30_ : Prop.
Variable hskp3_ : Prop.
Variable hskp29_ : Prop.
Variable hskp28_ : Prop.
Variable hskp27_ : Prop.
Variable hskp26_ : Prop.
Variable hskp25_ : Prop.
Variable hskp24_ : Prop.
Variable hskp23_ : Prop.
Variable hskp22_ : Prop.
Variable hskp21_ : Prop.
Variable hskp20_ : Prop.
Variable hskp2_ : Prop.
Variable hskp19_ : Prop.
Variable hskp18_ : Prop.
Variable hskp17_ : Prop.
Variable hskp16_ : Prop.
Variable hskp15_ : Prop.
Variable hskp14_ : Prop.
Variable hskp13_ : Prop.
Variable hskp12_ : Prop.
Variable hskp11_ : Prop.
Variable hskp10_ : Prop.
Variable hskp1_ : Prop.
Variable hskp0_ : Prop.
Variable c3_1_ : Universe -> Prop.
Variable c2_1_ : Universe -> Prop.
Variable c1_1_ : Universe -> Prop.
Variable c0_1_ : Universe -> Prop.

Variable a979_ : Universe.
Variable a960_ : Universe.
Variable a959_ : Universe.
Variable a954_ : Universe.
Variable a949_ : Universe.
Variable a946_ : Universe.
Variable a942_ : Universe.
Variable a939_ : Universe.
Variable a938_ : Universe.
Variable a937_ : Universe.
Variable a936_ : Universe.
Variable a933_ : Universe.
Variable a926_ : Universe.
Variable a924_ : Universe.
Variable a923_ : Universe.
Variable a921_ : Universe.
Variable a917_ : Universe.
Variable a916_ : Universe.
Variable a914_ : Universe.
Variable a912_ : Universe.
Variable a910_ : Universe.
Variable a909_ : Universe.
Variable a908_ : Universe.
Variable a907_ : Universe.
Variable a906_ : Universe.
Variable a905_ : Universe.
Variable a904_ : Universe.
Variable a903_ : Universe.
Variable a902_ : Universe.
Variable a901_ : Universe.
Variable a900_ : Universe.


Theorem co1_1 : ~(((~(hskp0_) \/ (ndr1_0_ /\ (~(c0_1_ a901_) /\ (~(c1_1_ a901_) /\ ~(c3_1_ a901_))))) /\ ((~(hskp1_) \/ (ndr1_0_ /\ (c0_1_ a902_ /\ (c2_1_ a902_ /\ ~(c1_1_ a902_))))) /\ ((~(hskp2_) \/ (ndr1_0_ /\ (c0_1_ a903_ /\ (~(c2_1_ a903_) /\ ~(c3_1_ a903_))))) /\ ((~(hskp3_) \/ (ndr1_0_ /\ (c0_1_ a904_ /\ (~(c1_1_ a904_) /\ ~(c2_1_ a904_))))) /\ ((~(hskp4_) \/ (ndr1_0_ /\ (c3_1_ a905_ /\ (~(c0_1_ a905_) /\ ~(c2_1_ a905_))))) /\ ((~(hskp5_) \/ (ndr1_0_ /\ (c0_1_ a906_ /\ (c2_1_ a906_ /\ ~(c3_1_ a906_))))) /\ ((~(hskp6_) \/ (ndr1_0_ /\ (c0_1_ a907_ /\ (c1_1_ a907_ /\ ~(c2_1_ a907_))))) /\ ((~(hskp7_) \/ (ndr1_0_ /\ (c1_1_ a908_ /\ (~(c2_1_ a908_) /\ ~(c3_1_ a908_))))) /\ ((~(hskp8_) \/ (ndr1_0_ /\ (c1_1_ a909_ /\ (~(c0_1_ a909_) /\ ~(c3_1_ a909_))))) /\ ((~(hskp9_) \/ (ndr1_0_ /\ (c2_1_ a910_ /\ (~(c1_1_ a910_) /\ ~(c3_1_ a910_))))) /\ ((~(hskp10_) \/ (ndr1_0_ /\ (c1_1_ a912_ /\ (c2_1_ a912_ /\ ~(c0_1_ a912_))))) /\ ((~(hskp11_) \/ (ndr1_0_ /\ (c0_1_ a914_ /\ (c3_1_ a914_ /\ ~(c2_1_ a914_))))) /\ ((~(hskp12_) \/ (ndr1_0_ /\ (c1_1_ a917_ /\ (c3_1_ a917_ /\ ~(c2_1_ a917_))))) /\ ((~(hskp13_) \/ (ndr1_0_ /\ (c2_1_ a921_ /\ (~(c0_1_ a921_) /\ ~(c3_1_ a921_))))) /\ ((~(hskp14_) \/ (ndr1_0_ /\ (c3_1_ a923_ /\ (~(c0_1_ a923_) /\ ~(c1_1_ a923_))))) /\ ((~(hskp15_) \/ (ndr1_0_ /\ (c2_1_ a924_ /\ (~(c0_1_ a924_) /\ ~(c1_1_ a924_))))) /\ ((~(hskp16_) \/ (ndr1_0_ /\ (c1_1_ a926_ /\ (c2_1_ a926_ /\ ~(c3_1_ a926_))))) /\ ((~(hskp17_) \/ (ndr1_0_ /\ (~(c1_1_ a936_) /\ (~(c2_1_ a936_) /\ ~(c3_1_ a936_))))) /\ ((~(hskp18_) \/ (ndr1_0_ /\ (c1_1_ a937_ /\ (~(c0_1_ a937_) /\ ~(c2_1_ a937_))))) /\ ((~(hskp19_) \/ (ndr1_0_ /\ (c2_1_ a938_ /\ (c3_1_ a938_ /\ ~(c0_1_ a938_))))) /\ ((~(hskp20_) \/ (ndr1_0_ /\ (c0_1_ a939_ /\ (~(c1_1_ a939_) /\ ~(c3_1_ a939_))))) /\ ((~(hskp21_) \/ (ndr1_0_ /\ (~(c0_1_ a946_) /\ (~(c2_1_ a946_) /\ ~(c3_1_ a946_))))) /\ ((~(hskp22_) \/ (ndr1_0_ /\ (c2_1_ a949_ /\ (c3_1_ a949_ /\ ~(c1_1_ a949_))))) /\ ((~(hskp23_) \/ (ndr1_0_ /\ (c1_1_ a954_ /\ (c3_1_ a954_ /\ ~(c0_1_ a954_))))) /\ ((~(hskp24_) \/ (ndr1_0_ /\ (~(c0_1_ a959_) /\ (~(c1_1_ a959_) /\ ~(c2_1_ a959_))))) /\ ((~(hskp25_) \/ (ndr1_0_ /\ (c0_1_ a960_ /\ (c3_1_ a960_ /\ ~(c1_1_ a960_))))) /\ ((~(hskp26_) \/ (ndr1_0_ /\ (c0_1_ a979_ /\ (c1_1_ a979_ /\ ~(c3_1_ a979_))))) /\ ((~(hskp27_) \/ (ndr1_0_ /\ (c1_1_ a900_ /\ (c2_1_ a900_ /\ c3_1_ a900_)))) /\ ((~(hskp28_) \/ (ndr1_0_ /\ (c0_1_ a916_ /\ (c1_1_ a916_ /\ c3_1_ a916_)))) /\ ((~(hskp29_) \/ (ndr1_0_ /\ (c0_1_ a933_ /\ (c2_1_ a933_ /\ c3_1_ a933_)))) /\ ((~(hskp30_) \/ (ndr1_0_ /\ (c0_1_ a942_ /\ (c1_1_ a942_ /\ c2_1_ a942_)))) /\ (((forall U : Universe, (ndr1_0_ -> (c0_1_ U \/ (c1_1_ U \/ c2_1_ U)))) \/ ((forall V : Universe, (ndr1_0_ -> (c0_1_ V \/ (c2_1_ V \/ ~(c3_1_ V))))) \/ (forall W : Universe, (ndr1_0_ -> (~(c0_1_ W) \/ (~(c1_1_ W) \/ ~(c3_1_ W))))))) /\ (((forall X : Universe, (ndr1_0_ -> (c0_1_ X \/ (c1_1_ X \/ c2_1_ X)))) \/ ((forall Y : Universe, (ndr1_0_ -> (c0_1_ Y \/ (c3_1_ Y \/ ~(c2_1_ Y))))) \/ (forall Z : Universe, (ndr1_0_ -> (c1_1_ Z \/ (c3_1_ Z \/ ~(c0_1_ Z))))))) /\ (((forall X1 : Universe, (ndr1_0_ -> (c0_1_ X1 \/ (c1_1_ X1 \/ c2_1_ X1)))) \/ ((forall X2 : Universe, (ndr1_0_ -> (c0_1_ X2 \/ (~(c1_1_ X2) \/ ~(c3_1_ X2))))) \/ hskp27_)) /\ (((forall X3 : Universe, (ndr1_0_ -> (c0_1_ X3 \/ (c1_1_ X3 \/ c2_1_ X3)))) \/ ((forall X4 : Universe, (ndr1_0_ -> (c2_1_ X4 \/ (~(c0_1_ X4) \/ ~(c3_1_ X4))))) \/ hskp0_)) /\ (((forall X5 : Universe, (ndr1_0_ -> (c0_1_ X5 \/ (c1_1_ X5 \/ c2_1_ X5)))) \/ ((forall X6 : Universe, (ndr1_0_ -> (c3_1_ X6 \/ (~(c0_1_ X6) \/ ~(c2_1_ X6))))) \/ (forall X7 : Universe, (ndr1_0_ -> (c3_1_ X7 \/ (~(c1_1_ X7) \/ ~(c2_1_ X7))))))) /\ (((forall X8 : Universe, (ndr1_0_ -> (c0_1_ X8 \/ (c1_1_ X8 \/ c2_1_ X8)))) \/ (hskp1_ \/ hskp2_)) /\ (((forall X9 : Universe, (ndr1_0_ -> (c0_1_ X9 \/ (c1_1_ X9 \/ c3_1_ X9)))) \/ ((forall X10 : Universe, (ndr1_0_ -> (c0_1_ X10 \/ (c2_1_ X10 \/ c3_1_ X10)))) \/ (forall X11 : Universe, (ndr1_0_ -> (c2_1_ X11 \/ (c3_1_ X11 \/ ~(c0_1_ X11))))))) /\ (((forall X12 : Universe, (ndr1_0_ -> (c0_1_ X12 \/ (c1_1_ X12 \/ c3_1_ X12)))) \/ ((forall X13 : Universe, (ndr1_0_ -> (c0_1_ X13 \/ (~(c1_1_ X13) \/ ~(c2_1_ X13))))) \/ (forall X14 : Universe, (ndr1_0_ -> (c2_1_ X14 \/ (c3_1_ X14 \/ ~(c0_1_ X14))))))) /\ (((forall X15 : Universe, (ndr1_0_ -> (c0_1_ X15 \/ (c1_1_ X15 \/ ~(c2_1_ X15))))) \/ (hskp3_ \/ hskp4_)) /\ (((forall X16 : Universe, (ndr1_0_ -> (c0_1_ X16 \/ (c1_1_ X16 \/ ~(c3_1_ X16))))) \/ ((forall X17 : Universe, (ndr1_0_ -> (~(c1_1_ X17) \/ (~(c2_1_ X17) \/ ~(c3_1_ X17))))) \/ hskp5_)) /\ (((forall X18 : Universe, (ndr1_0_ -> (c0_1_ X18 \/ (c1_1_ X18 \/ ~(c3_1_ X18))))) \/ (hskp6_ \/ hskp7_)) /\ (((forall X19 : Universe, (ndr1_0_ -> (c0_1_ X19 \/ (c2_1_ X19 \/ c3_1_ X19)))) \/ ((forall X20 : Universe, (ndr1_0_ -> (c0_1_ X20 \/ (~(c1_1_ X20) \/ ~(c3_1_ X20))))) \/ hskp8_)) /\ (((forall X21 : Universe, (ndr1_0_ -> (c0_1_ X21 \/ (c2_1_ X21 \/ c3_1_ X21)))) \/ ((forall X22 : Universe, (ndr1_0_ -> (c1_1_ X22 \/ (c2_1_ X22 \/ ~(c0_1_ X22))))) \/ hskp9_)) /\ (((forall X23 : Universe, (ndr1_0_ -> (c0_1_ X23 \/ (c2_1_ X23 \/ c3_1_ X23)))) \/ (hskp27_ \/ hskp10_)) /\ (((forall X24 : Universe, (ndr1_0_ -> (c0_1_ X24 \/ (c3_1_ X24 \/ ~(c1_1_ X24))))) \/ (hskp6_ \/ hskp11_)) /\ (((forall X25 : Universe, (ndr1_0_ -> (c0_1_ X25 \/ (c3_1_ X25 \/ ~(c2_1_ X25))))) \/ ((forall X26 : Universe, (ndr1_0_ -> (c0_1_ X26 \/ (~(c2_1_ X26) \/ ~(c3_1_ X26))))) \/ hskp5_)) /\ (((forall X27 : Universe, (ndr1_0_ -> (c0_1_ X27 \/ (c3_1_ X27 \/ ~(c2_1_ X27))))) \/ (hskp28_ \/ hskp12_)) /\ (((forall X28 : Universe, (ndr1_0_ -> (c0_1_ X28 \/ (c3_1_ X28 \/ ~(c2_1_ X28))))) \/ (hskp2_ \/ hskp0_)) /\ (((forall X29 : Universe, (ndr1_0_ -> (c0_1_ X29 \/ (~(c1_1_ X29) \/ ~(c2_1_ X29))))) \/ ((forall X30 : Universe, (ndr1_0_ -> (c1_1_ X30 \/ (c3_1_ X30 \/ ~(c2_1_ X30))))) \/ (forall X31 : Universe, (ndr1_0_ -> (c2_1_ X31 \/ (~(c1_1_ X31) \/ ~(c3_1_ X31))))))) /\ (((forall X32 : Universe, (ndr1_0_ -> (c0_1_ X32 \/ (~(c1_1_ X32) \/ ~(c2_1_ X32))))) \/ (hskp3_ \/ hskp13_)) /\ (((forall X33 : Universe, (ndr1_0_ -> (c0_1_ X33 \/ (~(c1_1_ X33) \/ ~(c2_1_ X33))))) \/ (hskp7_ \/ hskp14_)) /\ (((forall X34 : Universe, (ndr1_0_ -> (c0_1_ X34 \/ (~(c2_1_ X34) \/ ~(c3_1_ X34))))) \/ ((forall X35 : Universe, (ndr1_0_ -> (~(c1_1_ X35) \/ (~(c2_1_ X35) \/ ~(c3_1_ X35))))) \/ hskp15_)) /\ (((forall X36 : Universe, (ndr1_0_ -> (c0_1_ X36 \/ (~(c2_1_ X36) \/ ~(c3_1_ X36))))) \/ (hskp28_ \/ hskp16_)) /\ (((forall X37 : Universe, (ndr1_0_ -> (c0_1_ X37 \/ (~(c2_1_ X37) \/ ~(c3_1_ X37))))) \/ (hskp7_ \/ hskp13_)) /\ (((forall X38 : Universe, (ndr1_0_ -> (c1_1_ X38 \/ (c2_1_ X38 \/ c3_1_ X38)))) \/ (hskp11_ \/ hskp27_)) /\ (((forall X39 : Universe, (ndr1_0_ -> (c1_1_ X39 \/ (c2_1_ X39 \/ c3_1_ X39)))) \/ (hskp27_ \/ hskp9_)) /\ (((forall X40 : Universe, (ndr1_0_ -> (c1_1_ X40 \/ (c2_1_ X40 \/ ~(c0_1_ X40))))) \/ ((forall X41 : Universe, (ndr1_0_ -> (c1_1_ X41 \/ (~(c0_1_ X41) \/ ~(c3_1_ X41))))) \/ hskp29_)) /\ (((forall X42 : Universe, (ndr1_0_ -> (c1_1_ X42 \/ (c2_1_ X42 \/ ~(c0_1_ X42))))) \/ ((forall X43 : Universe, (ndr1_0_ -> (~(c0_1_ X43) \/ (~(c1_1_ X43) \/ ~(c3_1_ X43))))) \/ hskp15_)) /\ (((forall X44 : Universe, (ndr1_0_ -> (c1_1_ X44 \/ (c2_1_ X44 \/ ~(c0_1_ X44))))) \/ (hskp12_ \/ hskp17_)) /\ (((forall X45 : Universe, (ndr1_0_ -> (c1_1_ X45 \/ (c2_1_ X45 \/ ~(c0_1_ X45))))) \/ (hskp18_ \/ hskp19_)) /\ (((forall X46 : Universe, (ndr1_0_ -> (c1_1_ X46 \/ (c2_1_ X46 \/ ~(c3_1_ X46))))) \/ (hskp20_ \/ hskp18_)) /\ (((forall X47 : Universe, (ndr1_0_ -> (c1_1_ X47 \/ (c3_1_ X47 \/ ~(c0_1_ X47))))) \/ ((forall X48 : Universe, (ndr1_0_ -> (~(c0_1_ X48) \/ (~(c2_1_ X48) \/ ~(c3_1_ X48))))) \/ hskp9_)) /\ (((forall X49 : Universe, (ndr1_0_ -> (c1_1_ X49 \/ (c3_1_ X49 \/ ~(c0_1_ X49))))) \/ (hskp30_ \/ hskp7_)) /\ (((forall X50 : Universe, (ndr1_0_ -> (c1_1_ X50 \/ (~(c0_1_ X50) \/ ~(c2_1_ X50))))) \/ ((forall X51 : Universe, (ndr1_0_ -> (c2_1_ X51 \/ (c3_1_ X51 \/ ~(c1_1_ X51))))) \/ hskp27_)) /\ (((forall X52 : Universe, (ndr1_0_ -> (c1_1_ X52 \/ (~(c0_1_ X52) \/ ~(c2_1_ X52))))) \/ ((forall X53 : Universe, (ndr1_0_ -> (c2_1_ X53 \/ (~(c0_1_ X53) \/ ~(c1_1_ X53))))) \/ hskp0_)) /\ (((forall X54 : Universe, (ndr1_0_ -> (c1_1_ X54 \/ (~(c0_1_ X54) \/ ~(c3_1_ X54))))) \/ ((forall X55 : Universe, (ndr1_0_ -> (c2_1_ X55 \/ (c3_1_ X55 \/ ~(c1_1_ X55))))) \/ hskp21_)) /\ (((forall X56 : Universe, (ndr1_0_ -> (c1_1_ X56 \/ (~(c0_1_ X56) \/ ~(c3_1_ X56))))) \/ ((forall X57 : Universe, (ndr1_0_ -> (~(c0_1_ X57) \/ (~(c1_1_ X57) \/ ~(c3_1_ X57))))) \/ hskp1_)) /\ (((forall X58 : Universe, (ndr1_0_ -> (c1_1_ X58 \/ (~(c0_1_ X58) \/ ~(c3_1_ X58))))) \/ hskp28_) /\ (((forall X59 : Universe, (ndr1_0_ -> (c2_1_ X59 \/ (c3_1_ X59 \/ ~(c0_1_ X59))))) \/ ((forall X60 : Universe, (ndr1_0_ -> (c2_1_ X60 \/ (~(c1_1_ X60) \/ ~(c3_1_ X60))))) \/ hskp22_)) /\ (((forall X61 : Universe, (ndr1_0_ -> (c2_1_ X61 \/ (c3_1_ X61 \/ ~(c0_1_ X61))))) \/ ((forall X62 : Universe, (ndr1_0_ -> (c3_1_ X62 \/ (~(c0_1_ X62) \/ ~(c1_1_ X62))))) \/ hskp0_)) /\ (((forall X63 : Universe, (ndr1_0_ -> (c2_1_ X63 \/ (c3_1_ X63 \/ ~(c0_1_ X63))))) \/ (hskp6_ \/ hskp14_)) /\ (((forall X64 : Universe, (ndr1_0_ -> (c2_1_ X64 \/ (c3_1_ X64 \/ ~(c0_1_ X64))))) \/ (hskp1_ \/ hskp23_)) /\ (((forall X65 : Universe, (ndr1_0_ -> (c2_1_ X65 \/ (c3_1_ X65 \/ ~(c1_1_ X65))))) \/ (forall X66 : Universe, (ndr1_0_ -> (c2_1_ X66 \/ (~(c1_1_ X66) \/ ~(c3_1_ X66)))))) /\ (((forall X67 : Universe, (ndr1_0_ -> (c2_1_ X67 \/ (c3_1_ X67 \/ ~(c1_1_ X67))))) \/ ((forall X68 : Universe, (ndr1_0_ -> (c3_1_ X68 \/ (~(c0_1_ X68) \/ ~(c2_1_ X68))))) \/ (forall X69 : Universe, (ndr1_0_ -> (~(c0_1_ X69) \/ (~(c1_1_ X69) \/ ~(c3_1_ X69))))))) /\ (((forall X70 : Universe, (ndr1_0_ -> (c2_1_ X70 \/ (c3_1_ X70 \/ ~(c1_1_ X70))))) \/ ((forall X71 : Universe, (ndr1_0_ -> (~(c1_1_ X71) \/ (~(c2_1_ X71) \/ ~(c3_1_ X71))))) \/ hskp16_)) /\ (((forall X72 : Universe, (ndr1_0_ -> (c2_1_ X72 \/ (c3_1_ X72 \/ ~(c1_1_ X72))))) \/ (hskp30_ \/ hskp9_)) /\ (((forall X73 : Universe, (ndr1_0_ -> (c2_1_ X73 \/ (~(c0_1_ X73) \/ ~(c1_1_ X73))))) \/ (hskp30_ \/ hskp24_)) /\ (((forall X74 : Universe, (ndr1_0_ -> (c2_1_ X74 \/ (~(c0_1_ X74) \/ ~(c3_1_ X74))))) \/ ((forall X75 : Universe, (ndr1_0_ -> (c3_1_ X75 \/ (~(c0_1_ X75) \/ ~(c1_1_ X75))))) \/ hskp25_)) /\ (((forall X76 : Universe, (ndr1_0_ -> (c2_1_ X76 \/ (~(c0_1_ X76) \/ ~(c3_1_ X76))))) \/ (hskp1_ \/ hskp10_)) /\ (((forall X77 : Universe, (ndr1_0_ -> (c2_1_ X77 \/ (~(c0_1_ X77) \/ ~(c3_1_ X77))))) \/ (hskp5_ \/ hskp7_)) /\ (((forall X78 : Universe, (ndr1_0_ -> (c2_1_ X78 \/ (~(c1_1_ X78) \/ ~(c3_1_ X78))))) \/ (hskp25_ \/ hskp21_)) /\ (((forall X79 : Universe, (ndr1_0_ -> (c2_1_ X79 \/ (~(c1_1_ X79) \/ ~(c3_1_ X79))))) \/ (hskp10_ \/ hskp21_)) /\ (((forall X80 : Universe, (ndr1_0_ -> (c3_1_ X80 \/ (~(c0_1_ X80) \/ ~(c1_1_ X80))))) \/ (hskp27_ \/ hskp13_)) /\ (((forall X81 : Universe, (ndr1_0_ -> (c3_1_ X81 \/ (~(c0_1_ X81) \/ ~(c2_1_ X81))))) \/ (hskp30_ \/ hskp17_)) /\ (((forall X82 : Universe, (ndr1_0_ -> (c3_1_ X82 \/ (~(c1_1_ X82) \/ ~(c2_1_ X82))))) \/ (hskp20_ \/ hskp8_)) /\ (((forall X83 : Universe, (ndr1_0_ -> (~(c0_1_ X83) \/ (~(c2_1_ X83) \/ ~(c3_1_ X83))))) \/ (hskp23_ \/ hskp15_)) /\ (((forall X84 : Universe, (ndr1_0_ -> (~(c1_1_ X84) \/ (~(c2_1_ X84) \/ ~(c3_1_ X84))))) \/ (hskp11_ \/ hskp12_)) /\ ((hskp26_ \/ (hskp5_ \/ hskp21_)) /\ ((hskp20_ \/ (hskp14_ \/ hskp4_)) /\ (hskp12_ \/ (hskp13_ \/ hskp21_))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
