(*
% File     : SYN450+1 : ILTP v1.1.2
% Domain   : Syntactic (Translated)
% Problem  : ALC, N=4, R=1, L=60, K=3, D=1, P=0, Index=029
% Version  : Especial.
% English  : 
% Refs     : [OS95]  Ohlbach & Schmidt (1995), Functional Translation and S
%          : [HS97]  Hustadt & Schmidt (1997), On Evaluating Decision Proce
%          : [Wei97] Weidenbach (1997), Email to G. Sutcliffe
% Source   : [Wei97]
% Names    : alc-4-1-60-3-1-029.dfg [Wei97]
% Status   : Theorem
% Rating   : 0.33 v3.1.0, 0.67 v2.7.0, 0.33 v2.6.0, 0.00 v2.5.0, 0.33 v2.4.0, 0.33 v2.2.1, 0.50 v2.2.0, 0.00 v2.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :    1 (   0 unit)
%            Number of atoms       :  599 (   0 equality)
%            Maximal formula depth :   93 (  93 average)
%            Number of connectives :  812 ( 214 ~  ; 329  |; 179  &)
%                                         (   0 <=>;  90 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   35 (  31 propositional; 0-1 arity)
%            Number of functors    :   30 (  30 constant; 0-0 arity)
%            Number of variables   :   90 (   0 singleton;  90 !;   0 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : These ALC problems have been translated from propositional 
%            multi-modal K logic formulae generated according to the scheme
%            described in [HS97], using the optimized functional translation
%            described in [OS95]. The finite model property holds, the
%            Herbrand Universe is finite, they are decidable (the complexity
%            is PSPACE-complete), resolution + subsumption + condensing is a
%            decision procedure, and the translated formulae belong to the
%            (CNF-translation of the) Bernays-Schoenfinkel class [Wei97].
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable ndr1_0_ : Prop.
Variable hskp9_ : Prop.
Variable hskp8_ : Prop.
Variable hskp7_ : Prop.
Variable hskp6_ : Prop.
Variable hskp5_ : Prop.
Variable hskp4_ : Prop.
Variable hskp3_ : Prop.
Variable hskp29_ : Prop.
Variable hskp28_ : Prop.
Variable hskp27_ : Prop.
Variable hskp26_ : Prop.
Variable hskp25_ : Prop.
Variable hskp24_ : Prop.
Variable hskp23_ : Prop.
Variable hskp22_ : Prop.
Variable hskp21_ : Prop.
Variable hskp20_ : Prop.
Variable hskp2_ : Prop.
Variable hskp19_ : Prop.
Variable hskp18_ : Prop.
Variable hskp17_ : Prop.
Variable hskp16_ : Prop.
Variable hskp15_ : Prop.
Variable hskp14_ : Prop.
Variable hskp13_ : Prop.
Variable hskp12_ : Prop.
Variable hskp11_ : Prop.
Variable hskp10_ : Prop.
Variable hskp1_ : Prop.
Variable hskp0_ : Prop.
Variable c3_1_ : Universe -> Prop.
Variable c2_1_ : Universe -> Prop.
Variable c1_1_ : Universe -> Prop.
Variable c0_1_ : Universe -> Prop.

Variable a710_ : Universe.
Variable a698_ : Universe.
Variable a695_ : Universe.
Variable a693_ : Universe.
Variable a691_ : Universe.
Variable a688_ : Universe.
Variable a686_ : Universe.
Variable a682_ : Universe.
Variable a676_ : Universe.
Variable a675_ : Universe.
Variable a672_ : Universe.
Variable a671_ : Universe.
Variable a667_ : Universe.
Variable a665_ : Universe.
Variable a661_ : Universe.
Variable a660_ : Universe.
Variable a657_ : Universe.
Variable a656_ : Universe.
Variable a655_ : Universe.
Variable a654_ : Universe.
Variable a652_ : Universe.
Variable a651_ : Universe.
Variable a648_ : Universe.
Variable a647_ : Universe.
Variable a646_ : Universe.
Variable a645_ : Universe.
Variable a643_ : Universe.
Variable a642_ : Universe.
Variable a641_ : Universe.
Variable a640_ : Universe.


Theorem co1_1 : ~(((~(hskp0_) \/ (ndr1_0_ /\ (c2_1_ a641_ /\ (c3_1_ a641_ /\ ~(c1_1_ a641_))))) /\ ((~(hskp1_) \/ (ndr1_0_ /\ (c0_1_ a642_ /\ (c3_1_ a642_ /\ ~(c1_1_ a642_))))) /\ ((~(hskp2_) \/ (ndr1_0_ /\ (c1_1_ a643_ /\ (c2_1_ a643_ /\ ~(c0_1_ a643_))))) /\ ((~(hskp3_) \/ (ndr1_0_ /\ (c1_1_ a645_ /\ (c3_1_ a645_ /\ ~(c2_1_ a645_))))) /\ ((~(hskp4_) \/ (ndr1_0_ /\ (~(c1_1_ a646_) /\ (~(c2_1_ a646_) /\ ~(c3_1_ a646_))))) /\ ((~(hskp5_) \/ (ndr1_0_ /\ (c1_1_ a647_ /\ (~(c0_1_ a647_) /\ ~(c3_1_ a647_))))) /\ ((~(hskp6_) \/ (ndr1_0_ /\ (c0_1_ a648_ /\ (~(c2_1_ a648_) /\ ~(c3_1_ a648_))))) /\ ((~(hskp7_) \/ (ndr1_0_ /\ (c3_1_ a651_ /\ (~(c0_1_ a651_) /\ ~(c1_1_ a651_))))) /\ ((~(hskp8_) \/ (ndr1_0_ /\ (c0_1_ a652_ /\ (c3_1_ a652_ /\ ~(c2_1_ a652_))))) /\ ((~(hskp9_) \/ (ndr1_0_ /\ (~(c0_1_ a654_) /\ (~(c1_1_ a654_) /\ ~(c2_1_ a654_))))) /\ ((~(hskp10_) \/ (ndr1_0_ /\ (c0_1_ a656_ /\ (c2_1_ a656_ /\ ~(c1_1_ a656_))))) /\ ((~(hskp11_) \/ (ndr1_0_ /\ (c0_1_ a657_ /\ (c2_1_ a657_ /\ ~(c3_1_ a657_))))) /\ ((~(hskp12_) \/ (ndr1_0_ /\ (c0_1_ a660_ /\ (~(c1_1_ a660_) /\ ~(c2_1_ a660_))))) /\ ((~(hskp13_) \/ (ndr1_0_ /\ (c0_1_ a661_ /\ (~(c1_1_ a661_) /\ ~(c3_1_ a661_))))) /\ ((~(hskp14_) \/ (ndr1_0_ /\ (c2_1_ a665_ /\ (~(c0_1_ a665_) /\ ~(c1_1_ a665_))))) /\ ((~(hskp15_) \/ (ndr1_0_ /\ (c3_1_ a667_ /\ (~(c0_1_ a667_) /\ ~(c2_1_ a667_))))) /\ ((~(hskp16_) \/ (ndr1_0_ /\ (c1_1_ a672_ /\ (~(c2_1_ a672_) /\ ~(c3_1_ a672_))))) /\ ((~(hskp17_) \/ (ndr1_0_ /\ (c2_1_ a675_ /\ (~(c1_1_ a675_) /\ ~(c3_1_ a675_))))) /\ ((~(hskp18_) \/ (ndr1_0_ /\ (c0_1_ a676_ /\ (c1_1_ a676_ /\ ~(c2_1_ a676_))))) /\ ((~(hskp19_) \/ (ndr1_0_ /\ (c3_1_ a682_ /\ (~(c1_1_ a682_) /\ ~(c2_1_ a682_))))) /\ ((~(hskp20_) \/ (ndr1_0_ /\ (c1_1_ a686_ /\ (c2_1_ a686_ /\ ~(c3_1_ a686_))))) /\ ((~(hskp21_) \/ (ndr1_0_ /\ (~(c0_1_ a691_) /\ (~(c1_1_ a691_) /\ ~(c3_1_ a691_))))) /\ ((~(hskp22_) \/ (ndr1_0_ /\ (c2_1_ a693_ /\ (c3_1_ a693_ /\ ~(c0_1_ a693_))))) /\ ((~(hskp23_) \/ (ndr1_0_ /\ (c2_1_ a695_ /\ (~(c0_1_ a695_) /\ ~(c3_1_ a695_))))) /\ ((~(hskp24_) \/ (ndr1_0_ /\ (c1_1_ a698_ /\ (~(c0_1_ a698_) /\ ~(c2_1_ a698_))))) /\ ((~(hskp25_) \/ (ndr1_0_ /\ (~(c0_1_ a710_) /\ (~(c2_1_ a710_) /\ ~(c3_1_ a710_))))) /\ ((~(hskp26_) \/ (ndr1_0_ /\ (c0_1_ a640_ /\ (c1_1_ a640_ /\ c3_1_ a640_)))) /\ ((~(hskp27_) \/ (ndr1_0_ /\ (c0_1_ a655_ /\ (c2_1_ a655_ /\ c3_1_ a655_)))) /\ ((~(hskp28_) \/ (ndr1_0_ /\ (c0_1_ a671_ /\ (c1_1_ a671_ /\ c2_1_ a671_)))) /\ ((~(hskp29_) \/ (ndr1_0_ /\ (c1_1_ a688_ /\ (c2_1_ a688_ /\ c3_1_ a688_)))) /\ (((forall U : Universe, (ndr1_0_ -> (c0_1_ U \/ (c1_1_ U \/ c2_1_ U)))) \/ (hskp26_ \/ hskp0_)) /\ (((forall V : Universe, (ndr1_0_ -> (c0_1_ V \/ (c1_1_ V \/ c3_1_ V)))) \/ ((forall W : Universe, (ndr1_0_ -> (c0_1_ W \/ (c1_1_ W \/ ~(c2_1_ W))))) \/ (forall X : Universe, (ndr1_0_ -> (c2_1_ X \/ (~(c0_1_ X) \/ ~(c1_1_ X))))))) /\ (((forall Y : Universe, (ndr1_0_ -> (c0_1_ Y \/ (c1_1_ Y \/ c3_1_ Y)))) \/ ((forall Z : Universe, (ndr1_0_ -> (c0_1_ Z \/ (~(c2_1_ Z) \/ ~(c3_1_ Z))))) \/ hskp1_)) /\ (((forall X1 : Universe, (ndr1_0_ -> (c0_1_ X1 \/ (c1_1_ X1 \/ c3_1_ X1)))) \/ (hskp2_ \/ hskp0_)) /\ (((forall X2 : Universe, (ndr1_0_ -> (c0_1_ X2 \/ (c1_1_ X2 \/ c3_1_ X2)))) \/ (hskp3_ \/ hskp4_)) /\ (((forall X3 : Universe, (ndr1_0_ -> (c0_1_ X3 \/ (c1_1_ X3 \/ ~(c2_1_ X3))))) \/ ((forall X4 : Universe, (ndr1_0_ -> (c1_1_ X4 \/ (c3_1_ X4 \/ ~(c2_1_ X4))))) \/ hskp5_)) /\ (((forall X5 : Universe, (ndr1_0_ -> (c0_1_ X5 \/ (c1_1_ X5 \/ ~(c2_1_ X5))))) \/ (hskp6_ \/ hskp2_)) /\ (((forall X6 : Universe, (ndr1_0_ -> (c0_1_ X6 \/ (c1_1_ X6 \/ ~(c3_1_ X6))))) \/ ((forall X7 : Universe, (ndr1_0_ -> (c2_1_ X7 \/ (c3_1_ X7 \/ ~(c1_1_ X7))))) \/ hskp2_)) /\ (((forall X8 : Universe, (ndr1_0_ -> (c0_1_ X8 \/ (c1_1_ X8 \/ ~(c3_1_ X8))))) \/ ((forall X9 : Universe, (ndr1_0_ -> (c2_1_ X9 \/ (~(c0_1_ X9) \/ ~(c3_1_ X9))))) \/ hskp7_)) /\ (((forall X10 : Universe, (ndr1_0_ -> (c0_1_ X10 \/ (c1_1_ X10 \/ ~(c3_1_ X10))))) \/ ((forall X11 : Universe, (ndr1_0_ -> (~(c0_1_ X11) \/ (~(c1_1_ X11) \/ ~(c2_1_ X11))))) \/ hskp8_)) /\ (((forall X12 : Universe, (ndr1_0_ -> (c0_1_ X12 \/ (c1_1_ X12 \/ ~(c3_1_ X12))))) \/ ((forall X13 : Universe, (ndr1_0_ -> (~(c1_1_ X13) \/ (~(c2_1_ X13) \/ ~(c3_1_ X13))))) \/ hskp3_)) /\ (((forall X14 : Universe, (ndr1_0_ -> (c0_1_ X14 \/ (c2_1_ X14 \/ c3_1_ X14)))) \/ ((forall X15 : Universe, (ndr1_0_ -> (c1_1_ X15 \/ (c2_1_ X15 \/ c3_1_ X15)))) \/ (forall X16 : Universe, (ndr1_0_ -> (~(c0_1_ X16) \/ (~(c1_1_ X16) \/ ~(c3_1_ X16))))))) /\ (((forall X17 : Universe, (ndr1_0_ -> (c0_1_ X17 \/ (c2_1_ X17 \/ c3_1_ X17)))) \/ ((forall X18 : Universe, (ndr1_0_ -> (c1_1_ X18 \/ (c3_1_ X18 \/ ~(c2_1_ X18))))) \/ hskp9_)) /\ (((forall X19 : Universe, (ndr1_0_ -> (c0_1_ X19 \/ (c2_1_ X19 \/ ~(c3_1_ X19))))) \/ ((forall X20 : Universe, (ndr1_0_ -> (c1_1_ X20 \/ (c2_1_ X20 \/ ~(c3_1_ X20))))) \/ hskp27_)) /\ (((forall X21 : Universe, (ndr1_0_ -> (c0_1_ X21 \/ (c2_1_ X21 \/ ~(c3_1_ X21))))) \/ ((forall X22 : Universe, (ndr1_0_ -> (c2_1_ X22 \/ (~(c0_1_ X22) \/ ~(c1_1_ X22))))) \/ hskp10_)) /\ (((forall X23 : Universe, (ndr1_0_ -> (c0_1_ X23 \/ (c3_1_ X23 \/ ~(c1_1_ X23))))) \/ ((forall X24 : Universe, (ndr1_0_ -> (c0_1_ X24 \/ (~(c1_1_ X24) \/ ~(c2_1_ X24))))) \/ (forall X25 : Universe, (ndr1_0_ -> (c1_1_ X25 \/ (c2_1_ X25 \/ ~(c0_1_ X25))))))) /\ (((forall X26 : Universe, (ndr1_0_ -> (c0_1_ X26 \/ (c3_1_ X26 \/ ~(c1_1_ X26))))) \/ ((forall X27 : Universe, (ndr1_0_ -> (c0_1_ X27 \/ (~(c1_1_ X27) \/ ~(c3_1_ X27))))) \/ hskp11_)) /\ (((forall X28 : Universe, (ndr1_0_ -> (c0_1_ X28 \/ (c3_1_ X28 \/ ~(c1_1_ X28))))) \/ ((forall X29 : Universe, (ndr1_0_ -> (c1_1_ X29 \/ (~(c2_1_ X29) \/ ~(c3_1_ X29))))) \/ hskp27_)) /\ (((forall X30 : Universe, (ndr1_0_ -> (c0_1_ X30 \/ (c3_1_ X30 \/ ~(c1_1_ X30))))) \/ ((forall X31 : Universe, (ndr1_0_ -> (c2_1_ X31 \/ (~(c1_1_ X31) \/ ~(c3_1_ X31))))) \/ hskp6_)) /\ (((forall X32 : Universe, (ndr1_0_ -> (c0_1_ X32 \/ (c3_1_ X32 \/ ~(c1_1_ X32))))) \/ (hskp12_ \/ hskp13_)) /\ (((forall X33 : Universe, (ndr1_0_ -> (c0_1_ X33 \/ (c3_1_ X33 \/ ~(c2_1_ X33))))) \/ (hskp6_ \/ hskp3_)) /\ (((forall X34 : Universe, (ndr1_0_ -> (c0_1_ X34 \/ (~(c1_1_ X34) \/ ~(c2_1_ X34))))) \/ ((forall X35 : Universe, (ndr1_0_ -> (c1_1_ X35 \/ (~(c2_1_ X35) \/ ~(c3_1_ X35))))) \/ (forall X36 : Universe, (ndr1_0_ -> (~(c0_1_ X36) \/ (~(c1_1_ X36) \/ ~(c2_1_ X36))))))) /\ (((forall X37 : Universe, (ndr1_0_ -> (c0_1_ X37 \/ (~(c1_1_ X37) \/ ~(c2_1_ X37))))) \/ ((forall X38 : Universe, (ndr1_0_ -> (c1_1_ X38 \/ (~(c2_1_ X38) \/ ~(c3_1_ X38))))) \/ (forall X39 : Universe, (ndr1_0_ -> (~(c1_1_ X39) \/ (~(c2_1_ X39) \/ ~(c3_1_ X39))))))) /\ (((forall X40 : Universe, (ndr1_0_ -> (c0_1_ X40 \/ (~(c1_1_ X40) \/ ~(c3_1_ X40))))) \/ ((forall X41 : Universe, (ndr1_0_ -> (c1_1_ X41 \/ (c3_1_ X41 \/ ~(c0_1_ X41))))) \/ (forall X42 : Universe, (ndr1_0_ -> (c2_1_ X42 \/ (~(c0_1_ X42) \/ ~(c1_1_ X42))))))) /\ (((forall X43 : Universe, (ndr1_0_ -> (c0_1_ X43 \/ (~(c2_1_ X43) \/ ~(c3_1_ X43))))) \/ ((forall X44 : Universe, (ndr1_0_ -> (c1_1_ X44 \/ (c3_1_ X44 \/ ~(c0_1_ X44))))) \/ hskp7_)) /\ (((forall X45 : Universe, (ndr1_0_ -> (c0_1_ X45 \/ (~(c2_1_ X45) \/ ~(c3_1_ X45))))) \/ (hskp14_ \/ hskp4_)) /\ (((forall X46 : Universe, (ndr1_0_ -> (c0_1_ X46 \/ (~(c2_1_ X46) \/ ~(c3_1_ X46))))) \/ (hskp15_ \/ hskp9_)) /\ (((forall X47 : Universe, (ndr1_0_ -> (c1_1_ X47 \/ (c2_1_ X47 \/ c3_1_ X47)))) \/ ((forall X48 : Universe, (ndr1_0_ -> (c1_1_ X48 \/ (c2_1_ X48 \/ ~(c3_1_ X48))))) \/ hskp4_)) /\ (((forall X49 : Universe, (ndr1_0_ -> (c1_1_ X49 \/ (c2_1_ X49 \/ ~(c0_1_ X49))))) \/ ((forall X50 : Universe, (ndr1_0_ -> (c1_1_ X50 \/ (c3_1_ X50 \/ ~(c0_1_ X50))))) \/ hskp12_)) /\ (((forall X51 : Universe, (ndr1_0_ -> (c1_1_ X51 \/ (c2_1_ X51 \/ ~(c3_1_ X51))))) \/ (hskp28_ \/ hskp16_)) /\ (((forall X52 : Universe, (ndr1_0_ -> (c1_1_ X52 \/ (c3_1_ X52 \/ ~(c0_1_ X52))))) \/ ((forall X53 : Universe, (ndr1_0_ -> (c1_1_ X53 \/ (~(c0_1_ X53) \/ ~(c2_1_ X53))))) \/ (forall X54 : Universe, (ndr1_0_ -> (c3_1_ X54 \/ (~(c0_1_ X54) \/ ~(c2_1_ X54))))))) /\ (((forall X55 : Universe, (ndr1_0_ -> (c1_1_ X55 \/ (c3_1_ X55 \/ ~(c0_1_ X55))))) \/ ((forall X56 : Universe, (ndr1_0_ -> (~(c0_1_ X56) \/ (~(c1_1_ X56) \/ ~(c2_1_ X56))))) \/ hskp7_)) /\ (((forall X57 : Universe, (ndr1_0_ -> (c1_1_ X57 \/ (c3_1_ X57 \/ ~(c2_1_ X57))))) \/ ((forall X58 : Universe, (ndr1_0_ -> (c1_1_ X58 \/ (~(c2_1_ X58) \/ ~(c3_1_ X58))))) \/ (forall X59 : Universe, (ndr1_0_ -> (c2_1_ X59 \/ (~(c0_1_ X59) \/ ~(c1_1_ X59))))))) /\ (((forall X60 : Universe, (ndr1_0_ -> (c1_1_ X60 \/ (~(c0_1_ X60) \/ ~(c3_1_ X60))))) \/ (hskp28_ \/ hskp17_)) /\ (((forall X61 : Universe, (ndr1_0_ -> (c1_1_ X61 \/ (~(c0_1_ X61) \/ ~(c3_1_ X61))))) \/ (hskp18_ \/ hskp4_)) /\ (((forall X62 : Universe, (ndr1_0_ -> (c1_1_ X62 \/ (~(c2_1_ X62) \/ ~(c3_1_ X62))))) \/ ((forall X63 : Universe, (ndr1_0_ -> (c3_1_ X63 \/ (~(c0_1_ X63) \/ ~(c1_1_ X63))))) \/ hskp9_)) /\ (((forall X64 : Universe, (ndr1_0_ -> (c1_1_ X64 \/ (~(c2_1_ X64) \/ ~(c3_1_ X64))))) \/ (hskp17_ \/ hskp7_)) /\ (((forall X65 : Universe, (ndr1_0_ -> (c1_1_ X65 \/ (~(c2_1_ X65) \/ ~(c3_1_ X65))))) \/ (hskp17_ \/ hskp19_)) /\ (((forall X66 : Universe, (ndr1_0_ -> (c2_1_ X66 \/ (c3_1_ X66 \/ ~(c0_1_ X66))))) \/ (forall X67 : Universe, (ndr1_0_ -> (c3_1_ X67 \/ (~(c0_1_ X67) \/ ~(c2_1_ X67)))))) /\ (((forall X68 : Universe, (ndr1_0_ -> (c2_1_ X68 \/ (c3_1_ X68 \/ ~(c0_1_ X68))))) \/ ((forall X69 : Universe, (ndr1_0_ -> (~(c1_1_ X69) \/ (~(c2_1_ X69) \/ ~(c3_1_ X69))))) \/ hskp11_)) /\ (((forall X70 : Universe, (ndr1_0_ -> (c2_1_ X70 \/ (c3_1_ X70 \/ ~(c0_1_ X70))))) \/ (hskp8_ \/ hskp19_)) /\ (((forall X71 : Universe, (ndr1_0_ -> (c2_1_ X71 \/ (c3_1_ X71 \/ ~(c0_1_ X71))))) \/ (hskp20_ \/ hskp5_)) /\ (((forall X72 : Universe, (ndr1_0_ -> (c2_1_ X72 \/ (c3_1_ X72 \/ ~(c1_1_ X72))))) \/ (hskp29_ \/ hskp5_)) /\ (((forall X73 : Universe, (ndr1_0_ -> (c2_1_ X73 \/ (~(c0_1_ X73) \/ ~(c3_1_ X73))))) \/ (hskp11_ \/ hskp21_)) /\ (((forall X74 : Universe, (ndr1_0_ -> (c2_1_ X74 \/ (~(c0_1_ X74) \/ ~(c3_1_ X74))))) \/ (hskp20_ \/ hskp22_)) /\ (((forall X75 : Universe, (ndr1_0_ -> (c2_1_ X75 \/ (~(c0_1_ X75) \/ ~(c3_1_ X75))))) \/ (hskp5_ \/ hskp23_)) /\ (((forall X76 : Universe, (ndr1_0_ -> (c2_1_ X76 \/ (~(c1_1_ X76) \/ ~(c3_1_ X76))))) \/ ((forall X77 : Universe, (ndr1_0_ -> (~(c1_1_ X77) \/ (~(c2_1_ X77) \/ ~(c3_1_ X77))))) \/ hskp8_)) /\ (((forall X78 : Universe, (ndr1_0_ -> (c2_1_ X78 \/ (~(c1_1_ X78) \/ ~(c3_1_ X78))))) \/ (hskp2_ \/ hskp24_)) /\ (((forall X79 : Universe, (ndr1_0_ -> (c2_1_ X79 \/ (~(c1_1_ X79) \/ ~(c3_1_ X79))))) \/ (hskp3_ \/ hskp15_)) /\ (((forall X80 : Universe, (ndr1_0_ -> (c3_1_ X80 \/ (~(c0_1_ X80) \/ ~(c2_1_ X80))))) \/ (hskp1_ \/ hskp29_)) /\ (((forall X81 : Universe, (ndr1_0_ -> (c3_1_ X81 \/ (~(c0_1_ X81) \/ ~(c2_1_ X81))))) \/ (hskp12_ \/ hskp20_)) /\ (((forall X82 : Universe, (ndr1_0_ -> (c3_1_ X82 \/ (~(c0_1_ X82) \/ ~(c2_1_ X82))))) \/ (hskp15_ \/ hskp9_)) /\ (((forall X83 : Universe, (ndr1_0_ -> (c3_1_ X83 \/ (~(c1_1_ X83) \/ ~(c2_1_ X83))))) \/ (hskp10_ \/ hskp29_)) /\ (((forall X84 : Universe, (ndr1_0_ -> (~(c0_1_ X84) \/ (~(c1_1_ X84) \/ ~(c2_1_ X84))))) \/ (hskp23_ \/ hskp25_)) /\ ((hskp18_ \/ (hskp1_ \/ hskp7_)) /\ ((hskp18_ \/ (hskp2_ \/ hskp20_)) /\ ((hskp1_ \/ (hskp14_ \/ hskp17_)) /\ ((hskp2_ \/ (hskp22_ \/ hskp19_)) /\ ((hskp20_ \/ (hskp24_ \/ hskp0_)) /\ (hskp24_ \/ (hskp14_ \/ hskp17_)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
