(*
% File     : SYN448+1 : ILTP v1.1.2
% Domain   : Syntactic (Translated)
% Problem  : ALC, N=4, R=1, L=60, K=3, D=1, P=0, Index=019
% Version  : Especial.
% English  : 
% Refs     : [OS95]  Ohlbach & Schmidt (1995), Functional Translation and S
%          : [HS97]  Hustadt & Schmidt (1997), On Evaluating Decision Proce
%          : [Wei97] Weidenbach (1997), Email to G. Sutcliffe
% Source   : [Wei97]
% Names    : alc-4-1-60-3-1-019.dfg [Wei97]
% Status   : Theorem
% Rating   : 0.33 v3.1.0, 0.67 v2.7.0, 0.33 v2.6.0, 0.00 v2.5.0, 0.33 v2.4.0, 0.33 v2.2.1, 0.50 v2.2.0, 0.00 v2.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :    1 (   0 unit)
%            Number of atoms       :  603 (   0 equality)
%            Maximal formula depth :   92 (  92 average)
%            Number of connectives :  804 ( 202 ~  ; 334  |; 175  &)
%                                         (   0 <=>;  93 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   34 (  30 propositional; 0-1 arity)
%            Number of functors    :   29 (  29 constant; 0-0 arity)
%            Number of variables   :   93 (   0 singleton;  93 !;   0 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : These ALC problems have been translated from propositional 
%            multi-modal K logic formulae generated according to the scheme
%            described in [HS97], using the optimized functional translation
%            described in [OS95]. The finite model property holds, the
%            Herbrand Universe is finite, they are decidable (the complexity
%            is PSPACE-complete), resolution + subsumption + condensing is a
%            decision procedure, and the translated formulae belong to the
%            (CNF-translation of the) Bernays-Schoenfinkel class [Wei97].
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable ndr1_0_ : Prop.
Variable hskp9_ : Prop.
Variable hskp8_ : Prop.
Variable hskp7_ : Prop.
Variable hskp6_ : Prop.
Variable hskp5_ : Prop.
Variable hskp4_ : Prop.
Variable hskp3_ : Prop.
Variable hskp28_ : Prop.
Variable hskp27_ : Prop.
Variable hskp26_ : Prop.
Variable hskp25_ : Prop.
Variable hskp24_ : Prop.
Variable hskp23_ : Prop.
Variable hskp22_ : Prop.
Variable hskp21_ : Prop.
Variable hskp20_ : Prop.
Variable hskp2_ : Prop.
Variable hskp19_ : Prop.
Variable hskp18_ : Prop.
Variable hskp17_ : Prop.
Variable hskp16_ : Prop.
Variable hskp15_ : Prop.
Variable hskp14_ : Prop.
Variable hskp13_ : Prop.
Variable hskp12_ : Prop.
Variable hskp11_ : Prop.
Variable hskp10_ : Prop.
Variable hskp1_ : Prop.
Variable hskp0_ : Prop.
Variable c3_1_ : Universe -> Prop.
Variable c2_1_ : Universe -> Prop.
Variable c1_1_ : Universe -> Prop.
Variable c0_1_ : Universe -> Prop.

Variable a540_ : Universe.
Variable a533_ : Universe.
Variable a524_ : Universe.
Variable a512_ : Universe.
Variable a503_ : Universe.
Variable a502_ : Universe.
Variable a500_ : Universe.
Variable a494_ : Universe.
Variable a493_ : Universe.
Variable a492_ : Universe.
Variable a490_ : Universe.
Variable a488_ : Universe.
Variable a483_ : Universe.
Variable a480_ : Universe.
Variable a478_ : Universe.
Variable a477_ : Universe.
Variable a476_ : Universe.
Variable a475_ : Universe.
Variable a474_ : Universe.
Variable a473_ : Universe.
Variable a471_ : Universe.
Variable a470_ : Universe.
Variable a468_ : Universe.
Variable a467_ : Universe.
Variable a466_ : Universe.
Variable a465_ : Universe.
Variable a463_ : Universe.
Variable a461_ : Universe.
Variable a460_ : Universe.


Theorem co1_1 : ~(((~(hskp0_) \/ (ndr1_0_ /\ (c0_1_ a460_ /\ (~(c2_1_ a460_) /\ ~(c3_1_ a460_))))) /\ ((~(hskp1_) \/ (ndr1_0_ /\ (c2_1_ a463_ /\ (~(c0_1_ a463_) /\ ~(c1_1_ a463_))))) /\ ((~(hskp2_) \/ (ndr1_0_ /\ (~(c0_1_ a465_) /\ (~(c2_1_ a465_) /\ ~(c3_1_ a465_))))) /\ ((~(hskp3_) \/ (ndr1_0_ /\ (c1_1_ a466_ /\ (c3_1_ a466_ /\ ~(c0_1_ a466_))))) /\ ((~(hskp4_) \/ (ndr1_0_ /\ (c3_1_ a467_ /\ (~(c0_1_ a467_) /\ ~(c1_1_ a467_))))) /\ ((~(hskp5_) \/ (ndr1_0_ /\ (c0_1_ a468_ /\ (c3_1_ a468_ /\ ~(c2_1_ a468_))))) /\ ((~(hskp6_) \/ (ndr1_0_ /\ (c2_1_ a471_ /\ (~(c1_1_ a471_) /\ ~(c3_1_ a471_))))) /\ ((~(hskp7_) \/ (ndr1_0_ /\ (c3_1_ a474_ /\ (~(c1_1_ a474_) /\ ~(c2_1_ a474_))))) /\ ((~(hskp8_) \/ (ndr1_0_ /\ (c0_1_ a475_ /\ (c1_1_ a475_ /\ ~(c3_1_ a475_))))) /\ ((~(hskp9_) \/ (ndr1_0_ /\ (c0_1_ a476_ /\ (c2_1_ a476_ /\ ~(c1_1_ a476_))))) /\ ((~(hskp10_) \/ (ndr1_0_ /\ (c1_1_ a477_ /\ (c2_1_ a477_ /\ ~(c3_1_ a477_))))) /\ ((~(hskp11_) \/ (ndr1_0_ /\ (c2_1_ a478_ /\ (~(c0_1_ a478_) /\ ~(c3_1_ a478_))))) /\ ((~(hskp12_) \/ (ndr1_0_ /\ (~(c0_1_ a480_) /\ (~(c1_1_ a480_) /\ ~(c2_1_ a480_))))) /\ ((~(hskp13_) \/ (ndr1_0_ /\ (c0_1_ a483_ /\ (c2_1_ a483_ /\ ~(c3_1_ a483_))))) /\ ((~(hskp14_) \/ (ndr1_0_ /\ (~(c1_1_ a488_) /\ (~(c2_1_ a488_) /\ ~(c3_1_ a488_))))) /\ ((~(hskp15_) \/ (ndr1_0_ /\ (c1_1_ a492_ /\ (c3_1_ a492_ /\ ~(c2_1_ a492_))))) /\ ((~(hskp16_) \/ (ndr1_0_ /\ (c1_1_ a493_ /\ (~(c0_1_ a493_) /\ ~(c2_1_ a493_))))) /\ ((~(hskp17_) \/ (ndr1_0_ /\ (~(c0_1_ a494_) /\ (~(c1_1_ a494_) /\ ~(c3_1_ a494_))))) /\ ((~(hskp18_) \/ (ndr1_0_ /\ (c1_1_ a500_ /\ (c2_1_ a500_ /\ ~(c0_1_ a500_))))) /\ ((~(hskp19_) \/ (ndr1_0_ /\ (c2_1_ a502_ /\ (c3_1_ a502_ /\ ~(c0_1_ a502_))))) /\ ((~(hskp20_) \/ (ndr1_0_ /\ (c2_1_ a503_ /\ (c3_1_ a503_ /\ ~(c1_1_ a503_))))) /\ ((~(hskp21_) \/ (ndr1_0_ /\ (c0_1_ a512_ /\ (c3_1_ a512_ /\ ~(c1_1_ a512_))))) /\ ((~(hskp22_) \/ (ndr1_0_ /\ (c0_1_ a524_ /\ (c1_1_ a524_ /\ ~(c2_1_ a524_))))) /\ ((~(hskp23_) \/ (ndr1_0_ /\ (c0_1_ a533_ /\ (~(c1_1_ a533_) /\ ~(c3_1_ a533_))))) /\ ((~(hskp24_) \/ (ndr1_0_ /\ (c0_1_ a540_ /\ (~(c1_1_ a540_) /\ ~(c2_1_ a540_))))) /\ ((~(hskp25_) \/ (ndr1_0_ /\ (c0_1_ a461_ /\ (c2_1_ a461_ /\ c3_1_ a461_)))) /\ ((~(hskp26_) \/ (ndr1_0_ /\ (c1_1_ a470_ /\ (c2_1_ a470_ /\ c3_1_ a470_)))) /\ ((~(hskp27_) \/ (ndr1_0_ /\ (c0_1_ a473_ /\ (c1_1_ a473_ /\ c3_1_ a473_)))) /\ ((~(hskp28_) \/ (ndr1_0_ /\ (c0_1_ a490_ /\ (c1_1_ a490_ /\ c2_1_ a490_)))) /\ (((forall U : Universe, (ndr1_0_ -> (c0_1_ U \/ (c1_1_ U \/ c2_1_ U)))) \/ ((forall V : Universe, (ndr1_0_ -> (c0_1_ V \/ (c1_1_ V \/ ~(c2_1_ V))))) \/ hskp0_)) /\ (((forall W : Universe, (ndr1_0_ -> (c0_1_ W \/ (c1_1_ W \/ c2_1_ W)))) \/ ((forall X : Universe, (ndr1_0_ -> (c0_1_ X \/ (~(c1_1_ X) \/ ~(c3_1_ X))))) \/ (forall Y : Universe, (ndr1_0_ -> (c2_1_ Y \/ (c3_1_ Y \/ ~(c0_1_ Y))))))) /\ (((forall Z : Universe, (ndr1_0_ -> (c0_1_ Z \/ (c1_1_ Z \/ c2_1_ Z)))) \/ ((forall X1 : Universe, (ndr1_0_ -> (c1_1_ X1 \/ (c3_1_ X1 \/ ~(c0_1_ X1))))) \/ hskp25_)) /\ (((forall X2 : Universe, (ndr1_0_ -> (c0_1_ X2 \/ (c1_1_ X2 \/ c2_1_ X2)))) \/ ((forall X3 : Universe, (ndr1_0_ -> (c1_1_ X3 \/ (~(c2_1_ X3) \/ ~(c3_1_ X3))))) \/ (forall X4 : Universe, (ndr1_0_ -> (c3_1_ X4 \/ (~(c0_1_ X4) \/ ~(c2_1_ X4))))))) /\ (((forall X5 : Universe, (ndr1_0_ -> (c0_1_ X5 \/ (c1_1_ X5 \/ c2_1_ X5)))) \/ (hskp0_ \/ hskp1_)) /\ (((forall X6 : Universe, (ndr1_0_ -> (c0_1_ X6 \/ (c1_1_ X6 \/ c3_1_ X6)))) \/ ((forall X7 : Universe, (ndr1_0_ -> (c0_1_ X7 \/ (c2_1_ X7 \/ c3_1_ X7)))) \/ hskp0_)) /\ (((forall X8 : Universe, (ndr1_0_ -> (c0_1_ X8 \/ (c1_1_ X8 \/ c3_1_ X8)))) \/ ((forall X9 : Universe, (ndr1_0_ -> (c0_1_ X9 \/ (~(c1_1_ X9) \/ ~(c2_1_ X9))))) \/ hskp2_)) /\ (((forall X10 : Universe, (ndr1_0_ -> (c0_1_ X10 \/ (c1_1_ X10 \/ c3_1_ X10)))) \/ ((forall X11 : Universe, (ndr1_0_ -> (c0_1_ X11 \/ (~(c1_1_ X11) \/ ~(c3_1_ X11))))) \/ hskp3_)) /\ (((forall X12 : Universe, (ndr1_0_ -> (c0_1_ X12 \/ (c1_1_ X12 \/ c3_1_ X12)))) \/ ((forall X13 : Universe, (ndr1_0_ -> (c1_1_ X13 \/ (c2_1_ X13 \/ c3_1_ X13)))) \/ (forall X14 : Universe, (ndr1_0_ -> (c3_1_ X14 \/ (~(c1_1_ X14) \/ ~(c2_1_ X14))))))) /\ (((forall X15 : Universe, (ndr1_0_ -> (c0_1_ X15 \/ (c1_1_ X15 \/ c3_1_ X15)))) \/ ((forall X16 : Universe, (ndr1_0_ -> (c2_1_ X16 \/ (~(c1_1_ X16) \/ ~(c3_1_ X16))))) \/ hskp4_)) /\ (((forall X17 : Universe, (ndr1_0_ -> (c0_1_ X17 \/ (c1_1_ X17 \/ c3_1_ X17)))) \/ ((forall X18 : Universe, (ndr1_0_ -> (~(c0_1_ X18) \/ (~(c1_1_ X18) \/ ~(c2_1_ X18))))) \/ hskp5_)) /\ (((forall X19 : Universe, (ndr1_0_ -> (c0_1_ X19 \/ (c1_1_ X19 \/ c3_1_ X19)))) \/ ((forall X20 : Universe, (ndr1_0_ -> (~(c1_1_ X20) \/ (~(c2_1_ X20) \/ ~(c3_1_ X20))))) \/ hskp4_)) /\ (((forall X21 : Universe, (ndr1_0_ -> (c0_1_ X21 \/ (c1_1_ X21 \/ ~(c2_1_ X21))))) \/ ((forall X22 : Universe, (ndr1_0_ -> (~(c0_1_ X22) \/ (~(c2_1_ X22) \/ ~(c3_1_ X22))))) \/ hskp26_)) /\ (((forall X23 : Universe, (ndr1_0_ -> (c0_1_ X23 \/ (c1_1_ X23 \/ ~(c2_1_ X23))))) \/ (hskp6_ \/ hskp2_)) /\ (((forall X24 : Universe, (ndr1_0_ -> (c0_1_ X24 \/ (c2_1_ X24 \/ c3_1_ X24)))) \/ ((forall X25 : Universe, (ndr1_0_ -> (c1_1_ X25 \/ (c2_1_ X25 \/ c3_1_ X25)))) \/ hskp27_)) /\ (((forall X26 : Universe, (ndr1_0_ -> (c0_1_ X26 \/ (c2_1_ X26 \/ c3_1_ X26)))) \/ ((forall X27 : Universe, (ndr1_0_ -> (c2_1_ X27 \/ (c3_1_ X27 \/ ~(c0_1_ X27))))) \/ hskp7_)) /\ (((forall X28 : Universe, (ndr1_0_ -> (c0_1_ X28 \/ (c2_1_ X28 \/ ~(c1_1_ X28))))) \/ ((forall X29 : Universe, (ndr1_0_ -> (c0_1_ X29 \/ (~(c1_1_ X29) \/ ~(c3_1_ X29))))) \/ (forall X30 : Universe, (ndr1_0_ -> (c0_1_ X30 \/ (~(c2_1_ X30) \/ ~(c3_1_ X30))))))) /\ (((forall X31 : Universe, (ndr1_0_ -> (c0_1_ X31 \/ (c2_1_ X31 \/ ~(c1_1_ X31))))) \/ ((forall X32 : Universe, (ndr1_0_ -> (c1_1_ X32 \/ (~(c2_1_ X32) \/ ~(c3_1_ X32))))) \/ hskp8_)) /\ (((forall X33 : Universe, (ndr1_0_ -> (c0_1_ X33 \/ (c2_1_ X33 \/ ~(c3_1_ X33))))) \/ ((forall X34 : Universe, (ndr1_0_ -> (c0_1_ X34 \/ (~(c2_1_ X34) \/ ~(c3_1_ X34))))) \/ hskp9_)) /\ (((forall X35 : Universe, (ndr1_0_ -> (c0_1_ X35 \/ (c2_1_ X35 \/ ~(c3_1_ X35))))) \/ ((forall X36 : Universe, (ndr1_0_ -> (~(c0_1_ X36) \/ (~(c1_1_ X36) \/ ~(c2_1_ X36))))) \/ hskp10_)) /\ (((forall X37 : Universe, (ndr1_0_ -> (c0_1_ X37 \/ (c3_1_ X37 \/ ~(c1_1_ X37))))) \/ ((forall X38 : Universe, (ndr1_0_ -> (~(c0_1_ X38) \/ (~(c2_1_ X38) \/ ~(c3_1_ X38))))) \/ hskp11_)) /\ (((forall X39 : Universe, (ndr1_0_ -> (c0_1_ X39 \/ (c3_1_ X39 \/ ~(c2_1_ X39))))) \/ (hskp0_ \/ hskp12_)) /\ (((forall X40 : Universe, (ndr1_0_ -> (c0_1_ X40 \/ (~(c1_1_ X40) \/ ~(c2_1_ X40))))) \/ ((forall X41 : Universe, (ndr1_0_ -> (c1_1_ X41 \/ (c2_1_ X41 \/ ~(c0_1_ X41))))) \/ hskp9_)) /\ (((forall X42 : Universe, (ndr1_0_ -> (c0_1_ X42 \/ (~(c1_1_ X42) \/ ~(c2_1_ X42))))) \/ ((forall X43 : Universe, (ndr1_0_ -> (c1_1_ X43 \/ (c3_1_ X43 \/ ~(c0_1_ X43))))) \/ hskp9_)) /\ (((forall X44 : Universe, (ndr1_0_ -> (c0_1_ X44 \/ (~(c1_1_ X44) \/ ~(c2_1_ X44))))) \/ ((forall X45 : Universe, (ndr1_0_ -> (c1_1_ X45 \/ (c3_1_ X45 \/ ~(c0_1_ X45))))) \/ hskp13_)) /\ (((forall X46 : Universe, (ndr1_0_ -> (c0_1_ X46 \/ (~(c1_1_ X46) \/ ~(c2_1_ X46))))) \/ (hskp27_ \/ hskp10_)) /\ (((forall X47 : Universe, (ndr1_0_ -> (c0_1_ X47 \/ (~(c1_1_ X47) \/ ~(c3_1_ X47))))) \/ ((forall X48 : Universe, (ndr1_0_ -> (c3_1_ X48 \/ (~(c0_1_ X48) \/ ~(c2_1_ X48))))) \/ hskp8_)) /\ (((forall X49 : Universe, (ndr1_0_ -> (c0_1_ X49 \/ (~(c1_1_ X49) \/ ~(c3_1_ X49))))) \/ ((forall X50 : Universe, (ndr1_0_ -> (~(c0_1_ X50) \/ (~(c1_1_ X50) \/ ~(c2_1_ X50))))) \/ hskp7_)) /\ (((forall X51 : Universe, (ndr1_0_ -> (c0_1_ X51 \/ (~(c1_1_ X51) \/ ~(c3_1_ X51))))) \/ ((forall X52 : Universe, (ndr1_0_ -> (~(c0_1_ X52) \/ (~(c2_1_ X52) \/ ~(c3_1_ X52))))) \/ hskp14_)) /\ (((forall X53 : Universe, (ndr1_0_ -> (c0_1_ X53 \/ (~(c2_1_ X53) \/ ~(c3_1_ X53))))) \/ ((forall X54 : Universe, (ndr1_0_ -> (c1_1_ X54 \/ (c2_1_ X54 \/ c3_1_ X54)))) \/ (forall X55 : Universe, (ndr1_0_ -> (~(c0_1_ X55) \/ (~(c1_1_ X55) \/ ~(c3_1_ X55))))))) /\ (((forall X56 : Universe, (ndr1_0_ -> (c0_1_ X56 \/ (~(c2_1_ X56) \/ ~(c3_1_ X56))))) \/ ((forall X57 : Universe, (ndr1_0_ -> (c1_1_ X57 \/ (c3_1_ X57 \/ ~(c2_1_ X57))))) \/ (forall X58 : Universe, (ndr1_0_ -> (c2_1_ X58 \/ (~(c0_1_ X58) \/ ~(c1_1_ X58))))))) /\ (((forall X59 : Universe, (ndr1_0_ -> (c0_1_ X59 \/ (~(c2_1_ X59) \/ ~(c3_1_ X59))))) \/ ((forall X60 : Universe, (ndr1_0_ -> (~(c0_1_ X60) \/ (~(c1_1_ X60) \/ ~(c2_1_ X60))))) \/ hskp10_)) /\ (((forall X61 : Universe, (ndr1_0_ -> (c1_1_ X61 \/ (c2_1_ X61 \/ c3_1_ X61)))) \/ ((forall X62 : Universe, (ndr1_0_ -> (c2_1_ X62 \/ (~(c0_1_ X62) \/ ~(c3_1_ X62))))) \/ hskp28_)) /\ (((forall X63 : Universe, (ndr1_0_ -> (c1_1_ X63 \/ (c2_1_ X63 \/ c3_1_ X63)))) \/ (hskp3_ \/ hskp15_)) /\ (((forall X64 : Universe, (ndr1_0_ -> (c1_1_ X64 \/ (c2_1_ X64 \/ ~(c0_1_ X64))))) \/ (hskp16_ \/ hskp17_)) /\ (((forall X65 : Universe, (ndr1_0_ -> (c1_1_ X65 \/ (c2_1_ X65 \/ ~(c3_1_ X65))))) \/ (hskp7_ \/ hskp12_)) /\ (((forall X66 : Universe, (ndr1_0_ -> (c1_1_ X66 \/ (c3_1_ X66 \/ ~(c0_1_ X66))))) \/ ((forall X67 : Universe, (ndr1_0_ -> (c2_1_ X67 \/ (c3_1_ X67 \/ ~(c0_1_ X67))))) \/ hskp12_)) /\ (((forall X68 : Universe, (ndr1_0_ -> (c1_1_ X68 \/ (c3_1_ X68 \/ ~(c0_1_ X68))))) \/ (hskp27_ \/ hskp16_)) /\ (((forall X69 : Universe, (ndr1_0_ -> (c1_1_ X69 \/ (c3_1_ X69 \/ ~(c0_1_ X69))))) \/ (hskp18_ \/ hskp2_)) /\ (((forall X70 : Universe, (ndr1_0_ -> (c1_1_ X70 \/ (c3_1_ X70 \/ ~(c2_1_ X70))))) \/ (hskp19_ \/ hskp20_)) /\ (((forall X71 : Universe, (ndr1_0_ -> (c1_1_ X71 \/ (c3_1_ X71 \/ ~(c2_1_ X71))))) \/ (hskp12_ \/ hskp14_)) /\ (((forall X72 : Universe, (ndr1_0_ -> (c1_1_ X72 \/ (~(c0_1_ X72) \/ ~(c2_1_ X72))))) \/ ((forall X73 : Universe, (ndr1_0_ -> (c1_1_ X73 \/ (~(c0_1_ X73) \/ ~(c3_1_ X73))))) \/ hskp9_)) /\ (((forall X74 : Universe, (ndr1_0_ -> (c1_1_ X74 \/ (~(c0_1_ X74) \/ ~(c2_1_ X74))))) \/ ((forall X75 : Universe, (ndr1_0_ -> (~(c0_1_ X75) \/ (~(c2_1_ X75) \/ ~(c3_1_ X75))))) \/ hskp17_)) /\ (((forall X76 : Universe, (ndr1_0_ -> (c1_1_ X76 \/ (~(c0_1_ X76) \/ ~(c3_1_ X76))))) \/ (hskp3_ \/ hskp12_)) /\ (((forall X77 : Universe, (ndr1_0_ -> (c2_1_ X77 \/ (c3_1_ X77 \/ ~(c0_1_ X77))))) \/ ((forall X78 : Universe, (ndr1_0_ -> (~(c0_1_ X78) \/ (~(c1_1_ X78) \/ ~(c2_1_ X78))))) \/ hskp1_)) /\ (((forall X79 : Universe, (ndr1_0_ -> (c2_1_ X79 \/ (c3_1_ X79 \/ ~(c0_1_ X79))))) \/ ((forall X80 : Universe, (ndr1_0_ -> (~(c0_1_ X80) \/ (~(c1_1_ X80) \/ ~(c3_1_ X80))))) \/ hskp3_)) /\ (((forall X81 : Universe, (ndr1_0_ -> (c2_1_ X81 \/ (c3_1_ X81 \/ ~(c1_1_ X81))))) \/ ((forall X82 : Universe, (ndr1_0_ -> (c2_1_ X82 \/ (~(c0_1_ X82) \/ ~(c3_1_ X82))))) \/ hskp21_)) /\ (((forall X83 : Universe, (ndr1_0_ -> (c2_1_ X83 \/ (c3_1_ X83 \/ ~(c1_1_ X83))))) \/ (hskp11_ \/ hskp7_)) /\ (((forall X84 : Universe, (ndr1_0_ -> (c2_1_ X84 \/ (~(c0_1_ X84) \/ ~(c1_1_ X84))))) \/ (hskp18_ \/ hskp20_)) /\ (((forall X85 : Universe, (ndr1_0_ -> (c2_1_ X85 \/ (~(c0_1_ X85) \/ ~(c1_1_ X85))))) \/ (hskp15_ \/ hskp2_)) /\ (((forall X86 : Universe, (ndr1_0_ -> (c2_1_ X86 \/ (~(c1_1_ X86) \/ ~(c3_1_ X86))))) \/ (hskp15_ \/ hskp12_)) /\ (((forall X87 : Universe, (ndr1_0_ -> (c3_1_ X87 \/ (~(c0_1_ X87) \/ ~(c2_1_ X87))))) \/ (hskp26_ \/ hskp10_)) /\ ((hskp27_ \/ (hskp22_ \/ hskp17_)) /\ ((hskp8_ \/ (hskp15_ \/ hskp16_)) /\ ((hskp25_ \/ (hskp5_ \/ hskp14_)) /\ ((hskp9_ \/ (hskp23_ \/ hskp20_)) /\ ((hskp21_ \/ (hskp10_ \/ hskp6_)) /\ ((hskp5_ \/ hskp11_) /\ ((hskp24_ \/ (hskp15_ \/ hskp16_)) /\ (hskp20_ \/ (hskp6_ \/ hskp12_))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
