(*
% File     : SYN443+1 : ILTP v1.1.2
% Domain   : Syntactic (Translated)
% Problem  : ALC, N=4, R=1, L=60, K=3, D=1, P=0, Index=012
% Version  : Especial.
% English  : 
% Refs     : [OS95]  Ohlbach & Schmidt (1995), Functional Translation and S
%          : [HS97]  Hustadt & Schmidt (1997), On Evaluating Decision Proce
%          : [Wei97] Weidenbach (1997), Email to G. Sutcliffe
% Source   : [Wei97]
% Names    : alc-4-1-60-3-1-012.dfg [Wei97]
% Status   : Theorem
% Rating   : 0.33 v3.1.0, 0.67 v2.7.0, 0.33 v2.6.0, 0.00 v2.5.0, 0.33 v2.4.0, 0.33 v2.2.1, 0.50 v2.2.0, 0.00 v2.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :    1 (   0 unit)
%            Number of atoms       :  588 (   0 equality)
%            Maximal formula depth :   94 (  94 average)
%            Number of connectives :  782 ( 195 ~  ; 319  |; 183  &)
%                                         (   0 <=>;  85 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   36 (  32 propositional; 0-1 arity)
%            Number of functors    :   31 (  31 constant; 0-0 arity)
%            Number of variables   :   85 (   0 singleton;  85 !;   0 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : These ALC problems have been translated from propositional 
%            multi-modal K logic formulae generated according to the scheme
%            described in [HS97], using the optimized functional translation
%            described in [OS95]. The finite model property holds, the
%            Herbrand Universe is finite, they are decidable (the complexity
%            is PSPACE-complete), resolution + subsumption + condensing is a
%            decision procedure, and the translated formulae belong to the
%            (CNF-translation of the) Bernays-Schoenfinkel class [Wei97].
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable ndr1_0_ : Prop.
Variable hskp9_ : Prop.
Variable hskp8_ : Prop.
Variable hskp7_ : Prop.
Variable hskp6_ : Prop.
Variable hskp5_ : Prop.
Variable hskp4_ : Prop.
Variable hskp30_ : Prop.
Variable hskp3_ : Prop.
Variable hskp29_ : Prop.
Variable hskp28_ : Prop.
Variable hskp27_ : Prop.
Variable hskp26_ : Prop.
Variable hskp25_ : Prop.
Variable hskp24_ : Prop.
Variable hskp23_ : Prop.
Variable hskp22_ : Prop.
Variable hskp21_ : Prop.
Variable hskp20_ : Prop.
Variable hskp2_ : Prop.
Variable hskp19_ : Prop.
Variable hskp18_ : Prop.
Variable hskp17_ : Prop.
Variable hskp16_ : Prop.
Variable hskp15_ : Prop.
Variable hskp14_ : Prop.
Variable hskp13_ : Prop.
Variable hskp12_ : Prop.
Variable hskp11_ : Prop.
Variable hskp10_ : Prop.
Variable hskp1_ : Prop.
Variable hskp0_ : Prop.
Variable c3_1_ : Universe -> Prop.
Variable c2_1_ : Universe -> Prop.
Variable c1_1_ : Universe -> Prop.
Variable c0_1_ : Universe -> Prop.

Variable a92_ : Universe.
Variable a9_ : Universe.
Variable a8_ : Universe.
Variable a64_ : Universe.
Variable a6_ : Universe.
Variable a58_ : Universe.
Variable a52_ : Universe.
Variable a5_ : Universe.
Variable a43_ : Universe.
Variable a42_ : Universe.
Variable a4_ : Universe.
Variable a38_ : Universe.
Variable a36_ : Universe.
Variable a34_ : Universe.
Variable a33_ : Universe.
Variable a32_ : Universe.
Variable a31_ : Universe.
Variable a3_ : Universe.
Variable a27_ : Universe.
Variable a26_ : Universe.
Variable a25_ : Universe.
Variable a22_ : Universe.
Variable a21_ : Universe.
Variable a2_ : Universe.
Variable a19_ : Universe.
Variable a18_ : Universe.
Variable a15_ : Universe.
Variable a12_ : Universe.
Variable a11_ : Universe.
Variable a10_ : Universe.
Variable a1_ : Universe.


Theorem co1_1 : ~(((~(hskp0_) \/ (ndr1_0_ /\ (c1_1_ a1_ /\ (c2_1_ a1_ /\ ~(c0_1_ a1_))))) /\ ((~(hskp1_) \/ (ndr1_0_ /\ (c0_1_ a2_ /\ (c3_1_ a2_ /\ ~(c2_1_ a2_))))) /\ ((~(hskp2_) \/ (ndr1_0_ /\ (c0_1_ a3_ /\ (c2_1_ a3_ /\ ~(c1_1_ a3_))))) /\ ((~(hskp3_) \/ (ndr1_0_ /\ (c3_1_ a4_ /\ (~(c0_1_ a4_) /\ ~(c1_1_ a4_))))) /\ ((~(hskp4_) \/ (ndr1_0_ /\ (c2_1_ a5_ /\ (c3_1_ a5_ /\ ~(c1_1_ a5_))))) /\ ((~(hskp5_) \/ (ndr1_0_ /\ (c0_1_ a6_ /\ (c2_1_ a6_ /\ ~(c3_1_ a6_))))) /\ ((~(hskp6_) \/ (ndr1_0_ /\ (c0_1_ a8_ /\ (~(c2_1_ a8_) /\ ~(c3_1_ a8_))))) /\ ((~(hskp7_) \/ (ndr1_0_ /\ (c1_1_ a9_ /\ (~(c0_1_ a9_) /\ ~(c2_1_ a9_))))) /\ ((~(hskp8_) \/ (ndr1_0_ /\ (c1_1_ a11_ /\ (c2_1_ a11_ /\ ~(c3_1_ a11_))))) /\ ((~(hskp9_) \/ (ndr1_0_ /\ (c1_1_ a12_ /\ (~(c2_1_ a12_) /\ ~(c3_1_ a12_))))) /\ ((~(hskp10_) \/ (ndr1_0_ /\ (~(c0_1_ a18_) /\ (~(c1_1_ a18_) /\ ~(c3_1_ a18_))))) /\ ((~(hskp11_) \/ (ndr1_0_ /\ (c0_1_ a19_ /\ (c1_1_ a19_ /\ ~(c3_1_ a19_))))) /\ ((~(hskp12_) \/ (ndr1_0_ /\ (c0_1_ a21_ /\ (~(c1_1_ a21_) /\ ~(c3_1_ a21_))))) /\ ((~(hskp13_) \/ (ndr1_0_ /\ (~(c0_1_ a22_) /\ (~(c2_1_ a22_) /\ ~(c3_1_ a22_))))) /\ ((~(hskp14_) \/ (ndr1_0_ /\ (~(c0_1_ a26_) /\ (~(c1_1_ a26_) /\ ~(c2_1_ a26_))))) /\ ((~(hskp15_) \/ (ndr1_0_ /\ (c0_1_ a27_ /\ (c1_1_ a27_ /\ ~(c2_1_ a27_))))) /\ ((~(hskp16_) \/ (ndr1_0_ /\ (c2_1_ a31_ /\ (~(c0_1_ a31_) /\ ~(c1_1_ a31_))))) /\ ((~(hskp17_) \/ (ndr1_0_ /\ (c3_1_ a32_ /\ (~(c0_1_ a32_) /\ ~(c2_1_ a32_))))) /\ ((~(hskp18_) \/ (ndr1_0_ /\ (c3_1_ a34_ /\ (~(c1_1_ a34_) /\ ~(c2_1_ a34_))))) /\ ((~(hskp19_) \/ (ndr1_0_ /\ (~(c1_1_ a36_) /\ (~(c2_1_ a36_) /\ ~(c3_1_ a36_))))) /\ ((~(hskp20_) \/ (ndr1_0_ /\ (c1_1_ a38_ /\ (c3_1_ a38_ /\ ~(c0_1_ a38_))))) /\ ((~(hskp21_) \/ (ndr1_0_ /\ (c2_1_ a42_ /\ (c3_1_ a42_ /\ ~(c0_1_ a42_))))) /\ ((~(hskp22_) \/ (ndr1_0_ /\ (c2_1_ a43_ /\ (~(c1_1_ a43_) /\ ~(c3_1_ a43_))))) /\ ((~(hskp23_) \/ (ndr1_0_ /\ (c0_1_ a52_ /\ (~(c1_1_ a52_) /\ ~(c2_1_ a52_))))) /\ ((~(hskp24_) \/ (ndr1_0_ /\ (c0_1_ a58_ /\ (c3_1_ a58_ /\ ~(c1_1_ a58_))))) /\ ((~(hskp25_) \/ (ndr1_0_ /\ (c1_1_ a64_ /\ (c3_1_ a64_ /\ ~(c2_1_ a64_))))) /\ ((~(hskp26_) \/ (ndr1_0_ /\ (c2_1_ a92_ /\ (~(c0_1_ a92_) /\ ~(c3_1_ a92_))))) /\ ((~(hskp27_) \/ (ndr1_0_ /\ (c1_1_ a10_ /\ (c2_1_ a10_ /\ c3_1_ a10_)))) /\ ((~(hskp28_) \/ (ndr1_0_ /\ (c0_1_ a15_ /\ (c1_1_ a15_ /\ c3_1_ a15_)))) /\ ((~(hskp29_) \/ (ndr1_0_ /\ (c0_1_ a25_ /\ (c1_1_ a25_ /\ c2_1_ a25_)))) /\ ((~(hskp30_) \/ (ndr1_0_ /\ (c0_1_ a33_ /\ (c2_1_ a33_ /\ c3_1_ a33_)))) /\ (((forall U : Universe, (ndr1_0_ -> (c0_1_ U \/ (c1_1_ U \/ c2_1_ U)))) \/ ((forall V : Universe, (ndr1_0_ -> (c0_1_ V \/ (c1_1_ V \/ ~(c2_1_ V))))) \/ (forall W : Universe, (ndr1_0_ -> (c1_1_ W \/ (c3_1_ W \/ ~(c0_1_ W))))))) /\ (((forall X : Universe, (ndr1_0_ -> (c0_1_ X \/ (c1_1_ X \/ c2_1_ X)))) \/ ((forall Y : Universe, (ndr1_0_ -> (c0_1_ Y \/ (c2_1_ Y \/ c3_1_ Y)))) \/ hskp0_)) /\ (((forall Z : Universe, (ndr1_0_ -> (c0_1_ Z \/ (c1_1_ Z \/ c2_1_ Z)))) \/ ((forall X1 : Universe, (ndr1_0_ -> (c1_1_ X1 \/ (c2_1_ X1 \/ ~(c0_1_ X1))))) \/ (forall X2 : Universe, (ndr1_0_ -> (c2_1_ X2 \/ (c3_1_ X2 \/ ~(c0_1_ X2))))))) /\ (((forall X3 : Universe, (ndr1_0_ -> (c0_1_ X3 \/ (c1_1_ X3 \/ c2_1_ X3)))) \/ ((forall X4 : Universe, (ndr1_0_ -> (c1_1_ X4 \/ (~(c0_1_ X4) \/ ~(c2_1_ X4))))) \/ hskp1_)) /\ (((forall X5 : Universe, (ndr1_0_ -> (c0_1_ X5 \/ (c1_1_ X5 \/ c2_1_ X5)))) \/ ((forall X6 : Universe, (ndr1_0_ -> (c2_1_ X6 \/ (c3_1_ X6 \/ ~(c0_1_ X6))))) \/ hskp2_)) /\ (((forall X7 : Universe, (ndr1_0_ -> (c0_1_ X7 \/ (c1_1_ X7 \/ c3_1_ X7)))) \/ ((forall X8 : Universe, (ndr1_0_ -> (c2_1_ X8 \/ (~(c0_1_ X8) \/ ~(c3_1_ X8))))) \/ hskp3_)) /\ (((forall X9 : Universe, (ndr1_0_ -> (c0_1_ X9 \/ (c1_1_ X9 \/ c3_1_ X9)))) \/ hskp4_) /\ (((forall X10 : Universe, (ndr1_0_ -> (c0_1_ X10 \/ (c1_1_ X10 \/ ~(c2_1_ X10))))) \/ (hskp5_ \/ hskp0_)) /\ (((forall X11 : Universe, (ndr1_0_ -> (c0_1_ X11 \/ (c1_1_ X11 \/ ~(c3_1_ X11))))) \/ (hskp6_ \/ hskp7_)) /\ (((forall X12 : Universe, (ndr1_0_ -> (c0_1_ X12 \/ (c1_1_ X12 \/ ~(c3_1_ X12))))) \/ (hskp27_ \/ hskp8_)) /\ (((forall X13 : Universe, (ndr1_0_ -> (c0_1_ X13 \/ (c1_1_ X13 \/ ~(c3_1_ X13))))) \/ (hskp9_ \/ hskp3_)) /\ (((forall X14 : Universe, (ndr1_0_ -> (c0_1_ X14 \/ (c2_1_ X14 \/ ~(c1_1_ X14))))) \/ ((forall X15 : Universe, (ndr1_0_ -> (c0_1_ X15 \/ (c2_1_ X15 \/ ~(c3_1_ X15))))) \/ hskp6_)) /\ (((forall X16 : Universe, (ndr1_0_ -> (c0_1_ X16 \/ (c2_1_ X16 \/ ~(c1_1_ X16))))) \/ ((forall X17 : Universe, (ndr1_0_ -> (c0_1_ X17 \/ (~(c1_1_ X17) \/ ~(c2_1_ X17))))) \/ (forall X18 : Universe, (ndr1_0_ -> (c1_1_ X18 \/ (c3_1_ X18 \/ ~(c0_1_ X18))))))) /\ (((forall X19 : Universe, (ndr1_0_ -> (c0_1_ X19 \/ (c2_1_ X19 \/ ~(c1_1_ X19))))) \/ (hskp28_ \/ hskp27_)) /\ (((forall X20 : Universe, (ndr1_0_ -> (c0_1_ X20 \/ (c2_1_ X20 \/ ~(c3_1_ X20))))) \/ ((forall X21 : Universe, (ndr1_0_ -> (c1_1_ X21 \/ (c3_1_ X21 \/ ~(c0_1_ X21))))) \/ hskp9_)) /\ (((forall X22 : Universe, (ndr1_0_ -> (c0_1_ X22 \/ (c2_1_ X22 \/ ~(c3_1_ X22))))) \/ ((forall X23 : Universe, (ndr1_0_ -> (~(c0_1_ X23) \/ (~(c2_1_ X23) \/ ~(c3_1_ X23))))) \/ hskp10_)) /\ (((forall X24 : Universe, (ndr1_0_ -> (c0_1_ X24 \/ (c2_1_ X24 \/ ~(c3_1_ X24))))) \/ (hskp11_ \/ hskp6_)) /\ (((forall X25 : Universe, (ndr1_0_ -> (c0_1_ X25 \/ (c2_1_ X25 \/ ~(c3_1_ X25))))) \/ (hskp12_ \/ hskp13_)) /\ (((forall X26 : Universe, (ndr1_0_ -> (c0_1_ X26 \/ (c3_1_ X26 \/ ~(c1_1_ X26))))) \/ ((forall X27 : Universe, (ndr1_0_ -> (c1_1_ X27 \/ (c3_1_ X27 \/ ~(c2_1_ X27))))) \/ hskp0_)) /\ (((forall X28 : Universe, (ndr1_0_ -> (c0_1_ X28 \/ (c3_1_ X28 \/ ~(c2_1_ X28))))) \/ ((forall X29 : Universe, (ndr1_0_ -> (c1_1_ X29 \/ (c3_1_ X29 \/ ~(c0_1_ X29))))) \/ hskp3_)) /\ (((forall X30 : Universe, (ndr1_0_ -> (c0_1_ X30 \/ (c3_1_ X30 \/ ~(c2_1_ X30))))) \/ (hskp29_ \/ hskp14_)) /\ (((forall X31 : Universe, (ndr1_0_ -> (c0_1_ X31 \/ (~(c1_1_ X31) \/ ~(c2_1_ X31))))) \/ ((forall X32 : Universe, (ndr1_0_ -> (c1_1_ X32 \/ (c3_1_ X32 \/ ~(c2_1_ X32))))) \/ (forall X33 : Universe, (ndr1_0_ -> (c2_1_ X33 \/ (~(c0_1_ X33) \/ ~(c3_1_ X33))))))) /\ (((forall X34 : Universe, (ndr1_0_ -> (c0_1_ X34 \/ (~(c1_1_ X34) \/ ~(c2_1_ X34))))) \/ (hskp15_ \/ hskp4_)) /\ (((forall X35 : Universe, (ndr1_0_ -> (c0_1_ X35 \/ (~(c2_1_ X35) \/ ~(c3_1_ X35))))) \/ ((forall X36 : Universe, (ndr1_0_ -> (c1_1_ X36 \/ (~(c0_1_ X36) \/ ~(c2_1_ X36))))) \/ (forall X37 : Universe, (ndr1_0_ -> (c3_1_ X37 \/ (~(c0_1_ X37) \/ ~(c2_1_ X37))))))) /\ (((forall X38 : Universe, (ndr1_0_ -> (c0_1_ X38 \/ (~(c2_1_ X38) \/ ~(c3_1_ X38))))) \/ ((forall X39 : Universe, (ndr1_0_ -> (c1_1_ X39 \/ (~(c0_1_ X39) \/ ~(c2_1_ X39))))) \/ hskp5_)) /\ (((forall X40 : Universe, (ndr1_0_ -> (c0_1_ X40 \/ (~(c2_1_ X40) \/ ~(c3_1_ X40))))) \/ (hskp9_ \/ hskp16_)) /\ (((forall X41 : Universe, (ndr1_0_ -> (c1_1_ X41 \/ (c2_1_ X41 \/ c3_1_ X41)))) \/ ((forall X42 : Universe, (ndr1_0_ -> (c1_1_ X42 \/ (c3_1_ X42 \/ ~(c0_1_ X42))))) \/ hskp17_)) /\ (((forall X43 : Universe, (ndr1_0_ -> (c1_1_ X43 \/ (c2_1_ X43 \/ c3_1_ X43)))) \/ (hskp30_ \/ hskp18_)) /\ (((forall X44 : Universe, (ndr1_0_ -> (c1_1_ X44 \/ (c2_1_ X44 \/ c3_1_ X44)))) \/ (hskp1_ \/ hskp19_)) /\ (((forall X45 : Universe, (ndr1_0_ -> (c1_1_ X45 \/ (c2_1_ X45 \/ ~(c0_1_ X45))))) \/ (hskp29_ \/ hskp20_)) /\ (((forall X46 : Universe, (ndr1_0_ -> (c1_1_ X46 \/ (c2_1_ X46 \/ ~(c0_1_ X46))))) \/ (hskp1_ \/ hskp13_)) /\ (((forall X47 : Universe, (ndr1_0_ -> (c1_1_ X47 \/ (c2_1_ X47 \/ ~(c0_1_ X47))))) \/ (hskp0_ \/ hskp21_)) /\ (((forall X48 : Universe, (ndr1_0_ -> (c1_1_ X48 \/ (c2_1_ X48 \/ ~(c3_1_ X48))))) \/ ((forall X49 : Universe, (ndr1_0_ -> (c1_1_ X49 \/ (~(c2_1_ X49) \/ ~(c3_1_ X49))))) \/ hskp22_)) /\ (((forall X50 : Universe, (ndr1_0_ -> (c1_1_ X50 \/ (c2_1_ X50 \/ ~(c3_1_ X50))))) \/ ((forall X51 : Universe, (ndr1_0_ -> (c3_1_ X51 \/ (~(c0_1_ X51) \/ ~(c1_1_ X51))))) \/ hskp0_)) /\ (((forall X52 : Universe, (ndr1_0_ -> (c1_1_ X52 \/ (c2_1_ X52 \/ ~(c3_1_ X52))))) \/ ((forall X53 : Universe, (ndr1_0_ -> (c3_1_ X53 \/ (~(c0_1_ X53) \/ ~(c2_1_ X53))))) \/ hskp5_)) /\ (((forall X54 : Universe, (ndr1_0_ -> (c1_1_ X54 \/ (c2_1_ X54 \/ ~(c3_1_ X54))))) \/ ((forall X55 : Universe, (ndr1_0_ -> (~(c1_1_ X55) \/ (~(c2_1_ X55) \/ ~(c3_1_ X55))))) \/ hskp29_)) /\ (((forall X56 : Universe, (ndr1_0_ -> (c1_1_ X56 \/ (c3_1_ X56 \/ ~(c0_1_ X56))))) \/ ((forall X57 : Universe, (ndr1_0_ -> (~(c0_1_ X57) \/ (~(c2_1_ X57) \/ ~(c3_1_ X57))))) \/ hskp29_)) /\ (((forall X58 : Universe, (ndr1_0_ -> (c1_1_ X58 \/ (~(c0_1_ X58) \/ ~(c2_1_ X58))))) \/ ((forall X59 : Universe, (ndr1_0_ -> (c2_1_ X59 \/ (c3_1_ X59 \/ ~(c0_1_ X59))))) \/ hskp13_)) /\ (((forall X60 : Universe, (ndr1_0_ -> (c1_1_ X60 \/ (~(c0_1_ X60) \/ ~(c2_1_ X60))))) \/ ((forall X61 : Universe, (ndr1_0_ -> (c2_1_ X61 \/ (~(c0_1_ X61) \/ ~(c1_1_ X61))))) \/ (forall X62 : Universe, (ndr1_0_ -> (~(c0_1_ X62) \/ (~(c1_1_ X62) \/ ~(c3_1_ X62))))))) /\ (((forall X63 : Universe, (ndr1_0_ -> (c1_1_ X63 \/ (~(c0_1_ X63) \/ ~(c3_1_ X63))))) \/ ((forall X64 : Universe, (ndr1_0_ -> (c3_1_ X64 \/ (~(c0_1_ X64) \/ ~(c1_1_ X64))))) \/ hskp16_)) /\ (((forall X65 : Universe, (ndr1_0_ -> (c1_1_ X65 \/ (~(c2_1_ X65) \/ ~(c3_1_ X65))))) \/ ((forall X66 : Universe, (ndr1_0_ -> (~(c1_1_ X66) \/ (~(c2_1_ X66) \/ ~(c3_1_ X66))))) \/ hskp19_)) /\ (((forall X67 : Universe, (ndr1_0_ -> (c1_1_ X67 \/ (~(c2_1_ X67) \/ ~(c3_1_ X67))))) \/ (hskp2_ \/ hskp23_)) /\ (((forall X68 : Universe, (ndr1_0_ -> (c1_1_ X68 \/ (~(c2_1_ X68) \/ ~(c3_1_ X68))))) \/ (hskp1_ \/ hskp0_)) /\ (((forall X69 : Universe, (ndr1_0_ -> (c2_1_ X69 \/ (c3_1_ X69 \/ ~(c0_1_ X69))))) \/ ((forall X70 : Universe, (ndr1_0_ -> (c2_1_ X70 \/ (c3_1_ X70 \/ ~(c1_1_ X70))))) \/ hskp22_)) /\ (((forall X71 : Universe, (ndr1_0_ -> (c2_1_ X71 \/ (c3_1_ X71 \/ ~(c0_1_ X71))))) \/ (hskp2_ \/ hskp4_)) /\ (((forall X72 : Universe, (ndr1_0_ -> (c2_1_ X72 \/ (c3_1_ X72 \/ ~(c1_1_ X72))))) \/ ((forall X73 : Universe, (ndr1_0_ -> (c3_1_ X73 \/ (~(c0_1_ X73) \/ ~(c2_1_ X73))))) \/ hskp24_)) /\ (((forall X74 : Universe, (ndr1_0_ -> (c2_1_ X74 \/ (~(c0_1_ X74) \/ ~(c3_1_ X74))))) \/ (hskp22_ \/ hskp19_)) /\ (((forall X75 : Universe, (ndr1_0_ -> (c2_1_ X75 \/ (~(c1_1_ X75) \/ ~(c3_1_ X75))))) \/ (hskp18_ \/ hskp14_)) /\ (((forall X76 : Universe, (ndr1_0_ -> (c3_1_ X76 \/ (~(c1_1_ X76) \/ ~(c2_1_ X76))))) \/ (hskp27_ \/ hskp25_)) /\ (((forall X77 : Universe, (ndr1_0_ -> (~(c0_1_ X77) \/ (~(c1_1_ X77) \/ ~(c2_1_ X77))))) \/ ((forall X78 : Universe, (ndr1_0_ -> (~(c0_1_ X78) \/ (~(c1_1_ X78) \/ ~(c3_1_ X78))))) \/ (forall X79 : Universe, (ndr1_0_ -> (~(c1_1_ X79) \/ (~(c2_1_ X79) \/ ~(c3_1_ X79))))))) /\ ((hskp28_ \/ (hskp1_ \/ hskp9_)) /\ ((hskp28_ \/ (hskp7_ \/ hskp9_)) /\ ((hskp15_ \/ (hskp2_ \/ hskp25_)) /\ ((hskp11_ \/ (hskp20_ \/ hskp7_)) /\ ((hskp11_ \/ hskp22_) /\ ((hskp30_ \/ (hskp2_ \/ hskp18_)) /\ ((hskp30_ \/ (hskp27_ \/ hskp7_)) /\ ((hskp30_ \/ (hskp27_ \/ hskp17_)) /\ ((hskp2_ \/ (hskp24_ \/ hskp23_)) /\ (hskp7_ \/ (hskp26_ \/ hskp18_))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
