(*
% File     : SYN347+1 : ILTP v1.1.2
% Domain   : Syntactic
% Problem  : Church problem 46.17 (3)
% Version  : Especial.
% English  : 
% Refs     : [Chu56] Church (1956), Introduction to Mathematical Logic I
% Source   : [Chu56]
% Names    : 46.17 (3) [Chu56]
% Status   : Theorem
% Rating   : 0.33 v3.1.0, 0.17 v2.7.0, 0.00 v2.5.0, 0.33 v2.4.0, 0.33 v2.2.1, 0.00 v2.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :    1 (   0 unit)
%            Number of atoms       :    5 (   0 equality)
%            Maximal formula depth :    9 (   9 average)
%            Number of connectives :    4 (   0 ~  ;   1  |;   0  &)
%                                         (   3 <=>;   0 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    1 (   0 propositional; 2-2 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :    5 (   0 singleton;   3 !;   2 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : In [Chu56] the variables Z1 and Z2 are not quantified.
%            I have assumed universal quantification.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable big_f_ : Universe -> Universe -> Prop.



Theorem church_46_17_3_1 : (forall Z1 Z2 : Universe, (exists X1 X2 : Universe, (forall Y : Universe, (((big_f_ X1 Y <-> big_f_ X2 Y) <-> big_f_ Z1 Z2) \/ (big_f_ Z1 Y <-> big_f_ Z2 Y))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
