(*
% File     : SYN084+1 : ILTP v1.1.2
% Domain   : Syntactic
% Problem  : Pelletier Problem 62
% Version  : Especial.
% English  : 
% Refs     : [Pel86] Pelletier (1986), Seventy-five Problems for Testing Au
%          : [Pel88] Pelletier (1988), Errata
%          : [Hah94] Haehnle (1994), Email to G. Sutcliffe
%          : [Pel95] Pelletier (1995), Email to G. Sutcliffe
% Source   : [Hah94]
% Names    : Pelletier 62 [Pel86]
% Status   : Theorem
% Rating   : 0.00 v2.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :    1 (   0 unit)
%            Number of atoms       :   10 (   0 equality)
%            Maximal formula depth :    7 (   7 average)
%            Number of connectives :   12 (   3 ~  ;   4  |;   2  &)
%                                         (   1 <=>;   2 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    1 (   0 propositional; 1-1 arity)
%            Number of functors    :    2 (   1 constant; 0-1 arity)
%            Number of variables   :    2 (   0 singleton;   2 !;   0 ?)
%            Maximal term depth    :    3 (   2 average)
% Comments : This problem is incorrect in [Pel86] and is 'corrected' in
%            [Pel88]. The 1988 version is broken too [Pel95]. This is the
%            correct version.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable big_p_ : Universe -> Prop.

Variable f_ : Universe -> Universe.
Variable a_ : Universe.


Theorem pel62_1 : ((forall X : Universe, ((big_p_ a_ /\ (big_p_ X -> big_p_ (f_ X))) -> big_p_ (f_ (f_ X)))) <-> (forall X1 : Universe, ((~(big_p_ a_) \/ (big_p_ X1 \/ big_p_ (f_ (f_ X1)))) /\ (~(big_p_ a_) \/ (~(big_p_ (f_ X1)) \/ big_p_ (f_ (f_ X1))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
