(*
% File     : SYN083+1 : ILTP v1.1.2
% Domain   : Syntactic
% Problem  : Pelletier Problem 61
% Version  : Especial.
% English  : 
% Refs     : [Pel86] Pelletier (1986), Seventy-five Problems for Testing Au
%          : [Hah94] Haehnle (1994), Email to G. Sutcliffe
% Source   : [Hah94]
% Names    : Pelletier 61 [Pel86]
% Status   : Theorem
% Rating   : 0.18 v3.1.0, 0.11 v2.7.0, 0.17 v2.6.0, 0.14 v2.5.0, 0.00 v2.1.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.0.0
% Syntax   : Number of formulae    :    2 (   2 unit)
%            Number of atoms       :    2 (   2 equality)
%            Maximal formula depth :    5 (   4 average)
%            Number of connectives :    0 (   0 ~  ;   0  |;   0  &)
%                                         (   0 <=>;   0 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    1 (   0 propositional; 2-2 arity)
%            Number of functors    :    1 (   0 constant; 2-2 arity)
%            Number of variables   :    7 (   0 singleton;   7 !;   0 ?)
%            Maximal term depth    :    4 (   4 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.


Variable f_ : Universe -> Universe -> Universe.

Variable p61_1_1 : (forall X Y Z : Universe, (f_ X (f_ Y Z)) = (f_ (f_ X Y) Z)).

Theorem pel61_2 : (forall X Y Z W : Universe, (f_ X (f_ Y (f_ Z W))) = (f_ (f_ (f_ X Y) Z) W)).
Proof.
  time hprover.
Qed.

End FOFProblem.
