(*
% File     : SYN074+1 : ILTP v1.1.2
% Domain   : Syntactic
% Problem  : Pelletier Problem 51
% Version  : Especial.
% English  : 
% Refs     : [Pel86] Pelletier (1986), Seventy-five Problems for Testing Au
%          : [Hah94] Haehnle (1994), Email to G. Sutcliffe
% Source   : [Hah94]
% Names    : Pelletier 51 [Pel86]
% Status   : Theorem
% Rating   : 0.33 v3.1.0, 0.17 v2.7.0, 0.00 v2.5.0, 0.33 v2.4.0, 0.33 v2.2.1, 0.00 v2.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :    2 (   0 unit)
%            Number of atoms       :    6 (   4 equality)
%            Maximal formula depth :    7 (   7 average)
%            Number of connectives :    4 (   0 ~  ;   0  |;   1  &)
%                                         (   3 <=>;   0 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    2 (   0 propositional; 2-2 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :    8 (   0 singleton;   4 !;   4 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable big_f_ : Universe -> Universe -> Prop.


Variable pel51_1_1 : (exists Z W : Universe, (forall X Y : Universe, (big_f_ X Y <-> (X = Z /\ Y = W)))).

Theorem pel51_2 : (exists Z : Universe, (forall X : Universe, ((exists W : Universe, (forall Y : Universe, (big_f_ X Y <-> Y = W))) <-> X = Z))).
Proof.
  time hprover.
Qed.

End FOFProblem.
