(*
% File     : SYN071+1 : ILTP v1.1.2
% Domain   : Syntactic
% Problem  : Pelletier Problem 48
% Version  : Especial.
% English  : 
% Refs     : [Pel86] Pelletier (1986), Seventy-five Problems for Testing Au
%          : [Rud93] Rudnicki (1993), Email to G. Sutcliffe
%          : [Hah94] Haehnle (1994), Email to G. Sutcliffe
% Source   : [Hah94]
% Names    : Pelletier 48 [Pel86]
% Status   : Theorem
% Rating   : 0.00 v3.1.0, 0.17 v2.7.0, 0.00 v2.4.0, 0.00 v2.1.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.50 v1.1.0, 0.75 v1.0.0
% Syntax   : Number of formulae    :    3 (   0 unit)
%            Number of atoms       :    6 (   6 equality)
%            Maximal formula depth :    2 (   2 average)
%            Number of connectives :    3 (   0 ~  ;   3  |;   0  &)
%                                         (   0 <=>;   0 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    1 (   0 propositional; 2-2 arity)
%            Number of functors    :    4 (   4 constant; 0-0 arity)
%            Number of variables   :    0 (   0 singleton;   0 !;   0 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : [Pel86] says that Rudnicki has not published this problem 
%            anywhere.
%          : [Rud93] says I have seen it for the first time around 1977,
%            it was shown to me by A. Trybulec but I am sure it is folklore.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.


Variable d_ : Universe.
Variable c_ : Universe.
Variable b_ : Universe.
Variable a_ : Universe.

Variable pel48_1_1 : (a_ = b_ \/ c_ = d_).
Variable pel48_2_2 : (a_ = c_ \/ b_ = d_).

Theorem pel48_3 : (a_ = d_ \/ b_ = c_).
Proof.
  time hprover.
Qed.

End FOFProblem.
