(*
% File     : SYN070+1 : ILTP v1.1.2
% Domain   : Syntactic
% Problem  : Pelletier Problem 46
% Version  : Especial.
% English  : 
% Refs     : [KM64]  Kalish & Montegue (1964), Logic: Techniques of Formal 
%          : [Pel86] Pelletier (1986), Seventy-five Problems for Testing Au
%          : [Hah94] Haehnle (1994), Email to G. Sutcliffe
% Source   : [Hah94]
% Names    : Pelletier 46 [Pel86]
% Status   : Theorem
% Rating   : 0.11 v3.1.0, 0.00 v2.5.0, 0.33 v2.4.0, 0.33 v2.2.1, 0.00 v2.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :    4 (   0 unit)
%            Number of atoms       :   18 (   0 equality)
%            Maximal formula depth :    9 (   6 average)
%            Number of connectives :   18 (   4 ~  ;   0  |;   8  &)
%                                         (   0 <=>;   6 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    4 (   0 propositional; 1-2 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :    8 (   0 singleton;   6 !;   2 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable big_j_ : Universe -> Universe -> Prop.
Variable big_h_ : Universe -> Universe -> Prop.
Variable big_g_ : Universe -> Prop.
Variable big_f_ : Universe -> Prop.


Variable pel46_1_1 : (forall X Y : Universe, ((big_f_ X /\ ((big_f_ Y /\ big_h_ Y X) -> big_g_ Y)) -> big_g_ X)).
Variable pel46_2_2 : ((exists X : Universe, (big_f_ X /\ ~(big_g_ X))) -> (exists X1 : Universe, (big_f_ X1 /\ (~(big_g_ X1) /\ (forall Y : Universe, ((big_f_ Y /\ ~(big_g_ Y)) -> big_j_ X1 Y)))))).
Variable pel46_3_3 : (forall X Y : Universe, ((big_f_ X /\ (big_f_ Y /\ big_h_ X Y)) -> ~(big_j_ Y X))).

Theorem pel46_4 : (forall X : Universe, (big_f_ X -> big_g_ X)).
Proof.
  time hprover.
Qed.

End FOFProblem.
