(*
% File     : SYN068+1 : ILTP v1.1.2
% Domain   : Syntactic
% Problem  : Pelletier Problem 44
% Version  : Especial.
% English  : 
% Refs     : [KM64]  Kalish & Montegue (1964), Logic: Techniques of Formal 
%          : [Pel86] Pelletier (1986), Seventy-five Problems for Testing Au
%          : [Hah94] Haehnle (1994), Email to G. Sutcliffe
% Source   : [Hah94]
% Names    : Pelletier 44 [Pel86]
% Status   : Theorem
% Rating   : 0.22 v3.1.0, 0.00 v2.5.0, 0.33 v2.4.0, 0.33 v2.2.1, 0.00 v2.1.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.0.0
% Syntax   : Number of formulae    :    3 (   0 unit)
%            Number of atoms       :   10 (   0 equality)
%            Maximal formula depth :    7 (   5 average)
%            Number of connectives :    9 (   2 ~  ;   0  |;   5  &)
%                                         (   0 <=>;   2 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    4 (   0 propositional; 1-2 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :    6 (   0 singleton;   2 !;   4 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable big_j_ : Universe -> Prop.
Variable big_h_ : Universe -> Universe -> Prop.
Variable big_g_ : Universe -> Prop.
Variable big_f_ : Universe -> Prop.


Variable pel44_1_1 : (forall X : Universe, (big_f_ X -> ((exists Y : Universe, (big_g_ Y /\ big_h_ X Y)) /\ (exists Y1 : Universe, (big_g_ Y1 /\ ~(big_h_ X Y1)))))).
Variable pel44_2_2 : (exists X : Universe, (big_j_ X /\ (forall Y : Universe, (big_g_ Y -> big_h_ X Y)))).

Theorem pel44_3 : (exists X : Universe, (big_j_ X /\ ~(big_f_ X))).
Proof.
  time hprover.
Qed.

End FOFProblem.
