(*
% File     : SYN067+1 : ILTP v1.1.2
% Domain   : Syntactic
% Problem  : Pelletier Problem 38
% Version  : Especial.
% English  : 
% Refs     : [KM64]  Kalish & Montegue (1964), Logic: Techniques of Formal 
%          : [Pel86] Pelletier (1986), Seventy-five Problems for Testing Au
%          : [Hah94] Haehnle (1994), Email to G. Sutcliffe
% Source   : [Hah94]
% Names    : Pelletier 38 [Pel86]
% Status   : Theorem
% Rating   : 0.33 v3.1.0, 0.50 v2.7.0, 0.33 v2.6.0, 0.00 v2.5.0, 0.33 v2.4.0, 0.67 v2.2.1, 0.50 v2.2.0, 0.00 v2.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :    1 (   0 unit)
%            Number of atoms       :   18 (   0 equality)
%            Maximal formula depth :   10 (  10 average)
%            Number of connectives :   20 (   3 ~  ;   4  |;  10  &)
%                                         (   1 <=>;   2 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    2 (   0 propositional; 1-2 arity)
%            Number of functors    :    1 (   1 constant; 0-0 arity)
%            Number of variables   :   10 (   0 singleton;   2 !;   8 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable big_r_ : Universe -> Universe -> Prop.
Variable big_p_ : Universe -> Prop.

Variable a_ : Universe.


Theorem pel38_1 : ((forall X : Universe, ((big_p_ a_ /\ (big_p_ X -> (exists Y : Universe, (big_p_ Y /\ big_r_ X Y)))) -> (exists Z W : Universe, (big_p_ Z /\ (big_r_ X W /\ big_r_ W Z))))) <-> (forall X1 : Universe, ((~(big_p_ a_) \/ (big_p_ X1 \/ (exists Z1 W1 : Universe, (big_p_ Z1 /\ (big_r_ X1 W1 /\ big_r_ W1 Z1))))) /\ (~(big_p_ a_) \/ (~((exists Y1 : Universe, (big_p_ Y1 /\ big_r_ X1 Y1))) \/ (exists Z2 W2 : Universe, (big_p_ Z2 /\ (big_r_ X1 W2 /\ big_r_ W2 Z2)))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
