(*
% File     : SYN066+1 : ILTP v1.1.2
% Domain   : Syntactic
% Problem  : Pelletier Problem 37
% Version  : Especial.
% English  : 
% Refs     : [KM64]  Kalish & Montegue (1964), Logic: Techniques of Formal 
%          : [Pel86] Pelletier (1986), Seventy-five Problems for Testing Au
%          : [Hah94] Haehnle (1994), Email to G. Sutcliffe
% Source   : [Hah94]
% Names    : Pelletier 37 [Pel86]
% Status   : Theorem
% Rating   : 0.11 v3.1.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.1.0, 1.00 v1.0.0
% Syntax   : Number of formulae    :    4 (   1 unit)
%            Number of atoms       :   10 (   0 equality)
%            Maximal formula depth :    9 (   5 average)
%            Number of connectives :    7 (   1 ~  ;   0  |;   2  &)
%                                         (   0 <=>;   4 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    3 (   0 propositional; 2-2 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :   13 (   0 singleton;   6 !;   7 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
% Bugfixes : Fixed pel37_1.
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable big_r_ : Universe -> Universe -> Prop.
Variable big_q_ : Universe -> Universe -> Prop.
Variable big_p_ : Universe -> Universe -> Prop.


Variable pel37_1_1 : (forall Z : Universe, (exists W : Universe, (forall X : Universe, (exists Y : Universe, ((big_p_ X Z -> big_p_ Y W) /\ (big_p_ Y Z /\ (big_p_ Y W -> (exists U : Universe, big_q_ U W)))))))).
Variable pel37_2_2 : (forall X Z : Universe, (~(big_p_ X Z) -> (exists Y : Universe, big_q_ Y Z))).
Variable pel37_3_3 : ((exists X Y : Universe, big_q_ X Y) -> (forall Z : Universe, big_r_ Z Z)).

Theorem pel37_4 : (forall X : Universe, (exists Y : Universe, big_r_ X Y)).
Proof.
  time hprover.
Qed.

End FOFProblem.
