(*
% File     : SYN057+1 : ILTP v1.1.2
% Domain   : Syntactic
% Problem  : Pelletier Problem 27
% Version  : Especial.
% English  : 
% Refs     : [KM64]  Kalish & Montegue (1964), Logic: Techniques of Formal 
%          : [Pel86] Pelletier (1986), Seventy-five Problems for Testing Au
%          : [Hah94] Haehnle (1994), Email to G. Sutcliffe
% Source   : [Hah94]
% Names    : Pelletier 27 [Pel86]
% Status   : Theorem
% Rating   : 0.11 v3.1.0, 0.00 v2.5.0, 0.33 v2.4.0, 0.33 v2.2.1, 0.00 v2.1.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.1.0, 0.25 v1.0.0
% Syntax   : Number of formulae    :    5 (   0 unit)
%            Number of atoms       :   13 (   0 equality)
%            Maximal formula depth :    5 (   4 average)
%            Number of connectives :   12 (   4 ~  ;   0  |;   3  &)
%                                         (   0 <=>;   5 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    5 (   0 propositional; 1-1 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :    6 (   0 singleton;   4 !;   2 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable big_j_ : Universe -> Prop.
Variable big_i_ : Universe -> Prop.
Variable big_h_ : Universe -> Prop.
Variable big_g_ : Universe -> Prop.
Variable big_f_ : Universe -> Prop.


Variable pel27_1_1 : (exists X : Universe, (big_f_ X /\ ~(big_g_ X))).
Variable pel27_2_2 : (forall X : Universe, (big_f_ X -> big_h_ X)).
Variable pel27_3_3 : (forall X : Universe, ((big_j_ X /\ big_i_ X) -> big_f_ X)).
Variable pel27_4_4 : ((exists X : Universe, (big_h_ X /\ ~(big_g_ X))) -> (forall X1 : Universe, (big_i_ X1 -> ~(big_h_ X1)))).

Theorem pel27_5 : (forall X : Universe, (big_j_ X -> ~(big_i_ X))).
Proof.
  time hprover.
Qed.

End FOFProblem.
