(*
% File     : SYN056+1 : ILTP v1.1.2
% Domain   : Syntactic
% Problem  : Pelletier Problem 26
% Version  : Especial.
% English  : 
% Refs     : [KM64]  Kalish & Montegue (1964), Logic: Techniques of Formal 
%          : [Pel86] Pelletier (1986), Seventy-five Problems for Testing Au
%          : [Hah94] Haehnle (1994), Email to G. Sutcliffe
% Source   : [Hah94]
% Names    : Pelletier 26 [Pel86]
% Status   : Theorem
% Rating   : 0.00 v2.1.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.50 v1.0.0
% Syntax   : Number of formulae    :    3 (   0 unit)
%            Number of atoms       :   10 (   0 equality)
%            Maximal formula depth :    5 (   4 average)
%            Number of connectives :    7 (   0 ~  ;   0  |;   1  &)
%                                         (   3 <=>;   3 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    4 (   0 propositional; 1-1 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :    6 (   0 singleton;   4 !;   2 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable big_s_ : Universe -> Prop.
Variable big_r_ : Universe -> Prop.
Variable big_q_ : Universe -> Prop.
Variable big_p_ : Universe -> Prop.


Variable pel26_1_1 : ((exists X : Universe, big_p_ X) <-> (exists Y : Universe, big_q_ Y)).
Variable pel26_2_2 : (forall X Y : Universe, ((big_p_ X /\ big_q_ Y) -> (big_r_ X <-> big_s_ Y))).

Theorem pel26_3 : ((forall X : Universe, (big_p_ X -> big_r_ X)) <-> (forall Y : Universe, (big_q_ Y -> big_s_ Y))).
Proof.
  time hprover.
Qed.

End FOFProblem.
