(*
% File     : SYN055+1 : ILTP v1.1.2
% Domain   : Syntactic
% Problem  : Pelletier Problem 25
% Version  : Especial.
% English  : 
% Refs     : [KM64]  Kalish & Montegue (1964), Logic: Techniques of Formal 
%          : [Pel86] Pelletier (1986), Seventy-five Problems for Testing Au
%          : [Hah94] Haehnle (1994), Email to G. Sutcliffe
% Source   : [Hah94]
% Names    : Pelletier 25 [Pel86]
% Status   : Theorem
% Rating   : 0.00 v2.1.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.0.0
% Syntax   : Number of formulae    :    5 (   1 unit)
%            Number of atoms       :   13 (   0 equality)
%            Maximal formula depth :    5 (   4 average)
%            Number of connectives :    9 (   1 ~  ;   1  |;   4  &)
%                                         (   0 <=>;   3 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    5 (   0 propositional; 1-1 arity)
%            Number of functors    :    0 (   0 constant; --- arity)
%            Number of variables   :    6 (   0 singleton;   3 !;   3 ?)
%            Maximal term depth    :    1 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable big_r_ : Universe -> Prop.
Variable big_q_ : Universe -> Prop.
Variable big_p_ : Universe -> Prop.
Variable big_g_ : Universe -> Prop.
Variable big_f_ : Universe -> Prop.


Variable pel25_1_1 : (exists X : Universe, big_p_ X).
Variable pel25_2_2 : (forall X : Universe, (big_f_ X -> (~(big_g_ X) /\ big_r_ X))).
Variable pel25_3_3 : (forall X : Universe, (big_p_ X -> (big_g_ X /\ big_f_ X))).
Variable pel25_4_4 : ((forall X : Universe, (big_p_ X -> big_q_ X)) \/ (exists Z : Universe, (big_p_ Z /\ big_r_ Z))).

Theorem pel25_5 : (exists X : Universe, (big_q_ X /\ big_p_ X)).
Proof.
  time hprover.
Qed.

End FOFProblem.
