(*
% File     : SYJ206+1.010 : ILTP v1.1.2
% Domain   : Intuitionistic Syntactic
% Problem  : Equivalences
% Version  : Especial.
%            Problem formulation : Intuit. Valid  Size 10
% English  : (..(( p(1) <=> p(2)) <=> p(3)) <=> .. <=> p(N))  <=>
%            (p(N) <=> ( p(N-1) <=> (.. (p(2) <=> p(1)) ) ))
% Refs     : [Dyc97] Roy Dyckhoff. Some benchmark formulas for
%                    intuitionistic propositional logic. At
%                    http://www.dcs.st-and.ac.uk/~rd/logic/marks.html
% Source   : [Dyc97]
% Names    : equiv_p10 : Dyckhoff's benchmark formulas (1997)
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.25 v1.0.0
% Comments : this formula is different to the equivalences formulated
%            in Pelletier 71 [Pel86], TPTP SYN007+1
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable a9_ : Prop.
Variable a8_ : Prop.
Variable a7_ : Prop.
Variable a6_ : Prop.
Variable a5_ : Prop.
Variable a4_ : Prop.
Variable a3_ : Prop.
Variable a2_ : Prop.
Variable a10_ : Prop.
Variable a1_ : Prop.



Theorem con_1 : ((((((((((a1_ <-> a2_) <-> a3_) <-> a4_) <-> a5_) <-> a6_) <-> a7_) <-> a8_) <-> a9_) <-> a10_) <-> (a10_ <-> (a9_ <-> (a8_ <-> (a7_ <-> (a6_ <-> (a5_ <-> (a4_ <-> (a3_ <-> (a2_ <-> a1_)))))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
