(*
% File     : SYJ204+1.010 : ILTP v1.1.2
% Domain   : Intuitionistic Syntactic
% Problem  : Formulae with normal natural deduction proofs only of exponential size
% Version  : Especial.
%            Problem formulation : Intuit. Valid  Size 10
% English  : (p(N) & &&_{i=1..N} (p(i) => p(i) => p(i-1))) => p(0)
% Refs     : [Dyc97] Roy Dyckhoff. Some benchmark formulas for
%                    intuitionistic propositional logic. At
%                    http://www.dcs.st-and.ac.uk/~rd/logic/marks.html
%          : [Sch97] H. Schwichtenberg, Termination of permutative
%                    conversions in Gentzen's sequent calculus,
%                    unpublished (1997). 
% Source   : [Dyc97]
% Names    : schwicht_p10 : Dyckhoff's benchmark formulas (1997)
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.0.0
% Comments : ...no normal natural deduction proof of size less than an
%             expontial function of N.
%            ..Our experience of these problems is that they can be decided
%            very fast but can generate space problems, e.g. for some
%            implementations of Prolog. [Dyc97]
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable p9_ : Prop.
Variable p8_ : Prop.
Variable p7_ : Prop.
Variable p6_ : Prop.
Variable p5_ : Prop.
Variable p4_ : Prop.
Variable p3_ : Prop.
Variable p2_ : Prop.
Variable p10_ : Prop.
Variable p1_ : Prop.
Variable p0_ : Prop.


Variable axiom1_1 : p10_.
Variable axiom2_2 : (p1_ -> (p1_ -> p0_)).
Variable axiom3_3 : (p2_ -> (p2_ -> p1_)).
Variable axiom4_4 : (p3_ -> (p3_ -> p2_)).
Variable axiom5_5 : (p4_ -> (p4_ -> p3_)).
Variable axiom6_6 : (p5_ -> (p5_ -> p4_)).
Variable axiom7_7 : (p6_ -> (p6_ -> p5_)).
Variable axiom8_8 : (p7_ -> (p7_ -> p6_)).
Variable axiom9_9 : (p8_ -> (p8_ -> p7_)).
Variable axiom10_10 : (p9_ -> (p9_ -> p8_)).
Variable axiom11_11 : (p10_ -> (p10_ -> p9_)).

Theorem con_12 : p0_.
Proof.
  time hprover.
Qed.

End FOFProblem.
