(*
% File     : SYJ202+1.006 : ILTP v1.1.2
% Domain   : Intuitionistic Syntactic
% Problem  : Cook pigeon-hole problem
% Version  : Especial.
%            Problem formulation : Prop. Non-Clausal. Intuit. Valid  Size 6
% English  : Suppose there are N holes and N+1 pigeons to put in the
%            holes. Every pigeon is in a hole and no hole contains more
%            than one pigeon. Prove that this is impossible. The size is
%            the number of pigeons.
%            LHS(N) => RHS(N) with 
%            LHS(N) = &&_{p=1..N+1} (||_{h=1,..N} o(p,h) )
%            RHS(N) = ||_{h=1..N, p1=1..{N+1}, p2={p1+1}..{N+1}} s(p1,p2,h)
%            with s(p1,p2,h) = o(p1,h) & o(p2,h)
% Refs     : [Dyc97] Roy Dyckhoff. Some benchmark formulas for
%                    intuitionistic propositional logic. At
%                    http://www.dcs.st-and.ac.uk/~rd/logic/marks.html
%          : [CR79]  Cook & Reckhow (1979), The Relative Efficiency of
%                    Propositional Proof Systems, Journal of Symbolic
%                    Logic 44, pp.36-50.
%          : [Pel86] Pelletier (1986), Seventy-five Problems for Testing
%                    Automatic Theorem Provers, Journal of Automated
%                    Reasoning 2(2), pp.191-216.
% Source   : [Dyc97]
% Names    : ph_p6 : Dyckhoff's benchmark formulas (1997)
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.25 v1.1.0, 0.00 v1.0.0
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable o76_ : Prop.
Variable o75_ : Prop.
Variable o74_ : Prop.
Variable o73_ : Prop.
Variable o72_ : Prop.
Variable o71_ : Prop.
Variable o66_ : Prop.
Variable o65_ : Prop.
Variable o64_ : Prop.
Variable o63_ : Prop.
Variable o62_ : Prop.
Variable o61_ : Prop.
Variable o56_ : Prop.
Variable o55_ : Prop.
Variable o54_ : Prop.
Variable o53_ : Prop.
Variable o52_ : Prop.
Variable o51_ : Prop.
Variable o46_ : Prop.
Variable o45_ : Prop.
Variable o44_ : Prop.
Variable o43_ : Prop.
Variable o42_ : Prop.
Variable o41_ : Prop.
Variable o36_ : Prop.
Variable o35_ : Prop.
Variable o34_ : Prop.
Variable o33_ : Prop.
Variable o32_ : Prop.
Variable o31_ : Prop.
Variable o26_ : Prop.
Variable o25_ : Prop.
Variable o24_ : Prop.
Variable o23_ : Prop.
Variable o22_ : Prop.
Variable o21_ : Prop.
Variable o16_ : Prop.
Variable o15_ : Prop.
Variable o14_ : Prop.
Variable o13_ : Prop.
Variable o12_ : Prop.
Variable o11_ : Prop.


Variable axiom1_1 : (o11_ \/ (o12_ \/ (o13_ \/ (o14_ \/ (o15_ \/ o16_))))).
Variable axiom2_2 : (o21_ \/ (o22_ \/ (o23_ \/ (o24_ \/ (o25_ \/ o26_))))).
Variable axiom3_3 : (o31_ \/ (o32_ \/ (o33_ \/ (o34_ \/ (o35_ \/ o36_))))).
Variable axiom4_4 : (o41_ \/ (o42_ \/ (o43_ \/ (o44_ \/ (o45_ \/ o46_))))).
Variable axiom5_5 : (o51_ \/ (o52_ \/ (o53_ \/ (o54_ \/ (o55_ \/ o56_))))).
Variable axiom6_6 : (o61_ \/ (o62_ \/ (o63_ \/ (o64_ \/ (o65_ \/ o66_))))).
Variable axiom7_7 : (o71_ \/ (o72_ \/ (o73_ \/ (o74_ \/ (o75_ \/ o76_))))).

Theorem con_8 : ((o11_ /\ o21_) \/ ((o11_ /\ o31_) \/ ((o11_ /\ o41_) \/ ((o11_ /\ o51_) \/ ((o11_ /\ o61_) \/ ((o11_ /\ o71_) \/ ((o21_ /\ o31_) \/ ((o21_ /\ o41_) \/ ((o21_ /\ o51_) \/ ((o21_ /\ o61_) \/ ((o21_ /\ o71_) \/ ((o31_ /\ o41_) \/ ((o31_ /\ o51_) \/ ((o31_ /\ o61_) \/ ((o31_ /\ o71_) \/ ((o41_ /\ o51_) \/ ((o41_ /\ o61_) \/ ((o41_ /\ o71_) \/ ((o51_ /\ o61_) \/ ((o51_ /\ o71_) \/ ((o61_ /\ o71_) \/ ((o12_ /\ o22_) \/ ((o12_ /\ o32_) \/ ((o12_ /\ o42_) \/ ((o12_ /\ o52_) \/ ((o12_ /\ o62_) \/ ((o12_ /\ o72_) \/ ((o22_ /\ o32_) \/ ((o22_ /\ o42_) \/ ((o22_ /\ o52_) \/ ((o22_ /\ o62_) \/ ((o22_ /\ o72_) \/ ((o32_ /\ o42_) \/ ((o32_ /\ o52_) \/ ((o32_ /\ o62_) \/ ((o32_ /\ o72_) \/ ((o42_ /\ o52_) \/ ((o42_ /\ o62_) \/ ((o42_ /\ o72_) \/ ((o52_ /\ o62_) \/ ((o52_ /\ o72_) \/ ((o62_ /\ o72_) \/ ((o13_ /\ o23_) \/ ((o13_ /\ o33_) \/ ((o13_ /\ o43_) \/ ((o13_ /\ o53_) \/ ((o13_ /\ o63_) \/ ((o13_ /\ o73_) \/ ((o23_ /\ o33_) \/ ((o23_ /\ o43_) \/ ((o23_ /\ o53_) \/ ((o23_ /\ o63_) \/ ((o23_ /\ o73_) \/ ((o33_ /\ o43_) \/ ((o33_ /\ o53_) \/ ((o33_ /\ o63_) \/ ((o33_ /\ o73_) \/ ((o43_ /\ o53_) \/ ((o43_ /\ o63_) \/ ((o43_ /\ o73_) \/ ((o53_ /\ o63_) \/ ((o53_ /\ o73_) \/ ((o63_ /\ o73_) \/ ((o14_ /\ o24_) \/ ((o14_ /\ o34_) \/ ((o14_ /\ o44_) \/ ((o14_ /\ o54_) \/ ((o14_ /\ o64_) \/ ((o14_ /\ o74_) \/ ((o24_ /\ o34_) \/ ((o24_ /\ o44_) \/ ((o24_ /\ o54_) \/ ((o24_ /\ o64_) \/ ((o24_ /\ o74_) \/ ((o34_ /\ o44_) \/ ((o34_ /\ o54_) \/ ((o34_ /\ o64_) \/ ((o34_ /\ o74_) \/ ((o44_ /\ o54_) \/ ((o44_ /\ o64_) \/ ((o44_ /\ o74_) \/ ((o54_ /\ o64_) \/ ((o54_ /\ o74_) \/ ((o64_ /\ o74_) \/ ((o15_ /\ o25_) \/ ((o15_ /\ o35_) \/ ((o15_ /\ o45_) \/ ((o15_ /\ o55_) \/ ((o15_ /\ o65_) \/ ((o15_ /\ o75_) \/ ((o25_ /\ o35_) \/ ((o25_ /\ o45_) \/ ((o25_ /\ o55_) \/ ((o25_ /\ o65_) \/ ((o25_ /\ o75_) \/ ((o35_ /\ o45_) \/ ((o35_ /\ o55_) \/ ((o35_ /\ o65_) \/ ((o35_ /\ o75_) \/ ((o45_ /\ o55_) \/ ((o45_ /\ o65_) \/ ((o45_ /\ o75_) \/ ((o55_ /\ o65_) \/ ((o55_ /\ o75_) \/ ((o65_ /\ o75_) \/ ((o16_ /\ o26_) \/ ((o16_ /\ o36_) \/ ((o16_ /\ o46_) \/ ((o16_ /\ o56_) \/ ((o16_ /\ o66_) \/ ((o16_ /\ o76_) \/ ((o26_ /\ o36_) \/ ((o26_ /\ o46_) \/ ((o26_ /\ o56_) \/ ((o26_ /\ o66_) \/ ((o26_ /\ o76_) \/ ((o36_ /\ o46_) \/ ((o36_ /\ o56_) \/ ((o36_ /\ o66_) \/ ((o36_ /\ o76_) \/ ((o46_ /\ o56_) \/ ((o46_ /\ o66_) \/ ((o46_ /\ o76_) \/ ((o56_ /\ o66_) \/ ((o56_ /\ o76_) \/ (o66_ /\ o76_)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
