(*
% File     : SYJ201+1.002 : ILTP v1.1.2
% Domain   : Intuitionistic Syntactic
% Problem  : de Bruijn's example
% Version  : Especial.
%            Problem formulation : Intuit. Valid  Size 2
% English  : LHS(2*N+1) => RHS(2*N+1) with
%            RHS(m) = &&_{i=1..m} p(i),
%            LHS(m) = &&_{i=1..m} ((p(i)<=>p(i+1)) => c(N))
%            where addition is computed modulo m, and with
%            c(N) = &&_{i=1..N} p(i)
% Refs     : [Dyc97] Roy Dyckhoff. Some benchmark formulas for
%                    intuitionistic propositional logic. At
%                    http://www.dcs.st-and.ac.uk/~rd/logic/marks.html
%          :         de Bruijn, N.: personal communication in about 1990.
% Source   : [Dyc97]
% Names    : debruijn_p2 : Dyckhoff's benchmark formulas (1997)
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.0.0
% Comments : quite a tough exercise for students to prove by natural
%             deduction [Dyc97]
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable p5_ : Prop.
Variable p4_ : Prop.
Variable p3_ : Prop.
Variable p2_ : Prop.
Variable p1_ : Prop.


Variable axiom1_1 : ((p1_ <-> p2_) -> (p1_ /\ (p2_ /\ (p3_ /\ (p4_ /\ p5_))))).
Variable axiom2_2 : ((p2_ <-> p3_) -> (p1_ /\ (p2_ /\ (p3_ /\ (p4_ /\ p5_))))).
Variable axiom3_3 : ((p3_ <-> p4_) -> (p1_ /\ (p2_ /\ (p3_ /\ (p4_ /\ p5_))))).
Variable axiom4_4 : ((p4_ <-> p5_) -> (p1_ /\ (p2_ /\ (p3_ /\ (p4_ /\ p5_))))).
Variable axiom5_5 : ((p5_ <-> p1_) -> (p1_ /\ (p2_ /\ (p3_ /\ (p4_ /\ p5_))))).

Theorem con_6 : (p1_ /\ (p2_ /\ (p3_ /\ (p4_ /\ p5_)))).
Proof.
  time hprover.
Qed.

End FOFProblem.
