(*
% File     : SYJ124+1 : ILTP v1.1.2
% Domain   : Intuitionistic Syntactic
% Problem  : 
% Version  : Especial.
% English  : 
% Refs     : [SN00]  S. Schmitt & A. Nogin: test module jprover_tests.ml,
%                    test formulas for JProver in MetaPRL, at
%                    http://cvs.metaprl.org:12000/cvsweb/metaprl/theories/
%                         itt/jprover_tests.ml
%            [ES98] U. Egly & S. Schmitt. Intuitionistic proof 
%                   transformations and their application to constructive 
%                   program synthesis, In J. Calmet & J. Plaza (Eds.), 
%                   Proceedings of the 4th International Conference on 
%                   Artificial Intelligence and Symbolic Computation, 
%                   LNAI 1476, p. 132-144, Springer Verlag, 1998
% Source   : [SN00]
% Names    : mult_rename : JProver test formulae (2000)
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.0.0
% Comments : it requires the permutation-based proof transformations from
%            [ES98]
%            embedding multiple use of eigenvariable formula WITH 
%            eigenvariable renaming
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable c_ : Universe -> Universe -> Prop.
Variable b_ : Universe -> Prop.
Variable a_ : Universe -> Prop.


Variable axiom1_1 : (forall X : Universe, ((a_ X \/ b_ X) /\ (exists A : Universe, c_ A X))).
Variable axiom2_2 : ((exists Y : Universe, a_ Y) -> (exists Z : Universe, ~(a_ Z))).

Theorem con_3 : (exists X : Universe, (b_ X /\ (exists Z : Universe, c_ Z X))).
Proof.
  time hprover.
Qed.

End FOFProblem.
