(*
% File     : SYJ119+1 : ILTP v1.1.2
% Domain   : Intuitionistic Syntactic
% Problem  : 
% Version  : Especial.
% English  : 
% Refs     : [SN00]  S. Schmitt & A. Nogin: test module jprover_tests.ml,
%                    test formulas for JProver in MetaPRL, at
%                    http://cvs.metaprl.org:12000/cvsweb/metaprl/theories/
%                         itt/jprover_tests.ml
%            [ES98] U. Egly & S. Schmitt. Intuitionistic proof 
%                   transformations and their application to constructive 
%                   program synthesis, In J. Calmet & J. Plaza (Eds.), 
%                   Proceedings of the 4th International Conference on 
%                   Artificial Intelligence and Symbolic Computation, 
%                   LNAI 1476, p. 132-144, Springer Verlag, 1998
% Source   : [SN00]
% Names    : deadlock3 : JProver test formulae (2000)
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.0.0
% Comments : Some weired LJ deadlock
%            shows a deeper difference between the rule non-permutabilities 
%            of the sequent calculi LJmc and LJ.
%            it requires the permutation-based proof transformations from
%            [ES98]
% embedding LJ deadlocks into bigger non-deadlock proofs
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable p_ : Prop.
Variable b_ : Universe -> Prop.
Variable a_ : Universe -> Prop.


Variable axiom1_1 : p_.
Variable axiom2_2 : (forall X : Universe, (a_ X \/ b_ X)).
Variable axiom3_3 : ((exists Y : Universe, a_ Y) -> (exists Z : Universe, ~(a_ Z))).

Theorem con_4 : ((exists X : Universe, b_ X) /\ p_).
Proof.
  time hprover.
Qed.

End FOFProblem.
