(*
% File     : SYJ110+1 : ILTP v1.1.2
% Domain   : Intuitionistic Syntactic
% Problem  : 
% Version  : Especial.
% English  : 
% Refs     : [SN00]  S. Schmitt & A. Nogin: test module jprover_tests.ml,
%                    test formulas for JProver in MetaPRL, at
%                    http://cvs.metaprl.org:12000/cvsweb/metaprl/theories/
%                         itt/jprover_tests.ml
%            [OK96] J. Otten und C. Kreitz. A uniform proof procedure
%                   for classical and non-classical logics. In KI-96: 
%                   Advances in Artificial Intelligence, LNAI 1137, 
%                   p. 307-319, Springer Verlag, 1996.
% Source   : [SN00]
% Names    : jens_fo : JProver test formulae (2000)
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.0.0
% Comments : Only difference to example in [OK96]: all-closure wrt. the 
%            parameters a and b 
%            It needs two instances of the (! [X] : s(X)) subformula 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable t_ : Universe -> Prop.
Variable s_ : Universe -> Prop.
Variable r_ : Universe -> Prop.
Variable q_ : Universe -> Prop.
Variable p_ : Universe -> Prop.



Theorem con_1 : (forall A : Universe, (forall B : Universe, (((forall X : Universe, s_ X) /\ (forall Y : Universe, (~((t_ Y -> r_ Y)) -> p_ Y))) -> (~((exists Z : Universe, ((p_ Z -> q_ Z) /\ (t_ Z -> r_ Z)))) -> (~(~(p_ A)) /\ (s_ A /\ s_ B)))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
