(*
% File     : SYJ107+1.003 : ILTP v1.1.2
% Domain   : Intuitionistic Syntactic
% Problem  : 
% Version  : Especial.
%            Problem formulation : Intuit. Valid  Size 3
% English  : 
% Refs     : [SN00]  S. Schmitt & A. Nogin: test module jprover_tests.ml,
%                    test formulas for JProver in MetaPRL, at
%                    http://cvs.metaprl.org:12000/cvsweb/metaprl/theories/
%                         itt/jprover_tests.ml
%            [ES99]  U. Egly & S. Schmitt. On intuitionistic proof
%                    transformations, their complexity, and application to 
%                    constructive program synthesis. In Fundamenta 
%                    Informaticae, Special Issue: Symbolic Computation and 
%                    Artificial Intelligence, vol. 39, 1/2, p. 59-83, 1999
% Source   : [SN00]
% Names    : prop_n3 : JProver test formulae (2000)
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.0.0
% Comments : cause exponential proof length in EVERY LJ proof wrt. the 
%            proof length of a given LJmc proof in propositional 
%            intuitionistic logic 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable b2_ : Prop.
Variable b1_ : Prop.
Variable b_ : Prop.
Variable a3_ : Prop.
Variable a2_ : Prop.
Variable a1_ : Prop.
Variable a_ : Prop.


Variable axiom1_1 : a3_.
Variable axiom2_2 : (b1_ -> ((b2_ \/ a2_) \/ b2_)).
Variable axiom3_3 : (b_ -> ((b1_ \/ a1_) \/ b1_)).
Variable axiom4_4 : ((b_ \/ a_) \/ b_).

Theorem con_5 : (a_ \/ ((b_ /\ a1_) \/ ((b1_ /\ a2_) \/ (b2_ /\ a3_)))).
Proof.
  time hprover.
Qed.

End FOFProblem.
