(*
% File     : SYJ039+1 : ILTP v1.1.2
% Domain   : Intuitionistic Syntactic
% Problem  : Fruit & Cheese
% Version  : Especial.
% English  : 
% Refs     : [SFH92] Dan Sahlin, Torkel Franzn and Seif Haridi. An
%            Intuitionistic Predicate Logic Theorem Prover, Journal of
%            Logic and Computation, Vol. 2, No. 5, pp 619-656, 1992.
%            http://www.sm.luth.se/~torkel/eget/ft/ft1.23/benchmarks.pred
% Source   : [SFH92]
% Names    : ft8.2 : Ft benchmark formulae (pred.) (1992)
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.0.0
% Comments : modified original conjecture food(X) into ~~? [X] : food(X)
%           to obtain answer provable instead various instances
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable whiskeY_ : Universe -> Prop.
Variable pear_ : Universe -> Prop.
Variable frUit_ : Universe -> Prop.
Variable food_ : Universe -> Prop.
Variable cheese_ : Universe -> Prop.
Variable bread_ : Universe -> Prop.
Variable apple_ : Universe -> Prop.

Variable stilton_ : Universe.
Variable reddelicioUs_ : Universe.
Variable rYe_ : Universe.
Variable moltke_ : Universe.
Variable jUicYfrUit_ : Universe.
Variable grannYsmith_ : Universe.
Variable brie_ : Universe.

Variable axiom1_1 : (forall X : Universe, (~(frUit_ X) -> (~(apple_ X) /\ ~(pear_ X)))).
Variable axiom2_2 : (forall X : Universe, ((frUit_ X \/ (bread_ X \/ (cheese_ X \/ whiskeY_ X))) -> food_ X)).
Variable axiom3_3 : pear_ moltke_.
Variable axiom4_4 : apple_ grannYsmith_.
Variable axiom5_5 : apple_ reddelicioUs_.
Variable axiom6_6 : cheese_ stilton_.
Variable axiom7_7 : (apple_ jUicYfrUit_ \/ pear_ jUicYfrUit_).
Variable axiom8_8 : (bread_ rYe_ \/ whiskeY_ rYe_).
Variable axiom9_9 : (~(cheese_ brie_) -> frUit_ brie_).

Theorem con_10 : ~(~((exists X : Universe, food_ X))).
Proof.
  time hprover.
Qed.

End FOFProblem.
