(*
% File     : SYJ037+1 : ILTP v1.1.2
% Domain   : Intuitionistic Syntactic
% Problem  : formula being Problematic for Ft-Algorithm
% Version  : Especial.
% English  : 
% Refs     : [SFH92] Dan Sahlin, Torkel Franzn and Seif Haridi. An
%            Intuitionistic Predicate Logic Theorem Prover, Journal of
%            Logic and Computation, Vol. 2, No. 5, pp 619-656, 1992.
%            http://www.sm.luth.se/~torkel/eget/ft/ft1.23/benchmarks.pred
% Source   : [SFH92]
% Names    : ft7d : Ft benchmark formulae (pred.) (1992)
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.1.0, 0.25 v1.0.0
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable q_ : Universe -> Universe -> Universe -> Universe -> Universe -> Universe -> Universe -> Universe -> Universe -> Universe -> Prop.
Variable p_ : Universe -> Prop.

Variable a5_ : Universe.
Variable a4_ : Universe.
Variable a3_ : Universe.
Variable a2_ : Universe.
Variable a1_ : Universe.

Variable axiom1_1 : q_ a1_ a2_ a3_ a4_ a5_ a1_ a2_ a3_ a4_ a5_.

Theorem con_2 : (exists X1 : Universe, (exists X2 : Universe, (exists X3 : Universe, (exists X4 : Universe, (exists X5 : Universe, (exists Y1 : Universe, (exists Y2 : Universe, (exists Y3 : Universe, (exists Y4 : Universe, (exists Y5 : Universe, (((p_ X1 /\ (p_ X2 /\ (p_ X3 /\ (p_ X4 /\ p_ X5)))) <-> (p_ Y1 /\ (p_ Y2 /\ (p_ Y3 /\ (p_ Y4 /\ p_ Y5))))) /\ q_ X1 X2 X3 X4 X5 Y1 Y2 Y3 Y4 Y5))))))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
