(*
% File     : SYJ033+1 : ILTP v1.1.2
% Domain   : Intuitionistic Syntactic
% Problem  : Simple
% Version  : Especial.
% English  : 
% Refs     : [SFH92] Dan Sahlin, Torkel Franzn and Seif Haridi. An
%            Intuitionistic Predicate Logic Theorem Prover, Journal of
%            Logic and Computation, Vol. 2, No. 5, pp 619-656, 1992.
%            http://www.sm.luth.se/~torkel/eget/ft/ft1.23/benchmarks.pred
% Source   : [SFH92]
% Names    : ft6.15 : Ft benchmark formulae (pred.) (1992)
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.0.0
% Comments : ...just some short formulae, written sown more or less at
%            random... [SFH92]
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable t_ : Universe -> Prop.
Variable s_ : Universe -> Prop.
Variable r_ : Universe -> Universe -> Prop.
Variable q_ : Universe -> Prop.
Variable p_ : Universe -> Prop.


Variable axiom1_1 : (forall X : Universe, (p_ X -> ~((exists Y : Universe, (q_ Y /\ r_ X Y))))).
Variable axiom2_2 : (forall X1 : Universe, (t_ X1 -> (exists Y1 : Universe, (s_ Y1 /\ r_ X1 Y1)))).
Variable axiom3_3 : (forall X2 : Universe, (p_ X2 -> ~(~(t_ X2)))).
Variable axiom4_4 : (forall Y2 : Universe, (s_ Y2 -> q_ Y2)).

Theorem con_5 : ~((exists X3 : Universe, p_ X3)).
Proof.
  time hprover.
Qed.

End FOFProblem.
