(*
% File     : SYJ031+1 : ILTP v1.1.2
% Domain   : Intuitionistic Syntactic
% Problem  : Simple
% Version  : Especial.
% English  : 
% Refs     : [SFH92] Dan Sahlin, Torkel Franzn and Seif Haridi. An
%            Intuitionistic Predicate Logic Theorem Prover, Journal of
%            Logic and Computation, Vol. 2, No. 5, pp 619-656, 1992.
%            http://www.sm.luth.se/~torkel/eget/ft/ft1.23/benchmarks.pred
% Source   : [SFH92]
% Names    : ft6.13 : Ft benchmark formulae (pred.) (1992)
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.25 v1.0.0
% Comments : ...just some short formulae, written sown more or less at
%            random... [SFH92]
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable s_ : Universe -> Universe -> Prop.
Variable r_ : Universe -> Prop.
Variable q_ : Universe -> Prop.
Variable p_ : Universe -> Prop.
Variable g_ : Universe -> Prop.

Variable a_ : Universe.

Variable axiom1_1 : (forall X : Universe, (p_ X <-> (q_ X \/ (r_ X \/ (exists Y : Universe, s_ X Y))))).
Variable axiom2_2 : (exists X1 : Universe, (exists Y1 : Universe, (s_ Y1 X1 \/ g_ X1))).
Variable axiom3_3 : (forall X2 : Universe, (g_ X2 <-> ((exists Y2 : Universe, s_ X2 Y2) \/ (exists Z : Universe, (r_ Z \/ (q_ Z \/ s_ a_ Z)))))).

Theorem con_4 : ((exists X3 : Universe, q_ X3) \/ ((exists X4 : Universe, r_ X4) \/ (exists X5 : Universe, (exists Y5 : Universe, s_ X5 Y5)))).
Proof.
  time hprover.
Qed.

End FOFProblem.
