(*
% File     : SYJ026+1 : ILTP v1.1.2
% Domain   : Intuitionistic Syntactic
% Problem  : Simple
% Version  : Especial.
% English  : 
% Refs     : [SFH92] Dan Sahlin, Torkel Franzn and Seif Haridi. An
%            Intuitionistic Predicate Logic Theorem Prover, Journal of
%            Logic and Computation, Vol. 2, No. 5, pp 619-656, 1992.
%            http://www.sm.luth.se/~torkel/eget/ft/ft1.23/benchmarks.pred
% Source   : [SFH92]
% Names    : ft6.8 : Ft benchmark formulae (pred.) (1992)
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.0.0
% Comments : ...just some short formulae, written sown more or less at
%            random... [SFH92]
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable r_ : Universe -> Prop.
Variable q_ : Universe -> Universe -> Prop.
Variable p_ : Universe -> Prop.


Variable axiom1_1 : (forall X : Universe, (p_ X -> (exists Y : Universe, (q_ X Y /\ r_ Y)))).
Variable axiom2_2 : (exists X : Universe, (exists Y : Universe, (q_ X Y \/ p_ X))).

Theorem con_3 : (exists X : Universe, (exists Y : Universe, q_ X Y)).
Proof.
  time hprover.
Qed.

End FOFProblem.
