(*
% File     : SYJ015+1 : ILTP v1.1.2
% Domain   : Intuitionistic Syntactic
% Problem  : Using Existence-quantor
% Version  : Especial.
% English  : 
% Refs     : [SFH92] Dan Sahlin, Torkel Franzn and Seif Haridi. An
%            Intuitionistic Predicate Logic Theorem Prover, Journal of
%            Logic and Computation, Vol. 2, No. 5, pp 619-656, 1992.
%            http://www.sm.luth.se/~torkel/eget/ft/ft1.23/benchmarks.pred
% Source   : [SFH92]
% Names    : ft4.3 : Ft benchmark formulae (pred.) (1992)
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.50 v1.0.0
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable p_ : Universe -> Prop.

Variable h_ : Universe -> Universe.
Variable g_ : Universe -> Universe.

Variable axiom1_1 : (forall X : Universe, (p_ X -> (p_ (h_ X) \/ p_ (g_ X)))).
Variable axiom2_2 : (exists X : Universe, p_ X).
Variable axiom3_3 : (forall X : Universe, ~(p_ (h_ X))).

Theorem con_4 : (exists X : Universe, p_ (g_ (g_ (g_ (g_ (g_ (g_ (g_ X)))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
