(*
% File     : SYJ004+1 : ILTP v1.1.2
% Domain   : Intuitionistic Syntactic
% Problem  : Append.
% Version  : Especial.
%          : Theorem formulation : For N = SIZE. Size 7
% English  : All x. append(nil,X,X) &  
%          : All x. All y. All z. All w. append(y,z,w)->append(cons(x,y),z,cons(x,w)) ->
%          : Ex x. append(cons(a1,cons(a2,cons( .. (an,nil)))),nil,x)
% Refs     : [SFH92] Dan Sahlin, Torkel Franzn and Seif Haridi. An
%            Intuitionistic Predicate Logic Theorem Prover, Journal of
%            Logic and Computation, Vol. 2, No. 5, pp 619-656, 1992.
%            http://www.sm.luth.se/~torkel/eget/ft/ft1.23/benchmarks.pred
% Source   : [SFH92]
% Names    : ft2.3
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.1.0, 0.50 v1.0.0
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable append_ : Universe -> Universe -> Universe -> Prop.

Variable nil_ : Universe.
Variable cons_ : Universe -> Universe -> Universe.
Variable a7_ : Universe.
Variable a6_ : Universe.
Variable a5_ : Universe.
Variable a4_ : Universe.
Variable a3_ : Universe.
Variable a2_ : Universe.
Variable a1_ : Universe.

Variable ax1_1 : (forall X : Universe, append_ nil_ X X).
Variable ax2_2 : (forall X Y Z W : Universe, (append_ Y Z W -> append_ (cons_ X Y) Z (cons_ X W))).

Theorem con_3 : (exists X : Universe, append_ (cons_ a1_ (cons_ a2_ (cons_ a3_ (cons_ a4_ (cons_ a5_ (cons_ a6_ (cons_ a7_ nil_))))))) nil_ X).
Proof.
  time hprover.
Qed.

End FOFProblem.
