(*
% File     : SYJ002+1 : ILTP v1.1.2
% Domain   : Intuitionistic Syntactic
% Problem  : Alternations of quantifiers
% Version  : Especial.
%          : Theorem formulation : For N = SIZE. Size 16
% English  : Ex x1.All x2.Ex x3... xn.(p1(x1)&p2(x2)&p3(x3)&..pn(xn)) <->
%            ..  xn... Ex x3.All x2.Ex x1.(p1(x1)&p2(x2)&p3(x3)&..pn(xn))
% Refs     : [SFH92] Dan Sahlin, Torkel Franzn and Seif Haridi. An
%            Intuitionistic Predicate Logic Theorem Prover, Journal of
%            Logic and Computation, Vol. 2, No. 5, pp 619-656, 1992.
%            http://www.sm.luth.se/~torkel/eget/ft/ft1.23/benchmarks.pred
% Source   : [SFH92]
% Names    : 
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.1.0
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable p9_ : Universe -> Prop.
Variable p8_ : Universe -> Prop.
Variable p7_ : Universe -> Prop.
Variable p6_ : Universe -> Prop.
Variable p5_ : Universe -> Prop.
Variable p4_ : Universe -> Prop.
Variable p3_ : Universe -> Prop.
Variable p2_ : Universe -> Prop.
Variable p16_ : Universe -> Prop.
Variable p15_ : Universe -> Prop.
Variable p14_ : Universe -> Prop.
Variable p13_ : Universe -> Prop.
Variable p12_ : Universe -> Prop.
Variable p11_ : Universe -> Prop.
Variable p10_ : Universe -> Prop.
Variable p1_ : Universe -> Prop.



Theorem con_1 : ((exists X1 : Universe, (forall X2 : Universe, (exists X3 : Universe, (forall X4 : Universe, (exists X5 : Universe, (forall X6 : Universe, (exists X7 : Universe, (forall X8 : Universe, (exists X9 : Universe, (forall X10 : Universe, (exists X11 : Universe, (forall X12 : Universe, (exists X13 : Universe, (forall X14 : Universe, (exists X15 : Universe, (forall X16 : Universe, (p1_ X1 /\ (p2_ X2 /\ (p3_ X3 /\ (p4_ X4 /\ (p5_ X5 /\ (p6_ X6 /\ (p7_ X7 /\ (p8_ X8 /\ (p9_ X9 /\ (p10_ X10 /\ (p11_ X11 /\ (p12_ X12 /\ (p13_ X13 /\ (p14_ X14 /\ (p15_ X15 /\ p16_ X16))))))))))))))))))))))))))))))) <-> (forall X16 : Universe, (exists X15 : Universe, (forall X14 : Universe, (exists X13 : Universe, (forall X12 : Universe, (exists X11 : Universe, (forall X10 : Universe, (exists X9 : Universe, (forall X8 : Universe, (exists X7 : Universe, (forall X6 : Universe, (exists X5 : Universe, (forall X4 : Universe, (exists X3 : Universe, (forall X2 : Universe, (exists X1 : Universe, (p1_ X1 /\ (p2_ X2 /\ (p3_ X3 /\ (p4_ X4 /\ (p5_ X5 /\ (p6_ X6 /\ (p7_ X7 /\ (p8_ X8 /\ (p9_ X9 /\ (p10_ X10 /\ (p11_ X11 /\ (p12_ X12 /\ (p13_ X13 /\ (p14_ X14 /\ (p15_ X15 /\ p16_ X16)))))))))))))))))))))))))))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
