(*
% File     : SWV130+1 : ILTP v1.1.2
% Domain   : Software Verification
% Problem  : Unsimplified proof obligation thruster_symm_0001
% Version  : [DFS04] axioms : Especial.
% English  : Proof obligation emerging from the symm-safety verification for
%            the thruster program. symmetry-safety ensures that certain
%            two-dimensional arrays remain symmetric.
% Refs     : [Fis04] Fischer (2004), Email to G. Sutcliffe
%          : [DFS04] Denney et al. (2004), Using Automated Theorem Provers
% Source   : [Fis04]
% Names    : thruster_symm_0001 [Fis04]
% Status   : Theorem
% Rating   : 1.00 v3.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :  183 ( 147 unit)
%            Number of atoms       : 1370 ( 276 equality)
%            Maximal formula depth :   37 (   3 average)
%            Number of connectives : 1207 (  20 ~  ;  23  |; 852  &)
%                                         (   5 <=>; 307 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   1 propositional; 0-2 arity)
%            Number of functors    :   74 (  51 constant; 0-4 arity)
%            Number of variables   :  510 (   2 singleton; 510 !;   0 ?)
%            Maximal term depth    :   38 (   2 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable true_ : Prop.
Variable lt_ : Universe -> Universe -> Prop.
Variable leq_ : Universe -> Universe -> Prop.
Variable gt_ : Universe -> Universe -> Prop.
Variable geq_ : Universe -> Universe -> Prop.

Variable xhatmin_thruster_filter_ : Universe.
Variable use_ : Universe.
Variable uniform_int_rnd_ : Universe -> Universe -> Universe.
Variable trans_ : Universe -> Universe.
Variable tr_ : Universe.
Variable tptp_update3_ : Universe -> Universe -> Universe -> Universe -> Universe.
Variable tptp_update2_ : Universe -> Universe -> Universe -> Universe.
Variable tptp_uminus_ : Universe -> Universe.
Variable tptp_msub_ : Universe -> Universe -> Universe.
Variable tptp_mmul_ : Universe -> Universe -> Universe.
Variable tptp_minus_1_ : Universe.
Variable tptp_madd_ : Universe -> Universe -> Universe.
Variable tptp_float_70_707_ : Universe.
Variable tptp_float_1_2_ : Universe.
Variable tptp_float_0_423_ : Universe.
Variable tptp_float_0_217_ : Universe.
Variable tptp_float_0_034_ : Universe.
Variable tptp_float_0_001_ : Universe.
Variable tptp_float_0_0001_ : Universe.
Variable tptp_const_array2_ : Universe -> Universe -> Universe -> Universe.
Variable tptp_const_array1_ : Universe -> Universe -> Universe.
Variable times_ : Universe -> Universe -> Universe.
Variable sum_ : Universe -> Universe -> Universe -> Universe.
Variable succ_ : Universe -> Universe.
Variable sin_ : Universe -> Universe.
Variable sigma_ : Universe.
Variable rho_ : Universe.
Variable r_thruster_filter_ : Universe.
Variable q_thruster_filter_ : Universe.
Variable pv5_ : Universe.
Variable pv40_ : Universe.
Variable pv39_ : Universe.
Variable pv31_ : Universe.
Variable pv29_ : Universe.
Variable pred_ : Universe -> Universe.
Variable pminus_thruster_filter_ : Universe.
Variable plus_ : Universe -> Universe -> Universe.
Variable phi_thruster_filter_ : Universe.
Variable n707_ : Universe.
Variable n7_ : Universe.
Variable n6_ : Universe.
Variable n588_ : Universe.
Variable n5_ : Universe.
Variable n423_ : Universe.
Variable n4_ : Universe.
Variable n34_ : Universe.
Variable n3_ : Universe.
Variable n217_ : Universe.
Variable n2_ : Universe.
Variable n10000_ : Universe.
Variable n1000_ : Universe.
Variable n1_ : Universe.
Variable n0_ : Universe.
Variable minus_ : Universe -> Universe -> Universe.
Variable inv_ : Universe -> Universe.
Variable id_thruster_filter_ : Universe.
Variable h_thruster_filter_ : Universe.
Variable divide_ : Universe -> Universe -> Universe.
Variable dim_ : Universe -> Universe -> Universe.
Variable def_ : Universe.
Variable cos_ : Universe -> Universe.
Variable a_select3_ : Universe -> Universe -> Universe -> Universe.
Variable a_select2_ : Universe -> Universe -> Universe.

Variable totality_1 : (forall X Y : Universe, (gt_ X Y \/ (gt_ Y X \/ X = Y))).
Variable transitivity_gt_2 : (forall X Y Z : Universe, ((gt_ X Y /\ gt_ Y Z) -> gt_ X Z)).
Variable irreflexivity_gt_3 : (forall X : Universe, ~(gt_ X X)).
Variable reflexivity_leq_4 : (forall X : Universe, leq_ X X).
Variable transitivity_leq_5 : (forall X Y Z : Universe, ((leq_ X Y /\ leq_ Y Z) -> leq_ X Z)).
Variable lt_gt_6 : (forall X Y : Universe, (lt_ X Y <-> gt_ Y X)).
Variable leq_geq_7 : (forall X Y : Universe, (geq_ X Y <-> leq_ Y X)).
Variable leq_gt1_8 : (forall X Y : Universe, (gt_ Y X -> leq_ X Y)).
Variable leq_gt2_9 : (forall X Y : Universe, ((leq_ X Y /\ X <> Y) -> gt_ Y X)).
Variable leq_gt_pred_10 : (forall X Y : Universe, (leq_ X (pred_ Y) <-> gt_ Y X)).
Variable gt_succ_11 : (forall X : Universe, gt_ (succ_ X) X).
Variable leq_succ_12 : (forall X Y : Universe, (leq_ X Y -> leq_ X (succ_ Y))).
Variable leq_succ_gt_equiv_13 : (forall X Y : Universe, (leq_ X Y <-> gt_ (succ_ Y) X)).
Variable uniform_int_rand_ranges_hi_14 : (forall X C : Universe, (leq_ n0_ X -> leq_ (uniform_int_rnd_ C X) X)).
Variable uniform_int_rand_ranges_lo_15 : (forall X C : Universe, (leq_ n0_ X -> leq_ n0_ (uniform_int_rnd_ C X))).
Variable const_array1_select_16 : (forall I L U Val : Universe, ((leq_ L I /\ leq_ I U) -> (a_select2_ (tptp_const_array1_ (dim_ L U) Val) I) = Val)).
Variable const_array2_select_17 : (forall I L1 U1 J L2 U2 Val : Universe, ((leq_ L1 I /\ (leq_ I U1 /\ (leq_ L2 J /\ leq_ J U2))) -> (a_select3_ (tptp_const_array2_ (dim_ L1 U1) (dim_ L2 U2) Val) I J) = Val)).
Variable matrix_symm_aba1_18 : (forall I0 J0 A B N : Universe, ((leq_ n0_ I0 /\ (leq_ I0 N /\ (leq_ n0_ J0 /\ (leq_ J0 N /\ (a_select3_ B I0 J0) = (a_select3_ B J0 I0))))) -> (a_select3_ (tptp_mmul_ A (tptp_mmul_ B (trans_ A))) I0 J0) = (a_select3_ (tptp_mmul_ A (tptp_mmul_ B (trans_ A))) J0 I0))).
Variable matrix_symm_aba2_19 : (forall I0 J0 I J A B N M : Universe, ((leq_ n0_ I0 /\ (leq_ I0 N /\ (leq_ n0_ J0 /\ (leq_ J0 N /\ (leq_ n0_ I /\ (leq_ I M /\ (leq_ n0_ J /\ (leq_ J M /\ (a_select3_ B I J) = (a_select3_ B J I))))))))) -> (a_select3_ (tptp_mmul_ A (tptp_mmul_ B (trans_ A))) I0 J0) = (a_select3_ (tptp_mmul_ A (tptp_mmul_ B (trans_ A))) J0 I0))).
Variable matrix_symm_add_20 : (forall I J A B N : Universe, ((leq_ n0_ I /\ (leq_ I N /\ (leq_ n0_ J /\ (leq_ J N /\ ((a_select3_ A I J) = (a_select3_ A J I) /\ (a_select3_ B I J) = (a_select3_ B J I)))))) -> (a_select3_ (tptp_madd_ A B) I J) = (a_select3_ (tptp_madd_ A B) J I))).
Variable matrix_symm_sub_21 : (forall I J A B N : Universe, ((leq_ n0_ I /\ (leq_ I N /\ (leq_ n0_ J /\ (leq_ J N /\ ((a_select3_ A I J) = (a_select3_ A J I) /\ (a_select3_ B I J) = (a_select3_ B J I)))))) -> (a_select3_ (tptp_msub_ A B) I J) = (a_select3_ (tptp_msub_ A B) J I))).
Variable matrix_symm_trans_22 : (forall I J A N : Universe, ((leq_ n0_ I /\ (leq_ I N /\ (leq_ n0_ J /\ (leq_ J N /\ (a_select3_ A I J) = (a_select3_ A J I))))) -> (a_select3_ (trans_ A) I J) = (a_select3_ (trans_ A) J I))).
Variable matrix_symm_inv_23 : (forall I J A N : Universe, ((leq_ n0_ I /\ (leq_ I N /\ (leq_ n0_ J /\ (leq_ J N /\ (a_select3_ A I J) = (a_select3_ A J I))))) -> (a_select3_ (inv_ A) I J) = (a_select3_ (inv_ A) J I))).
Variable matrix_symm_joseph_update_24 : (forall I0 J0 I J A B C D E F N M : Universe, ((leq_ n0_ I0 /\ (leq_ I0 N /\ (leq_ n0_ J0 /\ (leq_ J0 N /\ (leq_ n0_ I /\ (leq_ I M /\ (leq_ n0_ J /\ (leq_ J M /\ ((a_select3_ D I J) = (a_select3_ D J I) /\ ((a_select3_ A I0 J0) = (a_select3_ A J0 I0) /\ (a_select3_ F I0 J0) = (a_select3_ F J0 I0))))))))))) -> (a_select3_ (tptp_madd_ A (tptp_mmul_ B (tptp_mmul_ (tptp_madd_ (tptp_mmul_ C (tptp_mmul_ D (trans_ C))) (tptp_mmul_ E (tptp_mmul_ F (trans_ E)))) (trans_ B)))) I0 J0) = (a_select3_ (tptp_madd_ A (tptp_mmul_ B (tptp_mmul_ (tptp_madd_ (tptp_mmul_ C (tptp_mmul_ D (trans_ C))) (tptp_mmul_ E (tptp_mmul_ F (trans_ E)))) (trans_ B)))) J0 I0))).
Variable sum_plus_base_25 : (forall Body : Universe, (sum_ n0_ tptp_minus_1_ Body) = n0_).
Variable succ_tptp_minus_1_26 : (succ_ tptp_minus_1_) = n0_.
Variable succ_plus_1_r_27 : (forall X : Universe, (plus_ X n1_) = (succ_ X)).
Variable succ_plus_1_l_28 : (forall X : Universe, (plus_ n1_ X) = (succ_ X)).
Variable succ_plus_2_r_29 : (forall X : Universe, (plus_ X n2_) = (succ_ (succ_ X))).
Variable succ_plus_2_l_30 : (forall X : Universe, (plus_ n2_ X) = (succ_ (succ_ X))).
Variable succ_plus_3_r_31 : (forall X : Universe, (plus_ X n3_) = (succ_ (succ_ (succ_ X)))).
Variable succ_plus_3_l_32 : (forall X : Universe, (plus_ n3_ X) = (succ_ (succ_ (succ_ X)))).
Variable succ_plus_4_r_33 : (forall X : Universe, (plus_ X n4_) = (succ_ (succ_ (succ_ (succ_ X))))).
Variable succ_plus_4_l_34 : (forall X : Universe, (plus_ n4_ X) = (succ_ (succ_ (succ_ (succ_ X))))).
Variable succ_plus_5_r_35 : (forall X : Universe, (plus_ X n5_) = (succ_ (succ_ (succ_ (succ_ (succ_ X)))))).
Variable succ_plus_5_l_36 : (forall X : Universe, (plus_ n5_ X) = (succ_ (succ_ (succ_ (succ_ (succ_ X)))))).
Variable pred_minus_1_37 : (forall X : Universe, (minus_ X n1_) = (pred_ X)).
Variable pred_succ_38 : (forall X : Universe, (pred_ (succ_ X)) = X).
Variable succ_pred_39 : (forall X : Universe, (succ_ (pred_ X)) = X).
Variable leq_succ_succ_40 : (forall X Y : Universe, (leq_ (succ_ X) (succ_ Y) <-> leq_ X Y)).
Variable leq_succ_gt_41 : (forall X Y : Universe, (leq_ (succ_ X) Y -> gt_ Y X)).
Variable leq_minus_42 : (forall X Y : Universe, (leq_ (minus_ X Y) X -> leq_ n0_ Y)).
Variable sel3_update_1_43 : (forall X U V VAL : Universe, (a_select3_ (tptp_update3_ X U V VAL) U V) = VAL).
Variable sel3_update_2_44 : (forall I J U V X VAL VAL2 : Universe, ((I <> U /\ (J = V /\ (a_select3_ X U V) = VAL)) -> (a_select3_ (tptp_update3_ X I J VAL2) U V) = VAL)).
Variable sel3_update_3_45 : (forall I J U V X VAL : Universe, (((forall I0 J0 : Universe, ((leq_ n0_ I0 /\ (leq_ n0_ J0 /\ (leq_ I0 U /\ leq_ J0 V))) -> (a_select3_ X I0 J0) = VAL)) /\ (leq_ n0_ I /\ (leq_ I U /\ (leq_ n0_ J /\ leq_ J V)))) -> (a_select3_ (tptp_update3_ X U V VAL) I J) = VAL)).
Variable sel2_update_1_46 : (forall X U VAL : Universe, (a_select2_ (tptp_update2_ X U VAL) U) = VAL).
Variable sel2_update_2_47 : (forall I U X VAL VAL2 : Universe, ((I <> U /\ (a_select2_ X U) = VAL) -> (a_select2_ (tptp_update2_ X I VAL2) U) = VAL)).
Variable sel2_update_3_48 : (forall I U X VAL : Universe, (((forall I0 : Universe, ((leq_ n0_ I0 /\ leq_ I0 U) -> (a_select2_ X I0) = VAL)) /\ (leq_ n0_ I /\ leq_ I U)) -> (a_select2_ (tptp_update2_ X U VAL) I) = VAL)).
Variable ttrue_49 : true_.
Variable defuse_50 : def_ <> use_.
Variable gt_10000_588_51 : gt_ n10000_ n588_.
Variable gt_1000_588_52 : gt_ n1000_ n588_.
Variable gt_588_4_53 : gt_ n588_ n4_.
Variable gt_707_4_54 : gt_ n707_ n4_.
Variable gt_5_4_55 : gt_ n5_ n4_.
Variable gt_6_4_56 : gt_ n6_ n4_.
Variable gt_7_4_57 : gt_ n7_ n4_.
Variable gt_217_4_58 : gt_ n217_ n4_.
Variable gt_10000_4_59 : gt_ n10000_ n4_.
Variable gt_423_4_60 : gt_ n423_ n4_.
Variable gt_1000_4_61 : gt_ n1000_ n4_.
Variable gt_34_4_62 : gt_ n34_ n4_.
Variable gt_10000_707_63 : gt_ n10000_ n707_.
Variable gt_1000_707_64 : gt_ n1000_ n707_.
Variable gt_588_5_65 : gt_ n588_ n5_.
Variable gt_707_5_66 : gt_ n707_ n5_.
Variable gt_6_5_67 : gt_ n6_ n5_.
Variable gt_7_5_68 : gt_ n7_ n5_.
Variable gt_217_5_69 : gt_ n217_ n5_.
Variable gt_10000_5_70 : gt_ n10000_ n5_.
Variable gt_423_5_71 : gt_ n423_ n5_.
Variable gt_1000_5_72 : gt_ n1000_ n5_.
Variable gt_34_5_73 : gt_ n34_ n5_.
Variable gt_588_6_74 : gt_ n588_ n6_.
Variable gt_707_6_75 : gt_ n707_ n6_.
Variable gt_7_6_76 : gt_ n7_ n6_.
Variable gt_217_6_77 : gt_ n217_ n6_.
Variable gt_10000_6_78 : gt_ n10000_ n6_.
Variable gt_423_6_79 : gt_ n423_ n6_.
Variable gt_1000_6_80 : gt_ n1000_ n6_.
Variable gt_34_6_81 : gt_ n34_ n6_.
Variable gt_588_7_82 : gt_ n588_ n7_.
Variable gt_707_7_83 : gt_ n707_ n7_.
Variable gt_217_7_84 : gt_ n217_ n7_.
Variable gt_10000_7_85 : gt_ n10000_ n7_.
Variable gt_423_7_86 : gt_ n423_ n7_.
Variable gt_1000_7_87 : gt_ n1000_ n7_.
Variable gt_34_7_88 : gt_ n34_ n7_.
Variable gt_588_217_89 : gt_ n588_ n217_.
Variable gt_707_217_90 : gt_ n707_ n217_.
Variable gt_10000_217_91 : gt_ n10000_ n217_.
Variable gt_423_217_92 : gt_ n423_ n217_.
Variable gt_1000_217_93 : gt_ n1000_ n217_.
Variable gt_588_tptp_minus_1_94 : gt_ n588_ tptp_minus_1_.
Variable gt_4_tptp_minus_1_95 : gt_ n4_ tptp_minus_1_.
Variable gt_707_tptp_minus_1_96 : gt_ n707_ tptp_minus_1_.
Variable gt_5_tptp_minus_1_97 : gt_ n5_ tptp_minus_1_.
Variable gt_6_tptp_minus_1_98 : gt_ n6_ tptp_minus_1_.
Variable gt_7_tptp_minus_1_99 : gt_ n7_ tptp_minus_1_.
Variable gt_217_tptp_minus_1_100 : gt_ n217_ tptp_minus_1_.
Variable gt_10000_tptp_minus_1_101 : gt_ n10000_ tptp_minus_1_.
Variable gt_0_tptp_minus_1_102 : gt_ n0_ tptp_minus_1_.
Variable gt_423_tptp_minus_1_103 : gt_ n423_ tptp_minus_1_.
Variable gt_1_tptp_minus_1_104 : gt_ n1_ tptp_minus_1_.
Variable gt_2_tptp_minus_1_105 : gt_ n2_ tptp_minus_1_.
Variable gt_1000_tptp_minus_1_106 : gt_ n1000_ tptp_minus_1_.
Variable gt_3_tptp_minus_1_107 : gt_ n3_ tptp_minus_1_.
Variable gt_34_tptp_minus_1_108 : gt_ n34_ tptp_minus_1_.
Variable gt_588_0_109 : gt_ n588_ n0_.
Variable gt_4_0_110 : gt_ n4_ n0_.
Variable gt_707_0_111 : gt_ n707_ n0_.
Variable gt_5_0_112 : gt_ n5_ n0_.
Variable gt_6_0_113 : gt_ n6_ n0_.
Variable gt_7_0_114 : gt_ n7_ n0_.
Variable gt_217_0_115 : gt_ n217_ n0_.
Variable gt_10000_0_116 : gt_ n10000_ n0_.
Variable gt_423_0_117 : gt_ n423_ n0_.
Variable gt_1_0_118 : gt_ n1_ n0_.
Variable gt_2_0_119 : gt_ n2_ n0_.
Variable gt_1000_0_120 : gt_ n1000_ n0_.
Variable gt_3_0_121 : gt_ n3_ n0_.
Variable gt_34_0_122 : gt_ n34_ n0_.
Variable gt_588_423_123 : gt_ n588_ n423_.
Variable gt_707_423_124 : gt_ n707_ n423_.
Variable gt_10000_423_125 : gt_ n10000_ n423_.
Variable gt_1000_423_126 : gt_ n1000_ n423_.
Variable gt_588_1_127 : gt_ n588_ n1_.
Variable gt_4_1_128 : gt_ n4_ n1_.
Variable gt_707_1_129 : gt_ n707_ n1_.
Variable gt_5_1_130 : gt_ n5_ n1_.
Variable gt_6_1_131 : gt_ n6_ n1_.
Variable gt_7_1_132 : gt_ n7_ n1_.
Variable gt_217_1_133 : gt_ n217_ n1_.
Variable gt_10000_1_134 : gt_ n10000_ n1_.
Variable gt_423_1_135 : gt_ n423_ n1_.
Variable gt_2_1_136 : gt_ n2_ n1_.
Variable gt_1000_1_137 : gt_ n1000_ n1_.
Variable gt_3_1_138 : gt_ n3_ n1_.
Variable gt_34_1_139 : gt_ n34_ n1_.
Variable gt_588_2_140 : gt_ n588_ n2_.
Variable gt_4_2_141 : gt_ n4_ n2_.
Variable gt_707_2_142 : gt_ n707_ n2_.
Variable gt_5_2_143 : gt_ n5_ n2_.
Variable gt_6_2_144 : gt_ n6_ n2_.
Variable gt_7_2_145 : gt_ n7_ n2_.
Variable gt_217_2_146 : gt_ n217_ n2_.
Variable gt_10000_2_147 : gt_ n10000_ n2_.
Variable gt_423_2_148 : gt_ n423_ n2_.
Variable gt_1000_2_149 : gt_ n1000_ n2_.
Variable gt_3_2_150 : gt_ n3_ n2_.
Variable gt_34_2_151 : gt_ n34_ n2_.
Variable gt_10000_1000_152 : gt_ n10000_ n1000_.
Variable gt_588_3_153 : gt_ n588_ n3_.
Variable gt_4_3_154 : gt_ n4_ n3_.
Variable gt_707_3_155 : gt_ n707_ n3_.
Variable gt_5_3_156 : gt_ n5_ n3_.
Variable gt_6_3_157 : gt_ n6_ n3_.
Variable gt_7_3_158 : gt_ n7_ n3_.
Variable gt_217_3_159 : gt_ n217_ n3_.
Variable gt_10000_3_160 : gt_ n10000_ n3_.
Variable gt_423_3_161 : gt_ n423_ n3_.
Variable gt_1000_3_162 : gt_ n1000_ n3_.
Variable gt_34_3_163 : gt_ n34_ n3_.
Variable gt_588_34_164 : gt_ n588_ n34_.
Variable gt_707_34_165 : gt_ n707_ n34_.
Variable gt_217_34_166 : gt_ n217_ n34_.
Variable gt_10000_34_167 : gt_ n10000_ n34_.
Variable gt_423_34_168 : gt_ n423_ n34_.
Variable gt_1000_34_169 : gt_ n1000_ n34_.
Variable finite_domain_4_170 : (forall X : Universe, ((leq_ n0_ X /\ leq_ X n4_) -> (X = n0_ \/ (X = n1_ \/ (X = n2_ \/ (X = n3_ \/ X = n4_)))))).
Variable finite_domain_5_171 : (forall X : Universe, ((leq_ n0_ X /\ leq_ X n5_) -> (X = n0_ \/ (X = n1_ \/ (X = n2_ \/ (X = n3_ \/ (X = n4_ \/ X = n5_))))))).
Variable finite_domain_6_172 : (forall X : Universe, ((leq_ n0_ X /\ leq_ X n6_) -> (X = n0_ \/ (X = n1_ \/ (X = n2_ \/ (X = n3_ \/ (X = n4_ \/ (X = n5_ \/ X = n6_)))))))).
Variable finite_domain_0_173 : (forall X : Universe, ((leq_ n0_ X /\ leq_ X n0_) -> X = n0_)).
Variable finite_domain_1_174 : (forall X : Universe, ((leq_ n0_ X /\ leq_ X n1_) -> (X = n0_ \/ X = n1_))).
Variable finite_domain_2_175 : (forall X : Universe, ((leq_ n0_ X /\ leq_ X n2_) -> (X = n0_ \/ (X = n1_ \/ X = n2_)))).
Variable finite_domain_3_176 : (forall X : Universe, ((leq_ n0_ X /\ leq_ X n3_) -> (X = n0_ \/ (X = n1_ \/ (X = n2_ \/ X = n3_))))).
Variable successor_4_177 : (succ_ (succ_ (succ_ (succ_ n0_)))) = n4_.
Variable successor_5_178 : (succ_ (succ_ (succ_ (succ_ (succ_ n0_))))) = n5_.
Variable successor_6_179 : (succ_ (succ_ (succ_ (succ_ (succ_ (succ_ n0_)))))) = n6_.
Variable successor_1_180 : (succ_ n0_) = n1_.
Variable successor_2_181 : (succ_ (succ_ n0_)) = n2_.
Variable successor_3_182 : (succ_ (succ_ (succ_ n0_))) = n3_.

Theorem thruster_symm_0001_183 : ((geq_ (minus_ n4_ n1_) n0_ /\ geq_ (minus_ n1000_ n1_) n0_) -> (forall A : Universe, ((geq_ n7_ n0_ /\ geq_ (minus_ n1000_ n1_) n0_) -> (forall D14 : Universe, ((true_ -> (forall B C : Universe, ((leq_ n0_ B /\ (leq_ n0_ C /\ (leq_ B (minus_ n6_ n1_) /\ leq_ C (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ q_thruster_filter_ n0_ n0_ n0_) n0_ n1_ n0_) n0_ n2_ n0_) n0_ n3_ n0_) n0_ n4_ n0_) n0_ n5_ n0_) n1_ n0_ n0_) n1_ n1_ n0_) n1_ n2_ n0_) n1_ n3_ n0_) n1_ n4_ n0_) n1_ n5_ n0_) n2_ n0_ n0_) n2_ n1_ n0_) n2_ n2_ n0_) n2_ n3_ n0_) n2_ n4_ n0_) n2_ n5_ n0_) n3_ n0_ n0_) n3_ n1_ n0_) n3_ n2_ n0_) n3_ n3_ tptp_float_0_001_) n3_ n4_ n0_) n3_ n5_ n0_) n4_ n0_ n0_) n4_ n1_ n0_) n4_ n2_ n0_) n4_ n3_ n0_) n4_ n4_ tptp_float_0_0001_) n4_ n5_ n0_) n5_ n0_ n0_) n5_ n1_ n0_) n5_ n2_ n0_) n5_ n3_ n0_) n5_ n4_ n0_) n5_ n5_ tptp_float_0_0001_) B C) = (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ q_thruster_filter_ n0_ n0_ n0_) n0_ n1_ n0_) n0_ n2_ n0_) n0_ n3_ n0_) n0_ n4_ n0_) n0_ n5_ n0_) n1_ n0_ n0_) n1_ n1_ n0_) n1_ n2_ n0_) n1_ n3_ n0_) n1_ n4_ n0_) n1_ n5_ n0_) n2_ n0_ n0_) n2_ n1_ n0_) n2_ n2_ n0_) n2_ n3_ n0_) n2_ n4_ n0_) n2_ n5_ n0_) n3_ n0_ n0_) n3_ n1_ n0_) n3_ n2_ n0_) n3_ n3_ tptp_float_0_001_) n3_ n4_ n0_) n3_ n5_ n0_) n4_ n0_ n0_) n4_ n1_ n0_) n4_ n2_ n0_) n4_ n3_ n0_) n4_ n4_ tptp_float_0_0001_) n4_ n5_ n0_) n5_ n0_ n0_) n5_ n1_ n0_) n5_ n2_ n0_) n5_ n3_ n0_) n5_ n4_ n0_) n5_ n5_ tptp_float_0_0001_) C B)))) /\ (((leq_ n0_ pv5_ /\ (leq_ n0_ pv29_ /\ (leq_ pv5_ n588_ /\ (leq_ pv29_ (minus_ n6_ n1_) /\ ((forall D E : Universe, ((leq_ n0_ D /\ (leq_ n0_ E /\ (leq_ D (minus_ n6_ n1_) /\ leq_ E (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ D E) = (a_select3_ q_thruster_filter_ E D))) /\ ((forall F G : Universe, ((leq_ n0_ F /\ (leq_ n0_ G /\ (leq_ F (minus_ n4_ n1_) /\ leq_ G (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_ F G) = (a_select3_ r_thruster_filter_ G F))) /\ ((forall H I : Universe, ((leq_ n0_ H /\ (leq_ n0_ I /\ (leq_ H (minus_ n6_ n1_) /\ leq_ I (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_ H I) = (a_select3_ pminus_thruster_filter_ I H))) /\ ((forall J K : Universe, ((leq_ n0_ J /\ (leq_ n0_ K /\ (leq_ J (minus_ n6_ n1_) /\ leq_ K (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_ J K) = (a_select3_ pminus_thruster_filter_ K J))) /\ (forall L : Universe, ((leq_ n0_ L /\ leq_ L (minus_ n6_ n1_)) -> (forall M : Universe, ((leq_ n0_ M /\ leq_ M (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_ L M) = (a_select3_ id_thruster_filter_ M L))))))))))))) -> (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall N O : Universe, ((leq_ n0_ N /\ (leq_ n0_ O /\ (leq_ N (minus_ n6_ n1_) /\ leq_ O (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ N O) = (a_select3_ q_thruster_filter_ O N))) /\ ((forall P Q : Universe, ((leq_ n0_ P /\ (leq_ n0_ Q /\ (leq_ P (minus_ n4_ n1_) /\ leq_ Q (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_ P Q) = (a_select3_ r_thruster_filter_ Q P))) /\ ((forall R S : Universe, ((leq_ n0_ R /\ (leq_ n0_ S /\ (leq_ R (minus_ n6_ n1_) /\ leq_ S (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_ R S) = (a_select3_ pminus_thruster_filter_ S R))) /\ ((forall T U : Universe, ((leq_ n0_ T /\ (leq_ n0_ U /\ (leq_ T (minus_ n6_ n1_) /\ leq_ U (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_ T U) = (a_select3_ pminus_thruster_filter_ U T))) /\ (forall V : Universe, ((leq_ n0_ V /\ leq_ V (minus_ n6_ n1_)) -> (forall W : Universe, ((leq_ n0_ W /\ leq_ W (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_ V W) = (a_select3_ id_thruster_filter_ W V)))))))))))) /\ (((leq_ n0_ pv5_ /\ (leq_ n0_ pv39_ /\ (leq_ (plus_ n1_ pv39_) pv40_ /\ (leq_ pv5_ n588_ /\ (leq_ pv39_ (minus_ n6_ n1_) /\ (leq_ pv40_ (minus_ n6_ n1_) /\ ((forall X Y : Universe, ((leq_ n0_ X /\ (leq_ n0_ Y /\ (leq_ X (minus_ n6_ n1_) /\ leq_ Y (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ X Y) = (a_select3_ q_thruster_filter_ Y X))) /\ ((forall Z A1 : Universe, ((leq_ n0_ Z /\ (leq_ n0_ A1 /\ (leq_ Z (minus_ n4_ n1_) /\ leq_ A1 (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_ Z A1) = (a_select3_ r_thruster_filter_ A1 Z))) /\ ((forall B1 C1 : Universe, ((leq_ n0_ B1 /\ (leq_ n0_ C1 /\ (leq_ B1 (minus_ n6_ n1_) /\ leq_ C1 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_ B1 C1) = (a_select3_ pminus_thruster_filter_ C1 B1))) /\ ((forall D1 E1 : Universe, ((leq_ n0_ D1 /\ (leq_ n0_ E1 /\ (leq_ D1 (minus_ n6_ n1_) /\ leq_ E1 (minus_ n6_ n1_)))) -> (((lt_ E1 pv40_ /\ D1 = pv39_) -> (a_select3_ id_thruster_filter_ D1 E1) = (a_select3_ id_thruster_filter_ E1 D1)) /\ (lt_ D1 pv39_ -> (a_select3_ id_thruster_filter_ D1 E1) = (a_select3_ id_thruster_filter_ E1 D1))))) /\ (forall F1 : Universe, ((leq_ n0_ F1 /\ leq_ F1 (minus_ pv39_ n1_)) -> (forall G1 : Universe, ((leq_ n0_ G1 /\ leq_ G1 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_ F1 G1) = (a_select3_ id_thruster_filter_ G1 F1))))))))))))))) -> (leq_ n0_ pv5_ /\ (leq_ n0_ pv39_ /\ (leq_ pv5_ n588_ /\ (leq_ pv39_ (minus_ n6_ n1_) /\ ((forall H1 I1 : Universe, ((leq_ n0_ H1 /\ (leq_ n0_ I1 /\ (leq_ H1 (minus_ n6_ n1_) /\ leq_ I1 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ H1 I1) = (a_select3_ q_thruster_filter_ I1 H1))) /\ ((forall J1 K1 : Universe, ((leq_ n0_ J1 /\ (leq_ n0_ K1 /\ (leq_ J1 (minus_ n4_ n1_) /\ leq_ K1 (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_ J1 K1) = (a_select3_ r_thruster_filter_ K1 J1))) /\ ((forall L1 M1 : Universe, ((leq_ n0_ L1 /\ (leq_ n0_ M1 /\ (leq_ L1 (minus_ n6_ n1_) /\ leq_ M1 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_ L1 M1) = (a_select3_ pminus_thruster_filter_ M1 L1))) /\ ((forall N1 O1 : Universe, ((leq_ n0_ N1 /\ (leq_ n0_ O1 /\ (leq_ N1 (minus_ n6_ n1_) /\ leq_ O1 (minus_ n6_ n1_)))) -> (((lt_ O1 (plus_ n1_ pv40_) /\ N1 = pv39_) -> (a_select3_ (tptp_update3_ (tptp_update3_ id_thruster_filter_ pv39_ pv40_ n0_) pv40_ pv39_ n0_) N1 O1) = (a_select3_ (tptp_update3_ (tptp_update3_ id_thruster_filter_ pv39_ pv40_ n0_) pv40_ pv39_ n0_) O1 N1)) /\ (lt_ N1 pv39_ -> (a_select3_ (tptp_update3_ (tptp_update3_ id_thruster_filter_ pv39_ pv40_ n0_) pv40_ pv39_ n0_) N1 O1) = (a_select3_ (tptp_update3_ (tptp_update3_ id_thruster_filter_ pv39_ pv40_ n0_) pv40_ pv39_ n0_) O1 N1))))) /\ (forall P1 : Universe, ((leq_ n0_ P1 /\ leq_ P1 (minus_ pv39_ n1_)) -> (forall Q1 : Universe, ((leq_ n0_ Q1 /\ leq_ Q1 (minus_ n6_ n1_)) -> (a_select3_ (tptp_update3_ (tptp_update3_ id_thruster_filter_ pv39_ Q1 n0_) Q1 pv39_ n0_) P1 Q1) = (a_select3_ (tptp_update3_ (tptp_update3_ id_thruster_filter_ pv39_ Q1 n0_) Q1 pv39_ n0_) Q1 P1)))))))))))))) /\ (((leq_ n0_ pv5_ /\ (leq_ n0_ pv39_ /\ (leq_ pv5_ n588_ /\ (leq_ pv39_ (minus_ n6_ n1_) /\ ((forall R1 S1 : Universe, ((leq_ n0_ R1 /\ (leq_ n0_ S1 /\ (leq_ R1 (minus_ n6_ n1_) /\ leq_ S1 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ R1 S1) = (a_select3_ q_thruster_filter_ S1 R1))) /\ ((forall T1 U1 : Universe, ((leq_ n0_ T1 /\ (leq_ n0_ U1 /\ (leq_ T1 (minus_ n4_ n1_) /\ leq_ U1 (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_ T1 U1) = (a_select3_ r_thruster_filter_ U1 T1))) /\ ((forall V1 W1 : Universe, ((leq_ n0_ V1 /\ (leq_ n0_ W1 /\ (leq_ V1 (minus_ n6_ n1_) /\ leq_ W1 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_ V1 W1) = (a_select3_ pminus_thruster_filter_ W1 V1))) /\ ((forall X1 Y1 : Universe, ((leq_ n0_ X1 /\ (leq_ n0_ Y1 /\ (leq_ X1 (minus_ n6_ n1_) /\ leq_ Y1 (minus_ n6_ n1_)))) -> (((lt_ Y1 (plus_ n1_ (minus_ n6_ n1_)) /\ X1 = pv39_) -> (a_select3_ id_thruster_filter_ X1 Y1) = (a_select3_ id_thruster_filter_ Y1 X1)) /\ (lt_ X1 pv39_ -> (a_select3_ id_thruster_filter_ X1 Y1) = (a_select3_ id_thruster_filter_ Y1 X1))))) /\ (forall Z1 : Universe, ((leq_ n0_ Z1 /\ leq_ Z1 (minus_ pv39_ n1_)) -> (forall A2 : Universe, ((leq_ n0_ A2 /\ leq_ A2 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_ Z1 A2) = (a_select3_ id_thruster_filter_ A2 Z1))))))))))))) -> (leq_ n0_ pv5_ /\ (leq_ n0_ pv39_ /\ (leq_ pv5_ n588_ /\ (leq_ pv39_ (minus_ n6_ n1_) /\ ((forall B2 C2 : Universe, ((leq_ n0_ B2 /\ (leq_ n0_ C2 /\ (leq_ B2 (minus_ n6_ n1_) /\ leq_ C2 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ B2 C2) = (a_select3_ q_thruster_filter_ C2 B2))) /\ ((forall D2 E2 : Universe, ((leq_ n0_ D2 /\ (leq_ n0_ E2 /\ (leq_ D2 (minus_ n4_ n1_) /\ leq_ E2 (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_ D2 E2) = (a_select3_ r_thruster_filter_ E2 D2))) /\ ((forall F2 G2 : Universe, ((leq_ n0_ F2 /\ (leq_ n0_ G2 /\ (leq_ F2 (minus_ n6_ n1_) /\ leq_ G2 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_ F2 G2) = (a_select3_ pminus_thruster_filter_ G2 F2))) /\ ((forall H2 I2 : Universe, ((leq_ n0_ H2 /\ (leq_ n0_ I2 /\ (leq_ H2 pv39_ /\ leq_ I2 (minus_ n6_ n1_)))) -> (a_select3_ id_thruster_filter_ H2 I2) = (a_select3_ id_thruster_filter_ I2 H2))) /\ (forall J2 : Universe, ((leq_ n0_ J2 /\ leq_ J2 (minus_ pv39_ n1_)) -> (forall K2 : Universe, ((leq_ n0_ K2 /\ leq_ K2 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_ J2 K2) = (a_select3_ id_thruster_filter_ K2 J2)))))))))))))) /\ (((leq_ n0_ pv5_ /\ (leq_ n0_ pv39_ /\ (leq_ pv5_ n588_ /\ (leq_ pv39_ (minus_ n6_ n1_) /\ ((forall L2 M2 : Universe, ((leq_ n0_ L2 /\ (leq_ n0_ M2 /\ (leq_ L2 (minus_ n6_ n1_) /\ leq_ M2 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ L2 M2) = (a_select3_ q_thruster_filter_ M2 L2))) /\ ((forall N2 O2 : Universe, ((leq_ n0_ N2 /\ (leq_ n0_ O2 /\ (leq_ N2 (minus_ n4_ n1_) /\ leq_ O2 (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_ N2 O2) = (a_select3_ r_thruster_filter_ O2 N2))) /\ ((forall P2 Q2 : Universe, ((leq_ n0_ P2 /\ (leq_ n0_ Q2 /\ (leq_ P2 (minus_ n6_ n1_) /\ leq_ Q2 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_ P2 Q2) = (a_select3_ pminus_thruster_filter_ Q2 P2))) /\ ((forall R2 S2 : Universe, ((leq_ n0_ R2 /\ (leq_ n0_ S2 /\ (leq_ R2 pv39_ /\ leq_ S2 (minus_ n6_ n1_)))) -> (a_select3_ id_thruster_filter_ R2 S2) = (a_select3_ id_thruster_filter_ S2 R2))) /\ (forall T2 : Universe, ((leq_ n0_ T2 /\ leq_ T2 (minus_ pv39_ n1_)) -> (forall U2 : Universe, ((leq_ n0_ U2 /\ leq_ U2 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_ T2 U2) = (a_select3_ id_thruster_filter_ U2 T2))))))))))))) -> (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall V2 W2 : Universe, ((leq_ n0_ V2 /\ (leq_ n0_ W2 /\ (leq_ V2 (minus_ n6_ n1_) /\ leq_ W2 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ V2 W2) = (a_select3_ q_thruster_filter_ W2 V2))) /\ ((forall X2 Y2 : Universe, ((leq_ n0_ X2 /\ (leq_ n0_ Y2 /\ (leq_ X2 (minus_ n4_ n1_) /\ leq_ Y2 (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_ X2 Y2) = (a_select3_ r_thruster_filter_ Y2 X2))) /\ ((forall Z2 A3 : Universe, ((leq_ n0_ Z2 /\ (leq_ n0_ A3 /\ (leq_ Z2 (minus_ n6_ n1_) /\ leq_ A3 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_ Z2 A3) = (a_select3_ pminus_thruster_filter_ A3 Z2))) /\ (forall B3 : Universe, ((leq_ n0_ B3 /\ leq_ B3 (minus_ (plus_ n1_ pv39_) n1_)) -> (forall C3 : Universe, ((leq_ n0_ C3 /\ leq_ C3 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_ B3 C3) = (a_select3_ id_thruster_filter_ C3 B3))))))))))) /\ (((leq_ n0_ pv5_ /\ (leq_ n0_ pv39_ /\ (leq_ pv5_ n588_ /\ (leq_ pv39_ (minus_ n6_ n1_) /\ ((forall D3 E3 : Universe, ((leq_ n0_ D3 /\ (leq_ n0_ E3 /\ (leq_ D3 (minus_ n6_ n1_) /\ leq_ E3 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ D3 E3) = (a_select3_ q_thruster_filter_ E3 D3))) /\ ((forall F3 G3 : Universe, ((leq_ n0_ F3 /\ (leq_ n0_ G3 /\ (leq_ F3 (minus_ n4_ n1_) /\ leq_ G3 (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_ F3 G3) = (a_select3_ r_thruster_filter_ G3 F3))) /\ ((forall H3 I3 : Universe, ((leq_ n0_ H3 /\ (leq_ n0_ I3 /\ (leq_ H3 (minus_ n6_ n1_) /\ leq_ I3 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_ H3 I3) = (a_select3_ pminus_thruster_filter_ I3 H3))) /\ (forall J3 : Universe, ((leq_ n0_ J3 /\ leq_ J3 (minus_ pv39_ n1_)) -> (forall K3 : Universe, ((leq_ n0_ K3 /\ leq_ K3 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_ J3 K3) = (a_select3_ id_thruster_filter_ K3 J3)))))))))))) -> (leq_ n0_ pv5_ /\ (leq_ n0_ pv39_ /\ (leq_ pv5_ n588_ /\ (leq_ pv39_ (minus_ n6_ n1_) /\ ((forall L3 M3 : Universe, ((leq_ n0_ L3 /\ (leq_ n0_ M3 /\ (leq_ L3 (minus_ n6_ n1_) /\ leq_ M3 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ L3 M3) = (a_select3_ q_thruster_filter_ M3 L3))) /\ ((forall N3 O3 : Universe, ((leq_ n0_ N3 /\ (leq_ n0_ O3 /\ (leq_ N3 (minus_ n4_ n1_) /\ leq_ O3 (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_ N3 O3) = (a_select3_ r_thruster_filter_ O3 N3))) /\ ((forall P3 Q3 : Universe, ((leq_ n0_ P3 /\ (leq_ n0_ Q3 /\ (leq_ P3 (minus_ n6_ n1_) /\ leq_ Q3 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_ P3 Q3) = (a_select3_ pminus_thruster_filter_ Q3 P3))) /\ ((forall R3 S3 : Universe, ((leq_ n0_ R3 /\ (leq_ n0_ S3 /\ (leq_ R3 (minus_ n6_ n1_) /\ leq_ S3 (minus_ n6_ n1_)))) -> (((lt_ S3 (plus_ n1_ pv39_) /\ R3 = pv39_) -> (a_select3_ (tptp_update3_ id_thruster_filter_ pv39_ pv39_ n1_) R3 S3) = (a_select3_ (tptp_update3_ id_thruster_filter_ pv39_ pv39_ n1_) S3 R3)) /\ (lt_ R3 pv39_ -> (a_select3_ (tptp_update3_ id_thruster_filter_ pv39_ pv39_ n1_) R3 S3) = (a_select3_ (tptp_update3_ id_thruster_filter_ pv39_ pv39_ n1_) S3 R3))))) /\ (forall T3 : Universe, ((leq_ n0_ T3 /\ leq_ T3 (minus_ pv39_ n1_)) -> (forall U3 : Universe, ((leq_ n0_ U3 /\ leq_ U3 (minus_ n6_ n1_)) -> (a_select3_ (tptp_update3_ id_thruster_filter_ pv39_ pv39_ n1_) T3 U3) = (a_select3_ (tptp_update3_ id_thruster_filter_ pv39_ pv39_ n1_) U3 T3)))))))))))))) /\ (((leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall V3 W3 : Universe, ((leq_ n0_ V3 /\ (leq_ n0_ W3 /\ (leq_ V3 (minus_ n6_ n1_) /\ leq_ W3 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ V3 W3) = (a_select3_ q_thruster_filter_ W3 V3))) /\ ((forall X3 Y3 : Universe, ((leq_ n0_ X3 /\ (leq_ n0_ Y3 /\ (leq_ X3 (minus_ n4_ n1_) /\ leq_ Y3 (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_ X3 Y3) = (a_select3_ r_thruster_filter_ Y3 X3))) /\ (forall Z3 A4 : Universe, ((leq_ n0_ Z3 /\ (leq_ n0_ A4 /\ (leq_ Z3 (minus_ n6_ n1_) /\ leq_ A4 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_ Z3 A4) = (a_select3_ pminus_thruster_filter_ A4 Z3))))))) -> (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall B4 C4 : Universe, ((leq_ n0_ B4 /\ (leq_ n0_ C4 /\ (leq_ B4 (minus_ n6_ n1_) /\ leq_ C4 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ B4 C4) = (a_select3_ q_thruster_filter_ C4 B4))) /\ ((forall D4 E4 : Universe, ((leq_ n0_ D4 /\ (leq_ n0_ E4 /\ (leq_ D4 (minus_ n4_ n1_) /\ leq_ E4 (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_ D4 E4) = (a_select3_ r_thruster_filter_ E4 D4))) /\ ((forall F4 G4 : Universe, ((leq_ n0_ F4 /\ (leq_ n0_ G4 /\ (leq_ F4 (minus_ n6_ n1_) /\ leq_ G4 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_ F4 G4) = (a_select3_ pminus_thruster_filter_ G4 F4))) /\ (forall H4 : Universe, ((leq_ n0_ H4 /\ leq_ H4 (minus_ n0_ n1_)) -> (forall I4 : Universe, ((leq_ n0_ I4 /\ leq_ I4 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_ H4 I4) = (a_select3_ id_thruster_filter_ I4 H4))))))))))) /\ (((leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall J4 K4 : Universe, ((leq_ n0_ J4 /\ (leq_ n0_ K4 /\ (leq_ J4 (minus_ n6_ n1_) /\ leq_ K4 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ J4 K4) = (a_select3_ q_thruster_filter_ K4 J4))) /\ ((forall L4 M4 : Universe, ((leq_ n0_ L4 /\ (leq_ n0_ M4 /\ (leq_ L4 (minus_ n4_ n1_) /\ leq_ M4 (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_ L4 M4) = (a_select3_ r_thruster_filter_ M4 L4))) /\ ((forall N4 O4 : Universe, ((leq_ n0_ N4 /\ (leq_ n0_ O4 /\ (leq_ N4 (minus_ n6_ n1_) /\ leq_ O4 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_ N4 O4) = (a_select3_ pminus_thruster_filter_ O4 N4))) /\ ((forall P4 Q4 : Universe, ((leq_ n0_ P4 /\ (leq_ n0_ Q4 /\ (leq_ P4 (minus_ n6_ n1_) /\ leq_ Q4 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_ P4 Q4) = (a_select3_ pminus_thruster_filter_ Q4 P4))) /\ (forall R4 : Universe, ((leq_ n0_ R4 /\ leq_ R4 (minus_ n6_ n1_)) -> (forall S4 : Universe, ((leq_ n0_ S4 /\ leq_ S4 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_ R4 S4) = (a_select3_ id_thruster_filter_ S4 R4))))))))))) -> (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall T4 U4 : Universe, ((leq_ n0_ T4 /\ (leq_ n0_ U4 /\ (leq_ T4 (minus_ n6_ n1_) /\ leq_ U4 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ T4 U4) = (a_select3_ q_thruster_filter_ U4 T4))) /\ ((forall V4 W4 : Universe, ((leq_ n0_ V4 /\ (leq_ n0_ W4 /\ (leq_ V4 (minus_ n4_ n1_) /\ leq_ W4 (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_ V4 W4) = (a_select3_ r_thruster_filter_ W4 V4))) /\ ((forall X4 Y4 : Universe, ((leq_ n0_ X4 /\ (leq_ n0_ Y4 /\ (leq_ X4 (minus_ n6_ n1_) /\ leq_ Y4 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_ X4 Y4) = (a_select3_ pminus_thruster_filter_ Y4 X4))) /\ ((forall Z4 A5 : Universe, ((leq_ n0_ Z4 /\ (leq_ n0_ A5 /\ (leq_ Z4 (minus_ n6_ n1_) /\ leq_ A5 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_ Z4 A5) = (a_select3_ pminus_thruster_filter_ A5 Z4))) /\ (forall B5 : Universe, ((leq_ n0_ B5 /\ leq_ B5 (minus_ n6_ n1_)) -> (forall C5 : Universe, ((leq_ n0_ C5 /\ leq_ C5 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_ B5 C5) = (a_select3_ id_thruster_filter_ C5 B5)))))))))))) /\ (((leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall D5 E5 : Universe, ((leq_ n0_ D5 /\ (leq_ n0_ E5 /\ (leq_ D5 (minus_ n6_ n1_) /\ leq_ E5 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ D5 E5) = (a_select3_ q_thruster_filter_ E5 D5))) /\ ((forall F5 G5 : Universe, ((leq_ n0_ F5 /\ (leq_ n0_ G5 /\ (leq_ F5 (minus_ n4_ n1_) /\ leq_ G5 (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_ F5 G5) = (a_select3_ r_thruster_filter_ G5 F5))) /\ ((forall H5 I5 : Universe, ((leq_ n0_ H5 /\ (leq_ n0_ I5 /\ (leq_ H5 (minus_ n6_ n1_) /\ leq_ I5 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_ H5 I5) = (a_select3_ pminus_thruster_filter_ I5 H5))) /\ ((forall J5 K5 : Universe, ((leq_ n0_ J5 /\ (leq_ n0_ K5 /\ (leq_ J5 (minus_ n6_ n1_) /\ leq_ K5 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_ J5 K5) = (a_select3_ pminus_thruster_filter_ K5 J5))) /\ (forall L5 : Universe, ((leq_ n0_ L5 /\ leq_ L5 (minus_ n6_ n1_)) -> (forall M5 : Universe, ((leq_ n0_ M5 /\ leq_ M5 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_ L5 M5) = (a_select3_ id_thruster_filter_ M5 L5))))))))))) -> ((forall N5 O5 : Universe, ((leq_ n0_ N5 /\ (leq_ n0_ O5 /\ (leq_ N5 (minus_ n6_ n1_) /\ leq_ O5 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ N5 O5) = (a_select3_ q_thruster_filter_ O5 N5))) /\ ((forall P5 Q5 : Universe, ((leq_ n0_ P5 /\ (leq_ n0_ Q5 /\ (leq_ P5 (minus_ n4_ n1_) /\ leq_ Q5 (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_ P5 Q5) = (a_select3_ r_thruster_filter_ Q5 P5))) /\ (forall R5 S5 : Universe, ((leq_ n0_ R5 /\ (leq_ n0_ S5 /\ (leq_ R5 (minus_ n6_ n1_) /\ leq_ S5 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_ R5 S5) = (a_select3_ pminus_thruster_filter_ S5 R5)))))) /\ (((leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall T5 U5 : Universe, ((leq_ n0_ T5 /\ (leq_ n0_ U5 /\ (leq_ T5 (minus_ n6_ n1_) /\ leq_ U5 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ T5 U5) = (a_select3_ q_thruster_filter_ U5 T5))) /\ ((forall V5 W5 : Universe, ((leq_ n0_ V5 /\ (leq_ n0_ W5 /\ (leq_ V5 (minus_ n4_ n1_) /\ leq_ W5 (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_ V5 W5) = (a_select3_ r_thruster_filter_ W5 V5))) /\ ((forall X5 Y5 : Universe, ((leq_ n0_ X5 /\ (leq_ n0_ Y5 /\ (leq_ X5 (minus_ n6_ n1_) /\ leq_ Y5 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_ X5 Y5) = (a_select3_ pminus_thruster_filter_ Y5 X5))) /\ (forall Z5 : Universe, ((leq_ n0_ Z5 /\ leq_ Z5 (minus_ (plus_ n1_ (minus_ n6_ n1_)) n1_)) -> (forall A6 : Universe, ((leq_ n0_ A6 /\ leq_ A6 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_ Z5 A6) = (a_select3_ id_thruster_filter_ A6 Z5)))))))))) -> (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall B6 C6 : Universe, ((leq_ n0_ B6 /\ (leq_ n0_ C6 /\ (leq_ B6 (minus_ n6_ n1_) /\ leq_ C6 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ B6 C6) = (a_select3_ q_thruster_filter_ C6 B6))) /\ ((forall D6 E6 : Universe, ((leq_ n0_ D6 /\ (leq_ n0_ E6 /\ (leq_ D6 (minus_ n4_ n1_) /\ leq_ E6 (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_ D6 E6) = (a_select3_ r_thruster_filter_ E6 D6))) /\ ((forall F6 G6 : Universe, ((leq_ n0_ F6 /\ (leq_ n0_ G6 /\ (leq_ F6 (minus_ n6_ n1_) /\ leq_ G6 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_ F6 G6) = (a_select3_ pminus_thruster_filter_ G6 F6))) /\ (forall H6 : Universe, ((leq_ n0_ H6 /\ leq_ H6 (minus_ n6_ n1_)) -> (forall I6 : Universe, ((leq_ n0_ I6 /\ leq_ I6 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_ H6 I6) = (a_select3_ id_thruster_filter_ I6 H6))))))))))) /\ (((leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall J6 K6 : Universe, ((leq_ n0_ J6 /\ (leq_ n0_ K6 /\ (leq_ J6 (minus_ n6_ n1_) /\ leq_ K6 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ J6 K6) = (a_select3_ q_thruster_filter_ K6 J6))) /\ ((forall L6 M6 : Universe, ((leq_ n0_ L6 /\ (leq_ n0_ M6 /\ (leq_ L6 (minus_ n4_ n1_) /\ leq_ M6 (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_ L6 M6) = (a_select3_ r_thruster_filter_ M6 L6))) /\ ((forall N6 O6 : Universe, ((leq_ n0_ N6 /\ (leq_ n0_ O6 /\ (leq_ N6 (minus_ n6_ n1_) /\ leq_ O6 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_ N6 O6) = (a_select3_ pminus_thruster_filter_ O6 N6))) /\ (forall P6 : Universe, ((leq_ n0_ P6 /\ leq_ P6 (minus_ n6_ n1_)) -> (forall Q6 : Universe, ((leq_ n0_ Q6 /\ leq_ Q6 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_ P6 Q6) = (a_select3_ id_thruster_filter_ Q6 P6)))))))))) -> ((~(gt_ pv5_ n0_) -> ((~(gt_ pv5_ n0_) -> ((~(gt_ pv5_ n0_) -> ((~(gt_ pv5_ n0_) -> (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall R6 S6 : Universe, ((leq_ n0_ R6 /\ (leq_ n0_ S6 /\ (leq_ R6 (minus_ n6_ n1_) /\ leq_ S6 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ R6 S6) = (a_select3_ q_thruster_filter_ S6 R6))) /\ ((forall T6 U6 : Universe, ((leq_ n0_ T6 /\ (leq_ n0_ U6 /\ (leq_ T6 (minus_ n4_ n1_) /\ leq_ U6 (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_ T6 U6) = (a_select3_ r_thruster_filter_ U6 T6))) /\ ((forall V6 W6 : Universe, ((leq_ n0_ V6 /\ (leq_ n0_ W6 /\ (leq_ V6 (minus_ n6_ n1_) /\ leq_ W6 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ phi_thruster_filter_ (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) (tptp_mmul_ r_thruster_filter_ (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_)))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)))))) (trans_ phi_thruster_filter_)))) V6 W6) = (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ phi_thruster_filter_ (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) (tptp_mmul_ r_thruster_filter_ (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_)))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)))))) (trans_ phi_thruster_filter_)))) W6 V6))) /\ ((forall X6 Y6 : Universe, ((leq_ n0_ X6 /\ (leq_ n0_ Y6 /\ (leq_ X6 (minus_ n6_ n1_) /\ leq_ Y6 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ phi_thruster_filter_ (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) (tptp_mmul_ r_thruster_filter_ (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_)))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)))))) (trans_ phi_thruster_filter_)))) X6 Y6) = (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ phi_thruster_filter_ (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) (tptp_mmul_ r_thruster_filter_ (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_)))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)))))) (trans_ phi_thruster_filter_)))) Y6 X6))) /\ (forall Z6 : Universe, ((leq_ n0_ Z6 /\ leq_ Z6 (minus_ n6_ n1_)) -> (forall A7 : Universe, ((leq_ n0_ A7 /\ leq_ A7 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_ Z6 A7) = (a_select3_ id_thruster_filter_ A7 Z6)))))))))))) /\ (gt_ pv5_ n0_ -> (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall B7 C7 : Universe, ((leq_ n0_ B7 /\ (leq_ n0_ C7 /\ (leq_ B7 (minus_ n6_ n1_) /\ leq_ C7 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ B7 C7) = (a_select3_ q_thruster_filter_ C7 B7))) /\ ((forall D7 E7 : Universe, ((leq_ n0_ D7 /\ (leq_ n0_ E7 /\ (leq_ D7 (minus_ n4_ n1_) /\ leq_ E7 (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_ D7 E7) = (a_select3_ r_thruster_filter_ E7 D7))) /\ ((forall F7 G7 : Universe, ((leq_ n0_ F7 /\ (leq_ n0_ G7 /\ (leq_ F7 (minus_ n6_ n1_) /\ leq_ G7 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ phi_thruster_filter_ (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_mmul_ r_thruster_filter_ (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))) (trans_ phi_thruster_filter_)))) F7 G7) = (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ phi_thruster_filter_ (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_mmul_ r_thruster_filter_ (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))) (trans_ phi_thruster_filter_)))) G7 F7))) /\ ((forall H7 I7 : Universe, ((leq_ n0_ H7 /\ (leq_ n0_ I7 /\ (leq_ H7 (minus_ n6_ n1_) /\ leq_ I7 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ phi_thruster_filter_ (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_mmul_ r_thruster_filter_ (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))) (trans_ phi_thruster_filter_)))) H7 I7) = (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ phi_thruster_filter_ (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_mmul_ r_thruster_filter_ (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))) (trans_ phi_thruster_filter_)))) I7 H7))) /\ (forall J7 : Universe, ((leq_ n0_ J7 /\ leq_ J7 (minus_ n6_ n1_)) -> (forall K7 : Universe, ((leq_ n0_ K7 /\ leq_ K7 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_ J7 K7) = (a_select3_ id_thruster_filter_ K7 J7)))))))))))))) /\ (gt_ pv5_ n0_ -> ((~(gt_ pv5_ n0_) -> (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall L7 M7 : Universe, ((leq_ n0_ L7 /\ (leq_ n0_ M7 /\ (leq_ L7 (minus_ n6_ n1_) /\ leq_ M7 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ L7 M7) = (a_select3_ q_thruster_filter_ M7 L7))) /\ ((forall N7 O7 : Universe, ((leq_ n0_ N7 /\ (leq_ n0_ O7 /\ (leq_ N7 (minus_ n4_ n1_) /\ leq_ O7 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) N7 O7) = (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) O7 N7))) /\ ((forall P7 Q7 : Universe, ((leq_ n0_ P7 /\ (leq_ n0_ Q7 /\ (leq_ P7 (minus_ n6_ n1_) /\ leq_ Q7 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ phi_thruster_filter_ (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_)))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)))))) (trans_ phi_thruster_filter_)))) P7 Q7) = (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ phi_thruster_filter_ (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_)))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)))))) (trans_ phi_thruster_filter_)))) Q7 P7))) /\ ((forall R7 S7 : Universe, ((leq_ n0_ R7 /\ (leq_ n0_ S7 /\ (leq_ R7 (minus_ n6_ n1_) /\ leq_ S7 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ phi_thruster_filter_ (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_)))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)))))) (trans_ phi_thruster_filter_)))) R7 S7) = (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ phi_thruster_filter_ (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_)))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)))))) (trans_ phi_thruster_filter_)))) S7 R7))) /\ (forall T7 : Universe, ((leq_ n0_ T7 /\ leq_ T7 (minus_ n6_ n1_)) -> (forall U7 : Universe, ((leq_ n0_ U7 /\ leq_ U7 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_ T7 U7) = (a_select3_ id_thruster_filter_ U7 T7)))))))))))) /\ (gt_ pv5_ n0_ -> (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall V7 W7 : Universe, ((leq_ n0_ V7 /\ (leq_ n0_ W7 /\ (leq_ V7 (minus_ n6_ n1_) /\ leq_ W7 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ V7 W7) = (a_select3_ q_thruster_filter_ W7 V7))) /\ ((forall X7 Y7 : Universe, ((leq_ n0_ X7 /\ (leq_ n0_ Y7 /\ (leq_ X7 (minus_ n4_ n1_) /\ leq_ Y7 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) X7 Y7) = (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) Y7 X7))) /\ ((forall Z7 A8 : Universe, ((leq_ n0_ Z7 /\ (leq_ n0_ A8 /\ (leq_ Z7 (minus_ n6_ n1_) /\ leq_ A8 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ phi_thruster_filter_ (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))) (trans_ phi_thruster_filter_)))) Z7 A8) = (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ phi_thruster_filter_ (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))) (trans_ phi_thruster_filter_)))) A8 Z7))) /\ ((forall B8 C8 : Universe, ((leq_ n0_ B8 /\ (leq_ n0_ C8 /\ (leq_ B8 (minus_ n6_ n1_) /\ leq_ C8 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ phi_thruster_filter_ (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))) (trans_ phi_thruster_filter_)))) B8 C8) = (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ phi_thruster_filter_ (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))) (trans_ phi_thruster_filter_)))) C8 B8))) /\ (forall D8 : Universe, ((leq_ n0_ D8 /\ leq_ D8 (minus_ n6_ n1_)) -> (forall E8 : Universe, ((leq_ n0_ E8 /\ leq_ E8 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_ D8 E8) = (a_select3_ id_thruster_filter_ E8 D8)))))))))))))))) /\ (gt_ pv5_ n0_ -> ((~(gt_ pv5_ n0_) -> ((~(gt_ pv5_ n0_) -> (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall F8 G8 : Universe, ((leq_ n0_ F8 /\ (leq_ n0_ G8 /\ (leq_ F8 (minus_ n6_ n1_) /\ leq_ G8 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ F8 G8) = (a_select3_ q_thruster_filter_ G8 F8))) /\ ((forall H8 I8 : Universe, ((leq_ n0_ H8 /\ (leq_ n0_ I8 /\ (leq_ H8 (minus_ n4_ n1_) /\ leq_ I8 (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_ H8 I8) = (a_select3_ r_thruster_filter_ I8 H8))) /\ ((forall J8 K8 : Universe, ((leq_ n0_ J8 /\ (leq_ n0_ K8 /\ (leq_ J8 (minus_ n6_ n1_) /\ leq_ K8 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ phi_thruster_filter_ (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) (tptp_mmul_ r_thruster_filter_ (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_)))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)))))) (trans_ phi_thruster_filter_)))) J8 K8) = (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ phi_thruster_filter_ (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) (tptp_mmul_ r_thruster_filter_ (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_)))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)))))) (trans_ phi_thruster_filter_)))) K8 J8))) /\ ((forall L8 M8 : Universe, ((leq_ n0_ L8 /\ (leq_ n0_ M8 /\ (leq_ L8 (minus_ n6_ n1_) /\ leq_ M8 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ phi_thruster_filter_ (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) (tptp_mmul_ r_thruster_filter_ (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_)))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)))))) (trans_ phi_thruster_filter_)))) L8 M8) = (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ phi_thruster_filter_ (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) (tptp_mmul_ r_thruster_filter_ (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_)))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)))))) (trans_ phi_thruster_filter_)))) M8 L8))) /\ (forall N8 : Universe, ((leq_ n0_ N8 /\ leq_ N8 (minus_ n6_ n1_)) -> (forall O8 : Universe, ((leq_ n0_ O8 /\ leq_ O8 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_ N8 O8) = (a_select3_ id_thruster_filter_ O8 N8)))))))))))) /\ (gt_ pv5_ n0_ -> (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall P8 Q8 : Universe, ((leq_ n0_ P8 /\ (leq_ n0_ Q8 /\ (leq_ P8 (minus_ n6_ n1_) /\ leq_ Q8 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ P8 Q8) = (a_select3_ q_thruster_filter_ Q8 P8))) /\ ((forall R8 S8 : Universe, ((leq_ n0_ R8 /\ (leq_ n0_ S8 /\ (leq_ R8 (minus_ n4_ n1_) /\ leq_ S8 (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_ R8 S8) = (a_select3_ r_thruster_filter_ S8 R8))) /\ ((forall T8 U8 : Universe, ((leq_ n0_ T8 /\ (leq_ n0_ U8 /\ (leq_ T8 (minus_ n6_ n1_) /\ leq_ U8 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ phi_thruster_filter_ (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_mmul_ r_thruster_filter_ (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))) (trans_ phi_thruster_filter_)))) T8 U8) = (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ phi_thruster_filter_ (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_mmul_ r_thruster_filter_ (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))) (trans_ phi_thruster_filter_)))) U8 T8))) /\ ((forall V8 W8 : Universe, ((leq_ n0_ V8 /\ (leq_ n0_ W8 /\ (leq_ V8 (minus_ n6_ n1_) /\ leq_ W8 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ phi_thruster_filter_ (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_mmul_ r_thruster_filter_ (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))) (trans_ phi_thruster_filter_)))) V8 W8) = (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ phi_thruster_filter_ (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_mmul_ r_thruster_filter_ (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))) (trans_ phi_thruster_filter_)))) W8 V8))) /\ (forall X8 : Universe, ((leq_ n0_ X8 /\ leq_ X8 (minus_ n6_ n1_)) -> (forall Y8 : Universe, ((leq_ n0_ Y8 /\ leq_ Y8 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_ X8 Y8) = (a_select3_ id_thruster_filter_ Y8 X8)))))))))))))) /\ (gt_ pv5_ n0_ -> ((~(gt_ pv5_ n0_) -> (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall Z8 A9 : Universe, ((leq_ n0_ Z8 /\ (leq_ n0_ A9 /\ (leq_ Z8 (minus_ n6_ n1_) /\ leq_ A9 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ Z8 A9) = (a_select3_ q_thruster_filter_ A9 Z8))) /\ ((forall B9 C9 : Universe, ((leq_ n0_ B9 /\ (leq_ n0_ C9 /\ (leq_ B9 (minus_ n4_ n1_) /\ leq_ C9 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) B9 C9) = (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) C9 B9))) /\ ((forall D9 E9 : Universe, ((leq_ n0_ D9 /\ (leq_ n0_ E9 /\ (leq_ D9 (minus_ n6_ n1_) /\ leq_ E9 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ phi_thruster_filter_ (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_)))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)))))) (trans_ phi_thruster_filter_)))) D9 E9) = (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ phi_thruster_filter_ (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_)))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)))))) (trans_ phi_thruster_filter_)))) E9 D9))) /\ ((forall F9 G9 : Universe, ((leq_ n0_ F9 /\ (leq_ n0_ G9 /\ (leq_ F9 (minus_ n6_ n1_) /\ leq_ G9 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ phi_thruster_filter_ (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_)))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)))))) (trans_ phi_thruster_filter_)))) F9 G9) = (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ phi_thruster_filter_ (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_)))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)))))) (trans_ phi_thruster_filter_)))) G9 F9))) /\ (forall H9 : Universe, ((leq_ n0_ H9 /\ leq_ H9 (minus_ n6_ n1_)) -> (forall I9 : Universe, ((leq_ n0_ I9 /\ leq_ I9 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_ H9 I9) = (a_select3_ id_thruster_filter_ I9 H9)))))))))))) /\ (gt_ pv5_ n0_ -> (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall J9 K9 : Universe, ((leq_ n0_ J9 /\ (leq_ n0_ K9 /\ (leq_ J9 (minus_ n6_ n1_) /\ leq_ K9 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ J9 K9) = (a_select3_ q_thruster_filter_ K9 J9))) /\ ((forall L9 M9 : Universe, ((leq_ n0_ L9 /\ (leq_ n0_ M9 /\ (leq_ L9 (minus_ n4_ n1_) /\ leq_ M9 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) L9 M9) = (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) M9 L9))) /\ ((forall N9 O9 : Universe, ((leq_ n0_ N9 /\ (leq_ n0_ O9 /\ (leq_ N9 (minus_ n6_ n1_) /\ leq_ O9 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ phi_thruster_filter_ (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))) (trans_ phi_thruster_filter_)))) N9 O9) = (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ phi_thruster_filter_ (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))) (trans_ phi_thruster_filter_)))) O9 N9))) /\ ((forall P9 Q9 : Universe, ((leq_ n0_ P9 /\ (leq_ n0_ Q9 /\ (leq_ P9 (minus_ n6_ n1_) /\ leq_ Q9 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ phi_thruster_filter_ (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))) (trans_ phi_thruster_filter_)))) P9 Q9) = (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ phi_thruster_filter_ (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))) (trans_ phi_thruster_filter_)))) Q9 P9))) /\ (forall R9 : Universe, ((leq_ n0_ R9 /\ leq_ R9 (minus_ n6_ n1_)) -> (forall S9 : Universe, ((leq_ n0_ S9 /\ leq_ S9 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_ R9 S9) = (a_select3_ id_thruster_filter_ S9 R9)))))))))))))))))) /\ (gt_ pv5_ n0_ -> ((~(gt_ pv5_ n0_) -> ((~(gt_ pv5_ n0_) -> ((~(gt_ pv5_ n0_) -> (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall T9 U9 : Universe, ((leq_ n0_ T9 /\ (leq_ n0_ U9 /\ (leq_ T9 (minus_ n6_ n1_) /\ leq_ U9 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ T9 U9) = (a_select3_ q_thruster_filter_ U9 T9))) /\ ((forall V9 W9 : Universe, ((leq_ n0_ V9 /\ (leq_ n0_ W9 /\ (leq_ V9 (minus_ n4_ n1_) /\ leq_ W9 (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_ V9 W9) = (a_select3_ r_thruster_filter_ W9 V9))) /\ ((forall X9 Y9 : Universe, ((leq_ n0_ X9 /\ (leq_ n0_ Y9 /\ (leq_ X9 (minus_ n6_ n1_) /\ leq_ Y9 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) (tptp_mmul_ r_thruster_filter_ (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_)))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)))))) (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)))))) X9 Y9) = (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) (tptp_mmul_ r_thruster_filter_ (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_)))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)))))) (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)))))) Y9 X9))) /\ ((forall Z9 A10 : Universe, ((leq_ n0_ Z9 /\ (leq_ n0_ A10 /\ (leq_ Z9 (minus_ n6_ n1_) /\ leq_ A10 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) (tptp_mmul_ r_thruster_filter_ (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_)))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)))))) (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)))))) Z9 A10) = (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) (tptp_mmul_ r_thruster_filter_ (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_)))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)))))) (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)))))) A10 Z9))) /\ (forall B10 : Universe, ((leq_ n0_ B10 /\ leq_ B10 (minus_ n6_ n1_)) -> (forall C10 : Universe, ((leq_ n0_ C10 /\ leq_ C10 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_ B10 C10) = (a_select3_ id_thruster_filter_ C10 B10)))))))))))) /\ (gt_ pv5_ n0_ -> (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall D10 E10 : Universe, ((leq_ n0_ D10 /\ (leq_ n0_ E10 /\ (leq_ D10 (minus_ n6_ n1_) /\ leq_ E10 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ D10 E10) = (a_select3_ q_thruster_filter_ E10 D10))) /\ ((forall F10 G10 : Universe, ((leq_ n0_ F10 /\ (leq_ n0_ G10 /\ (leq_ F10 (minus_ n4_ n1_) /\ leq_ G10 (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_ F10 G10) = (a_select3_ r_thruster_filter_ G10 F10))) /\ ((forall H10 I10 : Universe, ((leq_ n0_ H10 /\ (leq_ n0_ I10 /\ (leq_ H10 (minus_ n6_ n1_) /\ leq_ I10 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_mmul_ r_thruster_filter_ (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))) (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)))))) H10 I10) = (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_mmul_ r_thruster_filter_ (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))) (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)))))) I10 H10))) /\ ((forall J10 K10 : Universe, ((leq_ n0_ J10 /\ (leq_ n0_ K10 /\ (leq_ J10 (minus_ n6_ n1_) /\ leq_ K10 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_mmul_ r_thruster_filter_ (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))) (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)))))) J10 K10) = (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_mmul_ r_thruster_filter_ (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))) (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)))))) K10 J10))) /\ (forall L10 : Universe, ((leq_ n0_ L10 /\ leq_ L10 (minus_ n6_ n1_)) -> (forall M10 : Universe, ((leq_ n0_ M10 /\ leq_ M10 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_ L10 M10) = (a_select3_ id_thruster_filter_ M10 L10)))))))))))))) /\ (gt_ pv5_ n0_ -> ((~(gt_ pv5_ n0_) -> (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall N10 O10 : Universe, ((leq_ n0_ N10 /\ (leq_ n0_ O10 /\ (leq_ N10 (minus_ n6_ n1_) /\ leq_ O10 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ N10 O10) = (a_select3_ q_thruster_filter_ O10 N10))) /\ ((forall P10 Q10 : Universe, ((leq_ n0_ P10 /\ (leq_ n0_ Q10 /\ (leq_ P10 (minus_ n4_ n1_) /\ leq_ Q10 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) P10 Q10) = (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) Q10 P10))) /\ ((forall R10 S10 : Universe, ((leq_ n0_ R10 /\ (leq_ n0_ S10 /\ (leq_ R10 (minus_ n6_ n1_) /\ leq_ S10 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_)))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)))))) (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)))))) R10 S10) = (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_)))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)))))) (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)))))) S10 R10))) /\ ((forall T10 U10 : Universe, ((leq_ n0_ T10 /\ (leq_ n0_ U10 /\ (leq_ T10 (minus_ n6_ n1_) /\ leq_ U10 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_)))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)))))) (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)))))) T10 U10) = (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_)))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)))))) (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)))))) U10 T10))) /\ (forall V10 : Universe, ((leq_ n0_ V10 /\ leq_ V10 (minus_ n6_ n1_)) -> (forall W10 : Universe, ((leq_ n0_ W10 /\ leq_ W10 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_ V10 W10) = (a_select3_ id_thruster_filter_ W10 V10)))))))))))) /\ (gt_ pv5_ n0_ -> (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall X10 Y10 : Universe, ((leq_ n0_ X10 /\ (leq_ n0_ Y10 /\ (leq_ X10 (minus_ n6_ n1_) /\ leq_ Y10 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ X10 Y10) = (a_select3_ q_thruster_filter_ Y10 X10))) /\ ((forall Z10 A11 : Universe, ((leq_ n0_ Z10 /\ (leq_ n0_ A11 /\ (leq_ Z10 (minus_ n4_ n1_) /\ leq_ A11 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) Z10 A11) = (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) A11 Z10))) /\ ((forall B11 C11 : Universe, ((leq_ n0_ B11 /\ (leq_ n0_ C11 /\ (leq_ B11 (minus_ n6_ n1_) /\ leq_ C11 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))) (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)))))) B11 C11) = (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))) (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)))))) C11 B11))) /\ ((forall D11 E11 : Universe, ((leq_ n0_ D11 /\ (leq_ n0_ E11 /\ (leq_ D11 (minus_ n6_ n1_) /\ leq_ E11 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))) (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)))))) D11 E11) = (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))) (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)))))) E11 D11))) /\ (forall F11 : Universe, ((leq_ n0_ F11 /\ leq_ F11 (minus_ n6_ n1_)) -> (forall G11 : Universe, ((leq_ n0_ G11 /\ leq_ G11 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_ F11 G11) = (a_select3_ id_thruster_filter_ G11 F11)))))))))))))))) /\ (gt_ pv5_ n0_ -> ((~(gt_ pv5_ n0_) -> ((~(gt_ pv5_ n0_) -> (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall H11 I11 : Universe, ((leq_ n0_ H11 /\ (leq_ n0_ I11 /\ (leq_ H11 (minus_ n6_ n1_) /\ leq_ I11 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ H11 I11) = (a_select3_ q_thruster_filter_ I11 H11))) /\ ((forall J11 K11 : Universe, ((leq_ n0_ J11 /\ (leq_ n0_ K11 /\ (leq_ J11 (minus_ n4_ n1_) /\ leq_ K11 (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_ J11 K11) = (a_select3_ r_thruster_filter_ K11 J11))) /\ ((forall L11 M11 : Universe, ((leq_ n0_ L11 /\ (leq_ n0_ M11 /\ (leq_ L11 (minus_ n6_ n1_) /\ leq_ M11 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) (tptp_mmul_ r_thruster_filter_ (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_)))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)))))) (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)))))) L11 M11) = (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) (tptp_mmul_ r_thruster_filter_ (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_)))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)))))) (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)))))) M11 L11))) /\ ((forall N11 O11 : Universe, ((leq_ n0_ N11 /\ (leq_ n0_ O11 /\ (leq_ N11 (minus_ n6_ n1_) /\ leq_ O11 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) (tptp_mmul_ r_thruster_filter_ (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_)))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)))))) (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)))))) N11 O11) = (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) (tptp_mmul_ r_thruster_filter_ (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_)))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)))))) (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)))))) O11 N11))) /\ (forall P11 : Universe, ((leq_ n0_ P11 /\ leq_ P11 (minus_ n6_ n1_)) -> (forall Q11 : Universe, ((leq_ n0_ Q11 /\ leq_ Q11 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_ P11 Q11) = (a_select3_ id_thruster_filter_ Q11 P11)))))))))))) /\ (gt_ pv5_ n0_ -> (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall R11 S11 : Universe, ((leq_ n0_ R11 /\ (leq_ n0_ S11 /\ (leq_ R11 (minus_ n6_ n1_) /\ leq_ S11 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ R11 S11) = (a_select3_ q_thruster_filter_ S11 R11))) /\ ((forall T11 U11 : Universe, ((leq_ n0_ T11 /\ (leq_ n0_ U11 /\ (leq_ T11 (minus_ n4_ n1_) /\ leq_ U11 (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_ T11 U11) = (a_select3_ r_thruster_filter_ U11 T11))) /\ ((forall V11 W11 : Universe, ((leq_ n0_ V11 /\ (leq_ n0_ W11 /\ (leq_ V11 (minus_ n6_ n1_) /\ leq_ W11 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_mmul_ r_thruster_filter_ (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))) (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)))))) V11 W11) = (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_mmul_ r_thruster_filter_ (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))) (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)))))) W11 V11))) /\ ((forall X11 Y11 : Universe, ((leq_ n0_ X11 /\ (leq_ n0_ Y11 /\ (leq_ X11 (minus_ n6_ n1_) /\ leq_ Y11 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_mmul_ r_thruster_filter_ (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))) (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)))))) X11 Y11) = (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_mmul_ r_thruster_filter_ (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ r_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))) (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)))))) Y11 X11))) /\ (forall Z11 : Universe, ((leq_ n0_ Z11 /\ leq_ Z11 (minus_ n6_ n1_)) -> (forall A12 : Universe, ((leq_ n0_ A12 /\ leq_ A12 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_ Z11 A12) = (a_select3_ id_thruster_filter_ A12 Z11)))))))))))))) /\ (gt_ pv5_ n0_ -> ((~(gt_ pv5_ n0_) -> (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall B12 C12 : Universe, ((leq_ n0_ B12 /\ (leq_ n0_ C12 /\ (leq_ B12 (minus_ n6_ n1_) /\ leq_ C12 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ B12 C12) = (a_select3_ q_thruster_filter_ C12 B12))) /\ ((forall D12 E12 : Universe, ((leq_ n0_ D12 /\ (leq_ n0_ E12 /\ (leq_ D12 (minus_ n4_ n1_) /\ leq_ E12 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) D12 E12) = (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) E12 D12))) /\ ((forall F12 G12 : Universe, ((leq_ n0_ F12 /\ (leq_ n0_ G12 /\ (leq_ F12 (minus_ n6_ n1_) /\ leq_ G12 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_)))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)))))) (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)))))) F12 G12) = (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_)))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)))))) (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)))))) G12 F12))) /\ ((forall H12 I12 : Universe, ((leq_ n0_ H12 /\ (leq_ n0_ I12 /\ (leq_ H12 (minus_ n6_ n1_) /\ leq_ I12 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_)))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)))))) (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)))))) H12 I12) = (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_)))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ h_thruster_filter_) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ h_thruster_filter_ (tptp_mmul_ pminus_thruster_filter_ (trans_ h_thruster_filter_))))))) h_thruster_filter_)))))) (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)))))) I12 H12))) /\ (forall J12 : Universe, ((leq_ n0_ J12 /\ leq_ J12 (minus_ n6_ n1_)) -> (forall K12 : Universe, ((leq_ n0_ K12 /\ leq_ K12 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_ J12 K12) = (a_select3_ id_thruster_filter_ K12 J12)))))))))))) /\ (gt_ pv5_ n0_ -> (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall L12 M12 : Universe, ((leq_ n0_ L12 /\ (leq_ n0_ M12 /\ (leq_ L12 (minus_ n6_ n1_) /\ leq_ M12 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ L12 M12) = (a_select3_ q_thruster_filter_ M12 L12))) /\ ((forall N12 O12 : Universe, ((leq_ n0_ N12 /\ (leq_ n0_ O12 /\ (leq_ N12 (minus_ n4_ n1_) /\ leq_ O12 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) N12 O12) = (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) O12 N12))) /\ ((forall P12 Q12 : Universe, ((leq_ n0_ P12 /\ (leq_ n0_ Q12 /\ (leq_ P12 (minus_ n6_ n1_) /\ leq_ Q12 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))) (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)))))) P12 Q12) = (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))) (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)))))) Q12 P12))) /\ ((forall R12 S12 : Universe, ((leq_ n0_ R12 /\ (leq_ n0_ S12 /\ (leq_ R12 (minus_ n6_ n1_) /\ leq_ S12 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))) (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)))))) R12 S12) = (a_select3_ (tptp_madd_ q_thruster_filter_ (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) (tptp_mmul_ (tptp_madd_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (trans_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))))))) (tptp_mmul_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_msub_ id_thruster_filter_ (tptp_mmul_ (tptp_mmul_ pminus_thruster_filter_ (tptp_mmul_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) (inv_ (tptp_madd_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n3_ n3_ (a_select3_ rho_ n3_ pv5_)) n2_ n2_ (a_select3_ rho_ n2_ pv5_)) n1_ n1_ (a_select3_ rho_ n1_ pv5_)) n0_ n0_ (a_select3_ rho_ n0_ pv5_)) (tptp_mmul_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) (tptp_mmul_ pminus_thruster_filter_ (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))))))))) (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_ n3_ n0_ (tptp_uminus_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)))))) n2_ n0_ (minus_ (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n1_ n0_ (plus_ (times_ tptp_float_0_217_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))) n0_ n0_ (minus_ (times_ tptp_float_0_217_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))) (times_ tptp_float_0_423_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_))))))))))) (trans_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_ n5_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))))) tptp_float_70_707_)) n4_ n0_ (divide_ (times_ tptp_float_0_034_ (times_ tptp_float_1_2_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))))) tptp_float_70_707_)) n2_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)) n1_ n0_ (divide_ (times_ tptp_float_1_2_ (times_ (minus_ (minus_ (minus_ (minus_ (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n1_ pv5_)) (plus_ (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n2_ pv5_)) (plus_ (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n0_ pv5_)) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n7_ pv5_))))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n5_ pv5_))) (times_ (cos_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n6_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n3_ pv5_))) (times_ (sin_ (a_select3_ xhatmin_thruster_filter_ n0_ n0_)) (a_select3_ tr_ n4_ pv5_))) (divide_ (times_ tptp_float_0_034_ tptp_float_0_034_) n2_))) tptp_float_70_707_)))))) S12 R12))) /\ (forall T12 : Universe, ((leq_ n0_ T12 /\ leq_ T12 (minus_ n6_ n1_)) -> (forall U12 : Universe, ((leq_ n0_ U12 /\ leq_ U12 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_ T12 U12) = (a_select3_ id_thruster_filter_ U12 T12)))))))))))))))))))) /\ (((leq_ n0_ pv31_ /\ leq_ pv31_ (minus_ n6_ n1_)) -> (leq_ n0_ (a_select2_ sigma_ pv31_) -> true_)) /\ ((((forall V12 W12 : Universe, ((leq_ n0_ V12 /\ (leq_ n0_ W12 /\ (leq_ V12 (minus_ n6_ n1_) /\ leq_ W12 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ V12 W12) = (a_select3_ q_thruster_filter_ W12 V12))) /\ (forall X12 Y12 : Universe, ((leq_ n0_ X12 /\ (leq_ n0_ Y12 /\ (leq_ X12 (minus_ n4_ n1_) /\ leq_ Y12 (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_ X12 Y12) = (a_select3_ r_thruster_filter_ Y12 X12)))) -> ((forall Z12 A13 : Universe, ((leq_ n0_ Z12 /\ (leq_ n0_ A13 /\ (leq_ Z12 (minus_ n6_ n1_) /\ leq_ A13 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ Z12 A13) = (a_select3_ q_thruster_filter_ A13 Z12))) /\ ((forall B13 C13 : Universe, ((leq_ n0_ B13 /\ (leq_ n0_ C13 /\ (leq_ B13 (minus_ n4_ n1_) /\ leq_ C13 (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_ B13 C13) = (a_select3_ r_thruster_filter_ C13 B13))) /\ (forall D13 E13 : Universe, ((leq_ n0_ D13 /\ (leq_ n0_ E13 /\ (leq_ D13 (minus_ n6_ n1_) /\ leq_ E13 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ pminus_thruster_filter_ n0_ n0_ n10000_) n0_ n1_ n0_) n0_ n2_ n0_) n0_ n3_ n0_) n0_ n4_ n0_) n0_ n5_ n0_) n1_ n0_ n0_) n1_ n1_ n10000_) n1_ n2_ n0_) n1_ n3_ n0_) n1_ n4_ n0_) n1_ n5_ n0_) n2_ n0_ n0_) n2_ n1_ n0_) n2_ n2_ n10000_) n2_ n3_ n0_) n2_ n4_ n0_) n2_ n5_ n0_) n3_ n0_ n0_) n3_ n1_ n0_) n3_ n2_ n0_) n3_ n3_ n10000_) n3_ n4_ n0_) n3_ n5_ n0_) n4_ n0_ n0_) n4_ n1_ n0_) n4_ n2_ n0_) n4_ n3_ n0_) n4_ n4_ n10000_) n4_ n5_ n0_) n5_ n0_ n0_) n5_ n1_ n0_) n5_ n2_ n0_) n5_ n3_ n0_) n5_ n4_ n0_) n5_ n5_ n10000_) D13 E13) = (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ pminus_thruster_filter_ n0_ n0_ n10000_) n0_ n1_ n0_) n0_ n2_ n0_) n0_ n3_ n0_) n0_ n4_ n0_) n0_ n5_ n0_) n1_ n0_ n0_) n1_ n1_ n10000_) n1_ n2_ n0_) n1_ n3_ n0_) n1_ n4_ n0_) n1_ n5_ n0_) n2_ n0_ n0_) n2_ n1_ n0_) n2_ n2_ n10000_) n2_ n3_ n0_) n2_ n4_ n0_) n2_ n5_ n0_) n3_ n0_ n0_) n3_ n1_ n0_) n3_ n2_ n0_) n3_ n3_ n10000_) n3_ n4_ n0_) n3_ n5_ n0_) n4_ n0_ n0_) n4_ n1_ n0_) n4_ n2_ n0_) n4_ n3_ n0_) n4_ n4_ n10000_) n4_ n5_ n0_) n5_ n0_ n0_) n5_ n1_ n0_) n5_ n2_ n0_) n5_ n3_ n0_) n5_ n4_ n0_) n5_ n5_ n10000_) E13 D13)))))) /\ ((((forall F13 G13 : Universe, ((leq_ n0_ F13 /\ (leq_ n0_ G13 /\ (leq_ F13 (minus_ n6_ n1_) /\ leq_ G13 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ F13 G13) = (a_select3_ q_thruster_filter_ G13 F13))) /\ ((forall H13 I13 : Universe, ((leq_ n0_ H13 /\ (leq_ n0_ I13 /\ (leq_ H13 (minus_ n4_ n1_) /\ leq_ I13 (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_ H13 I13) = (a_select3_ r_thruster_filter_ I13 H13))) /\ (forall J13 K13 : Universe, ((leq_ n0_ J13 /\ (leq_ n0_ K13 /\ (leq_ J13 (minus_ n6_ n1_) /\ leq_ K13 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_ J13 K13) = (a_select3_ pminus_thruster_filter_ K13 J13))))) -> true_) /\ ((((forall L13 M13 : Universe, ((leq_ n0_ L13 /\ (leq_ n0_ M13 /\ (leq_ L13 (minus_ n6_ n1_) /\ leq_ M13 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ L13 M13) = (a_select3_ q_thruster_filter_ M13 L13))) /\ ((forall N13 O13 : Universe, ((leq_ n0_ N13 /\ (leq_ n0_ O13 /\ (leq_ N13 (minus_ n4_ n1_) /\ leq_ O13 (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_ N13 O13) = (a_select3_ r_thruster_filter_ O13 N13))) /\ (forall P13 Q13 : Universe, ((leq_ n0_ P13 /\ (leq_ n0_ Q13 /\ (leq_ P13 (minus_ n6_ n1_) /\ leq_ Q13 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_ P13 Q13) = (a_select3_ pminus_thruster_filter_ Q13 P13))))) -> ((forall R13 S13 : Universe, ((leq_ n0_ R13 /\ (leq_ n0_ S13 /\ (leq_ R13 (minus_ n6_ n1_) /\ leq_ S13 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ R13 S13) = (a_select3_ q_thruster_filter_ S13 R13))) /\ ((forall T13 U13 : Universe, ((leq_ n0_ T13 /\ (leq_ n0_ U13 /\ (leq_ T13 (minus_ n4_ n1_) /\ leq_ U13 (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_ T13 U13) = (a_select3_ r_thruster_filter_ U13 T13))) /\ (forall V13 W13 : Universe, ((leq_ n0_ V13 /\ (leq_ n0_ W13 /\ (leq_ V13 (minus_ n6_ n1_) /\ leq_ W13 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_ V13 W13) = (a_select3_ pminus_thruster_filter_ W13 V13)))))) /\ ((geq_ (minus_ n6_ n1_) n0_ -> (geq_ (minus_ n6_ n1_) n0_ -> ((geq_ (minus_ n4_ n1_) n0_ /\ geq_ (minus_ n1000_ n1_) n0_) -> true_))) /\ ((forall X13 Y13 : Universe, ((leq_ n0_ X13 /\ (leq_ n0_ Y13 /\ (leq_ X13 (minus_ n6_ n1_) /\ leq_ Y13 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ X13 Y13) = (a_select3_ q_thruster_filter_ Y13 X13))) -> ((forall Z13 A14 : Universe, ((leq_ n0_ Z13 /\ (leq_ n0_ A14 /\ (leq_ Z13 (minus_ n6_ n1_) /\ leq_ A14 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_ Z13 A14) = (a_select3_ q_thruster_filter_ A14 Z13))) /\ (forall B14 C14 : Universe, ((leq_ n0_ B14 /\ (leq_ n0_ C14 /\ (leq_ B14 (minus_ n4_ n1_) /\ leq_ C14 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n0_ n0_ (a_select3_ rho_ n0_ n0_)) n0_ n1_ n0_) n0_ n2_ n0_) n0_ n3_ n0_) n1_ n0_ n0_) n1_ n1_ (a_select3_ rho_ n1_ n0_)) n1_ n2_ n0_) n1_ n3_ n0_) n2_ n0_ n0_) n2_ n1_ n0_) n2_ n2_ (a_select3_ rho_ n2_ n0_)) n2_ n3_ n0_) n3_ n0_ n0_) n3_ n1_ n0_) n3_ n2_ n0_) n3_ n3_ (a_select3_ rho_ n3_ n0_)) B14 C14) = (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_ n0_ n0_ (a_select3_ rho_ n0_ n0_)) n0_ n1_ n0_) n0_ n2_ n0_) n0_ n3_ n0_) n1_ n0_ n0_) n1_ n1_ (a_select3_ rho_ n1_ n0_)) n1_ n2_ n0_) n1_ n3_ n0_) n2_ n0_ n0_) n2_ n1_ n0_) n2_ n2_ (a_select3_ rho_ n2_ n0_)) n2_ n3_ n0_) n3_ n0_ n0_) n3_ n1_ n0_) n3_ n2_ n0_) n3_ n3_ (a_select3_ rho_ n3_ n0_)) C14 B14))))))))))))))))))))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
