(*
% File     : SWV127+1 : ILTP v1.1.2
% Domain   : Software Verification
% Problem  : Unsimplified proof obligation thruster_init_0002
% Version  : [DFS04] axioms : Especial.
% English  : Proof obligation emerging from the init-safety verification for
%            the thruster program. init-safety ensures that each variable or
%            individual array element has been assigned a defined value before
%            it is used.
% Refs     : [Fis04] Fischer (2004), Email to G. Sutcliffe
%          : [DFS04] Denney et al. (2004), Using Automated Theorem Provers
% Source   : [Fis04]
% Names    : thruster_init_0002 [Fis04]
% Status   : Theorem
% Rating   : 1.00 v3.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :  119 (  83 unit)
%            Number of atoms       : 3948 (1109 equality)
%            Maximal formula depth :  105 (   4 average)
%            Number of connectives : 3850 (  21 ~  ;  23  |;3036  &)
%                                         (   5 <=>; 765 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   1 propositional; 0-2 arity)
%            Number of functors    :   48 (  30 constant; 0-4 arity)
%            Number of variables   : 1414 (   2 singleton;1414 !;   0 ?)
%            Maximal term depth    :   38 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable true_ : Prop.
Variable lt_ : Universe -> Universe -> Prop.
Variable leq_ : Universe -> Universe -> Prop.
Variable gt_ : Universe -> Universe -> Prop.
Variable geq_ : Universe -> Universe -> Prop.

Variable zpred_thruster_filter_init_ : Universe.
Variable zhat_thruster_filter_init_ : Universe.
Variable xhatmin_thruster_filter_init_ : Universe.
Variable use_ : Universe.
Variable uniform_int_rnd_ : Universe -> Universe -> Universe.
Variable trans_ : Universe -> Universe.
Variable tptp_update3_ : Universe -> Universe -> Universe -> Universe -> Universe.
Variable tptp_update2_ : Universe -> Universe -> Universe -> Universe.
Variable tptp_msub_ : Universe -> Universe -> Universe.
Variable tptp_mmul_ : Universe -> Universe -> Universe.
Variable tptp_minus_1_ : Universe.
Variable tptp_madd_ : Universe -> Universe -> Universe.
Variable tptp_const_array2_ : Universe -> Universe -> Universe -> Universe.
Variable tptp_const_array1_ : Universe -> Universe -> Universe.
Variable sum_ : Universe -> Universe -> Universe -> Universe.
Variable succ_ : Universe -> Universe.
Variable sigma_ : Universe.
Variable r_thruster_filter_init_ : Universe.
Variable q_thruster_filter_init_ : Universe.
Variable pv5_ : Universe.
Variable pv46_ : Universe.
Variable pv45_ : Universe.
Variable pv23_ : Universe.
Variable pv21_ : Universe.
Variable pred_ : Universe -> Universe.
Variable pminus_thruster_filter_init_ : Universe.
Variable plus_ : Universe -> Universe -> Universe.
Variable phi_thruster_filter_init_ : Universe.
Variable n7_ : Universe.
Variable n6_ : Universe.
Variable n588_ : Universe.
Variable n5_ : Universe.
Variable n4_ : Universe.
Variable n3_ : Universe.
Variable n2_ : Universe.
Variable n1000_ : Universe.
Variable n1_ : Universe.
Variable n0_ : Universe.
Variable minus_ : Universe -> Universe -> Universe.
Variable inv_ : Universe -> Universe.
Variable init_ : Universe.
Variable id_thruster_filter_init_ : Universe.
Variable h_thruster_filter_init_ : Universe.
Variable dv_thruster_filter_init_ : Universe.
Variable dim_ : Universe -> Universe -> Universe.
Variable def_ : Universe.
Variable a_select3_ : Universe -> Universe -> Universe -> Universe.
Variable a_select2_ : Universe -> Universe -> Universe.

Variable totality_1 : (forall X Y : Universe, (gt_ X Y \/ (gt_ Y X \/ X = Y))).
Variable transitivity_gt_2 : (forall X Y Z : Universe, ((gt_ X Y /\ gt_ Y Z) -> gt_ X Z)).
Variable irreflexivity_gt_3 : (forall X : Universe, ~(gt_ X X)).
Variable reflexivity_leq_4 : (forall X : Universe, leq_ X X).
Variable transitivity_leq_5 : (forall X Y Z : Universe, ((leq_ X Y /\ leq_ Y Z) -> leq_ X Z)).
Variable lt_gt_6 : (forall X Y : Universe, (lt_ X Y <-> gt_ Y X)).
Variable leq_geq_7 : (forall X Y : Universe, (geq_ X Y <-> leq_ Y X)).
Variable leq_gt1_8 : (forall X Y : Universe, (gt_ Y X -> leq_ X Y)).
Variable leq_gt2_9 : (forall X Y : Universe, ((leq_ X Y /\ X <> Y) -> gt_ Y X)).
Variable leq_gt_pred_10 : (forall X Y : Universe, (leq_ X (pred_ Y) <-> gt_ Y X)).
Variable gt_succ_11 : (forall X : Universe, gt_ (succ_ X) X).
Variable leq_succ_12 : (forall X Y : Universe, (leq_ X Y -> leq_ X (succ_ Y))).
Variable leq_succ_gt_equiv_13 : (forall X Y : Universe, (leq_ X Y <-> gt_ (succ_ Y) X)).
Variable uniform_int_rand_ranges_hi_14 : (forall X C : Universe, (leq_ n0_ X -> leq_ (uniform_int_rnd_ C X) X)).
Variable uniform_int_rand_ranges_lo_15 : (forall X C : Universe, (leq_ n0_ X -> leq_ n0_ (uniform_int_rnd_ C X))).
Variable const_array1_select_16 : (forall I L U Val : Universe, ((leq_ L I /\ leq_ I U) -> (a_select2_ (tptp_const_array1_ (dim_ L U) Val) I) = Val)).
Variable const_array2_select_17 : (forall I L1 U1 J L2 U2 Val : Universe, ((leq_ L1 I /\ (leq_ I U1 /\ (leq_ L2 J /\ leq_ J U2))) -> (a_select3_ (tptp_const_array2_ (dim_ L1 U1) (dim_ L2 U2) Val) I J) = Val)).
Variable matrix_symm_aba1_18 : (forall I0 J0 A B N : Universe, ((leq_ n0_ I0 /\ (leq_ I0 N /\ (leq_ n0_ J0 /\ (leq_ J0 N /\ (a_select3_ B I0 J0) = (a_select3_ B J0 I0))))) -> (a_select3_ (tptp_mmul_ A (tptp_mmul_ B (trans_ A))) I0 J0) = (a_select3_ (tptp_mmul_ A (tptp_mmul_ B (trans_ A))) J0 I0))).
Variable matrix_symm_aba2_19 : (forall I0 J0 I J A B N M : Universe, ((leq_ n0_ I0 /\ (leq_ I0 N /\ (leq_ n0_ J0 /\ (leq_ J0 N /\ (leq_ n0_ I /\ (leq_ I M /\ (leq_ n0_ J /\ (leq_ J M /\ (a_select3_ B I J) = (a_select3_ B J I))))))))) -> (a_select3_ (tptp_mmul_ A (tptp_mmul_ B (trans_ A))) I0 J0) = (a_select3_ (tptp_mmul_ A (tptp_mmul_ B (trans_ A))) J0 I0))).
Variable matrix_symm_add_20 : (forall I J A B N : Universe, ((leq_ n0_ I /\ (leq_ I N /\ (leq_ n0_ J /\ (leq_ J N /\ ((a_select3_ A I J) = (a_select3_ A J I) /\ (a_select3_ B I J) = (a_select3_ B J I)))))) -> (a_select3_ (tptp_madd_ A B) I J) = (a_select3_ (tptp_madd_ A B) J I))).
Variable matrix_symm_sub_21 : (forall I J A B N : Universe, ((leq_ n0_ I /\ (leq_ I N /\ (leq_ n0_ J /\ (leq_ J N /\ ((a_select3_ A I J) = (a_select3_ A J I) /\ (a_select3_ B I J) = (a_select3_ B J I)))))) -> (a_select3_ (tptp_msub_ A B) I J) = (a_select3_ (tptp_msub_ A B) J I))).
Variable matrix_symm_trans_22 : (forall I J A N : Universe, ((leq_ n0_ I /\ (leq_ I N /\ (leq_ n0_ J /\ (leq_ J N /\ (a_select3_ A I J) = (a_select3_ A J I))))) -> (a_select3_ (trans_ A) I J) = (a_select3_ (trans_ A) J I))).
Variable matrix_symm_inv_23 : (forall I J A N : Universe, ((leq_ n0_ I /\ (leq_ I N /\ (leq_ n0_ J /\ (leq_ J N /\ (a_select3_ A I J) = (a_select3_ A J I))))) -> (a_select3_ (inv_ A) I J) = (a_select3_ (inv_ A) J I))).
Variable matrix_symm_joseph_update_24 : (forall I0 J0 I J A B C D E F N M : Universe, ((leq_ n0_ I0 /\ (leq_ I0 N /\ (leq_ n0_ J0 /\ (leq_ J0 N /\ (leq_ n0_ I /\ (leq_ I M /\ (leq_ n0_ J /\ (leq_ J M /\ ((a_select3_ D I J) = (a_select3_ D J I) /\ ((a_select3_ A I0 J0) = (a_select3_ A J0 I0) /\ (a_select3_ F I0 J0) = (a_select3_ F J0 I0))))))))))) -> (a_select3_ (tptp_madd_ A (tptp_mmul_ B (tptp_mmul_ (tptp_madd_ (tptp_mmul_ C (tptp_mmul_ D (trans_ C))) (tptp_mmul_ E (tptp_mmul_ F (trans_ E)))) (trans_ B)))) I0 J0) = (a_select3_ (tptp_madd_ A (tptp_mmul_ B (tptp_mmul_ (tptp_madd_ (tptp_mmul_ C (tptp_mmul_ D (trans_ C))) (tptp_mmul_ E (tptp_mmul_ F (trans_ E)))) (trans_ B)))) J0 I0))).
Variable sum_plus_base_25 : (forall Body : Universe, (sum_ n0_ tptp_minus_1_ Body) = n0_).
Variable succ_tptp_minus_1_26 : (succ_ tptp_minus_1_) = n0_.
Variable succ_plus_1_r_27 : (forall X : Universe, (plus_ X n1_) = (succ_ X)).
Variable succ_plus_1_l_28 : (forall X : Universe, (plus_ n1_ X) = (succ_ X)).
Variable succ_plus_2_r_29 : (forall X : Universe, (plus_ X n2_) = (succ_ (succ_ X))).
Variable succ_plus_2_l_30 : (forall X : Universe, (plus_ n2_ X) = (succ_ (succ_ X))).
Variable succ_plus_3_r_31 : (forall X : Universe, (plus_ X n3_) = (succ_ (succ_ (succ_ X)))).
Variable succ_plus_3_l_32 : (forall X : Universe, (plus_ n3_ X) = (succ_ (succ_ (succ_ X)))).
Variable succ_plus_4_r_33 : (forall X : Universe, (plus_ X n4_) = (succ_ (succ_ (succ_ (succ_ X))))).
Variable succ_plus_4_l_34 : (forall X : Universe, (plus_ n4_ X) = (succ_ (succ_ (succ_ (succ_ X))))).
Variable succ_plus_5_r_35 : (forall X : Universe, (plus_ X n5_) = (succ_ (succ_ (succ_ (succ_ (succ_ X)))))).
Variable succ_plus_5_l_36 : (forall X : Universe, (plus_ n5_ X) = (succ_ (succ_ (succ_ (succ_ (succ_ X)))))).
Variable pred_minus_1_37 : (forall X : Universe, (minus_ X n1_) = (pred_ X)).
Variable pred_succ_38 : (forall X : Universe, (pred_ (succ_ X)) = X).
Variable succ_pred_39 : (forall X : Universe, (succ_ (pred_ X)) = X).
Variable leq_succ_succ_40 : (forall X Y : Universe, (leq_ (succ_ X) (succ_ Y) <-> leq_ X Y)).
Variable leq_succ_gt_41 : (forall X Y : Universe, (leq_ (succ_ X) Y -> gt_ Y X)).
Variable leq_minus_42 : (forall X Y : Universe, (leq_ (minus_ X Y) X -> leq_ n0_ Y)).
Variable sel3_update_1_43 : (forall X U V VAL : Universe, (a_select3_ (tptp_update3_ X U V VAL) U V) = VAL).
Variable sel3_update_2_44 : (forall I J U V X VAL VAL2 : Universe, ((I <> U /\ (J = V /\ (a_select3_ X U V) = VAL)) -> (a_select3_ (tptp_update3_ X I J VAL2) U V) = VAL)).
Variable sel3_update_3_45 : (forall I J U V X VAL : Universe, (((forall I0 J0 : Universe, ((leq_ n0_ I0 /\ (leq_ n0_ J0 /\ (leq_ I0 U /\ leq_ J0 V))) -> (a_select3_ X I0 J0) = VAL)) /\ (leq_ n0_ I /\ (leq_ I U /\ (leq_ n0_ J /\ leq_ J V)))) -> (a_select3_ (tptp_update3_ X U V VAL) I J) = VAL)).
Variable sel2_update_1_46 : (forall X U VAL : Universe, (a_select2_ (tptp_update2_ X U VAL) U) = VAL).
Variable sel2_update_2_47 : (forall I U X VAL VAL2 : Universe, ((I <> U /\ (a_select2_ X U) = VAL) -> (a_select2_ (tptp_update2_ X I VAL2) U) = VAL)).
Variable sel2_update_3_48 : (forall I U X VAL : Universe, (((forall I0 : Universe, ((leq_ n0_ I0 /\ leq_ I0 U) -> (a_select2_ X I0) = VAL)) /\ (leq_ n0_ I /\ leq_ I U)) -> (a_select2_ (tptp_update2_ X U VAL) I) = VAL)).
Variable ttrue_49 : true_.
Variable defuse_50 : def_ <> use_.
Variable gt_1000_588_51 : gt_ n1000_ n588_.
Variable gt_588_4_52 : gt_ n588_ n4_.
Variable gt_5_4_53 : gt_ n5_ n4_.
Variable gt_6_4_54 : gt_ n6_ n4_.
Variable gt_7_4_55 : gt_ n7_ n4_.
Variable gt_1000_4_56 : gt_ n1000_ n4_.
Variable gt_588_5_57 : gt_ n588_ n5_.
Variable gt_6_5_58 : gt_ n6_ n5_.
Variable gt_7_5_59 : gt_ n7_ n5_.
Variable gt_1000_5_60 : gt_ n1000_ n5_.
Variable gt_588_6_61 : gt_ n588_ n6_.
Variable gt_7_6_62 : gt_ n7_ n6_.
Variable gt_1000_6_63 : gt_ n1000_ n6_.
Variable gt_588_7_64 : gt_ n588_ n7_.
Variable gt_1000_7_65 : gt_ n1000_ n7_.
Variable gt_588_tptp_minus_1_66 : gt_ n588_ tptp_minus_1_.
Variable gt_4_tptp_minus_1_67 : gt_ n4_ tptp_minus_1_.
Variable gt_5_tptp_minus_1_68 : gt_ n5_ tptp_minus_1_.
Variable gt_6_tptp_minus_1_69 : gt_ n6_ tptp_minus_1_.
Variable gt_7_tptp_minus_1_70 : gt_ n7_ tptp_minus_1_.
Variable gt_0_tptp_minus_1_71 : gt_ n0_ tptp_minus_1_.
Variable gt_1_tptp_minus_1_72 : gt_ n1_ tptp_minus_1_.
Variable gt_2_tptp_minus_1_73 : gt_ n2_ tptp_minus_1_.
Variable gt_1000_tptp_minus_1_74 : gt_ n1000_ tptp_minus_1_.
Variable gt_3_tptp_minus_1_75 : gt_ n3_ tptp_minus_1_.
Variable gt_588_0_76 : gt_ n588_ n0_.
Variable gt_4_0_77 : gt_ n4_ n0_.
Variable gt_5_0_78 : gt_ n5_ n0_.
Variable gt_6_0_79 : gt_ n6_ n0_.
Variable gt_7_0_80 : gt_ n7_ n0_.
Variable gt_1_0_81 : gt_ n1_ n0_.
Variable gt_2_0_82 : gt_ n2_ n0_.
Variable gt_1000_0_83 : gt_ n1000_ n0_.
Variable gt_3_0_84 : gt_ n3_ n0_.
Variable gt_588_1_85 : gt_ n588_ n1_.
Variable gt_4_1_86 : gt_ n4_ n1_.
Variable gt_5_1_87 : gt_ n5_ n1_.
Variable gt_6_1_88 : gt_ n6_ n1_.
Variable gt_7_1_89 : gt_ n7_ n1_.
Variable gt_2_1_90 : gt_ n2_ n1_.
Variable gt_1000_1_91 : gt_ n1000_ n1_.
Variable gt_3_1_92 : gt_ n3_ n1_.
Variable gt_588_2_93 : gt_ n588_ n2_.
Variable gt_4_2_94 : gt_ n4_ n2_.
Variable gt_5_2_95 : gt_ n5_ n2_.
Variable gt_6_2_96 : gt_ n6_ n2_.
Variable gt_7_2_97 : gt_ n7_ n2_.
Variable gt_1000_2_98 : gt_ n1000_ n2_.
Variable gt_3_2_99 : gt_ n3_ n2_.
Variable gt_588_3_100 : gt_ n588_ n3_.
Variable gt_4_3_101 : gt_ n4_ n3_.
Variable gt_5_3_102 : gt_ n5_ n3_.
Variable gt_6_3_103 : gt_ n6_ n3_.
Variable gt_7_3_104 : gt_ n7_ n3_.
Variable gt_1000_3_105 : gt_ n1000_ n3_.
Variable finite_domain_4_106 : (forall X : Universe, ((leq_ n0_ X /\ leq_ X n4_) -> (X = n0_ \/ (X = n1_ \/ (X = n2_ \/ (X = n3_ \/ X = n4_)))))).
Variable finite_domain_5_107 : (forall X : Universe, ((leq_ n0_ X /\ leq_ X n5_) -> (X = n0_ \/ (X = n1_ \/ (X = n2_ \/ (X = n3_ \/ (X = n4_ \/ X = n5_))))))).
Variable finite_domain_6_108 : (forall X : Universe, ((leq_ n0_ X /\ leq_ X n6_) -> (X = n0_ \/ (X = n1_ \/ (X = n2_ \/ (X = n3_ \/ (X = n4_ \/ (X = n5_ \/ X = n6_)))))))).
Variable finite_domain_0_109 : (forall X : Universe, ((leq_ n0_ X /\ leq_ X n0_) -> X = n0_)).
Variable finite_domain_1_110 : (forall X : Universe, ((leq_ n0_ X /\ leq_ X n1_) -> (X = n0_ \/ X = n1_))).
Variable finite_domain_2_111 : (forall X : Universe, ((leq_ n0_ X /\ leq_ X n2_) -> (X = n0_ \/ (X = n1_ \/ X = n2_)))).
Variable finite_domain_3_112 : (forall X : Universe, ((leq_ n0_ X /\ leq_ X n3_) -> (X = n0_ \/ (X = n1_ \/ (X = n2_ \/ X = n3_))))).
Variable successor_4_113 : (succ_ (succ_ (succ_ (succ_ n0_)))) = n4_.
Variable successor_5_114 : (succ_ (succ_ (succ_ (succ_ (succ_ n0_))))) = n5_.
Variable successor_6_115 : (succ_ (succ_ (succ_ (succ_ (succ_ (succ_ n0_)))))) = n6_.
Variable successor_1_116 : (succ_ n0_) = n1_.
Variable successor_2_117 : (succ_ (succ_ n0_)) = n2_.
Variable successor_3_118 : (succ_ (succ_ (succ_ n0_))) = n3_.

Theorem thruster_init_0002_119 : ((geq_ (minus_ n4_ n1_) n0_ /\ geq_ (minus_ n1000_ n1_) n0_) -> (forall A : Universe, (init_ = init_ /\ ((geq_ n7_ n0_ /\ geq_ (minus_ n1000_ n1_) n0_) -> (forall X48 : Universe, (init_ = init_ /\ ((true_ -> (init_ = init_ /\ ((a_select2_ (tptp_const_array1_ (dim_ n0_ (minus_ n6_ n1_)) init_) n0_) = init_ /\ (forall B C : Universe, ((leq_ n0_ B /\ (leq_ n0_ C /\ (leq_ B n3_ /\ leq_ C n5_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n0_ n0_ init_) n0_ n1_ init_) n0_ n2_ init_) n0_ n3_ init_) n0_ n4_ init_) n0_ n5_ init_) n1_ n0_ init_) n1_ n1_ init_) n1_ n2_ init_) n1_ n3_ init_) n1_ n4_ init_) n1_ n5_ init_) n2_ n0_ init_) n2_ n1_ init_) n2_ n2_ init_) n2_ n3_ init_) n2_ n4_ init_) n2_ n5_ init_) n3_ n0_ init_) n3_ n1_ init_) n3_ n2_ init_) n3_ n3_ init_) n3_ n4_ init_) n3_ n5_ init_) B C) = init_))))) /\ (((init_ = init_ /\ (leq_ n0_ pv5_ /\ (leq_ n0_ pv21_ /\ (leq_ pv5_ n588_ /\ (leq_ pv21_ (minus_ n6_ n1_) /\ ((forall D E : Universe, ((leq_ n0_ D /\ (leq_ n0_ E /\ (leq_ D n3_ /\ leq_ E n5_))) -> (a_select3_ h_thruster_filter_init_ D E) = init_)) /\ ((forall F G : Universe, ((leq_ n0_ F /\ (leq_ n0_ G /\ (leq_ F n5_ /\ leq_ G n5_))) -> (a_select3_ phi_thruster_filter_init_ F G) = init_)) /\ ((forall H I : Universe, ((leq_ n0_ H /\ (leq_ n0_ I /\ (leq_ H (minus_ n6_ n1_) /\ leq_ I n0_))) -> (a_select3_ dv_thruster_filter_init_ H I) = init_)) /\ ((forall J K : Universe, ((leq_ n0_ J /\ (leq_ n0_ K /\ (leq_ J n5_ /\ leq_ K n5_))) -> (a_select3_ q_thruster_filter_init_ J K) = init_)) /\ ((forall L M : Universe, ((leq_ n0_ L /\ (leq_ n0_ M /\ (leq_ L n3_ /\ leq_ M n3_))) -> (a_select3_ r_thruster_filter_init_ L M) = init_)) /\ ((forall N O : Universe, ((leq_ n0_ N /\ (leq_ n0_ O /\ (leq_ N n5_ /\ leq_ O n0_))) -> (a_select3_ xhatmin_thruster_filter_init_ N O) = init_)) /\ ((forall P Q : Universe, ((leq_ n0_ P /\ (leq_ n0_ Q /\ (leq_ P n5_ /\ leq_ Q n5_))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n6_ n1_)) init_) P Q) = init_)) /\ (forall R : Universe, ((leq_ n0_ R /\ leq_ R (minus_ n6_ n1_)) -> (forall S : Universe, ((leq_ n0_ S /\ leq_ S (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_init_ R S) = init_)))))))))))))))) -> (init_ = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) pv21_ n0_) = init_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall T U : Universe, ((leq_ n0_ T /\ (leq_ n0_ U /\ (leq_ T n3_ /\ leq_ U n5_))) -> (a_select3_ h_thruster_filter_init_ T U) = init_)) /\ ((forall V W : Universe, ((leq_ n0_ V /\ (leq_ n0_ W /\ (leq_ V n5_ /\ leq_ W n5_))) -> (a_select3_ phi_thruster_filter_init_ V W) = init_)) /\ ((forall X Y : Universe, ((leq_ n0_ X /\ (leq_ n0_ Y /\ (leq_ X (minus_ n6_ n1_) /\ leq_ Y n0_))) -> (a_select3_ dv_thruster_filter_init_ X Y) = init_)) /\ ((forall Z A1 : Universe, ((leq_ n0_ Z /\ (leq_ n0_ A1 /\ (leq_ Z n5_ /\ leq_ A1 n5_))) -> (a_select3_ q_thruster_filter_init_ Z A1) = init_)) /\ ((forall B1 C1 : Universe, ((leq_ n0_ B1 /\ (leq_ n0_ C1 /\ (leq_ B1 n3_ /\ leq_ C1 n3_))) -> (a_select3_ r_thruster_filter_init_ B1 C1) = init_)) /\ ((forall D1 E1 : Universe, ((leq_ n0_ D1 /\ (leq_ n0_ E1 /\ (leq_ D1 n5_ /\ leq_ E1 n0_))) -> (a_select3_ xhatmin_thruster_filter_init_ D1 E1) = init_)) /\ ((forall F1 G1 : Universe, ((leq_ n0_ F1 /\ (leq_ n0_ G1 /\ (leq_ F1 n5_ /\ leq_ G1 n5_))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n6_ n1_)) init_) F1 G1) = init_)) /\ (forall H1 : Universe, ((leq_ n0_ H1 /\ leq_ H1 (minus_ n6_ n1_)) -> (forall I1 : Universe, ((leq_ n0_ I1 /\ leq_ I1 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_init_ H1 I1) = init_)))))))))))))))) /\ (((init_ = init_ /\ (leq_ n0_ pv5_ /\ (leq_ n0_ pv45_ /\ (leq_ n0_ pv46_ /\ (leq_ pv5_ n588_ /\ (leq_ pv45_ (minus_ n6_ n1_) /\ (leq_ pv46_ (minus_ n6_ n1_) /\ ((forall J1 K1 : Universe, ((leq_ n0_ J1 /\ (leq_ n0_ K1 /\ (leq_ J1 n3_ /\ leq_ K1 n5_))) -> (a_select3_ h_thruster_filter_init_ J1 K1) = init_)) /\ ((forall L1 M1 : Universe, ((leq_ n0_ L1 /\ (leq_ n0_ M1 /\ (leq_ L1 n5_ /\ leq_ M1 n5_))) -> (a_select3_ phi_thruster_filter_init_ L1 M1) = init_)) /\ ((forall N1 O1 : Universe, ((leq_ n0_ N1 /\ (leq_ n0_ O1 /\ (leq_ N1 (minus_ n6_ n1_) /\ leq_ O1 n0_))) -> (a_select3_ dv_thruster_filter_init_ N1 O1) = init_)) /\ ((forall P1 Q1 : Universe, ((leq_ n0_ P1 /\ (leq_ n0_ Q1 /\ (leq_ P1 n5_ /\ leq_ Q1 n5_))) -> (a_select3_ q_thruster_filter_init_ P1 Q1) = init_)) /\ ((forall R1 S1 : Universe, ((leq_ n0_ R1 /\ (leq_ n0_ S1 /\ (leq_ R1 n3_ /\ leq_ S1 n3_))) -> (a_select3_ r_thruster_filter_init_ R1 S1) = init_)) /\ ((forall T1 U1 : Universe, ((leq_ n0_ T1 /\ (leq_ n0_ U1 /\ (leq_ T1 n5_ /\ leq_ U1 n0_))) -> (a_select3_ xhatmin_thruster_filter_init_ T1 U1) = init_)) /\ ((forall V1 W1 : Universe, ((leq_ n0_ V1 /\ (leq_ n0_ W1 /\ (leq_ V1 n5_ /\ leq_ W1 n5_))) -> (a_select3_ pminus_thruster_filter_init_ V1 W1) = init_)) /\ ((forall X1 Y1 : Universe, ((leq_ n0_ X1 /\ (leq_ n0_ Y1 /\ (leq_ X1 (minus_ n6_ n1_) /\ leq_ Y1 (minus_ n6_ n1_)))) -> (((lt_ Y1 pv46_ /\ X1 = pv45_) -> (a_select3_ id_thruster_filter_init_ X1 Y1) = init_) /\ (lt_ X1 pv45_ -> (a_select3_ id_thruster_filter_init_ X1 Y1) = init_)))) /\ (forall Z1 : Universe, ((leq_ n0_ Z1 /\ leq_ Z1 (minus_ pv45_ n1_)) -> (forall A2 : Universe, ((leq_ n0_ A2 /\ leq_ A2 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_init_ Z1 A2) = init_))))))))))))))))))) -> (init_ = init_ /\ ((pv45_ <> pv46_ -> (init_ = init_ /\ (leq_ n0_ pv5_ /\ (leq_ n0_ pv45_ /\ (leq_ pv5_ n588_ /\ (leq_ pv45_ (minus_ n6_ n1_) /\ ((forall B2 C2 : Universe, ((leq_ n0_ B2 /\ (leq_ n0_ C2 /\ (leq_ B2 n3_ /\ leq_ C2 n5_))) -> (a_select3_ h_thruster_filter_init_ B2 C2) = init_)) /\ ((forall D2 E2 : Universe, ((leq_ n0_ D2 /\ (leq_ n0_ E2 /\ (leq_ D2 n5_ /\ leq_ E2 n5_))) -> (a_select3_ phi_thruster_filter_init_ D2 E2) = init_)) /\ ((forall F2 G2 : Universe, ((leq_ n0_ F2 /\ (leq_ n0_ G2 /\ (leq_ F2 (minus_ n6_ n1_) /\ leq_ G2 n0_))) -> (a_select3_ dv_thruster_filter_init_ F2 G2) = init_)) /\ ((forall H2 I2 : Universe, ((leq_ n0_ H2 /\ (leq_ n0_ I2 /\ (leq_ H2 n5_ /\ leq_ I2 n5_))) -> (a_select3_ q_thruster_filter_init_ H2 I2) = init_)) /\ ((forall J2 K2 : Universe, ((leq_ n0_ J2 /\ (leq_ n0_ K2 /\ (leq_ J2 n3_ /\ leq_ K2 n3_))) -> (a_select3_ r_thruster_filter_init_ J2 K2) = init_)) /\ ((forall L2 M2 : Universe, ((leq_ n0_ L2 /\ (leq_ n0_ M2 /\ (leq_ L2 n5_ /\ leq_ M2 n0_))) -> (a_select3_ xhatmin_thruster_filter_init_ L2 M2) = init_)) /\ ((forall N2 O2 : Universe, ((leq_ n0_ N2 /\ (leq_ n0_ O2 /\ (leq_ N2 n5_ /\ leq_ O2 n5_))) -> (a_select3_ pminus_thruster_filter_init_ N2 O2) = init_)) /\ ((forall P2 Q2 : Universe, ((leq_ n0_ P2 /\ (leq_ n0_ Q2 /\ (leq_ P2 (minus_ n6_ n1_) /\ leq_ Q2 (minus_ n6_ n1_)))) -> (((lt_ Q2 (plus_ n1_ pv46_) /\ P2 = pv45_) -> (a_select3_ (tptp_update3_ id_thruster_filter_init_ pv45_ pv46_ init_) P2 Q2) = init_) /\ (lt_ P2 pv45_ -> (a_select3_ (tptp_update3_ id_thruster_filter_init_ pv45_ pv46_ init_) P2 Q2) = init_)))) /\ (forall R2 : Universe, ((leq_ n0_ R2 /\ leq_ R2 (minus_ pv45_ n1_)) -> (forall S2 : Universe, ((leq_ n0_ S2 /\ leq_ S2 (minus_ n6_ n1_)) -> (a_select3_ (tptp_update3_ id_thruster_filter_init_ pv45_ S2 init_) R2 S2) = init_)))))))))))))))))) /\ (pv45_ = pv46_ -> (init_ = init_ /\ (leq_ n0_ pv5_ /\ (leq_ n0_ pv45_ /\ (leq_ pv5_ n588_ /\ (leq_ pv45_ (minus_ n6_ n1_) /\ ((forall T2 U2 : Universe, ((leq_ n0_ T2 /\ (leq_ n0_ U2 /\ (leq_ T2 n3_ /\ leq_ U2 n5_))) -> (a_select3_ h_thruster_filter_init_ T2 U2) = init_)) /\ ((forall V2 W2 : Universe, ((leq_ n0_ V2 /\ (leq_ n0_ W2 /\ (leq_ V2 n5_ /\ leq_ W2 n5_))) -> (a_select3_ phi_thruster_filter_init_ V2 W2) = init_)) /\ ((forall X2 Y2 : Universe, ((leq_ n0_ X2 /\ (leq_ n0_ Y2 /\ (leq_ X2 (minus_ n6_ n1_) /\ leq_ Y2 n0_))) -> (a_select3_ dv_thruster_filter_init_ X2 Y2) = init_)) /\ ((forall Z2 A3 : Universe, ((leq_ n0_ Z2 /\ (leq_ n0_ A3 /\ (leq_ Z2 n5_ /\ leq_ A3 n5_))) -> (a_select3_ q_thruster_filter_init_ Z2 A3) = init_)) /\ ((forall B3 C3 : Universe, ((leq_ n0_ B3 /\ (leq_ n0_ C3 /\ (leq_ B3 n3_ /\ leq_ C3 n3_))) -> (a_select3_ r_thruster_filter_init_ B3 C3) = init_)) /\ ((forall D3 E3 : Universe, ((leq_ n0_ D3 /\ (leq_ n0_ E3 /\ (leq_ D3 n5_ /\ leq_ E3 n0_))) -> (a_select3_ xhatmin_thruster_filter_init_ D3 E3) = init_)) /\ ((forall F3 G3 : Universe, ((leq_ n0_ F3 /\ (leq_ n0_ G3 /\ (leq_ F3 n5_ /\ leq_ G3 n5_))) -> (a_select3_ pminus_thruster_filter_init_ F3 G3) = init_)) /\ ((forall H3 I3 : Universe, ((leq_ n0_ H3 /\ (leq_ n0_ I3 /\ (leq_ H3 (minus_ n6_ n1_) /\ leq_ I3 (minus_ n6_ n1_)))) -> (((lt_ I3 (plus_ n1_ pv46_) /\ H3 = pv45_) -> (a_select3_ (tptp_update3_ id_thruster_filter_init_ pv45_ pv46_ init_) H3 I3) = init_) /\ (lt_ H3 pv45_ -> (a_select3_ (tptp_update3_ id_thruster_filter_init_ pv45_ pv46_ init_) H3 I3) = init_)))) /\ (forall J3 : Universe, ((leq_ n0_ J3 /\ leq_ J3 (minus_ pv45_ n1_)) -> (forall K3 : Universe, ((leq_ n0_ K3 /\ leq_ K3 (minus_ n6_ n1_)) -> (a_select3_ (tptp_update3_ id_thruster_filter_init_ pv45_ K3 init_) J3 K3) = init_))))))))))))))))))))) /\ (((init_ = init_ /\ (leq_ n0_ pv5_ /\ (leq_ n0_ pv45_ /\ (leq_ pv5_ n588_ /\ (leq_ pv45_ (minus_ n6_ n1_) /\ ((forall L3 M3 : Universe, ((leq_ n0_ L3 /\ (leq_ n0_ M3 /\ (leq_ L3 n3_ /\ leq_ M3 n5_))) -> (a_select3_ h_thruster_filter_init_ L3 M3) = init_)) /\ ((forall N3 O3 : Universe, ((leq_ n0_ N3 /\ (leq_ n0_ O3 /\ (leq_ N3 n5_ /\ leq_ O3 n5_))) -> (a_select3_ phi_thruster_filter_init_ N3 O3) = init_)) /\ ((forall P3 Q3 : Universe, ((leq_ n0_ P3 /\ (leq_ n0_ Q3 /\ (leq_ P3 (minus_ n6_ n1_) /\ leq_ Q3 n0_))) -> (a_select3_ dv_thruster_filter_init_ P3 Q3) = init_)) /\ ((forall R3 S3 : Universe, ((leq_ n0_ R3 /\ (leq_ n0_ S3 /\ (leq_ R3 n5_ /\ leq_ S3 n5_))) -> (a_select3_ q_thruster_filter_init_ R3 S3) = init_)) /\ ((forall T3 U3 : Universe, ((leq_ n0_ T3 /\ (leq_ n0_ U3 /\ (leq_ T3 n3_ /\ leq_ U3 n3_))) -> (a_select3_ r_thruster_filter_init_ T3 U3) = init_)) /\ ((forall V3 W3 : Universe, ((leq_ n0_ V3 /\ (leq_ n0_ W3 /\ (leq_ V3 n5_ /\ leq_ W3 n0_))) -> (a_select3_ xhatmin_thruster_filter_init_ V3 W3) = init_)) /\ ((forall X3 Y3 : Universe, ((leq_ n0_ X3 /\ (leq_ n0_ Y3 /\ (leq_ X3 n5_ /\ leq_ Y3 n5_))) -> (a_select3_ pminus_thruster_filter_init_ X3 Y3) = init_)) /\ ((forall Z3 A4 : Universe, ((leq_ n0_ Z3 /\ (leq_ n0_ A4 /\ (leq_ Z3 (minus_ n6_ n1_) /\ leq_ A4 (minus_ n6_ n1_)))) -> (((lt_ A4 (plus_ n1_ (minus_ n6_ n1_)) /\ Z3 = pv45_) -> (a_select3_ id_thruster_filter_init_ Z3 A4) = init_) /\ (lt_ Z3 pv45_ -> (a_select3_ id_thruster_filter_init_ Z3 A4) = init_)))) /\ (forall B4 : Universe, ((leq_ n0_ B4 /\ leq_ B4 (minus_ pv45_ n1_)) -> (forall C4 : Universe, ((leq_ n0_ C4 /\ leq_ C4 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_init_ B4 C4) = init_))))))))))))))))) -> (init_ = init_ /\ (leq_ n0_ pv5_ /\ (leq_ n0_ pv45_ /\ (leq_ pv5_ n588_ /\ (leq_ pv45_ (minus_ n6_ n1_) /\ ((forall D4 E4 : Universe, ((leq_ n0_ D4 /\ (leq_ n0_ E4 /\ (leq_ D4 n3_ /\ leq_ E4 n5_))) -> (a_select3_ h_thruster_filter_init_ D4 E4) = init_)) /\ ((forall F4 G4 : Universe, ((leq_ n0_ F4 /\ (leq_ n0_ G4 /\ (leq_ F4 n5_ /\ leq_ G4 n5_))) -> (a_select3_ phi_thruster_filter_init_ F4 G4) = init_)) /\ ((forall H4 I4 : Universe, ((leq_ n0_ H4 /\ (leq_ n0_ I4 /\ (leq_ H4 (minus_ n6_ n1_) /\ leq_ I4 n0_))) -> (a_select3_ dv_thruster_filter_init_ H4 I4) = init_)) /\ ((forall J4 K4 : Universe, ((leq_ n0_ J4 /\ (leq_ n0_ K4 /\ (leq_ J4 n5_ /\ leq_ K4 n5_))) -> (a_select3_ q_thruster_filter_init_ J4 K4) = init_)) /\ ((forall L4 M4 : Universe, ((leq_ n0_ L4 /\ (leq_ n0_ M4 /\ (leq_ L4 n3_ /\ leq_ M4 n3_))) -> (a_select3_ r_thruster_filter_init_ L4 M4) = init_)) /\ ((forall N4 O4 : Universe, ((leq_ n0_ N4 /\ (leq_ n0_ O4 /\ (leq_ N4 n5_ /\ leq_ O4 n0_))) -> (a_select3_ xhatmin_thruster_filter_init_ N4 O4) = init_)) /\ ((forall P4 Q4 : Universe, ((leq_ n0_ P4 /\ (leq_ n0_ Q4 /\ (leq_ P4 n5_ /\ leq_ Q4 n5_))) -> (a_select3_ pminus_thruster_filter_init_ P4 Q4) = init_)) /\ ((forall R4 S4 : Universe, ((leq_ n0_ R4 /\ (leq_ n0_ S4 /\ (leq_ R4 pv45_ /\ leq_ S4 (minus_ n6_ n1_)))) -> (a_select3_ id_thruster_filter_init_ R4 S4) = init_)) /\ (forall T4 : Universe, ((leq_ n0_ T4 /\ leq_ T4 (minus_ pv45_ n1_)) -> (forall U4 : Universe, ((leq_ n0_ U4 /\ leq_ U4 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_init_ T4 U4) = init_)))))))))))))))))) /\ (((init_ = init_ /\ (leq_ n0_ pv5_ /\ (leq_ n0_ pv45_ /\ (leq_ pv5_ n588_ /\ (leq_ pv45_ (minus_ n6_ n1_) /\ ((forall V4 W4 : Universe, ((leq_ n0_ V4 /\ (leq_ n0_ W4 /\ (leq_ V4 n3_ /\ leq_ W4 n5_))) -> (a_select3_ h_thruster_filter_init_ V4 W4) = init_)) /\ ((forall X4 Y4 : Universe, ((leq_ n0_ X4 /\ (leq_ n0_ Y4 /\ (leq_ X4 n5_ /\ leq_ Y4 n5_))) -> (a_select3_ phi_thruster_filter_init_ X4 Y4) = init_)) /\ ((forall Z4 A5 : Universe, ((leq_ n0_ Z4 /\ (leq_ n0_ A5 /\ (leq_ Z4 (minus_ n6_ n1_) /\ leq_ A5 n0_))) -> (a_select3_ dv_thruster_filter_init_ Z4 A5) = init_)) /\ ((forall B5 C5 : Universe, ((leq_ n0_ B5 /\ (leq_ n0_ C5 /\ (leq_ B5 n5_ /\ leq_ C5 n5_))) -> (a_select3_ q_thruster_filter_init_ B5 C5) = init_)) /\ ((forall D5 E5 : Universe, ((leq_ n0_ D5 /\ (leq_ n0_ E5 /\ (leq_ D5 n3_ /\ leq_ E5 n3_))) -> (a_select3_ r_thruster_filter_init_ D5 E5) = init_)) /\ ((forall F5 G5 : Universe, ((leq_ n0_ F5 /\ (leq_ n0_ G5 /\ (leq_ F5 n5_ /\ leq_ G5 n0_))) -> (a_select3_ xhatmin_thruster_filter_init_ F5 G5) = init_)) /\ ((forall H5 I5 : Universe, ((leq_ n0_ H5 /\ (leq_ n0_ I5 /\ (leq_ H5 n5_ /\ leq_ I5 n5_))) -> (a_select3_ pminus_thruster_filter_init_ H5 I5) = init_)) /\ ((forall J5 K5 : Universe, ((leq_ n0_ J5 /\ (leq_ n0_ K5 /\ (leq_ J5 pv45_ /\ leq_ K5 (minus_ n6_ n1_)))) -> (a_select3_ id_thruster_filter_init_ J5 K5) = init_)) /\ (forall L5 : Universe, ((leq_ n0_ L5 /\ leq_ L5 (minus_ pv45_ n1_)) -> (forall M5 : Universe, ((leq_ n0_ M5 /\ leq_ M5 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_init_ L5 M5) = init_))))))))))))))))) -> (init_ = init_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall N5 O5 : Universe, ((leq_ n0_ N5 /\ (leq_ n0_ O5 /\ (leq_ N5 n3_ /\ leq_ O5 n5_))) -> (a_select3_ h_thruster_filter_init_ N5 O5) = init_)) /\ ((forall P5 Q5 : Universe, ((leq_ n0_ P5 /\ (leq_ n0_ Q5 /\ (leq_ P5 n5_ /\ leq_ Q5 n5_))) -> (a_select3_ phi_thruster_filter_init_ P5 Q5) = init_)) /\ ((forall R5 S5 : Universe, ((leq_ n0_ R5 /\ (leq_ n0_ S5 /\ (leq_ R5 (minus_ n6_ n1_) /\ leq_ S5 n0_))) -> (a_select3_ dv_thruster_filter_init_ R5 S5) = init_)) /\ ((forall T5 U5 : Universe, ((leq_ n0_ T5 /\ (leq_ n0_ U5 /\ (leq_ T5 n5_ /\ leq_ U5 n5_))) -> (a_select3_ q_thruster_filter_init_ T5 U5) = init_)) /\ ((forall V5 W5 : Universe, ((leq_ n0_ V5 /\ (leq_ n0_ W5 /\ (leq_ V5 n3_ /\ leq_ W5 n3_))) -> (a_select3_ r_thruster_filter_init_ V5 W5) = init_)) /\ ((forall X5 Y5 : Universe, ((leq_ n0_ X5 /\ (leq_ n0_ Y5 /\ (leq_ X5 n5_ /\ leq_ Y5 n0_))) -> (a_select3_ xhatmin_thruster_filter_init_ X5 Y5) = init_)) /\ ((forall Z5 A6 : Universe, ((leq_ n0_ Z5 /\ (leq_ n0_ A6 /\ (leq_ Z5 n5_ /\ leq_ A6 n5_))) -> (a_select3_ pminus_thruster_filter_init_ Z5 A6) = init_)) /\ (forall B6 : Universe, ((leq_ n0_ B6 /\ leq_ B6 (minus_ (plus_ n1_ pv45_) n1_)) -> (forall C6 : Universe, ((leq_ n0_ C6 /\ leq_ C6 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_init_ B6 C6) = init_))))))))))))))) /\ (((init_ = init_ /\ (leq_ n0_ pv5_ /\ (leq_ n0_ pv45_ /\ (leq_ pv5_ n588_ /\ (leq_ pv45_ (minus_ n6_ n1_) /\ ((forall D6 E6 : Universe, ((leq_ n0_ D6 /\ (leq_ n0_ E6 /\ (leq_ D6 n3_ /\ leq_ E6 n5_))) -> (a_select3_ h_thruster_filter_init_ D6 E6) = init_)) /\ ((forall F6 G6 : Universe, ((leq_ n0_ F6 /\ (leq_ n0_ G6 /\ (leq_ F6 n5_ /\ leq_ G6 n5_))) -> (a_select3_ phi_thruster_filter_init_ F6 G6) = init_)) /\ ((forall H6 I6 : Universe, ((leq_ n0_ H6 /\ (leq_ n0_ I6 /\ (leq_ H6 (minus_ n6_ n1_) /\ leq_ I6 n0_))) -> (a_select3_ dv_thruster_filter_init_ H6 I6) = init_)) /\ ((forall J6 K6 : Universe, ((leq_ n0_ J6 /\ (leq_ n0_ K6 /\ (leq_ J6 n5_ /\ leq_ K6 n5_))) -> (a_select3_ q_thruster_filter_init_ J6 K6) = init_)) /\ ((forall L6 M6 : Universe, ((leq_ n0_ L6 /\ (leq_ n0_ M6 /\ (leq_ L6 n3_ /\ leq_ M6 n3_))) -> (a_select3_ r_thruster_filter_init_ L6 M6) = init_)) /\ ((forall N6 O6 : Universe, ((leq_ n0_ N6 /\ (leq_ n0_ O6 /\ (leq_ N6 n5_ /\ leq_ O6 n0_))) -> (a_select3_ xhatmin_thruster_filter_init_ N6 O6) = init_)) /\ ((forall P6 Q6 : Universe, ((leq_ n0_ P6 /\ (leq_ n0_ Q6 /\ (leq_ P6 n5_ /\ leq_ Q6 n5_))) -> (a_select3_ pminus_thruster_filter_init_ P6 Q6) = init_)) /\ (forall R6 : Universe, ((leq_ n0_ R6 /\ leq_ R6 (minus_ pv45_ n1_)) -> (forall S6 : Universe, ((leq_ n0_ S6 /\ leq_ S6 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_init_ R6 S6) = init_)))))))))))))))) -> (init_ = init_ /\ (leq_ n0_ pv5_ /\ (leq_ n0_ pv45_ /\ (leq_ pv5_ n588_ /\ (leq_ pv45_ (minus_ n6_ n1_) /\ ((forall T6 U6 : Universe, ((leq_ n0_ T6 /\ (leq_ n0_ U6 /\ (leq_ T6 n3_ /\ leq_ U6 n5_))) -> (a_select3_ h_thruster_filter_init_ T6 U6) = init_)) /\ ((forall V6 W6 : Universe, ((leq_ n0_ V6 /\ (leq_ n0_ W6 /\ (leq_ V6 n5_ /\ leq_ W6 n5_))) -> (a_select3_ phi_thruster_filter_init_ V6 W6) = init_)) /\ ((forall X6 Y6 : Universe, ((leq_ n0_ X6 /\ (leq_ n0_ Y6 /\ (leq_ X6 (minus_ n6_ n1_) /\ leq_ Y6 n0_))) -> (a_select3_ dv_thruster_filter_init_ X6 Y6) = init_)) /\ ((forall Z6 A7 : Universe, ((leq_ n0_ Z6 /\ (leq_ n0_ A7 /\ (leq_ Z6 n5_ /\ leq_ A7 n5_))) -> (a_select3_ q_thruster_filter_init_ Z6 A7) = init_)) /\ ((forall B7 C7 : Universe, ((leq_ n0_ B7 /\ (leq_ n0_ C7 /\ (leq_ B7 n3_ /\ leq_ C7 n3_))) -> (a_select3_ r_thruster_filter_init_ B7 C7) = init_)) /\ ((forall D7 E7 : Universe, ((leq_ n0_ D7 /\ (leq_ n0_ E7 /\ (leq_ D7 n5_ /\ leq_ E7 n0_))) -> (a_select3_ xhatmin_thruster_filter_init_ D7 E7) = init_)) /\ ((forall F7 G7 : Universe, ((leq_ n0_ F7 /\ (leq_ n0_ G7 /\ (leq_ F7 n5_ /\ leq_ G7 n5_))) -> (a_select3_ pminus_thruster_filter_init_ F7 G7) = init_)) /\ ((forall H7 I7 : Universe, ((leq_ n0_ H7 /\ (leq_ n0_ I7 /\ (leq_ H7 (minus_ n6_ n1_) /\ leq_ I7 (minus_ n6_ n1_)))) -> (((lt_ I7 n0_ /\ H7 = pv45_) -> (a_select3_ id_thruster_filter_init_ H7 I7) = init_) /\ (lt_ H7 pv45_ -> (a_select3_ id_thruster_filter_init_ H7 I7) = init_)))) /\ (forall J7 : Universe, ((leq_ n0_ J7 /\ leq_ J7 (minus_ pv45_ n1_)) -> (forall K7 : Universe, ((leq_ n0_ K7 /\ leq_ K7 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_init_ J7 K7) = init_)))))))))))))))))) /\ (((init_ = init_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall L7 M7 : Universe, ((leq_ n0_ L7 /\ (leq_ n0_ M7 /\ (leq_ L7 n3_ /\ leq_ M7 n5_))) -> (a_select3_ h_thruster_filter_init_ L7 M7) = init_)) /\ ((forall N7 O7 : Universe, ((leq_ n0_ N7 /\ (leq_ n0_ O7 /\ (leq_ N7 n5_ /\ leq_ O7 n5_))) -> (a_select3_ phi_thruster_filter_init_ N7 O7) = init_)) /\ ((forall P7 Q7 : Universe, ((leq_ n0_ P7 /\ (leq_ n0_ Q7 /\ (leq_ P7 (minus_ n6_ n1_) /\ leq_ Q7 n0_))) -> (a_select3_ dv_thruster_filter_init_ P7 Q7) = init_)) /\ ((forall R7 S7 : Universe, ((leq_ n0_ R7 /\ (leq_ n0_ S7 /\ (leq_ R7 n5_ /\ leq_ S7 n5_))) -> (a_select3_ q_thruster_filter_init_ R7 S7) = init_)) /\ ((forall T7 U7 : Universe, ((leq_ n0_ T7 /\ (leq_ n0_ U7 /\ (leq_ T7 n3_ /\ leq_ U7 n3_))) -> (a_select3_ r_thruster_filter_init_ T7 U7) = init_)) /\ ((forall V7 W7 : Universe, ((leq_ n0_ V7 /\ (leq_ n0_ W7 /\ (leq_ V7 n5_ /\ leq_ W7 n0_))) -> (a_select3_ xhatmin_thruster_filter_init_ V7 W7) = init_)) /\ ((forall X7 Y7 : Universe, ((leq_ n0_ X7 /\ (leq_ n0_ Y7 /\ (leq_ X7 n5_ /\ leq_ Y7 n5_))) -> (a_select3_ pminus_thruster_filter_init_ X7 Y7) = init_)) /\ (forall Z7 : Universe, ((leq_ n0_ Z7 /\ leq_ Z7 (minus_ (plus_ n1_ (minus_ n6_ n1_)) n1_)) -> (forall A8 : Universe, ((leq_ n0_ A8 /\ leq_ A8 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_init_ Z7 A8) = init_)))))))))))))) -> (init_ = init_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall B8 C8 : Universe, ((leq_ n0_ B8 /\ (leq_ n0_ C8 /\ (leq_ B8 n3_ /\ leq_ C8 n5_))) -> (a_select3_ h_thruster_filter_init_ B8 C8) = init_)) /\ ((forall D8 E8 : Universe, ((leq_ n0_ D8 /\ (leq_ n0_ E8 /\ (leq_ D8 n5_ /\ leq_ E8 n5_))) -> (a_select3_ phi_thruster_filter_init_ D8 E8) = init_)) /\ ((forall F8 G8 : Universe, ((leq_ n0_ F8 /\ (leq_ n0_ G8 /\ (leq_ F8 (minus_ n6_ n1_) /\ leq_ G8 n0_))) -> (a_select3_ dv_thruster_filter_init_ F8 G8) = init_)) /\ ((forall H8 I8 : Universe, ((leq_ n0_ H8 /\ (leq_ n0_ I8 /\ (leq_ H8 n5_ /\ leq_ I8 n5_))) -> (a_select3_ q_thruster_filter_init_ H8 I8) = init_)) /\ ((forall J8 K8 : Universe, ((leq_ n0_ J8 /\ (leq_ n0_ K8 /\ (leq_ J8 n3_ /\ leq_ K8 n3_))) -> (a_select3_ r_thruster_filter_init_ J8 K8) = init_)) /\ ((forall L8 M8 : Universe, ((leq_ n0_ L8 /\ (leq_ n0_ M8 /\ (leq_ L8 n5_ /\ leq_ M8 n0_))) -> (a_select3_ xhatmin_thruster_filter_init_ L8 M8) = init_)) /\ ((forall N8 O8 : Universe, ((leq_ n0_ N8 /\ (leq_ n0_ O8 /\ (leq_ N8 n5_ /\ leq_ O8 n5_))) -> (a_select3_ pminus_thruster_filter_init_ N8 O8) = init_)) /\ (forall P8 : Universe, ((leq_ n0_ P8 /\ leq_ P8 (minus_ n6_ n1_)) -> (forall Q8 : Universe, ((leq_ n0_ Q8 /\ leq_ Q8 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_init_ P8 Q8) = init_))))))))))))))) /\ (((init_ = init_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall R8 S8 : Universe, ((leq_ n0_ R8 /\ (leq_ n0_ S8 /\ (leq_ R8 n3_ /\ leq_ S8 n5_))) -> (a_select3_ h_thruster_filter_init_ R8 S8) = init_)) /\ ((forall T8 U8 : Universe, ((leq_ n0_ T8 /\ (leq_ n0_ U8 /\ (leq_ T8 n5_ /\ leq_ U8 n5_))) -> (a_select3_ phi_thruster_filter_init_ T8 U8) = init_)) /\ ((forall V8 W8 : Universe, ((leq_ n0_ V8 /\ (leq_ n0_ W8 /\ (leq_ V8 (minus_ n6_ n1_) /\ leq_ W8 n0_))) -> (a_select3_ dv_thruster_filter_init_ V8 W8) = init_)) /\ ((forall X8 Y8 : Universe, ((leq_ n0_ X8 /\ (leq_ n0_ Y8 /\ (leq_ X8 n5_ /\ leq_ Y8 n5_))) -> (a_select3_ q_thruster_filter_init_ X8 Y8) = init_)) /\ ((forall Z8 A9 : Universe, ((leq_ n0_ Z8 /\ (leq_ n0_ A9 /\ (leq_ Z8 n3_ /\ leq_ A9 n3_))) -> (a_select3_ r_thruster_filter_init_ Z8 A9) = init_)) /\ ((forall B9 C9 : Universe, ((leq_ n0_ B9 /\ (leq_ n0_ C9 /\ (leq_ B9 n5_ /\ leq_ C9 n0_))) -> (a_select3_ xhatmin_thruster_filter_init_ B9 C9) = init_)) /\ ((forall D9 E9 : Universe, ((leq_ n0_ D9 /\ (leq_ n0_ E9 /\ (leq_ D9 n5_ /\ leq_ E9 n5_))) -> (a_select3_ pminus_thruster_filter_init_ D9 E9) = init_)) /\ (forall F9 : Universe, ((leq_ n0_ F9 /\ leq_ F9 (minus_ n6_ n1_)) -> (forall G9 : Universe, ((leq_ n0_ G9 /\ leq_ G9 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_init_ F9 G9) = init_)))))))))))))) -> (init_ = init_ /\ ((a_select3_ xhatmin_thruster_filter_init_ n0_ n0_) = init_ /\ ((a_select3_ xhatmin_thruster_filter_init_ n1_ n0_) = init_ /\ ((a_select3_ xhatmin_thruster_filter_init_ n2_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) init_) n0_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) init_) n1_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) init_) n2_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) init_) n3_ pv5_) = init_ /\ ((~(gt_ pv5_ n0_) -> (init_ = init_ /\ ((~(gt_ pv5_ n0_) -> (init_ = init_ /\ ((~(gt_ pv5_ n0_) -> (init_ = init_ /\ ((~(gt_ pv5_ n0_) -> (init_ = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n0_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n1_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n2_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n3_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n4_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n5_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n6_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n7_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n0_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n1_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n2_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n3_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n4_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n5_ n0_) = init_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall H9 I9 : Universe, ((leq_ n0_ H9 /\ (leq_ n0_ I9 /\ (leq_ H9 n3_ /\ leq_ I9 n5_))) -> (a_select3_ h_thruster_filter_init_ H9 I9) = init_)) /\ ((forall J9 K9 : Universe, ((leq_ n0_ J9 /\ (leq_ n0_ K9 /\ (leq_ J9 n5_ /\ leq_ K9 n5_))) -> (a_select3_ phi_thruster_filter_init_ J9 K9) = init_)) /\ ((forall L9 M9 : Universe, ((leq_ n0_ L9 /\ (leq_ n0_ M9 /\ (leq_ L9 (minus_ n6_ n1_) /\ leq_ M9 n0_))) -> (a_select3_ dv_thruster_filter_init_ L9 M9) = init_)) /\ ((forall N9 O9 : Universe, ((leq_ n0_ N9 /\ (leq_ n0_ O9 /\ (leq_ N9 n5_ /\ leq_ O9 n5_))) -> (a_select3_ q_thruster_filter_init_ N9 O9) = init_)) /\ ((forall P9 Q9 : Universe, ((leq_ n0_ P9 /\ (leq_ n0_ Q9 /\ (leq_ P9 n3_ /\ leq_ Q9 n3_))) -> (a_select3_ r_thruster_filter_init_ P9 Q9) = init_)) /\ ((forall R9 S9 : Universe, ((leq_ n0_ R9 /\ (leq_ n0_ S9 /\ (leq_ R9 n5_ /\ leq_ S9 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ xhatmin_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) n4_ n0_ init_) n5_ n0_ init_) R9 S9) = init_)) /\ ((forall T9 U9 : Universe, ((leq_ n0_ T9 /\ (leq_ n0_ U9 /\ (leq_ T9 n5_ /\ leq_ U9 n5_))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n6_ n1_)) init_) T9 U9) = init_)) /\ ((forall V9 : Universe, ((leq_ n0_ V9 /\ leq_ V9 (minus_ n6_ n1_)) -> (forall W9 : Universe, ((leq_ n0_ W9 /\ leq_ W9 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_init_ V9 W9) = init_)))) /\ ((forall X9 Y9 : Universe, ((leq_ n0_ X9 /\ (leq_ n0_ Y9 /\ (leq_ X9 (minus_ n6_ n1_) /\ leq_ Y9 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_init_ X9 Y9) = init_)) /\ ((forall Z9 A10 : Universe, ((leq_ n0_ Z9 /\ (leq_ n0_ A10 /\ (leq_ Z9 (minus_ n6_ n1_) /\ leq_ A10 (minus_ n6_ n1_)))) -> (a_select3_ phi_thruster_filter_init_ Z9 A10) = init_)) /\ ((forall B10 C10 : Universe, ((leq_ n0_ B10 /\ (leq_ n0_ C10 /\ (leq_ B10 (minus_ n6_ n1_) /\ leq_ C10 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n6_ n1_)) init_) B10 C10) = init_)) /\ ((forall D10 E10 : Universe, ((leq_ n0_ D10 /\ (leq_ n0_ E10 /\ (leq_ D10 (minus_ n6_ n1_) /\ leq_ E10 (minus_ n6_ n1_)))) -> (a_select3_ phi_thruster_filter_init_ D10 E10) = init_)) /\ ((forall F10 G10 : Universe, ((leq_ n0_ F10 /\ (leq_ n0_ G10 /\ (leq_ F10 (minus_ n6_ n1_) /\ leq_ G10 (minus_ n6_ n1_)))) -> (a_select3_ id_thruster_filter_init_ F10 G10) = init_)) /\ ((forall H10 I10 : Universe, ((leq_ n0_ H10 /\ (leq_ n0_ I10 /\ (leq_ H10 (minus_ n6_ n1_) /\ leq_ I10 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n4_ n1_)) init_) H10 I10) = init_)) /\ ((forall J10 K10 : Universe, ((leq_ n0_ J10 /\ (leq_ n0_ K10 /\ (leq_ J10 (minus_ n4_ n1_) /\ leq_ K10 (minus_ n6_ n1_)))) -> (a_select3_ h_thruster_filter_init_ J10 K10) = init_)) /\ ((forall L10 M10 : Universe, ((leq_ n0_ L10 /\ (leq_ n0_ M10 /\ (leq_ L10 (minus_ n6_ n1_) /\ leq_ M10 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ L10 M10) = init_)) /\ ((forall N10 O10 : Universe, ((leq_ n0_ N10 /\ (leq_ n0_ O10 /\ (leq_ N10 (minus_ n6_ n1_) /\ leq_ O10 n0_))) -> (a_select3_ xhatmin_thruster_filter_init_ N10 O10) = init_)) /\ ((forall P10 Q10 : Universe, ((leq_ n0_ P10 /\ (leq_ n0_ Q10 /\ (leq_ P10 (minus_ n6_ n1_) /\ leq_ Q10 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n4_ n1_)) init_) P10 Q10) = init_)) /\ ((forall R10 S10 : Universe, ((leq_ n0_ R10 /\ (leq_ n0_ S10 /\ (leq_ R10 (minus_ n4_ n1_) /\ leq_ S10 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ zhat_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) R10 S10) = init_)) /\ ((forall T10 U10 : Universe, ((leq_ n0_ T10 /\ (leq_ n0_ U10 /\ (leq_ T10 (minus_ n4_ n1_) /\ leq_ U10 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ zpred_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) T10 U10) = init_)) /\ ((forall V10 W10 : Universe, ((leq_ n0_ V10 /\ (leq_ n0_ W10 /\ (leq_ V10 (minus_ n6_ n1_) /\ leq_ W10 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ V10 W10) = init_)) /\ ((forall X10 Y10 : Universe, ((leq_ n0_ X10 /\ (leq_ n0_ Y10 /\ (leq_ X10 (minus_ n4_ n1_) /\ leq_ Y10 (minus_ n6_ n1_)))) -> (a_select3_ h_thruster_filter_init_ X10 Y10) = init_)) /\ ((forall Z10 A11 : Universe, ((leq_ n0_ Z10 /\ (leq_ n0_ A11 /\ (leq_ Z10 (minus_ n4_ n1_) /\ leq_ A11 (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_init_ Z10 A11) = init_)) /\ ((forall B11 C11 : Universe, ((leq_ n0_ B11 /\ (leq_ n0_ C11 /\ (leq_ B11 (minus_ n4_ n1_) /\ leq_ C11 (minus_ n6_ n1_)))) -> (a_select3_ h_thruster_filter_init_ B11 C11) = init_)) /\ ((forall D11 E11 : Universe, ((leq_ n0_ D11 /\ (leq_ n0_ E11 /\ (leq_ D11 (minus_ n6_ n1_) /\ leq_ E11 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ D11 E11) = init_)) /\ (forall F11 G11 : Universe, ((leq_ n0_ F11 /\ (leq_ n0_ G11 /\ (leq_ F11 (minus_ n4_ n1_) /\ leq_ G11 (minus_ n6_ n1_)))) -> (a_select3_ h_thruster_filter_init_ F11 G11) = init_))))))))))))))))))))))))))))))))))))))))))))) /\ (gt_ pv5_ n0_ -> (init_ = init_ /\ ((a_select3_ xhatmin_thruster_filter_init_ n0_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n0_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n1_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n2_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n3_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n4_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n5_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n6_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n7_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n0_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n1_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n2_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n3_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n4_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n5_ n0_) = init_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall H11 I11 : Universe, ((leq_ n0_ H11 /\ (leq_ n0_ I11 /\ (leq_ H11 n3_ /\ leq_ I11 n5_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) H11 I11) = init_)) /\ ((forall J11 K11 : Universe, ((leq_ n0_ J11 /\ (leq_ n0_ K11 /\ (leq_ J11 n5_ /\ leq_ K11 n5_))) -> (a_select3_ phi_thruster_filter_init_ J11 K11) = init_)) /\ ((forall L11 M11 : Universe, ((leq_ n0_ L11 /\ (leq_ n0_ M11 /\ (leq_ L11 (minus_ n6_ n1_) /\ leq_ M11 n0_))) -> (a_select3_ dv_thruster_filter_init_ L11 M11) = init_)) /\ ((forall N11 O11 : Universe, ((leq_ n0_ N11 /\ (leq_ n0_ O11 /\ (leq_ N11 n5_ /\ leq_ O11 n5_))) -> (a_select3_ q_thruster_filter_init_ N11 O11) = init_)) /\ ((forall P11 Q11 : Universe, ((leq_ n0_ P11 /\ (leq_ n0_ Q11 /\ (leq_ P11 n3_ /\ leq_ Q11 n3_))) -> (a_select3_ r_thruster_filter_init_ P11 Q11) = init_)) /\ ((forall R11 S11 : Universe, ((leq_ n0_ R11 /\ (leq_ n0_ S11 /\ (leq_ R11 n5_ /\ leq_ S11 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ xhatmin_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) n4_ n0_ init_) n5_ n0_ init_) R11 S11) = init_)) /\ ((forall T11 U11 : Universe, ((leq_ n0_ T11 /\ (leq_ n0_ U11 /\ (leq_ T11 n5_ /\ leq_ U11 n5_))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n6_ n1_)) init_) T11 U11) = init_)) /\ ((forall V11 : Universe, ((leq_ n0_ V11 /\ leq_ V11 (minus_ n6_ n1_)) -> (forall W11 : Universe, ((leq_ n0_ W11 /\ leq_ W11 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_init_ V11 W11) = init_)))) /\ ((forall X11 Y11 : Universe, ((leq_ n0_ X11 /\ (leq_ n0_ Y11 /\ (leq_ X11 (minus_ n6_ n1_) /\ leq_ Y11 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_init_ X11 Y11) = init_)) /\ ((forall Z11 A12 : Universe, ((leq_ n0_ Z11 /\ (leq_ n0_ A12 /\ (leq_ Z11 (minus_ n6_ n1_) /\ leq_ A12 (minus_ n6_ n1_)))) -> (a_select3_ phi_thruster_filter_init_ Z11 A12) = init_)) /\ ((forall B12 C12 : Universe, ((leq_ n0_ B12 /\ (leq_ n0_ C12 /\ (leq_ B12 (minus_ n6_ n1_) /\ leq_ C12 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n6_ n1_)) init_) B12 C12) = init_)) /\ ((forall D12 E12 : Universe, ((leq_ n0_ D12 /\ (leq_ n0_ E12 /\ (leq_ D12 (minus_ n6_ n1_) /\ leq_ E12 (minus_ n6_ n1_)))) -> (a_select3_ phi_thruster_filter_init_ D12 E12) = init_)) /\ ((forall F12 G12 : Universe, ((leq_ n0_ F12 /\ (leq_ n0_ G12 /\ (leq_ F12 (minus_ n6_ n1_) /\ leq_ G12 (minus_ n6_ n1_)))) -> (a_select3_ id_thruster_filter_init_ F12 G12) = init_)) /\ ((forall H12 I12 : Universe, ((leq_ n0_ H12 /\ (leq_ n0_ I12 /\ (leq_ H12 (minus_ n6_ n1_) /\ leq_ I12 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n4_ n1_)) init_) H12 I12) = init_)) /\ ((forall J12 K12 : Universe, ((leq_ n0_ J12 /\ (leq_ n0_ K12 /\ (leq_ J12 (minus_ n4_ n1_) /\ leq_ K12 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) J12 K12) = init_)) /\ ((forall L12 M12 : Universe, ((leq_ n0_ L12 /\ (leq_ n0_ M12 /\ (leq_ L12 (minus_ n6_ n1_) /\ leq_ M12 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ L12 M12) = init_)) /\ ((forall N12 O12 : Universe, ((leq_ n0_ N12 /\ (leq_ n0_ O12 /\ (leq_ N12 (minus_ n6_ n1_) /\ leq_ O12 n0_))) -> (a_select3_ xhatmin_thruster_filter_init_ N12 O12) = init_)) /\ ((forall P12 Q12 : Universe, ((leq_ n0_ P12 /\ (leq_ n0_ Q12 /\ (leq_ P12 (minus_ n6_ n1_) /\ leq_ Q12 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n4_ n1_)) init_) P12 Q12) = init_)) /\ ((forall R12 S12 : Universe, ((leq_ n0_ R12 /\ (leq_ n0_ S12 /\ (leq_ R12 (minus_ n4_ n1_) /\ leq_ S12 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ zhat_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) R12 S12) = init_)) /\ ((forall T12 U12 : Universe, ((leq_ n0_ T12 /\ (leq_ n0_ U12 /\ (leq_ T12 (minus_ n4_ n1_) /\ leq_ U12 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ zpred_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) T12 U12) = init_)) /\ ((forall V12 W12 : Universe, ((leq_ n0_ V12 /\ (leq_ n0_ W12 /\ (leq_ V12 (minus_ n6_ n1_) /\ leq_ W12 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ V12 W12) = init_)) /\ ((forall X12 Y12 : Universe, ((leq_ n0_ X12 /\ (leq_ n0_ Y12 /\ (leq_ X12 (minus_ n4_ n1_) /\ leq_ Y12 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) X12 Y12) = init_)) /\ ((forall Z12 A13 : Universe, ((leq_ n0_ Z12 /\ (leq_ n0_ A13 /\ (leq_ Z12 (minus_ n4_ n1_) /\ leq_ A13 (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_init_ Z12 A13) = init_)) /\ ((forall B13 C13 : Universe, ((leq_ n0_ B13 /\ (leq_ n0_ C13 /\ (leq_ B13 (minus_ n4_ n1_) /\ leq_ C13 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) B13 C13) = init_)) /\ ((forall D13 E13 : Universe, ((leq_ n0_ D13 /\ (leq_ n0_ E13 /\ (leq_ D13 (minus_ n6_ n1_) /\ leq_ E13 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ D13 E13) = init_)) /\ (forall F13 G13 : Universe, ((leq_ n0_ F13 /\ (leq_ n0_ G13 /\ (leq_ F13 (minus_ n4_ n1_) /\ leq_ G13 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) F13 G13) = init_))))))))))))))))))))))))))))))))))))))))))))))))) /\ (gt_ pv5_ n0_ -> (init_ = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) init_) n0_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) init_) n1_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) init_) n2_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) init_) n3_ pv5_) = init_ /\ ((~(gt_ pv5_ n0_) -> (init_ = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n0_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n1_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n2_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n3_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n4_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n5_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n6_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n7_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n0_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n1_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n2_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n3_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n4_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n5_ n0_) = init_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall H13 I13 : Universe, ((leq_ n0_ H13 /\ (leq_ n0_ I13 /\ (leq_ H13 n3_ /\ leq_ I13 n5_))) -> (a_select3_ h_thruster_filter_init_ H13 I13) = init_)) /\ ((forall J13 K13 : Universe, ((leq_ n0_ J13 /\ (leq_ n0_ K13 /\ (leq_ J13 n5_ /\ leq_ K13 n5_))) -> (a_select3_ phi_thruster_filter_init_ J13 K13) = init_)) /\ ((forall L13 M13 : Universe, ((leq_ n0_ L13 /\ (leq_ n0_ M13 /\ (leq_ L13 (minus_ n6_ n1_) /\ leq_ M13 n0_))) -> (a_select3_ dv_thruster_filter_init_ L13 M13) = init_)) /\ ((forall N13 O13 : Universe, ((leq_ n0_ N13 /\ (leq_ n0_ O13 /\ (leq_ N13 n5_ /\ leq_ O13 n5_))) -> (a_select3_ q_thruster_filter_init_ N13 O13) = init_)) /\ ((forall P13 Q13 : Universe, ((leq_ n0_ P13 /\ (leq_ n0_ Q13 /\ (leq_ P13 n3_ /\ leq_ Q13 n3_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_init_ n3_ n3_ init_) n2_ n2_ init_) n1_ n1_ init_) n0_ n0_ init_) P13 Q13) = init_)) /\ ((forall R13 S13 : Universe, ((leq_ n0_ R13 /\ (leq_ n0_ S13 /\ (leq_ R13 n5_ /\ leq_ S13 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ xhatmin_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) n4_ n0_ init_) n5_ n0_ init_) R13 S13) = init_)) /\ ((forall T13 U13 : Universe, ((leq_ n0_ T13 /\ (leq_ n0_ U13 /\ (leq_ T13 n5_ /\ leq_ U13 n5_))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n6_ n1_)) init_) T13 U13) = init_)) /\ ((forall V13 : Universe, ((leq_ n0_ V13 /\ leq_ V13 (minus_ n6_ n1_)) -> (forall W13 : Universe, ((leq_ n0_ W13 /\ leq_ W13 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_init_ V13 W13) = init_)))) /\ ((forall X13 Y13 : Universe, ((leq_ n0_ X13 /\ (leq_ n0_ Y13 /\ (leq_ X13 (minus_ n6_ n1_) /\ leq_ Y13 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_init_ X13 Y13) = init_)) /\ ((forall Z13 A14 : Universe, ((leq_ n0_ Z13 /\ (leq_ n0_ A14 /\ (leq_ Z13 (minus_ n6_ n1_) /\ leq_ A14 (minus_ n6_ n1_)))) -> (a_select3_ phi_thruster_filter_init_ Z13 A14) = init_)) /\ ((forall B14 C14 : Universe, ((leq_ n0_ B14 /\ (leq_ n0_ C14 /\ (leq_ B14 (minus_ n6_ n1_) /\ leq_ C14 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n6_ n1_)) init_) B14 C14) = init_)) /\ ((forall D14 E14 : Universe, ((leq_ n0_ D14 /\ (leq_ n0_ E14 /\ (leq_ D14 (minus_ n6_ n1_) /\ leq_ E14 (minus_ n6_ n1_)))) -> (a_select3_ phi_thruster_filter_init_ D14 E14) = init_)) /\ ((forall F14 G14 : Universe, ((leq_ n0_ F14 /\ (leq_ n0_ G14 /\ (leq_ F14 (minus_ n6_ n1_) /\ leq_ G14 (minus_ n6_ n1_)))) -> (a_select3_ id_thruster_filter_init_ F14 G14) = init_)) /\ ((forall H14 I14 : Universe, ((leq_ n0_ H14 /\ (leq_ n0_ I14 /\ (leq_ H14 (minus_ n6_ n1_) /\ leq_ I14 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n4_ n1_)) init_) H14 I14) = init_)) /\ ((forall J14 K14 : Universe, ((leq_ n0_ J14 /\ (leq_ n0_ K14 /\ (leq_ J14 (minus_ n4_ n1_) /\ leq_ K14 (minus_ n6_ n1_)))) -> (a_select3_ h_thruster_filter_init_ J14 K14) = init_)) /\ ((forall L14 M14 : Universe, ((leq_ n0_ L14 /\ (leq_ n0_ M14 /\ (leq_ L14 (minus_ n6_ n1_) /\ leq_ M14 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ L14 M14) = init_)) /\ ((forall N14 O14 : Universe, ((leq_ n0_ N14 /\ (leq_ n0_ O14 /\ (leq_ N14 (minus_ n6_ n1_) /\ leq_ O14 n0_))) -> (a_select3_ xhatmin_thruster_filter_init_ N14 O14) = init_)) /\ ((forall P14 Q14 : Universe, ((leq_ n0_ P14 /\ (leq_ n0_ Q14 /\ (leq_ P14 (minus_ n6_ n1_) /\ leq_ Q14 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n4_ n1_)) init_) P14 Q14) = init_)) /\ ((forall R14 S14 : Universe, ((leq_ n0_ R14 /\ (leq_ n0_ S14 /\ (leq_ R14 (minus_ n4_ n1_) /\ leq_ S14 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ zhat_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) R14 S14) = init_)) /\ ((forall T14 U14 : Universe, ((leq_ n0_ T14 /\ (leq_ n0_ U14 /\ (leq_ T14 (minus_ n4_ n1_) /\ leq_ U14 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ zpred_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) T14 U14) = init_)) /\ ((forall V14 W14 : Universe, ((leq_ n0_ V14 /\ (leq_ n0_ W14 /\ (leq_ V14 (minus_ n6_ n1_) /\ leq_ W14 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ V14 W14) = init_)) /\ ((forall X14 Y14 : Universe, ((leq_ n0_ X14 /\ (leq_ n0_ Y14 /\ (leq_ X14 (minus_ n4_ n1_) /\ leq_ Y14 (minus_ n6_ n1_)))) -> (a_select3_ h_thruster_filter_init_ X14 Y14) = init_)) /\ ((forall Z14 A15 : Universe, ((leq_ n0_ Z14 /\ (leq_ n0_ A15 /\ (leq_ Z14 (minus_ n4_ n1_) /\ leq_ A15 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_init_ n3_ n3_ init_) n2_ n2_ init_) n1_ n1_ init_) n0_ n0_ init_) Z14 A15) = init_)) /\ ((forall B15 C15 : Universe, ((leq_ n0_ B15 /\ (leq_ n0_ C15 /\ (leq_ B15 (minus_ n4_ n1_) /\ leq_ C15 (minus_ n6_ n1_)))) -> (a_select3_ h_thruster_filter_init_ B15 C15) = init_)) /\ ((forall D15 E15 : Universe, ((leq_ n0_ D15 /\ (leq_ n0_ E15 /\ (leq_ D15 (minus_ n6_ n1_) /\ leq_ E15 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ D15 E15) = init_)) /\ (forall F15 G15 : Universe, ((leq_ n0_ F15 /\ (leq_ n0_ G15 /\ (leq_ F15 (minus_ n4_ n1_) /\ leq_ G15 (minus_ n6_ n1_)))) -> (a_select3_ h_thruster_filter_init_ F15 G15) = init_))))))))))))))))))))))))))))))))))))))))))))) /\ (gt_ pv5_ n0_ -> (init_ = init_ /\ ((a_select3_ xhatmin_thruster_filter_init_ n0_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n0_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n1_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n2_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n3_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n4_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n5_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n6_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n7_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n0_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n1_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n2_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n3_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n4_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n5_ n0_) = init_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall H15 I15 : Universe, ((leq_ n0_ H15 /\ (leq_ n0_ I15 /\ (leq_ H15 n3_ /\ leq_ I15 n5_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) H15 I15) = init_)) /\ ((forall J15 K15 : Universe, ((leq_ n0_ J15 /\ (leq_ n0_ K15 /\ (leq_ J15 n5_ /\ leq_ K15 n5_))) -> (a_select3_ phi_thruster_filter_init_ J15 K15) = init_)) /\ ((forall L15 M15 : Universe, ((leq_ n0_ L15 /\ (leq_ n0_ M15 /\ (leq_ L15 (minus_ n6_ n1_) /\ leq_ M15 n0_))) -> (a_select3_ dv_thruster_filter_init_ L15 M15) = init_)) /\ ((forall N15 O15 : Universe, ((leq_ n0_ N15 /\ (leq_ n0_ O15 /\ (leq_ N15 n5_ /\ leq_ O15 n5_))) -> (a_select3_ q_thruster_filter_init_ N15 O15) = init_)) /\ ((forall P15 Q15 : Universe, ((leq_ n0_ P15 /\ (leq_ n0_ Q15 /\ (leq_ P15 n3_ /\ leq_ Q15 n3_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_init_ n3_ n3_ init_) n2_ n2_ init_) n1_ n1_ init_) n0_ n0_ init_) P15 Q15) = init_)) /\ ((forall R15 S15 : Universe, ((leq_ n0_ R15 /\ (leq_ n0_ S15 /\ (leq_ R15 n5_ /\ leq_ S15 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ xhatmin_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) n4_ n0_ init_) n5_ n0_ init_) R15 S15) = init_)) /\ ((forall T15 U15 : Universe, ((leq_ n0_ T15 /\ (leq_ n0_ U15 /\ (leq_ T15 n5_ /\ leq_ U15 n5_))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n6_ n1_)) init_) T15 U15) = init_)) /\ ((forall V15 : Universe, ((leq_ n0_ V15 /\ leq_ V15 (minus_ n6_ n1_)) -> (forall W15 : Universe, ((leq_ n0_ W15 /\ leq_ W15 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_init_ V15 W15) = init_)))) /\ ((forall X15 Y15 : Universe, ((leq_ n0_ X15 /\ (leq_ n0_ Y15 /\ (leq_ X15 (minus_ n6_ n1_) /\ leq_ Y15 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_init_ X15 Y15) = init_)) /\ ((forall Z15 A16 : Universe, ((leq_ n0_ Z15 /\ (leq_ n0_ A16 /\ (leq_ Z15 (minus_ n6_ n1_) /\ leq_ A16 (minus_ n6_ n1_)))) -> (a_select3_ phi_thruster_filter_init_ Z15 A16) = init_)) /\ ((forall B16 C16 : Universe, ((leq_ n0_ B16 /\ (leq_ n0_ C16 /\ (leq_ B16 (minus_ n6_ n1_) /\ leq_ C16 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n6_ n1_)) init_) B16 C16) = init_)) /\ ((forall D16 E16 : Universe, ((leq_ n0_ D16 /\ (leq_ n0_ E16 /\ (leq_ D16 (minus_ n6_ n1_) /\ leq_ E16 (minus_ n6_ n1_)))) -> (a_select3_ phi_thruster_filter_init_ D16 E16) = init_)) /\ ((forall F16 G16 : Universe, ((leq_ n0_ F16 /\ (leq_ n0_ G16 /\ (leq_ F16 (minus_ n6_ n1_) /\ leq_ G16 (minus_ n6_ n1_)))) -> (a_select3_ id_thruster_filter_init_ F16 G16) = init_)) /\ ((forall H16 I16 : Universe, ((leq_ n0_ H16 /\ (leq_ n0_ I16 /\ (leq_ H16 (minus_ n6_ n1_) /\ leq_ I16 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n4_ n1_)) init_) H16 I16) = init_)) /\ ((forall J16 K16 : Universe, ((leq_ n0_ J16 /\ (leq_ n0_ K16 /\ (leq_ J16 (minus_ n4_ n1_) /\ leq_ K16 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) J16 K16) = init_)) /\ ((forall L16 M16 : Universe, ((leq_ n0_ L16 /\ (leq_ n0_ M16 /\ (leq_ L16 (minus_ n6_ n1_) /\ leq_ M16 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ L16 M16) = init_)) /\ ((forall N16 O16 : Universe, ((leq_ n0_ N16 /\ (leq_ n0_ O16 /\ (leq_ N16 (minus_ n6_ n1_) /\ leq_ O16 n0_))) -> (a_select3_ xhatmin_thruster_filter_init_ N16 O16) = init_)) /\ ((forall P16 Q16 : Universe, ((leq_ n0_ P16 /\ (leq_ n0_ Q16 /\ (leq_ P16 (minus_ n6_ n1_) /\ leq_ Q16 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n4_ n1_)) init_) P16 Q16) = init_)) /\ ((forall R16 S16 : Universe, ((leq_ n0_ R16 /\ (leq_ n0_ S16 /\ (leq_ R16 (minus_ n4_ n1_) /\ leq_ S16 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ zhat_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) R16 S16) = init_)) /\ ((forall T16 U16 : Universe, ((leq_ n0_ T16 /\ (leq_ n0_ U16 /\ (leq_ T16 (minus_ n4_ n1_) /\ leq_ U16 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ zpred_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) T16 U16) = init_)) /\ ((forall V16 W16 : Universe, ((leq_ n0_ V16 /\ (leq_ n0_ W16 /\ (leq_ V16 (minus_ n6_ n1_) /\ leq_ W16 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ V16 W16) = init_)) /\ ((forall X16 Y16 : Universe, ((leq_ n0_ X16 /\ (leq_ n0_ Y16 /\ (leq_ X16 (minus_ n4_ n1_) /\ leq_ Y16 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) X16 Y16) = init_)) /\ ((forall Z16 A17 : Universe, ((leq_ n0_ Z16 /\ (leq_ n0_ A17 /\ (leq_ Z16 (minus_ n4_ n1_) /\ leq_ A17 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_init_ n3_ n3_ init_) n2_ n2_ init_) n1_ n1_ init_) n0_ n0_ init_) Z16 A17) = init_)) /\ ((forall B17 C17 : Universe, ((leq_ n0_ B17 /\ (leq_ n0_ C17 /\ (leq_ B17 (minus_ n4_ n1_) /\ leq_ C17 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) B17 C17) = init_)) /\ ((forall D17 E17 : Universe, ((leq_ n0_ D17 /\ (leq_ n0_ E17 /\ (leq_ D17 (minus_ n6_ n1_) /\ leq_ E17 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ D17 E17) = init_)) /\ (forall F17 G17 : Universe, ((leq_ n0_ F17 /\ (leq_ n0_ G17 /\ (leq_ F17 (minus_ n4_ n1_) /\ leq_ G17 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) F17 G17) = init_)))))))))))))))))))))))))))))))))))))))))))))))))))))))) /\ (gt_ pv5_ n0_ -> (init_ = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n0_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n1_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n2_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n3_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n4_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n5_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n6_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n7_ pv5_) = init_ /\ ((~(gt_ pv5_ n0_) -> (init_ = init_ /\ ((~(gt_ pv5_ n0_) -> (init_ = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n0_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n1_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n2_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n3_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n4_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n5_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n6_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n7_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n0_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n1_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n2_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n3_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n4_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n5_ n0_) = init_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall H17 I17 : Universe, ((leq_ n0_ H17 /\ (leq_ n0_ I17 /\ (leq_ H17 n3_ /\ leq_ I17 n5_))) -> (a_select3_ h_thruster_filter_init_ H17 I17) = init_)) /\ ((forall J17 K17 : Universe, ((leq_ n0_ J17 /\ (leq_ n0_ K17 /\ (leq_ J17 n5_ /\ leq_ K17 n5_))) -> (a_select3_ phi_thruster_filter_init_ J17 K17) = init_)) /\ ((forall L17 M17 : Universe, ((leq_ n0_ L17 /\ (leq_ n0_ M17 /\ (leq_ L17 (minus_ n6_ n1_) /\ leq_ M17 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ dv_thruster_filter_init_ n3_ n0_ init_) n0_ n0_ init_) L17 M17) = init_)) /\ ((forall N17 O17 : Universe, ((leq_ n0_ N17 /\ (leq_ n0_ O17 /\ (leq_ N17 n5_ /\ leq_ O17 n5_))) -> (a_select3_ q_thruster_filter_init_ N17 O17) = init_)) /\ ((forall P17 Q17 : Universe, ((leq_ n0_ P17 /\ (leq_ n0_ Q17 /\ (leq_ P17 n3_ /\ leq_ Q17 n3_))) -> (a_select3_ r_thruster_filter_init_ P17 Q17) = init_)) /\ ((forall R17 S17 : Universe, ((leq_ n0_ R17 /\ (leq_ n0_ S17 /\ (leq_ R17 n5_ /\ leq_ S17 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ xhatmin_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) n4_ n0_ init_) n5_ n0_ init_) R17 S17) = init_)) /\ ((forall T17 U17 : Universe, ((leq_ n0_ T17 /\ (leq_ n0_ U17 /\ (leq_ T17 n5_ /\ leq_ U17 n5_))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n6_ n1_)) init_) T17 U17) = init_)) /\ ((forall V17 : Universe, ((leq_ n0_ V17 /\ leq_ V17 (minus_ n6_ n1_)) -> (forall W17 : Universe, ((leq_ n0_ W17 /\ leq_ W17 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_init_ V17 W17) = init_)))) /\ ((forall X17 Y17 : Universe, ((leq_ n0_ X17 /\ (leq_ n0_ Y17 /\ (leq_ X17 (minus_ n6_ n1_) /\ leq_ Y17 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_init_ X17 Y17) = init_)) /\ ((forall Z17 A18 : Universe, ((leq_ n0_ Z17 /\ (leq_ n0_ A18 /\ (leq_ Z17 (minus_ n6_ n1_) /\ leq_ A18 (minus_ n6_ n1_)))) -> (a_select3_ phi_thruster_filter_init_ Z17 A18) = init_)) /\ ((forall B18 C18 : Universe, ((leq_ n0_ B18 /\ (leq_ n0_ C18 /\ (leq_ B18 (minus_ n6_ n1_) /\ leq_ C18 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n6_ n1_)) init_) B18 C18) = init_)) /\ ((forall D18 E18 : Universe, ((leq_ n0_ D18 /\ (leq_ n0_ E18 /\ (leq_ D18 (minus_ n6_ n1_) /\ leq_ E18 (minus_ n6_ n1_)))) -> (a_select3_ phi_thruster_filter_init_ D18 E18) = init_)) /\ ((forall F18 G18 : Universe, ((leq_ n0_ F18 /\ (leq_ n0_ G18 /\ (leq_ F18 (minus_ n6_ n1_) /\ leq_ G18 (minus_ n6_ n1_)))) -> (a_select3_ id_thruster_filter_init_ F18 G18) = init_)) /\ ((forall H18 I18 : Universe, ((leq_ n0_ H18 /\ (leq_ n0_ I18 /\ (leq_ H18 (minus_ n6_ n1_) /\ leq_ I18 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n4_ n1_)) init_) H18 I18) = init_)) /\ ((forall J18 K18 : Universe, ((leq_ n0_ J18 /\ (leq_ n0_ K18 /\ (leq_ J18 (minus_ n4_ n1_) /\ leq_ K18 (minus_ n6_ n1_)))) -> (a_select3_ h_thruster_filter_init_ J18 K18) = init_)) /\ ((forall L18 M18 : Universe, ((leq_ n0_ L18 /\ (leq_ n0_ M18 /\ (leq_ L18 (minus_ n6_ n1_) /\ leq_ M18 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ L18 M18) = init_)) /\ ((forall N18 O18 : Universe, ((leq_ n0_ N18 /\ (leq_ n0_ O18 /\ (leq_ N18 (minus_ n6_ n1_) /\ leq_ O18 n0_))) -> (a_select3_ xhatmin_thruster_filter_init_ N18 O18) = init_)) /\ ((forall P18 Q18 : Universe, ((leq_ n0_ P18 /\ (leq_ n0_ Q18 /\ (leq_ P18 (minus_ n6_ n1_) /\ leq_ Q18 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n4_ n1_)) init_) P18 Q18) = init_)) /\ ((forall R18 S18 : Universe, ((leq_ n0_ R18 /\ (leq_ n0_ S18 /\ (leq_ R18 (minus_ n4_ n1_) /\ leq_ S18 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ zhat_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) R18 S18) = init_)) /\ ((forall T18 U18 : Universe, ((leq_ n0_ T18 /\ (leq_ n0_ U18 /\ (leq_ T18 (minus_ n4_ n1_) /\ leq_ U18 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ zpred_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) T18 U18) = init_)) /\ ((forall V18 W18 : Universe, ((leq_ n0_ V18 /\ (leq_ n0_ W18 /\ (leq_ V18 (minus_ n6_ n1_) /\ leq_ W18 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ V18 W18) = init_)) /\ ((forall X18 Y18 : Universe, ((leq_ n0_ X18 /\ (leq_ n0_ Y18 /\ (leq_ X18 (minus_ n4_ n1_) /\ leq_ Y18 (minus_ n6_ n1_)))) -> (a_select3_ h_thruster_filter_init_ X18 Y18) = init_)) /\ ((forall Z18 A19 : Universe, ((leq_ n0_ Z18 /\ (leq_ n0_ A19 /\ (leq_ Z18 (minus_ n4_ n1_) /\ leq_ A19 (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_init_ Z18 A19) = init_)) /\ ((forall B19 C19 : Universe, ((leq_ n0_ B19 /\ (leq_ n0_ C19 /\ (leq_ B19 (minus_ n4_ n1_) /\ leq_ C19 (minus_ n6_ n1_)))) -> (a_select3_ h_thruster_filter_init_ B19 C19) = init_)) /\ ((forall D19 E19 : Universe, ((leq_ n0_ D19 /\ (leq_ n0_ E19 /\ (leq_ D19 (minus_ n6_ n1_) /\ leq_ E19 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ D19 E19) = init_)) /\ (forall F19 G19 : Universe, ((leq_ n0_ F19 /\ (leq_ n0_ G19 /\ (leq_ F19 (minus_ n4_ n1_) /\ leq_ G19 (minus_ n6_ n1_)))) -> (a_select3_ h_thruster_filter_init_ F19 G19) = init_))))))))))))))))))))))))))))))))))))))))))))) /\ (gt_ pv5_ n0_ -> (init_ = init_ /\ ((a_select3_ xhatmin_thruster_filter_init_ n0_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n0_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n1_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n2_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n3_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n4_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n5_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n6_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n7_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n0_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n1_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n2_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n3_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n4_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n5_ n0_) = init_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall H19 I19 : Universe, ((leq_ n0_ H19 /\ (leq_ n0_ I19 /\ (leq_ H19 n3_ /\ leq_ I19 n5_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) H19 I19) = init_)) /\ ((forall J19 K19 : Universe, ((leq_ n0_ J19 /\ (leq_ n0_ K19 /\ (leq_ J19 n5_ /\ leq_ K19 n5_))) -> (a_select3_ phi_thruster_filter_init_ J19 K19) = init_)) /\ ((forall L19 M19 : Universe, ((leq_ n0_ L19 /\ (leq_ n0_ M19 /\ (leq_ L19 (minus_ n6_ n1_) /\ leq_ M19 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ dv_thruster_filter_init_ n3_ n0_ init_) n0_ n0_ init_) L19 M19) = init_)) /\ ((forall N19 O19 : Universe, ((leq_ n0_ N19 /\ (leq_ n0_ O19 /\ (leq_ N19 n5_ /\ leq_ O19 n5_))) -> (a_select3_ q_thruster_filter_init_ N19 O19) = init_)) /\ ((forall P19 Q19 : Universe, ((leq_ n0_ P19 /\ (leq_ n0_ Q19 /\ (leq_ P19 n3_ /\ leq_ Q19 n3_))) -> (a_select3_ r_thruster_filter_init_ P19 Q19) = init_)) /\ ((forall R19 S19 : Universe, ((leq_ n0_ R19 /\ (leq_ n0_ S19 /\ (leq_ R19 n5_ /\ leq_ S19 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ xhatmin_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) n4_ n0_ init_) n5_ n0_ init_) R19 S19) = init_)) /\ ((forall T19 U19 : Universe, ((leq_ n0_ T19 /\ (leq_ n0_ U19 /\ (leq_ T19 n5_ /\ leq_ U19 n5_))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n6_ n1_)) init_) T19 U19) = init_)) /\ ((forall V19 : Universe, ((leq_ n0_ V19 /\ leq_ V19 (minus_ n6_ n1_)) -> (forall W19 : Universe, ((leq_ n0_ W19 /\ leq_ W19 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_init_ V19 W19) = init_)))) /\ ((forall X19 Y19 : Universe, ((leq_ n0_ X19 /\ (leq_ n0_ Y19 /\ (leq_ X19 (minus_ n6_ n1_) /\ leq_ Y19 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_init_ X19 Y19) = init_)) /\ ((forall Z19 A20 : Universe, ((leq_ n0_ Z19 /\ (leq_ n0_ A20 /\ (leq_ Z19 (minus_ n6_ n1_) /\ leq_ A20 (minus_ n6_ n1_)))) -> (a_select3_ phi_thruster_filter_init_ Z19 A20) = init_)) /\ ((forall B20 C20 : Universe, ((leq_ n0_ B20 /\ (leq_ n0_ C20 /\ (leq_ B20 (minus_ n6_ n1_) /\ leq_ C20 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n6_ n1_)) init_) B20 C20) = init_)) /\ ((forall D20 E20 : Universe, ((leq_ n0_ D20 /\ (leq_ n0_ E20 /\ (leq_ D20 (minus_ n6_ n1_) /\ leq_ E20 (minus_ n6_ n1_)))) -> (a_select3_ phi_thruster_filter_init_ D20 E20) = init_)) /\ ((forall F20 G20 : Universe, ((leq_ n0_ F20 /\ (leq_ n0_ G20 /\ (leq_ F20 (minus_ n6_ n1_) /\ leq_ G20 (minus_ n6_ n1_)))) -> (a_select3_ id_thruster_filter_init_ F20 G20) = init_)) /\ ((forall H20 I20 : Universe, ((leq_ n0_ H20 /\ (leq_ n0_ I20 /\ (leq_ H20 (minus_ n6_ n1_) /\ leq_ I20 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n4_ n1_)) init_) H20 I20) = init_)) /\ ((forall J20 K20 : Universe, ((leq_ n0_ J20 /\ (leq_ n0_ K20 /\ (leq_ J20 (minus_ n4_ n1_) /\ leq_ K20 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) J20 K20) = init_)) /\ ((forall L20 M20 : Universe, ((leq_ n0_ L20 /\ (leq_ n0_ M20 /\ (leq_ L20 (minus_ n6_ n1_) /\ leq_ M20 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ L20 M20) = init_)) /\ ((forall N20 O20 : Universe, ((leq_ n0_ N20 /\ (leq_ n0_ O20 /\ (leq_ N20 (minus_ n6_ n1_) /\ leq_ O20 n0_))) -> (a_select3_ xhatmin_thruster_filter_init_ N20 O20) = init_)) /\ ((forall P20 Q20 : Universe, ((leq_ n0_ P20 /\ (leq_ n0_ Q20 /\ (leq_ P20 (minus_ n6_ n1_) /\ leq_ Q20 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n4_ n1_)) init_) P20 Q20) = init_)) /\ ((forall R20 S20 : Universe, ((leq_ n0_ R20 /\ (leq_ n0_ S20 /\ (leq_ R20 (minus_ n4_ n1_) /\ leq_ S20 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ zhat_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) R20 S20) = init_)) /\ ((forall T20 U20 : Universe, ((leq_ n0_ T20 /\ (leq_ n0_ U20 /\ (leq_ T20 (minus_ n4_ n1_) /\ leq_ U20 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ zpred_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) T20 U20) = init_)) /\ ((forall V20 W20 : Universe, ((leq_ n0_ V20 /\ (leq_ n0_ W20 /\ (leq_ V20 (minus_ n6_ n1_) /\ leq_ W20 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ V20 W20) = init_)) /\ ((forall X20 Y20 : Universe, ((leq_ n0_ X20 /\ (leq_ n0_ Y20 /\ (leq_ X20 (minus_ n4_ n1_) /\ leq_ Y20 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) X20 Y20) = init_)) /\ ((forall Z20 A21 : Universe, ((leq_ n0_ Z20 /\ (leq_ n0_ A21 /\ (leq_ Z20 (minus_ n4_ n1_) /\ leq_ A21 (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_init_ Z20 A21) = init_)) /\ ((forall B21 C21 : Universe, ((leq_ n0_ B21 /\ (leq_ n0_ C21 /\ (leq_ B21 (minus_ n4_ n1_) /\ leq_ C21 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) B21 C21) = init_)) /\ ((forall D21 E21 : Universe, ((leq_ n0_ D21 /\ (leq_ n0_ E21 /\ (leq_ D21 (minus_ n6_ n1_) /\ leq_ E21 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ D21 E21) = init_)) /\ (forall F21 G21 : Universe, ((leq_ n0_ F21 /\ (leq_ n0_ G21 /\ (leq_ F21 (minus_ n4_ n1_) /\ leq_ G21 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) F21 G21) = init_))))))))))))))))))))))))))))))))))))))))))))))))) /\ (gt_ pv5_ n0_ -> (init_ = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) init_) n0_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) init_) n1_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) init_) n2_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) init_) n3_ pv5_) = init_ /\ ((~(gt_ pv5_ n0_) -> (init_ = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n0_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n1_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n2_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n3_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n4_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n5_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n6_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n7_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n0_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n1_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n2_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n3_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n4_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n5_ n0_) = init_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall H21 I21 : Universe, ((leq_ n0_ H21 /\ (leq_ n0_ I21 /\ (leq_ H21 n3_ /\ leq_ I21 n5_))) -> (a_select3_ h_thruster_filter_init_ H21 I21) = init_)) /\ ((forall J21 K21 : Universe, ((leq_ n0_ J21 /\ (leq_ n0_ K21 /\ (leq_ J21 n5_ /\ leq_ K21 n5_))) -> (a_select3_ phi_thruster_filter_init_ J21 K21) = init_)) /\ ((forall L21 M21 : Universe, ((leq_ n0_ L21 /\ (leq_ n0_ M21 /\ (leq_ L21 (minus_ n6_ n1_) /\ leq_ M21 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ dv_thruster_filter_init_ n3_ n0_ init_) n0_ n0_ init_) L21 M21) = init_)) /\ ((forall N21 O21 : Universe, ((leq_ n0_ N21 /\ (leq_ n0_ O21 /\ (leq_ N21 n5_ /\ leq_ O21 n5_))) -> (a_select3_ q_thruster_filter_init_ N21 O21) = init_)) /\ ((forall P21 Q21 : Universe, ((leq_ n0_ P21 /\ (leq_ n0_ Q21 /\ (leq_ P21 n3_ /\ leq_ Q21 n3_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_init_ n3_ n3_ init_) n2_ n2_ init_) n1_ n1_ init_) n0_ n0_ init_) P21 Q21) = init_)) /\ ((forall R21 S21 : Universe, ((leq_ n0_ R21 /\ (leq_ n0_ S21 /\ (leq_ R21 n5_ /\ leq_ S21 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ xhatmin_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) n4_ n0_ init_) n5_ n0_ init_) R21 S21) = init_)) /\ ((forall T21 U21 : Universe, ((leq_ n0_ T21 /\ (leq_ n0_ U21 /\ (leq_ T21 n5_ /\ leq_ U21 n5_))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n6_ n1_)) init_) T21 U21) = init_)) /\ ((forall V21 : Universe, ((leq_ n0_ V21 /\ leq_ V21 (minus_ n6_ n1_)) -> (forall W21 : Universe, ((leq_ n0_ W21 /\ leq_ W21 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_init_ V21 W21) = init_)))) /\ ((forall X21 Y21 : Universe, ((leq_ n0_ X21 /\ (leq_ n0_ Y21 /\ (leq_ X21 (minus_ n6_ n1_) /\ leq_ Y21 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_init_ X21 Y21) = init_)) /\ ((forall Z21 A22 : Universe, ((leq_ n0_ Z21 /\ (leq_ n0_ A22 /\ (leq_ Z21 (minus_ n6_ n1_) /\ leq_ A22 (minus_ n6_ n1_)))) -> (a_select3_ phi_thruster_filter_init_ Z21 A22) = init_)) /\ ((forall B22 C22 : Universe, ((leq_ n0_ B22 /\ (leq_ n0_ C22 /\ (leq_ B22 (minus_ n6_ n1_) /\ leq_ C22 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n6_ n1_)) init_) B22 C22) = init_)) /\ ((forall D22 E22 : Universe, ((leq_ n0_ D22 /\ (leq_ n0_ E22 /\ (leq_ D22 (minus_ n6_ n1_) /\ leq_ E22 (minus_ n6_ n1_)))) -> (a_select3_ phi_thruster_filter_init_ D22 E22) = init_)) /\ ((forall F22 G22 : Universe, ((leq_ n0_ F22 /\ (leq_ n0_ G22 /\ (leq_ F22 (minus_ n6_ n1_) /\ leq_ G22 (minus_ n6_ n1_)))) -> (a_select3_ id_thruster_filter_init_ F22 G22) = init_)) /\ ((forall H22 I22 : Universe, ((leq_ n0_ H22 /\ (leq_ n0_ I22 /\ (leq_ H22 (minus_ n6_ n1_) /\ leq_ I22 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n4_ n1_)) init_) H22 I22) = init_)) /\ ((forall J22 K22 : Universe, ((leq_ n0_ J22 /\ (leq_ n0_ K22 /\ (leq_ J22 (minus_ n4_ n1_) /\ leq_ K22 (minus_ n6_ n1_)))) -> (a_select3_ h_thruster_filter_init_ J22 K22) = init_)) /\ ((forall L22 M22 : Universe, ((leq_ n0_ L22 /\ (leq_ n0_ M22 /\ (leq_ L22 (minus_ n6_ n1_) /\ leq_ M22 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ L22 M22) = init_)) /\ ((forall N22 O22 : Universe, ((leq_ n0_ N22 /\ (leq_ n0_ O22 /\ (leq_ N22 (minus_ n6_ n1_) /\ leq_ O22 n0_))) -> (a_select3_ xhatmin_thruster_filter_init_ N22 O22) = init_)) /\ ((forall P22 Q22 : Universe, ((leq_ n0_ P22 /\ (leq_ n0_ Q22 /\ (leq_ P22 (minus_ n6_ n1_) /\ leq_ Q22 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n4_ n1_)) init_) P22 Q22) = init_)) /\ ((forall R22 S22 : Universe, ((leq_ n0_ R22 /\ (leq_ n0_ S22 /\ (leq_ R22 (minus_ n4_ n1_) /\ leq_ S22 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ zhat_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) R22 S22) = init_)) /\ ((forall T22 U22 : Universe, ((leq_ n0_ T22 /\ (leq_ n0_ U22 /\ (leq_ T22 (minus_ n4_ n1_) /\ leq_ U22 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ zpred_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) T22 U22) = init_)) /\ ((forall V22 W22 : Universe, ((leq_ n0_ V22 /\ (leq_ n0_ W22 /\ (leq_ V22 (minus_ n6_ n1_) /\ leq_ W22 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ V22 W22) = init_)) /\ ((forall X22 Y22 : Universe, ((leq_ n0_ X22 /\ (leq_ n0_ Y22 /\ (leq_ X22 (minus_ n4_ n1_) /\ leq_ Y22 (minus_ n6_ n1_)))) -> (a_select3_ h_thruster_filter_init_ X22 Y22) = init_)) /\ ((forall Z22 A23 : Universe, ((leq_ n0_ Z22 /\ (leq_ n0_ A23 /\ (leq_ Z22 (minus_ n4_ n1_) /\ leq_ A23 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_init_ n3_ n3_ init_) n2_ n2_ init_) n1_ n1_ init_) n0_ n0_ init_) Z22 A23) = init_)) /\ ((forall B23 C23 : Universe, ((leq_ n0_ B23 /\ (leq_ n0_ C23 /\ (leq_ B23 (minus_ n4_ n1_) /\ leq_ C23 (minus_ n6_ n1_)))) -> (a_select3_ h_thruster_filter_init_ B23 C23) = init_)) /\ ((forall D23 E23 : Universe, ((leq_ n0_ D23 /\ (leq_ n0_ E23 /\ (leq_ D23 (minus_ n6_ n1_) /\ leq_ E23 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ D23 E23) = init_)) /\ (forall F23 G23 : Universe, ((leq_ n0_ F23 /\ (leq_ n0_ G23 /\ (leq_ F23 (minus_ n4_ n1_) /\ leq_ G23 (minus_ n6_ n1_)))) -> (a_select3_ h_thruster_filter_init_ F23 G23) = init_))))))))))))))))))))))))))))))))))))))))))))) /\ (gt_ pv5_ n0_ -> (init_ = init_ /\ ((a_select3_ xhatmin_thruster_filter_init_ n0_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n0_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n1_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n2_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n3_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n4_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n5_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n6_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n7_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n0_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n1_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n2_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n3_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n4_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n5_ n0_) = init_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall H23 I23 : Universe, ((leq_ n0_ H23 /\ (leq_ n0_ I23 /\ (leq_ H23 n3_ /\ leq_ I23 n5_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) H23 I23) = init_)) /\ ((forall J23 K23 : Universe, ((leq_ n0_ J23 /\ (leq_ n0_ K23 /\ (leq_ J23 n5_ /\ leq_ K23 n5_))) -> (a_select3_ phi_thruster_filter_init_ J23 K23) = init_)) /\ ((forall L23 M23 : Universe, ((leq_ n0_ L23 /\ (leq_ n0_ M23 /\ (leq_ L23 (minus_ n6_ n1_) /\ leq_ M23 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ dv_thruster_filter_init_ n3_ n0_ init_) n0_ n0_ init_) L23 M23) = init_)) /\ ((forall N23 O23 : Universe, ((leq_ n0_ N23 /\ (leq_ n0_ O23 /\ (leq_ N23 n5_ /\ leq_ O23 n5_))) -> (a_select3_ q_thruster_filter_init_ N23 O23) = init_)) /\ ((forall P23 Q23 : Universe, ((leq_ n0_ P23 /\ (leq_ n0_ Q23 /\ (leq_ P23 n3_ /\ leq_ Q23 n3_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_init_ n3_ n3_ init_) n2_ n2_ init_) n1_ n1_ init_) n0_ n0_ init_) P23 Q23) = init_)) /\ ((forall R23 S23 : Universe, ((leq_ n0_ R23 /\ (leq_ n0_ S23 /\ (leq_ R23 n5_ /\ leq_ S23 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ xhatmin_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) n4_ n0_ init_) n5_ n0_ init_) R23 S23) = init_)) /\ ((forall T23 U23 : Universe, ((leq_ n0_ T23 /\ (leq_ n0_ U23 /\ (leq_ T23 n5_ /\ leq_ U23 n5_))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n6_ n1_)) init_) T23 U23) = init_)) /\ ((forall V23 : Universe, ((leq_ n0_ V23 /\ leq_ V23 (minus_ n6_ n1_)) -> (forall W23 : Universe, ((leq_ n0_ W23 /\ leq_ W23 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_init_ V23 W23) = init_)))) /\ ((forall X23 Y23 : Universe, ((leq_ n0_ X23 /\ (leq_ n0_ Y23 /\ (leq_ X23 (minus_ n6_ n1_) /\ leq_ Y23 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_init_ X23 Y23) = init_)) /\ ((forall Z23 A24 : Universe, ((leq_ n0_ Z23 /\ (leq_ n0_ A24 /\ (leq_ Z23 (minus_ n6_ n1_) /\ leq_ A24 (minus_ n6_ n1_)))) -> (a_select3_ phi_thruster_filter_init_ Z23 A24) = init_)) /\ ((forall B24 C24 : Universe, ((leq_ n0_ B24 /\ (leq_ n0_ C24 /\ (leq_ B24 (minus_ n6_ n1_) /\ leq_ C24 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n6_ n1_)) init_) B24 C24) = init_)) /\ ((forall D24 E24 : Universe, ((leq_ n0_ D24 /\ (leq_ n0_ E24 /\ (leq_ D24 (minus_ n6_ n1_) /\ leq_ E24 (minus_ n6_ n1_)))) -> (a_select3_ phi_thruster_filter_init_ D24 E24) = init_)) /\ ((forall F24 G24 : Universe, ((leq_ n0_ F24 /\ (leq_ n0_ G24 /\ (leq_ F24 (minus_ n6_ n1_) /\ leq_ G24 (minus_ n6_ n1_)))) -> (a_select3_ id_thruster_filter_init_ F24 G24) = init_)) /\ ((forall H24 I24 : Universe, ((leq_ n0_ H24 /\ (leq_ n0_ I24 /\ (leq_ H24 (minus_ n6_ n1_) /\ leq_ I24 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n4_ n1_)) init_) H24 I24) = init_)) /\ ((forall J24 K24 : Universe, ((leq_ n0_ J24 /\ (leq_ n0_ K24 /\ (leq_ J24 (minus_ n4_ n1_) /\ leq_ K24 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) J24 K24) = init_)) /\ ((forall L24 M24 : Universe, ((leq_ n0_ L24 /\ (leq_ n0_ M24 /\ (leq_ L24 (minus_ n6_ n1_) /\ leq_ M24 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ L24 M24) = init_)) /\ ((forall N24 O24 : Universe, ((leq_ n0_ N24 /\ (leq_ n0_ O24 /\ (leq_ N24 (minus_ n6_ n1_) /\ leq_ O24 n0_))) -> (a_select3_ xhatmin_thruster_filter_init_ N24 O24) = init_)) /\ ((forall P24 Q24 : Universe, ((leq_ n0_ P24 /\ (leq_ n0_ Q24 /\ (leq_ P24 (minus_ n6_ n1_) /\ leq_ Q24 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n4_ n1_)) init_) P24 Q24) = init_)) /\ ((forall R24 S24 : Universe, ((leq_ n0_ R24 /\ (leq_ n0_ S24 /\ (leq_ R24 (minus_ n4_ n1_) /\ leq_ S24 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ zhat_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) R24 S24) = init_)) /\ ((forall T24 U24 : Universe, ((leq_ n0_ T24 /\ (leq_ n0_ U24 /\ (leq_ T24 (minus_ n4_ n1_) /\ leq_ U24 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ zpred_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) T24 U24) = init_)) /\ ((forall V24 W24 : Universe, ((leq_ n0_ V24 /\ (leq_ n0_ W24 /\ (leq_ V24 (minus_ n6_ n1_) /\ leq_ W24 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ V24 W24) = init_)) /\ ((forall X24 Y24 : Universe, ((leq_ n0_ X24 /\ (leq_ n0_ Y24 /\ (leq_ X24 (minus_ n4_ n1_) /\ leq_ Y24 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) X24 Y24) = init_)) /\ ((forall Z24 A25 : Universe, ((leq_ n0_ Z24 /\ (leq_ n0_ A25 /\ (leq_ Z24 (minus_ n4_ n1_) /\ leq_ A25 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_init_ n3_ n3_ init_) n2_ n2_ init_) n1_ n1_ init_) n0_ n0_ init_) Z24 A25) = init_)) /\ ((forall B25 C25 : Universe, ((leq_ n0_ B25 /\ (leq_ n0_ C25 /\ (leq_ B25 (minus_ n4_ n1_) /\ leq_ C25 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) B25 C25) = init_)) /\ ((forall D25 E25 : Universe, ((leq_ n0_ D25 /\ (leq_ n0_ E25 /\ (leq_ D25 (minus_ n6_ n1_) /\ leq_ E25 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ D25 E25) = init_)) /\ (forall F25 G25 : Universe, ((leq_ n0_ F25 /\ (leq_ n0_ G25 /\ (leq_ F25 (minus_ n4_ n1_) /\ leq_ G25 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) F25 G25) = init_))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))) /\ (gt_ pv5_ n0_ -> (init_ = init_ /\ ((a_select3_ xhatmin_thruster_filter_init_ n0_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n0_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n1_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n2_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n3_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n4_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n5_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n6_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n7_ pv5_) = init_ /\ ((~(gt_ pv5_ n0_) -> (init_ = init_ /\ ((~(gt_ pv5_ n0_) -> (init_ = init_ /\ ((~(gt_ pv5_ n0_) -> (init_ = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n0_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n1_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n2_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n3_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n4_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n5_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n6_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n7_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n0_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n1_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n2_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n3_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n4_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n5_ n0_) = init_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall H25 I25 : Universe, ((leq_ n0_ H25 /\ (leq_ n0_ I25 /\ (leq_ H25 n3_ /\ leq_ I25 n5_))) -> (a_select3_ h_thruster_filter_init_ H25 I25) = init_)) /\ ((forall J25 K25 : Universe, ((leq_ n0_ J25 /\ (leq_ n0_ K25 /\ (leq_ J25 n5_ /\ leq_ K25 n5_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_init_ n5_ n0_ init_) n4_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) J25 K25) = init_)) /\ ((forall L25 M25 : Universe, ((leq_ n0_ L25 /\ (leq_ n0_ M25 /\ (leq_ L25 (minus_ n6_ n1_) /\ leq_ M25 n0_))) -> (a_select3_ dv_thruster_filter_init_ L25 M25) = init_)) /\ ((forall N25 O25 : Universe, ((leq_ n0_ N25 /\ (leq_ n0_ O25 /\ (leq_ N25 n5_ /\ leq_ O25 n5_))) -> (a_select3_ q_thruster_filter_init_ N25 O25) = init_)) /\ ((forall P25 Q25 : Universe, ((leq_ n0_ P25 /\ (leq_ n0_ Q25 /\ (leq_ P25 n3_ /\ leq_ Q25 n3_))) -> (a_select3_ r_thruster_filter_init_ P25 Q25) = init_)) /\ ((forall R25 S25 : Universe, ((leq_ n0_ R25 /\ (leq_ n0_ S25 /\ (leq_ R25 n5_ /\ leq_ S25 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ xhatmin_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) n4_ n0_ init_) n5_ n0_ init_) R25 S25) = init_)) /\ ((forall T25 U25 : Universe, ((leq_ n0_ T25 /\ (leq_ n0_ U25 /\ (leq_ T25 n5_ /\ leq_ U25 n5_))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n6_ n1_)) init_) T25 U25) = init_)) /\ ((forall V25 : Universe, ((leq_ n0_ V25 /\ leq_ V25 (minus_ n6_ n1_)) -> (forall W25 : Universe, ((leq_ n0_ W25 /\ leq_ W25 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_init_ V25 W25) = init_)))) /\ ((forall X25 Y25 : Universe, ((leq_ n0_ X25 /\ (leq_ n0_ Y25 /\ (leq_ X25 (minus_ n6_ n1_) /\ leq_ Y25 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_init_ X25 Y25) = init_)) /\ ((forall Z25 A26 : Universe, ((leq_ n0_ Z25 /\ (leq_ n0_ A26 /\ (leq_ Z25 (minus_ n6_ n1_) /\ leq_ A26 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_init_ n5_ n0_ init_) n4_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) Z25 A26) = init_)) /\ ((forall B26 C26 : Universe, ((leq_ n0_ B26 /\ (leq_ n0_ C26 /\ (leq_ B26 (minus_ n6_ n1_) /\ leq_ C26 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n6_ n1_)) init_) B26 C26) = init_)) /\ ((forall D26 E26 : Universe, ((leq_ n0_ D26 /\ (leq_ n0_ E26 /\ (leq_ D26 (minus_ n6_ n1_) /\ leq_ E26 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_init_ n5_ n0_ init_) n4_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) D26 E26) = init_)) /\ ((forall F26 G26 : Universe, ((leq_ n0_ F26 /\ (leq_ n0_ G26 /\ (leq_ F26 (minus_ n6_ n1_) /\ leq_ G26 (minus_ n6_ n1_)))) -> (a_select3_ id_thruster_filter_init_ F26 G26) = init_)) /\ ((forall H26 I26 : Universe, ((leq_ n0_ H26 /\ (leq_ n0_ I26 /\ (leq_ H26 (minus_ n6_ n1_) /\ leq_ I26 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n4_ n1_)) init_) H26 I26) = init_)) /\ ((forall J26 K26 : Universe, ((leq_ n0_ J26 /\ (leq_ n0_ K26 /\ (leq_ J26 (minus_ n4_ n1_) /\ leq_ K26 (minus_ n6_ n1_)))) -> (a_select3_ h_thruster_filter_init_ J26 K26) = init_)) /\ ((forall L26 M26 : Universe, ((leq_ n0_ L26 /\ (leq_ n0_ M26 /\ (leq_ L26 (minus_ n6_ n1_) /\ leq_ M26 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ L26 M26) = init_)) /\ ((forall N26 O26 : Universe, ((leq_ n0_ N26 /\ (leq_ n0_ O26 /\ (leq_ N26 (minus_ n6_ n1_) /\ leq_ O26 n0_))) -> (a_select3_ xhatmin_thruster_filter_init_ N26 O26) = init_)) /\ ((forall P26 Q26 : Universe, ((leq_ n0_ P26 /\ (leq_ n0_ Q26 /\ (leq_ P26 (minus_ n6_ n1_) /\ leq_ Q26 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n4_ n1_)) init_) P26 Q26) = init_)) /\ ((forall R26 S26 : Universe, ((leq_ n0_ R26 /\ (leq_ n0_ S26 /\ (leq_ R26 (minus_ n4_ n1_) /\ leq_ S26 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ zhat_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) R26 S26) = init_)) /\ ((forall T26 U26 : Universe, ((leq_ n0_ T26 /\ (leq_ n0_ U26 /\ (leq_ T26 (minus_ n4_ n1_) /\ leq_ U26 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ zpred_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) T26 U26) = init_)) /\ ((forall V26 W26 : Universe, ((leq_ n0_ V26 /\ (leq_ n0_ W26 /\ (leq_ V26 (minus_ n6_ n1_) /\ leq_ W26 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ V26 W26) = init_)) /\ ((forall X26 Y26 : Universe, ((leq_ n0_ X26 /\ (leq_ n0_ Y26 /\ (leq_ X26 (minus_ n4_ n1_) /\ leq_ Y26 (minus_ n6_ n1_)))) -> (a_select3_ h_thruster_filter_init_ X26 Y26) = init_)) /\ ((forall Z26 A27 : Universe, ((leq_ n0_ Z26 /\ (leq_ n0_ A27 /\ (leq_ Z26 (minus_ n4_ n1_) /\ leq_ A27 (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_init_ Z26 A27) = init_)) /\ ((forall B27 C27 : Universe, ((leq_ n0_ B27 /\ (leq_ n0_ C27 /\ (leq_ B27 (minus_ n4_ n1_) /\ leq_ C27 (minus_ n6_ n1_)))) -> (a_select3_ h_thruster_filter_init_ B27 C27) = init_)) /\ ((forall D27 E27 : Universe, ((leq_ n0_ D27 /\ (leq_ n0_ E27 /\ (leq_ D27 (minus_ n6_ n1_) /\ leq_ E27 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ D27 E27) = init_)) /\ (forall F27 G27 : Universe, ((leq_ n0_ F27 /\ (leq_ n0_ G27 /\ (leq_ F27 (minus_ n4_ n1_) /\ leq_ G27 (minus_ n6_ n1_)))) -> (a_select3_ h_thruster_filter_init_ F27 G27) = init_))))))))))))))))))))))))))))))))))))))))))))) /\ (gt_ pv5_ n0_ -> (init_ = init_ /\ ((a_select3_ xhatmin_thruster_filter_init_ n0_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n0_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n1_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n2_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n3_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n4_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n5_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n6_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n7_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n0_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n1_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n2_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n3_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n4_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n5_ n0_) = init_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall H27 I27 : Universe, ((leq_ n0_ H27 /\ (leq_ n0_ I27 /\ (leq_ H27 n3_ /\ leq_ I27 n5_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) H27 I27) = init_)) /\ ((forall J27 K27 : Universe, ((leq_ n0_ J27 /\ (leq_ n0_ K27 /\ (leq_ J27 n5_ /\ leq_ K27 n5_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_init_ n5_ n0_ init_) n4_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) J27 K27) = init_)) /\ ((forall L27 M27 : Universe, ((leq_ n0_ L27 /\ (leq_ n0_ M27 /\ (leq_ L27 (minus_ n6_ n1_) /\ leq_ M27 n0_))) -> (a_select3_ dv_thruster_filter_init_ L27 M27) = init_)) /\ ((forall N27 O27 : Universe, ((leq_ n0_ N27 /\ (leq_ n0_ O27 /\ (leq_ N27 n5_ /\ leq_ O27 n5_))) -> (a_select3_ q_thruster_filter_init_ N27 O27) = init_)) /\ ((forall P27 Q27 : Universe, ((leq_ n0_ P27 /\ (leq_ n0_ Q27 /\ (leq_ P27 n3_ /\ leq_ Q27 n3_))) -> (a_select3_ r_thruster_filter_init_ P27 Q27) = init_)) /\ ((forall R27 S27 : Universe, ((leq_ n0_ R27 /\ (leq_ n0_ S27 /\ (leq_ R27 n5_ /\ leq_ S27 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ xhatmin_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) n4_ n0_ init_) n5_ n0_ init_) R27 S27) = init_)) /\ ((forall T27 U27 : Universe, ((leq_ n0_ T27 /\ (leq_ n0_ U27 /\ (leq_ T27 n5_ /\ leq_ U27 n5_))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n6_ n1_)) init_) T27 U27) = init_)) /\ ((forall V27 : Universe, ((leq_ n0_ V27 /\ leq_ V27 (minus_ n6_ n1_)) -> (forall W27 : Universe, ((leq_ n0_ W27 /\ leq_ W27 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_init_ V27 W27) = init_)))) /\ ((forall X27 Y27 : Universe, ((leq_ n0_ X27 /\ (leq_ n0_ Y27 /\ (leq_ X27 (minus_ n6_ n1_) /\ leq_ Y27 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_init_ X27 Y27) = init_)) /\ ((forall Z27 A28 : Universe, ((leq_ n0_ Z27 /\ (leq_ n0_ A28 /\ (leq_ Z27 (minus_ n6_ n1_) /\ leq_ A28 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_init_ n5_ n0_ init_) n4_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) Z27 A28) = init_)) /\ ((forall B28 C28 : Universe, ((leq_ n0_ B28 /\ (leq_ n0_ C28 /\ (leq_ B28 (minus_ n6_ n1_) /\ leq_ C28 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n6_ n1_)) init_) B28 C28) = init_)) /\ ((forall D28 E28 : Universe, ((leq_ n0_ D28 /\ (leq_ n0_ E28 /\ (leq_ D28 (minus_ n6_ n1_) /\ leq_ E28 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_init_ n5_ n0_ init_) n4_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) D28 E28) = init_)) /\ ((forall F28 G28 : Universe, ((leq_ n0_ F28 /\ (leq_ n0_ G28 /\ (leq_ F28 (minus_ n6_ n1_) /\ leq_ G28 (minus_ n6_ n1_)))) -> (a_select3_ id_thruster_filter_init_ F28 G28) = init_)) /\ ((forall H28 I28 : Universe, ((leq_ n0_ H28 /\ (leq_ n0_ I28 /\ (leq_ H28 (minus_ n6_ n1_) /\ leq_ I28 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n4_ n1_)) init_) H28 I28) = init_)) /\ ((forall J28 K28 : Universe, ((leq_ n0_ J28 /\ (leq_ n0_ K28 /\ (leq_ J28 (minus_ n4_ n1_) /\ leq_ K28 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) J28 K28) = init_)) /\ ((forall L28 M28 : Universe, ((leq_ n0_ L28 /\ (leq_ n0_ M28 /\ (leq_ L28 (minus_ n6_ n1_) /\ leq_ M28 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ L28 M28) = init_)) /\ ((forall N28 O28 : Universe, ((leq_ n0_ N28 /\ (leq_ n0_ O28 /\ (leq_ N28 (minus_ n6_ n1_) /\ leq_ O28 n0_))) -> (a_select3_ xhatmin_thruster_filter_init_ N28 O28) = init_)) /\ ((forall P28 Q28 : Universe, ((leq_ n0_ P28 /\ (leq_ n0_ Q28 /\ (leq_ P28 (minus_ n6_ n1_) /\ leq_ Q28 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n4_ n1_)) init_) P28 Q28) = init_)) /\ ((forall R28 S28 : Universe, ((leq_ n0_ R28 /\ (leq_ n0_ S28 /\ (leq_ R28 (minus_ n4_ n1_) /\ leq_ S28 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ zhat_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) R28 S28) = init_)) /\ ((forall T28 U28 : Universe, ((leq_ n0_ T28 /\ (leq_ n0_ U28 /\ (leq_ T28 (minus_ n4_ n1_) /\ leq_ U28 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ zpred_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) T28 U28) = init_)) /\ ((forall V28 W28 : Universe, ((leq_ n0_ V28 /\ (leq_ n0_ W28 /\ (leq_ V28 (minus_ n6_ n1_) /\ leq_ W28 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ V28 W28) = init_)) /\ ((forall X28 Y28 : Universe, ((leq_ n0_ X28 /\ (leq_ n0_ Y28 /\ (leq_ X28 (minus_ n4_ n1_) /\ leq_ Y28 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) X28 Y28) = init_)) /\ ((forall Z28 A29 : Universe, ((leq_ n0_ Z28 /\ (leq_ n0_ A29 /\ (leq_ Z28 (minus_ n4_ n1_) /\ leq_ A29 (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_init_ Z28 A29) = init_)) /\ ((forall B29 C29 : Universe, ((leq_ n0_ B29 /\ (leq_ n0_ C29 /\ (leq_ B29 (minus_ n4_ n1_) /\ leq_ C29 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) B29 C29) = init_)) /\ ((forall D29 E29 : Universe, ((leq_ n0_ D29 /\ (leq_ n0_ E29 /\ (leq_ D29 (minus_ n6_ n1_) /\ leq_ E29 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ D29 E29) = init_)) /\ (forall F29 G29 : Universe, ((leq_ n0_ F29 /\ (leq_ n0_ G29 /\ (leq_ F29 (minus_ n4_ n1_) /\ leq_ G29 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) F29 G29) = init_))))))))))))))))))))))))))))))))))))))))))))))))) /\ (gt_ pv5_ n0_ -> (init_ = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) init_) n0_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) init_) n1_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) init_) n2_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) init_) n3_ pv5_) = init_ /\ ((~(gt_ pv5_ n0_) -> (init_ = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n0_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n1_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n2_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n3_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n4_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n5_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n6_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n7_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n0_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n1_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n2_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n3_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n4_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n5_ n0_) = init_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall H29 I29 : Universe, ((leq_ n0_ H29 /\ (leq_ n0_ I29 /\ (leq_ H29 n3_ /\ leq_ I29 n5_))) -> (a_select3_ h_thruster_filter_init_ H29 I29) = init_)) /\ ((forall J29 K29 : Universe, ((leq_ n0_ J29 /\ (leq_ n0_ K29 /\ (leq_ J29 n5_ /\ leq_ K29 n5_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_init_ n5_ n0_ init_) n4_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) J29 K29) = init_)) /\ ((forall L29 M29 : Universe, ((leq_ n0_ L29 /\ (leq_ n0_ M29 /\ (leq_ L29 (minus_ n6_ n1_) /\ leq_ M29 n0_))) -> (a_select3_ dv_thruster_filter_init_ L29 M29) = init_)) /\ ((forall N29 O29 : Universe, ((leq_ n0_ N29 /\ (leq_ n0_ O29 /\ (leq_ N29 n5_ /\ leq_ O29 n5_))) -> (a_select3_ q_thruster_filter_init_ N29 O29) = init_)) /\ ((forall P29 Q29 : Universe, ((leq_ n0_ P29 /\ (leq_ n0_ Q29 /\ (leq_ P29 n3_ /\ leq_ Q29 n3_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_init_ n3_ n3_ init_) n2_ n2_ init_) n1_ n1_ init_) n0_ n0_ init_) P29 Q29) = init_)) /\ ((forall R29 S29 : Universe, ((leq_ n0_ R29 /\ (leq_ n0_ S29 /\ (leq_ R29 n5_ /\ leq_ S29 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ xhatmin_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) n4_ n0_ init_) n5_ n0_ init_) R29 S29) = init_)) /\ ((forall T29 U29 : Universe, ((leq_ n0_ T29 /\ (leq_ n0_ U29 /\ (leq_ T29 n5_ /\ leq_ U29 n5_))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n6_ n1_)) init_) T29 U29) = init_)) /\ ((forall V29 : Universe, ((leq_ n0_ V29 /\ leq_ V29 (minus_ n6_ n1_)) -> (forall W29 : Universe, ((leq_ n0_ W29 /\ leq_ W29 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_init_ V29 W29) = init_)))) /\ ((forall X29 Y29 : Universe, ((leq_ n0_ X29 /\ (leq_ n0_ Y29 /\ (leq_ X29 (minus_ n6_ n1_) /\ leq_ Y29 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_init_ X29 Y29) = init_)) /\ ((forall Z29 A30 : Universe, ((leq_ n0_ Z29 /\ (leq_ n0_ A30 /\ (leq_ Z29 (minus_ n6_ n1_) /\ leq_ A30 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_init_ n5_ n0_ init_) n4_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) Z29 A30) = init_)) /\ ((forall B30 C30 : Universe, ((leq_ n0_ B30 /\ (leq_ n0_ C30 /\ (leq_ B30 (minus_ n6_ n1_) /\ leq_ C30 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n6_ n1_)) init_) B30 C30) = init_)) /\ ((forall D30 E30 : Universe, ((leq_ n0_ D30 /\ (leq_ n0_ E30 /\ (leq_ D30 (minus_ n6_ n1_) /\ leq_ E30 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_init_ n5_ n0_ init_) n4_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) D30 E30) = init_)) /\ ((forall F30 G30 : Universe, ((leq_ n0_ F30 /\ (leq_ n0_ G30 /\ (leq_ F30 (minus_ n6_ n1_) /\ leq_ G30 (minus_ n6_ n1_)))) -> (a_select3_ id_thruster_filter_init_ F30 G30) = init_)) /\ ((forall H30 I30 : Universe, ((leq_ n0_ H30 /\ (leq_ n0_ I30 /\ (leq_ H30 (minus_ n6_ n1_) /\ leq_ I30 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n4_ n1_)) init_) H30 I30) = init_)) /\ ((forall J30 K30 : Universe, ((leq_ n0_ J30 /\ (leq_ n0_ K30 /\ (leq_ J30 (minus_ n4_ n1_) /\ leq_ K30 (minus_ n6_ n1_)))) -> (a_select3_ h_thruster_filter_init_ J30 K30) = init_)) /\ ((forall L30 M30 : Universe, ((leq_ n0_ L30 /\ (leq_ n0_ M30 /\ (leq_ L30 (minus_ n6_ n1_) /\ leq_ M30 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ L30 M30) = init_)) /\ ((forall N30 O30 : Universe, ((leq_ n0_ N30 /\ (leq_ n0_ O30 /\ (leq_ N30 (minus_ n6_ n1_) /\ leq_ O30 n0_))) -> (a_select3_ xhatmin_thruster_filter_init_ N30 O30) = init_)) /\ ((forall P30 Q30 : Universe, ((leq_ n0_ P30 /\ (leq_ n0_ Q30 /\ (leq_ P30 (minus_ n6_ n1_) /\ leq_ Q30 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n4_ n1_)) init_) P30 Q30) = init_)) /\ ((forall R30 S30 : Universe, ((leq_ n0_ R30 /\ (leq_ n0_ S30 /\ (leq_ R30 (minus_ n4_ n1_) /\ leq_ S30 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ zhat_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) R30 S30) = init_)) /\ ((forall T30 U30 : Universe, ((leq_ n0_ T30 /\ (leq_ n0_ U30 /\ (leq_ T30 (minus_ n4_ n1_) /\ leq_ U30 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ zpred_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) T30 U30) = init_)) /\ ((forall V30 W30 : Universe, ((leq_ n0_ V30 /\ (leq_ n0_ W30 /\ (leq_ V30 (minus_ n6_ n1_) /\ leq_ W30 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ V30 W30) = init_)) /\ ((forall X30 Y30 : Universe, ((leq_ n0_ X30 /\ (leq_ n0_ Y30 /\ (leq_ X30 (minus_ n4_ n1_) /\ leq_ Y30 (minus_ n6_ n1_)))) -> (a_select3_ h_thruster_filter_init_ X30 Y30) = init_)) /\ ((forall Z30 A31 : Universe, ((leq_ n0_ Z30 /\ (leq_ n0_ A31 /\ (leq_ Z30 (minus_ n4_ n1_) /\ leq_ A31 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_init_ n3_ n3_ init_) n2_ n2_ init_) n1_ n1_ init_) n0_ n0_ init_) Z30 A31) = init_)) /\ ((forall B31 C31 : Universe, ((leq_ n0_ B31 /\ (leq_ n0_ C31 /\ (leq_ B31 (minus_ n4_ n1_) /\ leq_ C31 (minus_ n6_ n1_)))) -> (a_select3_ h_thruster_filter_init_ B31 C31) = init_)) /\ ((forall D31 E31 : Universe, ((leq_ n0_ D31 /\ (leq_ n0_ E31 /\ (leq_ D31 (minus_ n6_ n1_) /\ leq_ E31 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ D31 E31) = init_)) /\ (forall F31 G31 : Universe, ((leq_ n0_ F31 /\ (leq_ n0_ G31 /\ (leq_ F31 (minus_ n4_ n1_) /\ leq_ G31 (minus_ n6_ n1_)))) -> (a_select3_ h_thruster_filter_init_ F31 G31) = init_))))))))))))))))))))))))))))))))))))))))))))) /\ (gt_ pv5_ n0_ -> (init_ = init_ /\ ((a_select3_ xhatmin_thruster_filter_init_ n0_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n0_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n1_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n2_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n3_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n4_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n5_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n6_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n7_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n0_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n1_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n2_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n3_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n4_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n5_ n0_) = init_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall H31 I31 : Universe, ((leq_ n0_ H31 /\ (leq_ n0_ I31 /\ (leq_ H31 n3_ /\ leq_ I31 n5_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) H31 I31) = init_)) /\ ((forall J31 K31 : Universe, ((leq_ n0_ J31 /\ (leq_ n0_ K31 /\ (leq_ J31 n5_ /\ leq_ K31 n5_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_init_ n5_ n0_ init_) n4_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) J31 K31) = init_)) /\ ((forall L31 M31 : Universe, ((leq_ n0_ L31 /\ (leq_ n0_ M31 /\ (leq_ L31 (minus_ n6_ n1_) /\ leq_ M31 n0_))) -> (a_select3_ dv_thruster_filter_init_ L31 M31) = init_)) /\ ((forall N31 O31 : Universe, ((leq_ n0_ N31 /\ (leq_ n0_ O31 /\ (leq_ N31 n5_ /\ leq_ O31 n5_))) -> (a_select3_ q_thruster_filter_init_ N31 O31) = init_)) /\ ((forall P31 Q31 : Universe, ((leq_ n0_ P31 /\ (leq_ n0_ Q31 /\ (leq_ P31 n3_ /\ leq_ Q31 n3_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_init_ n3_ n3_ init_) n2_ n2_ init_) n1_ n1_ init_) n0_ n0_ init_) P31 Q31) = init_)) /\ ((forall R31 S31 : Universe, ((leq_ n0_ R31 /\ (leq_ n0_ S31 /\ (leq_ R31 n5_ /\ leq_ S31 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ xhatmin_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) n4_ n0_ init_) n5_ n0_ init_) R31 S31) = init_)) /\ ((forall T31 U31 : Universe, ((leq_ n0_ T31 /\ (leq_ n0_ U31 /\ (leq_ T31 n5_ /\ leq_ U31 n5_))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n6_ n1_)) init_) T31 U31) = init_)) /\ ((forall V31 : Universe, ((leq_ n0_ V31 /\ leq_ V31 (minus_ n6_ n1_)) -> (forall W31 : Universe, ((leq_ n0_ W31 /\ leq_ W31 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_init_ V31 W31) = init_)))) /\ ((forall X31 Y31 : Universe, ((leq_ n0_ X31 /\ (leq_ n0_ Y31 /\ (leq_ X31 (minus_ n6_ n1_) /\ leq_ Y31 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_init_ X31 Y31) = init_)) /\ ((forall Z31 A32 : Universe, ((leq_ n0_ Z31 /\ (leq_ n0_ A32 /\ (leq_ Z31 (minus_ n6_ n1_) /\ leq_ A32 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_init_ n5_ n0_ init_) n4_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) Z31 A32) = init_)) /\ ((forall B32 C32 : Universe, ((leq_ n0_ B32 /\ (leq_ n0_ C32 /\ (leq_ B32 (minus_ n6_ n1_) /\ leq_ C32 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n6_ n1_)) init_) B32 C32) = init_)) /\ ((forall D32 E32 : Universe, ((leq_ n0_ D32 /\ (leq_ n0_ E32 /\ (leq_ D32 (minus_ n6_ n1_) /\ leq_ E32 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_init_ n5_ n0_ init_) n4_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) D32 E32) = init_)) /\ ((forall F32 G32 : Universe, ((leq_ n0_ F32 /\ (leq_ n0_ G32 /\ (leq_ F32 (minus_ n6_ n1_) /\ leq_ G32 (minus_ n6_ n1_)))) -> (a_select3_ id_thruster_filter_init_ F32 G32) = init_)) /\ ((forall H32 I32 : Universe, ((leq_ n0_ H32 /\ (leq_ n0_ I32 /\ (leq_ H32 (minus_ n6_ n1_) /\ leq_ I32 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n4_ n1_)) init_) H32 I32) = init_)) /\ ((forall J32 K32 : Universe, ((leq_ n0_ J32 /\ (leq_ n0_ K32 /\ (leq_ J32 (minus_ n4_ n1_) /\ leq_ K32 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) J32 K32) = init_)) /\ ((forall L32 M32 : Universe, ((leq_ n0_ L32 /\ (leq_ n0_ M32 /\ (leq_ L32 (minus_ n6_ n1_) /\ leq_ M32 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ L32 M32) = init_)) /\ ((forall N32 O32 : Universe, ((leq_ n0_ N32 /\ (leq_ n0_ O32 /\ (leq_ N32 (minus_ n6_ n1_) /\ leq_ O32 n0_))) -> (a_select3_ xhatmin_thruster_filter_init_ N32 O32) = init_)) /\ ((forall P32 Q32 : Universe, ((leq_ n0_ P32 /\ (leq_ n0_ Q32 /\ (leq_ P32 (minus_ n6_ n1_) /\ leq_ Q32 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n4_ n1_)) init_) P32 Q32) = init_)) /\ ((forall R32 S32 : Universe, ((leq_ n0_ R32 /\ (leq_ n0_ S32 /\ (leq_ R32 (minus_ n4_ n1_) /\ leq_ S32 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ zhat_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) R32 S32) = init_)) /\ ((forall T32 U32 : Universe, ((leq_ n0_ T32 /\ (leq_ n0_ U32 /\ (leq_ T32 (minus_ n4_ n1_) /\ leq_ U32 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ zpred_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) T32 U32) = init_)) /\ ((forall V32 W32 : Universe, ((leq_ n0_ V32 /\ (leq_ n0_ W32 /\ (leq_ V32 (minus_ n6_ n1_) /\ leq_ W32 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ V32 W32) = init_)) /\ ((forall X32 Y32 : Universe, ((leq_ n0_ X32 /\ (leq_ n0_ Y32 /\ (leq_ X32 (minus_ n4_ n1_) /\ leq_ Y32 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) X32 Y32) = init_)) /\ ((forall Z32 A33 : Universe, ((leq_ n0_ Z32 /\ (leq_ n0_ A33 /\ (leq_ Z32 (minus_ n4_ n1_) /\ leq_ A33 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_init_ n3_ n3_ init_) n2_ n2_ init_) n1_ n1_ init_) n0_ n0_ init_) Z32 A33) = init_)) /\ ((forall B33 C33 : Universe, ((leq_ n0_ B33 /\ (leq_ n0_ C33 /\ (leq_ B33 (minus_ n4_ n1_) /\ leq_ C33 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) B33 C33) = init_)) /\ ((forall D33 E33 : Universe, ((leq_ n0_ D33 /\ (leq_ n0_ E33 /\ (leq_ D33 (minus_ n6_ n1_) /\ leq_ E33 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ D33 E33) = init_)) /\ (forall F33 G33 : Universe, ((leq_ n0_ F33 /\ (leq_ n0_ G33 /\ (leq_ F33 (minus_ n4_ n1_) /\ leq_ G33 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) F33 G33) = init_)))))))))))))))))))))))))))))))))))))))))))))))))))))))) /\ (gt_ pv5_ n0_ -> (init_ = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n0_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n1_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n2_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n3_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n4_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n5_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n6_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n7_ pv5_) = init_ /\ ((~(gt_ pv5_ n0_) -> (init_ = init_ /\ ((~(gt_ pv5_ n0_) -> (init_ = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n0_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n1_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n2_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n3_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n4_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n5_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n6_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n7_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n0_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n1_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n2_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n3_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n4_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n5_ n0_) = init_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall H33 I33 : Universe, ((leq_ n0_ H33 /\ (leq_ n0_ I33 /\ (leq_ H33 n3_ /\ leq_ I33 n5_))) -> (a_select3_ h_thruster_filter_init_ H33 I33) = init_)) /\ ((forall J33 K33 : Universe, ((leq_ n0_ J33 /\ (leq_ n0_ K33 /\ (leq_ J33 n5_ /\ leq_ K33 n5_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_init_ n5_ n0_ init_) n4_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) J33 K33) = init_)) /\ ((forall L33 M33 : Universe, ((leq_ n0_ L33 /\ (leq_ n0_ M33 /\ (leq_ L33 (minus_ n6_ n1_) /\ leq_ M33 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ dv_thruster_filter_init_ n3_ n0_ init_) n0_ n0_ init_) L33 M33) = init_)) /\ ((forall N33 O33 : Universe, ((leq_ n0_ N33 /\ (leq_ n0_ O33 /\ (leq_ N33 n5_ /\ leq_ O33 n5_))) -> (a_select3_ q_thruster_filter_init_ N33 O33) = init_)) /\ ((forall P33 Q33 : Universe, ((leq_ n0_ P33 /\ (leq_ n0_ Q33 /\ (leq_ P33 n3_ /\ leq_ Q33 n3_))) -> (a_select3_ r_thruster_filter_init_ P33 Q33) = init_)) /\ ((forall R33 S33 : Universe, ((leq_ n0_ R33 /\ (leq_ n0_ S33 /\ (leq_ R33 n5_ /\ leq_ S33 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ xhatmin_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) n4_ n0_ init_) n5_ n0_ init_) R33 S33) = init_)) /\ ((forall T33 U33 : Universe, ((leq_ n0_ T33 /\ (leq_ n0_ U33 /\ (leq_ T33 n5_ /\ leq_ U33 n5_))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n6_ n1_)) init_) T33 U33) = init_)) /\ ((forall V33 : Universe, ((leq_ n0_ V33 /\ leq_ V33 (minus_ n6_ n1_)) -> (forall W33 : Universe, ((leq_ n0_ W33 /\ leq_ W33 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_init_ V33 W33) = init_)))) /\ ((forall X33 Y33 : Universe, ((leq_ n0_ X33 /\ (leq_ n0_ Y33 /\ (leq_ X33 (minus_ n6_ n1_) /\ leq_ Y33 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_init_ X33 Y33) = init_)) /\ ((forall Z33 A34 : Universe, ((leq_ n0_ Z33 /\ (leq_ n0_ A34 /\ (leq_ Z33 (minus_ n6_ n1_) /\ leq_ A34 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_init_ n5_ n0_ init_) n4_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) Z33 A34) = init_)) /\ ((forall B34 C34 : Universe, ((leq_ n0_ B34 /\ (leq_ n0_ C34 /\ (leq_ B34 (minus_ n6_ n1_) /\ leq_ C34 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n6_ n1_)) init_) B34 C34) = init_)) /\ ((forall D34 E34 : Universe, ((leq_ n0_ D34 /\ (leq_ n0_ E34 /\ (leq_ D34 (minus_ n6_ n1_) /\ leq_ E34 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_init_ n5_ n0_ init_) n4_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) D34 E34) = init_)) /\ ((forall F34 G34 : Universe, ((leq_ n0_ F34 /\ (leq_ n0_ G34 /\ (leq_ F34 (minus_ n6_ n1_) /\ leq_ G34 (minus_ n6_ n1_)))) -> (a_select3_ id_thruster_filter_init_ F34 G34) = init_)) /\ ((forall H34 I34 : Universe, ((leq_ n0_ H34 /\ (leq_ n0_ I34 /\ (leq_ H34 (minus_ n6_ n1_) /\ leq_ I34 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n4_ n1_)) init_) H34 I34) = init_)) /\ ((forall J34 K34 : Universe, ((leq_ n0_ J34 /\ (leq_ n0_ K34 /\ (leq_ J34 (minus_ n4_ n1_) /\ leq_ K34 (minus_ n6_ n1_)))) -> (a_select3_ h_thruster_filter_init_ J34 K34) = init_)) /\ ((forall L34 M34 : Universe, ((leq_ n0_ L34 /\ (leq_ n0_ M34 /\ (leq_ L34 (minus_ n6_ n1_) /\ leq_ M34 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ L34 M34) = init_)) /\ ((forall N34 O34 : Universe, ((leq_ n0_ N34 /\ (leq_ n0_ O34 /\ (leq_ N34 (minus_ n6_ n1_) /\ leq_ O34 n0_))) -> (a_select3_ xhatmin_thruster_filter_init_ N34 O34) = init_)) /\ ((forall P34 Q34 : Universe, ((leq_ n0_ P34 /\ (leq_ n0_ Q34 /\ (leq_ P34 (minus_ n6_ n1_) /\ leq_ Q34 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n4_ n1_)) init_) P34 Q34) = init_)) /\ ((forall R34 S34 : Universe, ((leq_ n0_ R34 /\ (leq_ n0_ S34 /\ (leq_ R34 (minus_ n4_ n1_) /\ leq_ S34 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ zhat_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) R34 S34) = init_)) /\ ((forall T34 U34 : Universe, ((leq_ n0_ T34 /\ (leq_ n0_ U34 /\ (leq_ T34 (minus_ n4_ n1_) /\ leq_ U34 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ zpred_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) T34 U34) = init_)) /\ ((forall V34 W34 : Universe, ((leq_ n0_ V34 /\ (leq_ n0_ W34 /\ (leq_ V34 (minus_ n6_ n1_) /\ leq_ W34 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ V34 W34) = init_)) /\ ((forall X34 Y34 : Universe, ((leq_ n0_ X34 /\ (leq_ n0_ Y34 /\ (leq_ X34 (minus_ n4_ n1_) /\ leq_ Y34 (minus_ n6_ n1_)))) -> (a_select3_ h_thruster_filter_init_ X34 Y34) = init_)) /\ ((forall Z34 A35 : Universe, ((leq_ n0_ Z34 /\ (leq_ n0_ A35 /\ (leq_ Z34 (minus_ n4_ n1_) /\ leq_ A35 (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_init_ Z34 A35) = init_)) /\ ((forall B35 C35 : Universe, ((leq_ n0_ B35 /\ (leq_ n0_ C35 /\ (leq_ B35 (minus_ n4_ n1_) /\ leq_ C35 (minus_ n6_ n1_)))) -> (a_select3_ h_thruster_filter_init_ B35 C35) = init_)) /\ ((forall D35 E35 : Universe, ((leq_ n0_ D35 /\ (leq_ n0_ E35 /\ (leq_ D35 (minus_ n6_ n1_) /\ leq_ E35 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ D35 E35) = init_)) /\ (forall F35 G35 : Universe, ((leq_ n0_ F35 /\ (leq_ n0_ G35 /\ (leq_ F35 (minus_ n4_ n1_) /\ leq_ G35 (minus_ n6_ n1_)))) -> (a_select3_ h_thruster_filter_init_ F35 G35) = init_))))))))))))))))))))))))))))))))))))))))))))) /\ (gt_ pv5_ n0_ -> (init_ = init_ /\ ((a_select3_ xhatmin_thruster_filter_init_ n0_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n0_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n1_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n2_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n3_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n4_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n5_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n6_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n7_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n0_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n1_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n2_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n3_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n4_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n5_ n0_) = init_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall H35 I35 : Universe, ((leq_ n0_ H35 /\ (leq_ n0_ I35 /\ (leq_ H35 n3_ /\ leq_ I35 n5_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) H35 I35) = init_)) /\ ((forall J35 K35 : Universe, ((leq_ n0_ J35 /\ (leq_ n0_ K35 /\ (leq_ J35 n5_ /\ leq_ K35 n5_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_init_ n5_ n0_ init_) n4_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) J35 K35) = init_)) /\ ((forall L35 M35 : Universe, ((leq_ n0_ L35 /\ (leq_ n0_ M35 /\ (leq_ L35 (minus_ n6_ n1_) /\ leq_ M35 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ dv_thruster_filter_init_ n3_ n0_ init_) n0_ n0_ init_) L35 M35) = init_)) /\ ((forall N35 O35 : Universe, ((leq_ n0_ N35 /\ (leq_ n0_ O35 /\ (leq_ N35 n5_ /\ leq_ O35 n5_))) -> (a_select3_ q_thruster_filter_init_ N35 O35) = init_)) /\ ((forall P35 Q35 : Universe, ((leq_ n0_ P35 /\ (leq_ n0_ Q35 /\ (leq_ P35 n3_ /\ leq_ Q35 n3_))) -> (a_select3_ r_thruster_filter_init_ P35 Q35) = init_)) /\ ((forall R35 S35 : Universe, ((leq_ n0_ R35 /\ (leq_ n0_ S35 /\ (leq_ R35 n5_ /\ leq_ S35 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ xhatmin_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) n4_ n0_ init_) n5_ n0_ init_) R35 S35) = init_)) /\ ((forall T35 U35 : Universe, ((leq_ n0_ T35 /\ (leq_ n0_ U35 /\ (leq_ T35 n5_ /\ leq_ U35 n5_))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n6_ n1_)) init_) T35 U35) = init_)) /\ ((forall V35 : Universe, ((leq_ n0_ V35 /\ leq_ V35 (minus_ n6_ n1_)) -> (forall W35 : Universe, ((leq_ n0_ W35 /\ leq_ W35 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_init_ V35 W35) = init_)))) /\ ((forall X35 Y35 : Universe, ((leq_ n0_ X35 /\ (leq_ n0_ Y35 /\ (leq_ X35 (minus_ n6_ n1_) /\ leq_ Y35 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_init_ X35 Y35) = init_)) /\ ((forall Z35 A36 : Universe, ((leq_ n0_ Z35 /\ (leq_ n0_ A36 /\ (leq_ Z35 (minus_ n6_ n1_) /\ leq_ A36 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_init_ n5_ n0_ init_) n4_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) Z35 A36) = init_)) /\ ((forall B36 C36 : Universe, ((leq_ n0_ B36 /\ (leq_ n0_ C36 /\ (leq_ B36 (minus_ n6_ n1_) /\ leq_ C36 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n6_ n1_)) init_) B36 C36) = init_)) /\ ((forall D36 E36 : Universe, ((leq_ n0_ D36 /\ (leq_ n0_ E36 /\ (leq_ D36 (minus_ n6_ n1_) /\ leq_ E36 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_init_ n5_ n0_ init_) n4_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) D36 E36) = init_)) /\ ((forall F36 G36 : Universe, ((leq_ n0_ F36 /\ (leq_ n0_ G36 /\ (leq_ F36 (minus_ n6_ n1_) /\ leq_ G36 (minus_ n6_ n1_)))) -> (a_select3_ id_thruster_filter_init_ F36 G36) = init_)) /\ ((forall H36 I36 : Universe, ((leq_ n0_ H36 /\ (leq_ n0_ I36 /\ (leq_ H36 (minus_ n6_ n1_) /\ leq_ I36 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n4_ n1_)) init_) H36 I36) = init_)) /\ ((forall J36 K36 : Universe, ((leq_ n0_ J36 /\ (leq_ n0_ K36 /\ (leq_ J36 (minus_ n4_ n1_) /\ leq_ K36 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) J36 K36) = init_)) /\ ((forall L36 M36 : Universe, ((leq_ n0_ L36 /\ (leq_ n0_ M36 /\ (leq_ L36 (minus_ n6_ n1_) /\ leq_ M36 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ L36 M36) = init_)) /\ ((forall N36 O36 : Universe, ((leq_ n0_ N36 /\ (leq_ n0_ O36 /\ (leq_ N36 (minus_ n6_ n1_) /\ leq_ O36 n0_))) -> (a_select3_ xhatmin_thruster_filter_init_ N36 O36) = init_)) /\ ((forall P36 Q36 : Universe, ((leq_ n0_ P36 /\ (leq_ n0_ Q36 /\ (leq_ P36 (minus_ n6_ n1_) /\ leq_ Q36 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n4_ n1_)) init_) P36 Q36) = init_)) /\ ((forall R36 S36 : Universe, ((leq_ n0_ R36 /\ (leq_ n0_ S36 /\ (leq_ R36 (minus_ n4_ n1_) /\ leq_ S36 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ zhat_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) R36 S36) = init_)) /\ ((forall T36 U36 : Universe, ((leq_ n0_ T36 /\ (leq_ n0_ U36 /\ (leq_ T36 (minus_ n4_ n1_) /\ leq_ U36 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ zpred_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) T36 U36) = init_)) /\ ((forall V36 W36 : Universe, ((leq_ n0_ V36 /\ (leq_ n0_ W36 /\ (leq_ V36 (minus_ n6_ n1_) /\ leq_ W36 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ V36 W36) = init_)) /\ ((forall X36 Y36 : Universe, ((leq_ n0_ X36 /\ (leq_ n0_ Y36 /\ (leq_ X36 (minus_ n4_ n1_) /\ leq_ Y36 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) X36 Y36) = init_)) /\ ((forall Z36 A37 : Universe, ((leq_ n0_ Z36 /\ (leq_ n0_ A37 /\ (leq_ Z36 (minus_ n4_ n1_) /\ leq_ A37 (minus_ n4_ n1_)))) -> (a_select3_ r_thruster_filter_init_ Z36 A37) = init_)) /\ ((forall B37 C37 : Universe, ((leq_ n0_ B37 /\ (leq_ n0_ C37 /\ (leq_ B37 (minus_ n4_ n1_) /\ leq_ C37 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) B37 C37) = init_)) /\ ((forall D37 E37 : Universe, ((leq_ n0_ D37 /\ (leq_ n0_ E37 /\ (leq_ D37 (minus_ n6_ n1_) /\ leq_ E37 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ D37 E37) = init_)) /\ (forall F37 G37 : Universe, ((leq_ n0_ F37 /\ (leq_ n0_ G37 /\ (leq_ F37 (minus_ n4_ n1_) /\ leq_ G37 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) F37 G37) = init_))))))))))))))))))))))))))))))))))))))))))))))))) /\ (gt_ pv5_ n0_ -> (init_ = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) init_) n0_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) init_) n1_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) init_) n2_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) init_) n3_ pv5_) = init_ /\ ((~(gt_ pv5_ n0_) -> (init_ = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n0_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n1_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n2_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n3_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n4_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n5_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n6_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n7_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n0_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n1_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n2_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n3_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n4_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n5_ n0_) = init_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall H37 I37 : Universe, ((leq_ n0_ H37 /\ (leq_ n0_ I37 /\ (leq_ H37 n3_ /\ leq_ I37 n5_))) -> (a_select3_ h_thruster_filter_init_ H37 I37) = init_)) /\ ((forall J37 K37 : Universe, ((leq_ n0_ J37 /\ (leq_ n0_ K37 /\ (leq_ J37 n5_ /\ leq_ K37 n5_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_init_ n5_ n0_ init_) n4_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) J37 K37) = init_)) /\ ((forall L37 M37 : Universe, ((leq_ n0_ L37 /\ (leq_ n0_ M37 /\ (leq_ L37 (minus_ n6_ n1_) /\ leq_ M37 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ dv_thruster_filter_init_ n3_ n0_ init_) n0_ n0_ init_) L37 M37) = init_)) /\ ((forall N37 O37 : Universe, ((leq_ n0_ N37 /\ (leq_ n0_ O37 /\ (leq_ N37 n5_ /\ leq_ O37 n5_))) -> (a_select3_ q_thruster_filter_init_ N37 O37) = init_)) /\ ((forall P37 Q37 : Universe, ((leq_ n0_ P37 /\ (leq_ n0_ Q37 /\ (leq_ P37 n3_ /\ leq_ Q37 n3_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_init_ n3_ n3_ init_) n2_ n2_ init_) n1_ n1_ init_) n0_ n0_ init_) P37 Q37) = init_)) /\ ((forall R37 S37 : Universe, ((leq_ n0_ R37 /\ (leq_ n0_ S37 /\ (leq_ R37 n5_ /\ leq_ S37 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ xhatmin_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) n4_ n0_ init_) n5_ n0_ init_) R37 S37) = init_)) /\ ((forall T37 U37 : Universe, ((leq_ n0_ T37 /\ (leq_ n0_ U37 /\ (leq_ T37 n5_ /\ leq_ U37 n5_))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n6_ n1_)) init_) T37 U37) = init_)) /\ ((forall V37 : Universe, ((leq_ n0_ V37 /\ leq_ V37 (minus_ n6_ n1_)) -> (forall W37 : Universe, ((leq_ n0_ W37 /\ leq_ W37 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_init_ V37 W37) = init_)))) /\ ((forall X37 Y37 : Universe, ((leq_ n0_ X37 /\ (leq_ n0_ Y37 /\ (leq_ X37 (minus_ n6_ n1_) /\ leq_ Y37 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_init_ X37 Y37) = init_)) /\ ((forall Z37 A38 : Universe, ((leq_ n0_ Z37 /\ (leq_ n0_ A38 /\ (leq_ Z37 (minus_ n6_ n1_) /\ leq_ A38 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_init_ n5_ n0_ init_) n4_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) Z37 A38) = init_)) /\ ((forall B38 C38 : Universe, ((leq_ n0_ B38 /\ (leq_ n0_ C38 /\ (leq_ B38 (minus_ n6_ n1_) /\ leq_ C38 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n6_ n1_)) init_) B38 C38) = init_)) /\ ((forall D38 E38 : Universe, ((leq_ n0_ D38 /\ (leq_ n0_ E38 /\ (leq_ D38 (minus_ n6_ n1_) /\ leq_ E38 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_init_ n5_ n0_ init_) n4_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) D38 E38) = init_)) /\ ((forall F38 G38 : Universe, ((leq_ n0_ F38 /\ (leq_ n0_ G38 /\ (leq_ F38 (minus_ n6_ n1_) /\ leq_ G38 (minus_ n6_ n1_)))) -> (a_select3_ id_thruster_filter_init_ F38 G38) = init_)) /\ ((forall H38 I38 : Universe, ((leq_ n0_ H38 /\ (leq_ n0_ I38 /\ (leq_ H38 (minus_ n6_ n1_) /\ leq_ I38 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n4_ n1_)) init_) H38 I38) = init_)) /\ ((forall J38 K38 : Universe, ((leq_ n0_ J38 /\ (leq_ n0_ K38 /\ (leq_ J38 (minus_ n4_ n1_) /\ leq_ K38 (minus_ n6_ n1_)))) -> (a_select3_ h_thruster_filter_init_ J38 K38) = init_)) /\ ((forall L38 M38 : Universe, ((leq_ n0_ L38 /\ (leq_ n0_ M38 /\ (leq_ L38 (minus_ n6_ n1_) /\ leq_ M38 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ L38 M38) = init_)) /\ ((forall N38 O38 : Universe, ((leq_ n0_ N38 /\ (leq_ n0_ O38 /\ (leq_ N38 (minus_ n6_ n1_) /\ leq_ O38 n0_))) -> (a_select3_ xhatmin_thruster_filter_init_ N38 O38) = init_)) /\ ((forall P38 Q38 : Universe, ((leq_ n0_ P38 /\ (leq_ n0_ Q38 /\ (leq_ P38 (minus_ n6_ n1_) /\ leq_ Q38 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n4_ n1_)) init_) P38 Q38) = init_)) /\ ((forall R38 S38 : Universe, ((leq_ n0_ R38 /\ (leq_ n0_ S38 /\ (leq_ R38 (minus_ n4_ n1_) /\ leq_ S38 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ zhat_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) R38 S38) = init_)) /\ ((forall T38 U38 : Universe, ((leq_ n0_ T38 /\ (leq_ n0_ U38 /\ (leq_ T38 (minus_ n4_ n1_) /\ leq_ U38 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ zpred_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) T38 U38) = init_)) /\ ((forall V38 W38 : Universe, ((leq_ n0_ V38 /\ (leq_ n0_ W38 /\ (leq_ V38 (minus_ n6_ n1_) /\ leq_ W38 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ V38 W38) = init_)) /\ ((forall X38 Y38 : Universe, ((leq_ n0_ X38 /\ (leq_ n0_ Y38 /\ (leq_ X38 (minus_ n4_ n1_) /\ leq_ Y38 (minus_ n6_ n1_)))) -> (a_select3_ h_thruster_filter_init_ X38 Y38) = init_)) /\ ((forall Z38 A39 : Universe, ((leq_ n0_ Z38 /\ (leq_ n0_ A39 /\ (leq_ Z38 (minus_ n4_ n1_) /\ leq_ A39 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_init_ n3_ n3_ init_) n2_ n2_ init_) n1_ n1_ init_) n0_ n0_ init_) Z38 A39) = init_)) /\ ((forall B39 C39 : Universe, ((leq_ n0_ B39 /\ (leq_ n0_ C39 /\ (leq_ B39 (minus_ n4_ n1_) /\ leq_ C39 (minus_ n6_ n1_)))) -> (a_select3_ h_thruster_filter_init_ B39 C39) = init_)) /\ ((forall D39 E39 : Universe, ((leq_ n0_ D39 /\ (leq_ n0_ E39 /\ (leq_ D39 (minus_ n6_ n1_) /\ leq_ E39 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ D39 E39) = init_)) /\ (forall F39 G39 : Universe, ((leq_ n0_ F39 /\ (leq_ n0_ G39 /\ (leq_ F39 (minus_ n4_ n1_) /\ leq_ G39 (minus_ n6_ n1_)))) -> (a_select3_ h_thruster_filter_init_ F39 G39) = init_))))))))))))))))))))))))))))))))))))))))))))) /\ (gt_ pv5_ n0_ -> (init_ = init_ /\ ((a_select3_ xhatmin_thruster_filter_init_ n0_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n0_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n1_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n2_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n3_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n4_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n5_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n6_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n7_ pv5_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n0_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n1_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n2_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n3_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n4_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ n0_) init_) n5_ n0_) = init_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall H39 I39 : Universe, ((leq_ n0_ H39 /\ (leq_ n0_ I39 /\ (leq_ H39 n3_ /\ leq_ I39 n5_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) H39 I39) = init_)) /\ ((forall J39 K39 : Universe, ((leq_ n0_ J39 /\ (leq_ n0_ K39 /\ (leq_ J39 n5_ /\ leq_ K39 n5_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_init_ n5_ n0_ init_) n4_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) J39 K39) = init_)) /\ ((forall L39 M39 : Universe, ((leq_ n0_ L39 /\ (leq_ n0_ M39 /\ (leq_ L39 (minus_ n6_ n1_) /\ leq_ M39 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ dv_thruster_filter_init_ n3_ n0_ init_) n0_ n0_ init_) L39 M39) = init_)) /\ ((forall N39 O39 : Universe, ((leq_ n0_ N39 /\ (leq_ n0_ O39 /\ (leq_ N39 n5_ /\ leq_ O39 n5_))) -> (a_select3_ q_thruster_filter_init_ N39 O39) = init_)) /\ ((forall P39 Q39 : Universe, ((leq_ n0_ P39 /\ (leq_ n0_ Q39 /\ (leq_ P39 n3_ /\ leq_ Q39 n3_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_init_ n3_ n3_ init_) n2_ n2_ init_) n1_ n1_ init_) n0_ n0_ init_) P39 Q39) = init_)) /\ ((forall R39 S39 : Universe, ((leq_ n0_ R39 /\ (leq_ n0_ S39 /\ (leq_ R39 n5_ /\ leq_ S39 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ xhatmin_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) n4_ n0_ init_) n5_ n0_ init_) R39 S39) = init_)) /\ ((forall T39 U39 : Universe, ((leq_ n0_ T39 /\ (leq_ n0_ U39 /\ (leq_ T39 n5_ /\ leq_ U39 n5_))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n6_ n1_)) init_) T39 U39) = init_)) /\ ((forall V39 : Universe, ((leq_ n0_ V39 /\ leq_ V39 (minus_ n6_ n1_)) -> (forall W39 : Universe, ((leq_ n0_ W39 /\ leq_ W39 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_init_ V39 W39) = init_)))) /\ ((forall X39 Y39 : Universe, ((leq_ n0_ X39 /\ (leq_ n0_ Y39 /\ (leq_ X39 (minus_ n6_ n1_) /\ leq_ Y39 (minus_ n6_ n1_)))) -> (a_select3_ q_thruster_filter_init_ X39 Y39) = init_)) /\ ((forall Z39 A40 : Universe, ((leq_ n0_ Z39 /\ (leq_ n0_ A40 /\ (leq_ Z39 (minus_ n6_ n1_) /\ leq_ A40 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_init_ n5_ n0_ init_) n4_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) Z39 A40) = init_)) /\ ((forall B40 C40 : Universe, ((leq_ n0_ B40 /\ (leq_ n0_ C40 /\ (leq_ B40 (minus_ n6_ n1_) /\ leq_ C40 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n6_ n1_)) init_) B40 C40) = init_)) /\ ((forall D40 E40 : Universe, ((leq_ n0_ D40 /\ (leq_ n0_ E40 /\ (leq_ D40 (minus_ n6_ n1_) /\ leq_ E40 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_init_ n5_ n0_ init_) n4_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) D40 E40) = init_)) /\ ((forall F40 G40 : Universe, ((leq_ n0_ F40 /\ (leq_ n0_ G40 /\ (leq_ F40 (minus_ n6_ n1_) /\ leq_ G40 (minus_ n6_ n1_)))) -> (a_select3_ id_thruster_filter_init_ F40 G40) = init_)) /\ ((forall H40 I40 : Universe, ((leq_ n0_ H40 /\ (leq_ n0_ I40 /\ (leq_ H40 (minus_ n6_ n1_) /\ leq_ I40 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n4_ n1_)) init_) H40 I40) = init_)) /\ ((forall J40 K40 : Universe, ((leq_ n0_ J40 /\ (leq_ n0_ K40 /\ (leq_ J40 (minus_ n4_ n1_) /\ leq_ K40 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) J40 K40) = init_)) /\ ((forall L40 M40 : Universe, ((leq_ n0_ L40 /\ (leq_ n0_ M40 /\ (leq_ L40 (minus_ n6_ n1_) /\ leq_ M40 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ L40 M40) = init_)) /\ ((forall N40 O40 : Universe, ((leq_ n0_ N40 /\ (leq_ n0_ O40 /\ (leq_ N40 (minus_ n6_ n1_) /\ leq_ O40 n0_))) -> (a_select3_ xhatmin_thruster_filter_init_ N40 O40) = init_)) /\ ((forall P40 Q40 : Universe, ((leq_ n0_ P40 /\ (leq_ n0_ Q40 /\ (leq_ P40 (minus_ n6_ n1_) /\ leq_ Q40 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n4_ n1_)) init_) P40 Q40) = init_)) /\ ((forall R40 S40 : Universe, ((leq_ n0_ R40 /\ (leq_ n0_ S40 /\ (leq_ R40 (minus_ n4_ n1_) /\ leq_ S40 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ zhat_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) R40 S40) = init_)) /\ ((forall T40 U40 : Universe, ((leq_ n0_ T40 /\ (leq_ n0_ U40 /\ (leq_ T40 (minus_ n4_ n1_) /\ leq_ U40 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ zpred_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) T40 U40) = init_)) /\ ((forall V40 W40 : Universe, ((leq_ n0_ V40 /\ (leq_ n0_ W40 /\ (leq_ V40 (minus_ n6_ n1_) /\ leq_ W40 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ V40 W40) = init_)) /\ ((forall X40 Y40 : Universe, ((leq_ n0_ X40 /\ (leq_ n0_ Y40 /\ (leq_ X40 (minus_ n4_ n1_) /\ leq_ Y40 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) X40 Y40) = init_)) /\ ((forall Z40 A41 : Universe, ((leq_ n0_ Z40 /\ (leq_ n0_ A41 /\ (leq_ Z40 (minus_ n4_ n1_) /\ leq_ A41 (minus_ n4_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_init_ n3_ n3_ init_) n2_ n2_ init_) n1_ n1_ init_) n0_ n0_ init_) Z40 A41) = init_)) /\ ((forall B41 C41 : Universe, ((leq_ n0_ B41 /\ (leq_ n0_ C41 /\ (leq_ B41 (minus_ n4_ n1_) /\ leq_ C41 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) B41 C41) = init_)) /\ ((forall D41 E41 : Universe, ((leq_ n0_ D41 /\ (leq_ n0_ E41 /\ (leq_ D41 (minus_ n6_ n1_) /\ leq_ E41 (minus_ n6_ n1_)))) -> (a_select3_ pminus_thruster_filter_init_ D41 E41) = init_)) /\ (forall F41 G41 : Universe, ((leq_ n0_ F41 /\ (leq_ n0_ G41 /\ (leq_ F41 (minus_ n4_ n1_) /\ leq_ G41 (minus_ n6_ n1_)))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ h_thruster_filter_init_ n3_ n0_ init_) n2_ n0_ init_) n1_ n0_ init_) n0_ n0_ init_) F41 G41) = init_)))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))) /\ (((init_ = init_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall H41 I41 : Universe, ((leq_ n0_ H41 /\ (leq_ n0_ I41 /\ (leq_ H41 n3_ /\ leq_ I41 n5_))) -> (a_select3_ h_thruster_filter_init_ H41 I41) = init_)) /\ ((forall J41 K41 : Universe, ((leq_ n0_ J41 /\ (leq_ n0_ K41 /\ (leq_ J41 n5_ /\ leq_ K41 n5_))) -> (a_select3_ phi_thruster_filter_init_ J41 K41) = init_)) /\ ((forall L41 M41 : Universe, ((leq_ n0_ L41 /\ (leq_ n0_ M41 /\ (leq_ L41 (minus_ n6_ n1_) /\ leq_ M41 n0_))) -> (a_select3_ dv_thruster_filter_init_ L41 M41) = init_)) /\ ((forall N41 O41 : Universe, ((leq_ n0_ N41 /\ (leq_ n0_ O41 /\ (leq_ N41 n5_ /\ leq_ O41 n5_))) -> (a_select3_ q_thruster_filter_init_ N41 O41) = init_)) /\ ((forall P41 Q41 : Universe, ((leq_ n0_ P41 /\ (leq_ n0_ Q41 /\ (leq_ P41 n3_ /\ leq_ Q41 n3_))) -> (a_select3_ r_thruster_filter_init_ P41 Q41) = init_)) /\ ((forall R41 S41 : Universe, ((leq_ n0_ R41 /\ (leq_ n0_ S41 /\ (leq_ R41 n5_ /\ leq_ S41 n0_))) -> (a_select3_ xhatmin_thruster_filter_init_ R41 S41) = init_)) /\ ((forall T41 U41 : Universe, ((leq_ n0_ T41 /\ (leq_ n0_ U41 /\ (leq_ T41 n5_ /\ leq_ U41 n5_))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n6_ n1_)) init_) T41 U41) = init_)) /\ (forall V41 : Universe, ((leq_ n0_ V41 /\ leq_ V41 (minus_ n6_ n1_)) -> (forall W41 : Universe, ((leq_ n0_ W41 /\ leq_ W41 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_init_ V41 W41) = init_)))))))))))))) -> ((forall X41 Y41 : Universe, ((leq_ n0_ X41 /\ (leq_ n0_ Y41 /\ (leq_ X41 n3_ /\ leq_ Y41 n5_))) -> (a_select3_ h_thruster_filter_init_ X41 Y41) = init_)) /\ ((forall Z41 A42 : Universe, ((leq_ n0_ Z41 /\ (leq_ n0_ A42 /\ (leq_ Z41 n5_ /\ leq_ A42 n5_))) -> (a_select3_ phi_thruster_filter_init_ Z41 A42) = init_)) /\ ((forall B42 C42 : Universe, ((leq_ n0_ B42 /\ (leq_ n0_ C42 /\ (leq_ B42 (minus_ n6_ n1_) /\ leq_ C42 n0_))) -> (a_select3_ dv_thruster_filter_init_ B42 C42) = init_)) /\ ((forall D42 E42 : Universe, ((leq_ n0_ D42 /\ (leq_ n0_ E42 /\ (leq_ D42 n5_ /\ leq_ E42 n5_))) -> (a_select3_ q_thruster_filter_init_ D42 E42) = init_)) /\ ((forall F42 G42 : Universe, ((leq_ n0_ F42 /\ (leq_ n0_ G42 /\ (leq_ F42 n3_ /\ leq_ G42 n3_))) -> (a_select3_ r_thruster_filter_init_ F42 G42) = init_)) /\ ((forall H42 I42 : Universe, ((leq_ n0_ H42 /\ (leq_ n0_ I42 /\ (leq_ H42 n5_ /\ leq_ I42 n0_))) -> (a_select3_ xhatmin_thruster_filter_init_ H42 I42) = init_)) /\ (forall J42 K42 : Universe, ((leq_ n0_ J42 /\ (leq_ n0_ K42 /\ (leq_ J42 n5_ /\ leq_ K42 n5_))) -> (a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n6_ n1_)) (dim_ n0_ (minus_ n6_ n1_)) init_) J42 K42) = init_))))))))) /\ (((leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall L42 M42 : Universe, ((leq_ n0_ L42 /\ (leq_ n0_ M42 /\ (leq_ L42 n3_ /\ leq_ M42 n5_))) -> (a_select3_ h_thruster_filter_init_ L42 M42) = init_)) /\ ((forall N42 O42 : Universe, ((leq_ n0_ N42 /\ (leq_ n0_ O42 /\ (leq_ N42 n5_ /\ leq_ O42 n5_))) -> (a_select3_ phi_thruster_filter_init_ N42 O42) = init_)) /\ ((forall P42 Q42 : Universe, ((leq_ n0_ P42 /\ (leq_ n0_ Q42 /\ (leq_ P42 (minus_ n6_ n1_) /\ leq_ Q42 n0_))) -> (a_select3_ dv_thruster_filter_init_ P42 Q42) = init_)) /\ ((forall R42 S42 : Universe, ((leq_ n0_ R42 /\ (leq_ n0_ S42 /\ (leq_ R42 n5_ /\ leq_ S42 n5_))) -> (a_select3_ q_thruster_filter_init_ R42 S42) = init_)) /\ ((forall T42 U42 : Universe, ((leq_ n0_ T42 /\ (leq_ n0_ U42 /\ (leq_ T42 n3_ /\ leq_ U42 n3_))) -> (a_select3_ r_thruster_filter_init_ T42 U42) = init_)) /\ ((forall V42 W42 : Universe, ((leq_ n0_ V42 /\ (leq_ n0_ W42 /\ (leq_ V42 n5_ /\ leq_ W42 n0_))) -> (a_select3_ xhatmin_thruster_filter_init_ V42 W42) = init_)) /\ (forall X42 Y42 : Universe, ((leq_ n0_ X42 /\ (leq_ n0_ Y42 /\ (leq_ X42 n5_ /\ leq_ Y42 n5_))) -> (a_select3_ pminus_thruster_filter_init_ X42 Y42) = init_)))))))))) -> (init_ = init_ /\ (leq_ n0_ pv5_ /\ (leq_ pv5_ n588_ /\ ((forall Z42 A43 : Universe, ((leq_ n0_ Z42 /\ (leq_ n0_ A43 /\ (leq_ Z42 n3_ /\ leq_ A43 n5_))) -> (a_select3_ h_thruster_filter_init_ Z42 A43) = init_)) /\ ((forall B43 C43 : Universe, ((leq_ n0_ B43 /\ (leq_ n0_ C43 /\ (leq_ B43 n5_ /\ leq_ C43 n5_))) -> (a_select3_ phi_thruster_filter_init_ B43 C43) = init_)) /\ ((forall D43 E43 : Universe, ((leq_ n0_ D43 /\ (leq_ n0_ E43 /\ (leq_ D43 (minus_ n6_ n1_) /\ leq_ E43 n0_))) -> (a_select3_ dv_thruster_filter_init_ D43 E43) = init_)) /\ ((forall F43 G43 : Universe, ((leq_ n0_ F43 /\ (leq_ n0_ G43 /\ (leq_ F43 n5_ /\ leq_ G43 n5_))) -> (a_select3_ q_thruster_filter_init_ F43 G43) = init_)) /\ ((forall H43 I43 : Universe, ((leq_ n0_ H43 /\ (leq_ n0_ I43 /\ (leq_ H43 n3_ /\ leq_ I43 n3_))) -> (a_select3_ r_thruster_filter_init_ H43 I43) = init_)) /\ ((forall J43 K43 : Universe, ((leq_ n0_ J43 /\ (leq_ n0_ K43 /\ (leq_ J43 n5_ /\ leq_ K43 n0_))) -> (a_select3_ xhatmin_thruster_filter_init_ J43 K43) = init_)) /\ ((forall L43 M43 : Universe, ((leq_ n0_ L43 /\ (leq_ n0_ M43 /\ (leq_ L43 n5_ /\ leq_ M43 n5_))) -> (a_select3_ pminus_thruster_filter_init_ L43 M43) = init_)) /\ (forall N43 : Universe, ((leq_ n0_ N43 /\ leq_ N43 (minus_ n0_ n1_)) -> (forall O43 : Universe, ((leq_ n0_ O43 /\ leq_ O43 (minus_ n6_ n1_)) -> (a_select3_ id_thruster_filter_init_ N43 O43) = init_))))))))))))))) /\ (((leq_ n0_ pv23_ /\ leq_ pv23_ (minus_ n6_ n1_)) -> (leq_ n0_ (a_select2_ sigma_ pv23_) -> true_)) /\ ((((forall P43 Q43 : Universe, ((leq_ n0_ P43 /\ (leq_ n0_ Q43 /\ (leq_ P43 n3_ /\ leq_ Q43 n5_))) -> (a_select3_ h_thruster_filter_init_ P43 Q43) = init_)) /\ (forall R43 S43 : Universe, ((leq_ n0_ R43 /\ (leq_ n0_ S43 /\ (leq_ R43 n5_ /\ leq_ S43 n5_))) -> (a_select3_ phi_thruster_filter_init_ R43 S43) = init_))) -> (init_ = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n0_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n1_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n2_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n3_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n4_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n5_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n6_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n7_ n0_) = init_ /\ ((forall T43 U43 : Universe, ((leq_ n0_ T43 /\ (leq_ n0_ U43 /\ (leq_ T43 n3_ /\ leq_ U43 n5_))) -> (a_select3_ h_thruster_filter_init_ T43 U43) = init_)) /\ ((forall V43 W43 : Universe, ((leq_ n0_ V43 /\ (leq_ n0_ W43 /\ (leq_ V43 n5_ /\ leq_ W43 n5_))) -> (a_select3_ phi_thruster_filter_init_ V43 W43) = init_)) /\ (forall X43 Y43 : Universe, ((leq_ n0_ X43 /\ (leq_ n0_ Y43 /\ (leq_ X43 (minus_ n6_ n1_) /\ leq_ Y43 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ dv_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) n4_ n0_ init_) n5_ n0_ init_) X43 Y43) = init_)))))))))))))) /\ ((((forall Z43 A44 : Universe, ((leq_ n0_ Z43 /\ (leq_ n0_ A44 /\ (leq_ Z43 n3_ /\ leq_ A44 n5_))) -> (a_select3_ h_thruster_filter_init_ Z43 A44) = init_)) /\ ((forall B44 C44 : Universe, ((leq_ n0_ B44 /\ (leq_ n0_ C44 /\ (leq_ B44 n5_ /\ leq_ C44 n5_))) -> (a_select3_ phi_thruster_filter_init_ B44 C44) = init_)) /\ (forall D44 E44 : Universe, ((leq_ n0_ D44 /\ (leq_ n0_ E44 /\ (leq_ D44 (minus_ n6_ n1_) /\ leq_ E44 n0_))) -> (a_select3_ dv_thruster_filter_init_ D44 E44) = init_)))) -> ((a_select2_ (tptp_const_array1_ (dim_ n0_ (minus_ n6_ n1_)) init_) n0_) = init_ /\ ((a_select2_ (tptp_const_array1_ (dim_ n0_ (minus_ n6_ n1_)) init_) n1_) = init_ /\ ((a_select2_ (tptp_const_array1_ (dim_ n0_ (minus_ n6_ n1_)) init_) n2_) = init_ /\ ((a_select2_ (tptp_const_array1_ (dim_ n0_ (minus_ n6_ n1_)) init_) n3_) = init_ /\ ((a_select2_ (tptp_const_array1_ (dim_ n0_ (minus_ n6_ n1_)) init_) n4_) = init_ /\ ((a_select2_ (tptp_const_array1_ (dim_ n0_ (minus_ n6_ n1_)) init_) n5_) = init_ /\ ((forall F44 G44 : Universe, ((leq_ n0_ F44 /\ (leq_ n0_ G44 /\ (leq_ F44 n3_ /\ leq_ G44 n5_))) -> (a_select3_ h_thruster_filter_init_ F44 G44) = init_)) /\ ((forall H44 I44 : Universe, ((leq_ n0_ H44 /\ (leq_ n0_ I44 /\ (leq_ H44 n5_ /\ leq_ I44 n5_))) -> (a_select3_ phi_thruster_filter_init_ H44 I44) = init_)) /\ ((forall J44 K44 : Universe, ((leq_ n0_ J44 /\ (leq_ n0_ K44 /\ (leq_ J44 (minus_ n6_ n1_) /\ leq_ K44 n0_))) -> (a_select3_ dv_thruster_filter_init_ J44 K44) = init_)) /\ (forall L44 M44 : Universe, ((leq_ n0_ L44 /\ (leq_ n0_ M44 /\ (leq_ L44 n5_ /\ leq_ M44 n5_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ q_thruster_filter_init_ n0_ n0_ init_) n0_ n1_ init_) n0_ n2_ init_) n0_ n3_ init_) n0_ n4_ init_) n0_ n5_ init_) n1_ n0_ init_) n1_ n1_ init_) n1_ n2_ init_) n1_ n3_ init_) n1_ n4_ init_) n1_ n5_ init_) n2_ n0_ init_) n2_ n1_ init_) n2_ n2_ init_) n2_ n3_ init_) n2_ n4_ init_) n2_ n5_ init_) n3_ n0_ init_) n3_ n1_ init_) n3_ n2_ init_) n3_ n3_ init_) n3_ n4_ init_) n3_ n5_ init_) n4_ n0_ init_) n4_ n1_ init_) n4_ n2_ init_) n4_ n3_ init_) n4_ n4_ init_) n4_ n5_ init_) n5_ n0_ init_) n5_ n1_ init_) n5_ n2_ init_) n5_ n3_ init_) n5_ n4_ init_) n5_ n5_ init_) L44 M44) = init_)))))))))))) /\ ((((forall N44 O44 : Universe, ((leq_ n0_ N44 /\ (leq_ n0_ O44 /\ (leq_ N44 n3_ /\ leq_ O44 n5_))) -> (a_select3_ h_thruster_filter_init_ N44 O44) = init_)) /\ ((forall P44 Q44 : Universe, ((leq_ n0_ P44 /\ (leq_ n0_ Q44 /\ (leq_ P44 n5_ /\ leq_ Q44 n5_))) -> (a_select3_ phi_thruster_filter_init_ P44 Q44) = init_)) /\ ((forall R44 S44 : Universe, ((leq_ n0_ R44 /\ (leq_ n0_ S44 /\ (leq_ R44 (minus_ n6_ n1_) /\ leq_ S44 n0_))) -> (a_select3_ dv_thruster_filter_init_ R44 S44) = init_)) /\ (forall T44 U44 : Universe, ((leq_ n0_ T44 /\ (leq_ n0_ U44 /\ (leq_ T44 n5_ /\ leq_ U44 n5_))) -> (a_select3_ q_thruster_filter_init_ T44 U44) = init_))))) -> ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) init_) n0_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) init_) n1_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) init_) n2_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ (minus_ n4_ n1_)) (dim_ n0_ (minus_ n1000_ n1_)) init_) n3_ n0_) = init_ /\ ((forall V44 W44 : Universe, ((leq_ n0_ V44 /\ (leq_ n0_ W44 /\ (leq_ V44 n3_ /\ leq_ W44 n5_))) -> (a_select3_ h_thruster_filter_init_ V44 W44) = init_)) /\ ((forall X44 Y44 : Universe, ((leq_ n0_ X44 /\ (leq_ n0_ Y44 /\ (leq_ X44 n5_ /\ leq_ Y44 n5_))) -> (a_select3_ phi_thruster_filter_init_ X44 Y44) = init_)) /\ ((forall Z44 A45 : Universe, ((leq_ n0_ Z44 /\ (leq_ n0_ A45 /\ (leq_ Z44 (minus_ n6_ n1_) /\ leq_ A45 n0_))) -> (a_select3_ dv_thruster_filter_init_ Z44 A45) = init_)) /\ ((forall B45 C45 : Universe, ((leq_ n0_ B45 /\ (leq_ n0_ C45 /\ (leq_ B45 n5_ /\ leq_ C45 n5_))) -> (a_select3_ q_thruster_filter_init_ B45 C45) = init_)) /\ (forall D45 E45 : Universe, ((leq_ n0_ D45 /\ (leq_ n0_ E45 /\ (leq_ D45 n3_ /\ leq_ E45 n3_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ r_thruster_filter_init_ n0_ n0_ init_) n0_ n1_ init_) n0_ n2_ init_) n0_ n3_ init_) n1_ n0_ init_) n1_ n1_ init_) n1_ n2_ init_) n1_ n3_ init_) n2_ n0_ init_) n2_ n1_ init_) n2_ n2_ init_) n2_ n3_ init_) n3_ n0_ init_) n3_ n1_ init_) n3_ n2_ init_) n3_ n3_ init_) D45 E45) = init_))))))))))) /\ ((((forall F45 G45 : Universe, ((leq_ n0_ F45 /\ (leq_ n0_ G45 /\ (leq_ F45 n3_ /\ leq_ G45 n5_))) -> (a_select3_ h_thruster_filter_init_ F45 G45) = init_)) /\ ((forall H45 I45 : Universe, ((leq_ n0_ H45 /\ (leq_ n0_ I45 /\ (leq_ H45 n5_ /\ leq_ I45 n5_))) -> (a_select3_ phi_thruster_filter_init_ H45 I45) = init_)) /\ ((forall J45 K45 : Universe, ((leq_ n0_ J45 /\ (leq_ n0_ K45 /\ (leq_ J45 (minus_ n6_ n1_) /\ leq_ K45 n0_))) -> (a_select3_ dv_thruster_filter_init_ J45 K45) = init_)) /\ ((forall L45 M45 : Universe, ((leq_ n0_ L45 /\ (leq_ n0_ M45 /\ (leq_ L45 n5_ /\ leq_ M45 n5_))) -> (a_select3_ q_thruster_filter_init_ L45 M45) = init_)) /\ (forall N45 O45 : Universe, ((leq_ n0_ N45 /\ (leq_ n0_ O45 /\ (leq_ N45 n3_ /\ leq_ O45 n3_))) -> (a_select3_ r_thruster_filter_init_ N45 O45) = init_)))))) -> ((a_select2_ (tptp_const_array1_ (dim_ n0_ (minus_ n6_ n1_)) init_) n0_) = init_ /\ ((a_select2_ (tptp_const_array1_ (dim_ n0_ (minus_ n6_ n1_)) init_) n1_) = init_ /\ ((a_select2_ (tptp_const_array1_ (dim_ n0_ (minus_ n6_ n1_)) init_) n2_) = init_ /\ ((a_select2_ (tptp_const_array1_ (dim_ n0_ (minus_ n6_ n1_)) init_) n3_) = init_ /\ ((a_select2_ (tptp_const_array1_ (dim_ n0_ (minus_ n6_ n1_)) init_) n4_) = init_ /\ ((a_select2_ (tptp_const_array1_ (dim_ n0_ (minus_ n6_ n1_)) init_) n5_) = init_ /\ ((forall P45 Q45 : Universe, ((leq_ n0_ P45 /\ (leq_ n0_ Q45 /\ (leq_ P45 n3_ /\ leq_ Q45 n5_))) -> (a_select3_ h_thruster_filter_init_ P45 Q45) = init_)) /\ ((forall R45 S45 : Universe, ((leq_ n0_ R45 /\ (leq_ n0_ S45 /\ (leq_ R45 n5_ /\ leq_ S45 n5_))) -> (a_select3_ phi_thruster_filter_init_ R45 S45) = init_)) /\ ((forall T45 U45 : Universe, ((leq_ n0_ T45 /\ (leq_ n0_ U45 /\ (leq_ T45 (minus_ n6_ n1_) /\ leq_ U45 n0_))) -> (a_select3_ dv_thruster_filter_init_ T45 U45) = init_)) /\ ((forall V45 W45 : Universe, ((leq_ n0_ V45 /\ (leq_ n0_ W45 /\ (leq_ V45 n5_ /\ leq_ W45 n5_))) -> (a_select3_ q_thruster_filter_init_ V45 W45) = init_)) /\ ((forall X45 Y45 : Universe, ((leq_ n0_ X45 /\ (leq_ n0_ Y45 /\ (leq_ X45 n3_ /\ leq_ Y45 n3_))) -> (a_select3_ r_thruster_filter_init_ X45 Y45) = init_)) /\ (forall Z45 A46 : Universe, ((leq_ n0_ Z45 /\ (leq_ n0_ A46 /\ (leq_ Z45 n5_ /\ leq_ A46 n0_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ xhatmin_thruster_filter_init_ n0_ n0_ init_) n1_ n0_ init_) n2_ n0_ init_) n3_ n0_ init_) n4_ n0_ init_) n5_ n0_ init_) Z45 A46) = init_)))))))))))))) /\ ((((forall B46 C46 : Universe, ((leq_ n0_ B46 /\ (leq_ n0_ C46 /\ (leq_ B46 n3_ /\ leq_ C46 n5_))) -> (a_select3_ h_thruster_filter_init_ B46 C46) = init_)) /\ ((forall D46 E46 : Universe, ((leq_ n0_ D46 /\ (leq_ n0_ E46 /\ (leq_ D46 n5_ /\ leq_ E46 n5_))) -> (a_select3_ phi_thruster_filter_init_ D46 E46) = init_)) /\ ((forall F46 G46 : Universe, ((leq_ n0_ F46 /\ (leq_ n0_ G46 /\ (leq_ F46 (minus_ n6_ n1_) /\ leq_ G46 n0_))) -> (a_select3_ dv_thruster_filter_init_ F46 G46) = init_)) /\ ((forall H46 I46 : Universe, ((leq_ n0_ H46 /\ (leq_ n0_ I46 /\ (leq_ H46 n5_ /\ leq_ I46 n5_))) -> (a_select3_ q_thruster_filter_init_ H46 I46) = init_)) /\ ((forall J46 K46 : Universe, ((leq_ n0_ J46 /\ (leq_ n0_ K46 /\ (leq_ J46 n3_ /\ leq_ K46 n3_))) -> (a_select3_ r_thruster_filter_init_ J46 K46) = init_)) /\ (forall L46 M46 : Universe, ((leq_ n0_ L46 /\ (leq_ n0_ M46 /\ (leq_ L46 n5_ /\ leq_ M46 n0_))) -> (a_select3_ xhatmin_thruster_filter_init_ L46 M46) = init_))))))) -> ((a_select2_ (tptp_const_array1_ (dim_ n0_ (minus_ n6_ n1_)) init_) n0_) = init_ /\ ((a_select2_ (tptp_const_array1_ (dim_ n0_ (minus_ n6_ n1_)) init_) n1_) = init_ /\ ((a_select2_ (tptp_const_array1_ (dim_ n0_ (minus_ n6_ n1_)) init_) n2_) = init_ /\ ((a_select2_ (tptp_const_array1_ (dim_ n0_ (minus_ n6_ n1_)) init_) n3_) = init_ /\ ((a_select2_ (tptp_const_array1_ (dim_ n0_ (minus_ n6_ n1_)) init_) n4_) = init_ /\ ((a_select2_ (tptp_const_array1_ (dim_ n0_ (minus_ n6_ n1_)) init_) n5_) = init_ /\ ((forall N46 O46 : Universe, ((leq_ n0_ N46 /\ (leq_ n0_ O46 /\ (leq_ N46 n3_ /\ leq_ O46 n5_))) -> (a_select3_ h_thruster_filter_init_ N46 O46) = init_)) /\ ((forall P46 Q46 : Universe, ((leq_ n0_ P46 /\ (leq_ n0_ Q46 /\ (leq_ P46 n5_ /\ leq_ Q46 n5_))) -> (a_select3_ phi_thruster_filter_init_ P46 Q46) = init_)) /\ ((forall R46 S46 : Universe, ((leq_ n0_ R46 /\ (leq_ n0_ S46 /\ (leq_ R46 (minus_ n6_ n1_) /\ leq_ S46 n0_))) -> (a_select3_ dv_thruster_filter_init_ R46 S46) = init_)) /\ ((forall T46 U46 : Universe, ((leq_ n0_ T46 /\ (leq_ n0_ U46 /\ (leq_ T46 n5_ /\ leq_ U46 n5_))) -> (a_select3_ q_thruster_filter_init_ T46 U46) = init_)) /\ ((forall V46 W46 : Universe, ((leq_ n0_ V46 /\ (leq_ n0_ W46 /\ (leq_ V46 n3_ /\ leq_ W46 n3_))) -> (a_select3_ r_thruster_filter_init_ V46 W46) = init_)) /\ ((forall X46 Y46 : Universe, ((leq_ n0_ X46 /\ (leq_ n0_ Y46 /\ (leq_ X46 n5_ /\ leq_ Y46 n0_))) -> (a_select3_ xhatmin_thruster_filter_init_ X46 Y46) = init_)) /\ (forall Z46 A47 : Universe, ((leq_ n0_ Z46 /\ (leq_ n0_ A47 /\ (leq_ Z46 n5_ /\ leq_ A47 n5_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ pminus_thruster_filter_init_ n0_ n0_ init_) n0_ n1_ init_) n0_ n2_ init_) n0_ n3_ init_) n0_ n4_ init_) n0_ n5_ init_) n1_ n0_ init_) n1_ n1_ init_) n1_ n2_ init_) n1_ n3_ init_) n1_ n4_ init_) n1_ n5_ init_) n2_ n0_ init_) n2_ n1_ init_) n2_ n2_ init_) n2_ n3_ init_) n2_ n4_ init_) n2_ n5_ init_) n3_ n0_ init_) n3_ n1_ init_) n3_ n2_ init_) n3_ n3_ init_) n3_ n4_ init_) n3_ n5_ init_) n4_ n0_ init_) n4_ n1_ init_) n4_ n2_ init_) n4_ n3_ init_) n4_ n4_ init_) n4_ n5_ init_) n5_ n0_ init_) n5_ n1_ init_) n5_ n2_ init_) n5_ n3_ init_) n5_ n4_ init_) n5_ n5_ init_) Z46 A47) = init_))))))))))))))) /\ ((((forall B47 C47 : Universe, ((leq_ n0_ B47 /\ (leq_ n0_ C47 /\ (leq_ B47 n3_ /\ leq_ C47 n5_))) -> (a_select3_ h_thruster_filter_init_ B47 C47) = init_)) /\ ((forall D47 E47 : Universe, ((leq_ n0_ D47 /\ (leq_ n0_ E47 /\ (leq_ D47 n5_ /\ leq_ E47 n5_))) -> (a_select3_ phi_thruster_filter_init_ D47 E47) = init_)) /\ ((forall F47 G47 : Universe, ((leq_ n0_ F47 /\ (leq_ n0_ G47 /\ (leq_ F47 (minus_ n6_ n1_) /\ leq_ G47 n0_))) -> (a_select3_ dv_thruster_filter_init_ F47 G47) = init_)) /\ ((forall H47 I47 : Universe, ((leq_ n0_ H47 /\ (leq_ n0_ I47 /\ (leq_ H47 n5_ /\ leq_ I47 n5_))) -> (a_select3_ q_thruster_filter_init_ H47 I47) = init_)) /\ ((forall J47 K47 : Universe, ((leq_ n0_ J47 /\ (leq_ n0_ K47 /\ (leq_ J47 n3_ /\ leq_ K47 n3_))) -> (a_select3_ r_thruster_filter_init_ J47 K47) = init_)) /\ ((forall L47 M47 : Universe, ((leq_ n0_ L47 /\ (leq_ n0_ M47 /\ (leq_ L47 n5_ /\ leq_ M47 n0_))) -> (a_select3_ xhatmin_thruster_filter_init_ L47 M47) = init_)) /\ (forall N47 O47 : Universe, ((leq_ n0_ N47 /\ (leq_ n0_ O47 /\ (leq_ N47 n5_ /\ leq_ O47 n5_))) -> (a_select3_ pminus_thruster_filter_init_ N47 O47) = init_)))))))) -> true_) /\ ((((forall P47 Q47 : Universe, ((leq_ n0_ P47 /\ (leq_ n0_ Q47 /\ (leq_ P47 n3_ /\ leq_ Q47 n5_))) -> (a_select3_ h_thruster_filter_init_ P47 Q47) = init_)) /\ ((forall R47 S47 : Universe, ((leq_ n0_ R47 /\ (leq_ n0_ S47 /\ (leq_ R47 n5_ /\ leq_ S47 n5_))) -> (a_select3_ phi_thruster_filter_init_ R47 S47) = init_)) /\ ((forall T47 U47 : Universe, ((leq_ n0_ T47 /\ (leq_ n0_ U47 /\ (leq_ T47 (minus_ n6_ n1_) /\ leq_ U47 n0_))) -> (a_select3_ dv_thruster_filter_init_ T47 U47) = init_)) /\ ((forall V47 W47 : Universe, ((leq_ n0_ V47 /\ (leq_ n0_ W47 /\ (leq_ V47 n5_ /\ leq_ W47 n5_))) -> (a_select3_ q_thruster_filter_init_ V47 W47) = init_)) /\ ((forall X47 Y47 : Universe, ((leq_ n0_ X47 /\ (leq_ n0_ Y47 /\ (leq_ X47 n3_ /\ leq_ Y47 n3_))) -> (a_select3_ r_thruster_filter_init_ X47 Y47) = init_)) /\ ((forall Z47 A48 : Universe, ((leq_ n0_ Z47 /\ (leq_ n0_ A48 /\ (leq_ Z47 n5_ /\ leq_ A48 n0_))) -> (a_select3_ xhatmin_thruster_filter_init_ Z47 A48) = init_)) /\ (forall B48 C48 : Universe, ((leq_ n0_ B48 /\ (leq_ n0_ C48 /\ (leq_ B48 n5_ /\ leq_ C48 n5_))) -> (a_select3_ pminus_thruster_filter_init_ B48 C48) = init_)))))))) -> ((forall D48 E48 : Universe, ((leq_ n0_ D48 /\ (leq_ n0_ E48 /\ (leq_ D48 n3_ /\ leq_ E48 n5_))) -> (a_select3_ h_thruster_filter_init_ D48 E48) = init_)) /\ ((forall F48 G48 : Universe, ((leq_ n0_ F48 /\ (leq_ n0_ G48 /\ (leq_ F48 n5_ /\ leq_ G48 n5_))) -> (a_select3_ phi_thruster_filter_init_ F48 G48) = init_)) /\ ((forall H48 I48 : Universe, ((leq_ n0_ H48 /\ (leq_ n0_ I48 /\ (leq_ H48 (minus_ n6_ n1_) /\ leq_ I48 n0_))) -> (a_select3_ dv_thruster_filter_init_ H48 I48) = init_)) /\ ((forall J48 K48 : Universe, ((leq_ n0_ J48 /\ (leq_ n0_ K48 /\ (leq_ J48 n5_ /\ leq_ K48 n5_))) -> (a_select3_ q_thruster_filter_init_ J48 K48) = init_)) /\ ((forall L48 M48 : Universe, ((leq_ n0_ L48 /\ (leq_ n0_ M48 /\ (leq_ L48 n3_ /\ leq_ M48 n3_))) -> (a_select3_ r_thruster_filter_init_ L48 M48) = init_)) /\ ((forall N48 O48 : Universe, ((leq_ n0_ N48 /\ (leq_ n0_ O48 /\ (leq_ N48 n5_ /\ leq_ O48 n0_))) -> (a_select3_ xhatmin_thruster_filter_init_ N48 O48) = init_)) /\ (forall P48 Q48 : Universe, ((leq_ n0_ P48 /\ (leq_ n0_ Q48 /\ (leq_ P48 n5_ /\ leq_ Q48 n5_))) -> (a_select3_ pminus_thruster_filter_init_ P48 Q48) = init_))))))))) /\ ((geq_ (minus_ n6_ n1_) n0_ -> (init_ = init_ /\ (geq_ (minus_ n6_ n1_) n0_ -> (init_ = init_ /\ ((geq_ (minus_ n4_ n1_) n0_ /\ geq_ (minus_ n1000_ n1_) n0_) -> init_ = init_))))) /\ ((forall R48 S48 : Universe, ((leq_ n0_ R48 /\ (leq_ n0_ S48 /\ (leq_ R48 n3_ /\ leq_ S48 n5_))) -> (a_select3_ h_thruster_filter_init_ R48 S48) = init_)) -> (init_ = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n0_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n1_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n2_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n3_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n4_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n5_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n6_ n0_) = init_ /\ ((a_select3_ (tptp_const_array2_ (dim_ n0_ n7_) (dim_ n0_ (minus_ n1000_ n1_)) init_) n7_ n0_) = init_ /\ ((a_select2_ (tptp_const_array1_ (dim_ n0_ (minus_ n6_ n1_)) init_) n0_) = init_ /\ ((forall T48 U48 : Universe, ((leq_ n0_ T48 /\ (leq_ n0_ U48 /\ (leq_ T48 n3_ /\ leq_ U48 n5_))) -> (a_select3_ h_thruster_filter_init_ T48 U48) = init_)) /\ (forall V48 W48 : Universe, ((leq_ n0_ V48 /\ (leq_ n0_ W48 /\ (leq_ V48 n5_ /\ leq_ W48 n5_))) -> (a_select3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ (tptp_update3_ phi_thruster_filter_init_ n0_ n0_ init_) n0_ n1_ init_) n0_ n2_ init_) n0_ n3_ init_) n0_ n4_ init_) n0_ n5_ init_) n1_ n0_ init_) n1_ n1_ init_) n1_ n2_ init_) n1_ n3_ init_) n1_ n4_ init_) n1_ n5_ init_) n2_ n0_ init_) n2_ n1_ init_) n2_ n2_ init_) n2_ n3_ init_) n2_ n4_ init_) n2_ n5_ init_) n3_ n0_ init_) n3_ n1_ init_) n3_ n2_ init_) n3_ n3_ init_) n3_ n4_ init_) n3_ n5_ init_) n4_ n0_ init_) n4_ n1_ init_) n4_ n2_ init_) n4_ n3_ init_) n4_ n4_ init_) n4_ n5_ init_) n5_ n0_ init_) n5_ n1_ init_) n5_ n2_ init_) n5_ n3_ init_) n5_ n4_ init_) n5_ n5_ init_) V48 W48) = init_))))))))))))))))))))))))))))))))))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
