(*
% File     : SWV027+1 : ILTP v1.1.2
% Domain   : Software Verification
% Problem  : Unsimplified proof obligation gauss_init_0021
% Version  : [DFS04] axioms : Especial.
% English  : Proof obligation emerging from the init-safety verification for
%            the gauss program. init-safety ensures that each variable or
%            individual array element has been assigned a defined value before
%            it is used.
% Refs     : [Fis04] Fischer (2004), Email to G. Sutcliffe
%          : [DFS04] Denney et al. (2004), Using Automated Theorem Provers
% Source   : [Fis04]
% Names    : gauss_init_0021 [Fis04]
% Status   : Theorem
% Rating   : 0.82 v3.1.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   98 (  63 unit)
%            Number of atoms       :  283 (  99 equality)
%            Maximal formula depth :   25 (   4 average)
%            Number of connectives :  190 (   5 ~  ;  17  |; 120  &)
%                                         (   5 <=>;  43 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    6 (   1 propositional; 0-2 arity)
%            Number of functors    :   47 (  29 constant; 0-4 arity)
%            Number of variables   :  151 (   0 singleton; 151 !;   0 ?)
%            Maximal term depth    :    9 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable true_ : Prop.
Variable lt_ : Universe -> Universe -> Prop.
Variable leq_ : Universe -> Universe -> Prop.
Variable gt_ : Universe -> Universe -> Prop.
Variable geq_ : Universe -> Universe -> Prop.

Variable use_ : Universe.
Variable uniform_int_rnd_ : Universe -> Universe -> Universe.
Variable trans_ : Universe -> Universe.
Variable tptp_update3_ : Universe -> Universe -> Universe -> Universe -> Universe.
Variable tptp_update2_ : Universe -> Universe -> Universe -> Universe.
Variable tptp_msub_ : Universe -> Universe -> Universe.
Variable tptp_mmul_ : Universe -> Universe -> Universe.
Variable tptp_minus_1_ : Universe.
Variable tptp_madd_ : Universe -> Universe -> Universe.
Variable tptp_const_array2_ : Universe -> Universe -> Universe -> Universe.
Variable tptp_const_array1_ : Universe -> Universe -> Universe.
Variable sum_ : Universe -> Universe -> Universe -> Universe.
Variable succ_ : Universe -> Universe.
Variable simplex7_init_ : Universe.
Variable s_worst7_init_ : Universe.
Variable s_worst7_ : Universe.
Variable s_values7_init_ : Universe.
Variable s_try7_init_ : Universe.
Variable s_sworst7_init_ : Universe.
Variable s_sworst7_ : Universe.
Variable s_center7_init_ : Universe.
Variable s_best7_init_ : Universe.
Variable s_best7_ : Universe.
Variable pvar1402_init_ : Universe.
Variable pvar1401_init_ : Universe.
Variable pvar1400_init_ : Universe.
Variable pv20_ : Universe.
Variable pv19_ : Universe.
Variable pv1376_ : Universe.
Variable pred_ : Universe -> Universe.
Variable plus_ : Universe -> Universe -> Universe.
Variable n5_ : Universe.
Variable n410_ : Universe.
Variable n4_ : Universe.
Variable n330_ : Universe.
Variable n3_ : Universe.
Variable n2_ : Universe.
Variable n1_ : Universe.
Variable n0_ : Universe.
Variable minus_ : Universe -> Universe -> Universe.
Variable loopcounter_ : Universe.
Variable inv_ : Universe -> Universe.
Variable init_ : Universe.
Variable dim_ : Universe -> Universe -> Universe.
Variable def_ : Universe.
Variable a_select3_ : Universe -> Universe -> Universe -> Universe.
Variable a_select2_ : Universe -> Universe -> Universe.

Variable totality_1 : (forall X Y : Universe, (gt_ X Y \/ (gt_ Y X \/ X = Y))).
Variable transitivity_gt_2 : (forall X Y Z : Universe, ((gt_ X Y /\ gt_ Y Z) -> gt_ X Z)).
Variable irreflexivity_gt_3 : (forall X : Universe, ~(gt_ X X)).
Variable reflexivity_leq_4 : (forall X : Universe, leq_ X X).
Variable transitivity_leq_5 : (forall X Y Z : Universe, ((leq_ X Y /\ leq_ Y Z) -> leq_ X Z)).
Variable lt_gt_6 : (forall X Y : Universe, (lt_ X Y <-> gt_ Y X)).
Variable leq_geq_7 : (forall X Y : Universe, (geq_ X Y <-> leq_ Y X)).
Variable leq_gt1_8 : (forall X Y : Universe, (gt_ Y X -> leq_ X Y)).
Variable leq_gt2_9 : (forall X Y : Universe, ((leq_ X Y /\ X <> Y) -> gt_ Y X)).
Variable leq_gt_pred_10 : (forall X Y : Universe, (leq_ X (pred_ Y) <-> gt_ Y X)).
Variable gt_succ_11 : (forall X : Universe, gt_ (succ_ X) X).
Variable leq_succ_12 : (forall X Y : Universe, (leq_ X Y -> leq_ X (succ_ Y))).
Variable leq_succ_gt_equiv_13 : (forall X Y : Universe, (leq_ X Y <-> gt_ (succ_ Y) X)).
Variable uniform_int_rand_ranges_hi_14 : (forall X C : Universe, (leq_ n0_ X -> leq_ (uniform_int_rnd_ C X) X)).
Variable uniform_int_rand_ranges_lo_15 : (forall X C : Universe, (leq_ n0_ X -> leq_ n0_ (uniform_int_rnd_ C X))).
Variable const_array1_select_16 : (forall I L U Val : Universe, ((leq_ L I /\ leq_ I U) -> (a_select2_ (tptp_const_array1_ (dim_ L U) Val) I) = Val)).
Variable const_array2_select_17 : (forall I L1 U1 J L2 U2 Val : Universe, ((leq_ L1 I /\ (leq_ I U1 /\ (leq_ L2 J /\ leq_ J U2))) -> (a_select3_ (tptp_const_array2_ (dim_ L1 U1) (dim_ L2 U2) Val) I J) = Val)).
Variable matrix_symm_aba1_18 : (forall I0 J0 A B N : Universe, ((leq_ n0_ I0 /\ (leq_ I0 N /\ (leq_ n0_ J0 /\ (leq_ J0 N /\ (a_select3_ B I0 J0) = (a_select3_ B J0 I0))))) -> (a_select3_ (tptp_mmul_ A (tptp_mmul_ B (trans_ A))) I0 J0) = (a_select3_ (tptp_mmul_ A (tptp_mmul_ B (trans_ A))) J0 I0))).
Variable matrix_symm_aba2_19 : (forall I0 J0 I J A B N M : Universe, ((leq_ n0_ I0 /\ (leq_ I0 N /\ (leq_ n0_ J0 /\ (leq_ J0 N /\ (leq_ n0_ I /\ (leq_ I M /\ (leq_ n0_ J /\ (leq_ J M /\ (a_select3_ B I J) = (a_select3_ B J I))))))))) -> (a_select3_ (tptp_mmul_ A (tptp_mmul_ B (trans_ A))) I0 J0) = (a_select3_ (tptp_mmul_ A (tptp_mmul_ B (trans_ A))) J0 I0))).
Variable matrix_symm_add_20 : (forall I J A B N : Universe, ((leq_ n0_ I /\ (leq_ I N /\ (leq_ n0_ J /\ (leq_ J N /\ ((a_select3_ A I J) = (a_select3_ A J I) /\ (a_select3_ B I J) = (a_select3_ B J I)))))) -> (a_select3_ (tptp_madd_ A B) I J) = (a_select3_ (tptp_madd_ A B) J I))).
Variable matrix_symm_sub_21 : (forall I J A B N : Universe, ((leq_ n0_ I /\ (leq_ I N /\ (leq_ n0_ J /\ (leq_ J N /\ ((a_select3_ A I J) = (a_select3_ A J I) /\ (a_select3_ B I J) = (a_select3_ B J I)))))) -> (a_select3_ (tptp_msub_ A B) I J) = (a_select3_ (tptp_msub_ A B) J I))).
Variable matrix_symm_trans_22 : (forall I J A N : Universe, ((leq_ n0_ I /\ (leq_ I N /\ (leq_ n0_ J /\ (leq_ J N /\ (a_select3_ A I J) = (a_select3_ A J I))))) -> (a_select3_ (trans_ A) I J) = (a_select3_ (trans_ A) J I))).
Variable matrix_symm_inv_23 : (forall I J A N : Universe, ((leq_ n0_ I /\ (leq_ I N /\ (leq_ n0_ J /\ (leq_ J N /\ (a_select3_ A I J) = (a_select3_ A J I))))) -> (a_select3_ (inv_ A) I J) = (a_select3_ (inv_ A) J I))).
Variable matrix_symm_joseph_update_24 : (forall I0 J0 I J A B C D E F N M : Universe, ((leq_ n0_ I0 /\ (leq_ I0 N /\ (leq_ n0_ J0 /\ (leq_ J0 N /\ (leq_ n0_ I /\ (leq_ I M /\ (leq_ n0_ J /\ (leq_ J M /\ ((a_select3_ D I J) = (a_select3_ D J I) /\ ((a_select3_ A I0 J0) = (a_select3_ A J0 I0) /\ (a_select3_ F I0 J0) = (a_select3_ F J0 I0))))))))))) -> (a_select3_ (tptp_madd_ A (tptp_mmul_ B (tptp_mmul_ (tptp_madd_ (tptp_mmul_ C (tptp_mmul_ D (trans_ C))) (tptp_mmul_ E (tptp_mmul_ F (trans_ E)))) (trans_ B)))) I0 J0) = (a_select3_ (tptp_madd_ A (tptp_mmul_ B (tptp_mmul_ (tptp_madd_ (tptp_mmul_ C (tptp_mmul_ D (trans_ C))) (tptp_mmul_ E (tptp_mmul_ F (trans_ E)))) (trans_ B)))) J0 I0))).
Variable sum_plus_base_25 : (forall Body : Universe, (sum_ n0_ tptp_minus_1_ Body) = n0_).
Variable succ_tptp_minus_1_26 : (succ_ tptp_minus_1_) = n0_.
Variable succ_plus_1_r_27 : (forall X : Universe, (plus_ X n1_) = (succ_ X)).
Variable succ_plus_1_l_28 : (forall X : Universe, (plus_ n1_ X) = (succ_ X)).
Variable succ_plus_2_r_29 : (forall X : Universe, (plus_ X n2_) = (succ_ (succ_ X))).
Variable succ_plus_2_l_30 : (forall X : Universe, (plus_ n2_ X) = (succ_ (succ_ X))).
Variable succ_plus_3_r_31 : (forall X : Universe, (plus_ X n3_) = (succ_ (succ_ (succ_ X)))).
Variable succ_plus_3_l_32 : (forall X : Universe, (plus_ n3_ X) = (succ_ (succ_ (succ_ X)))).
Variable succ_plus_4_r_33 : (forall X : Universe, (plus_ X n4_) = (succ_ (succ_ (succ_ (succ_ X))))).
Variable succ_plus_4_l_34 : (forall X : Universe, (plus_ n4_ X) = (succ_ (succ_ (succ_ (succ_ X))))).
Variable succ_plus_5_r_35 : (forall X : Universe, (plus_ X n5_) = (succ_ (succ_ (succ_ (succ_ (succ_ X)))))).
Variable succ_plus_5_l_36 : (forall X : Universe, (plus_ n5_ X) = (succ_ (succ_ (succ_ (succ_ (succ_ X)))))).
Variable pred_minus_1_37 : (forall X : Universe, (minus_ X n1_) = (pred_ X)).
Variable pred_succ_38 : (forall X : Universe, (pred_ (succ_ X)) = X).
Variable succ_pred_39 : (forall X : Universe, (succ_ (pred_ X)) = X).
Variable leq_succ_succ_40 : (forall X Y : Universe, (leq_ (succ_ X) (succ_ Y) <-> leq_ X Y)).
Variable leq_succ_gt_41 : (forall X Y : Universe, (leq_ (succ_ X) Y -> gt_ Y X)).
Variable leq_minus_42 : (forall X Y : Universe, (leq_ (minus_ X Y) X -> leq_ n0_ Y)).
Variable sel3_update_1_43 : (forall X U V VAL : Universe, (a_select3_ (tptp_update3_ X U V VAL) U V) = VAL).
Variable sel3_update_2_44 : (forall I J U V X VAL VAL2 : Universe, ((I <> U /\ (J = V /\ (a_select3_ X U V) = VAL)) -> (a_select3_ (tptp_update3_ X I J VAL2) U V) = VAL)).
Variable sel3_update_3_45 : (forall I J U V X VAL : Universe, (((forall I0 J0 : Universe, ((leq_ n0_ I0 /\ (leq_ n0_ J0 /\ (leq_ I0 U /\ leq_ J0 V))) -> (a_select3_ X I0 J0) = VAL)) /\ (leq_ n0_ I /\ (leq_ I U /\ (leq_ n0_ J /\ leq_ J V)))) -> (a_select3_ (tptp_update3_ X U V VAL) I J) = VAL)).
Variable sel2_update_1_46 : (forall X U VAL : Universe, (a_select2_ (tptp_update2_ X U VAL) U) = VAL).
Variable sel2_update_2_47 : (forall I U X VAL VAL2 : Universe, ((I <> U /\ (a_select2_ X U) = VAL) -> (a_select2_ (tptp_update2_ X I VAL2) U) = VAL)).
Variable sel2_update_3_48 : (forall I U X VAL : Universe, (((forall I0 : Universe, ((leq_ n0_ I0 /\ leq_ I0 U) -> (a_select2_ X I0) = VAL)) /\ (leq_ n0_ I /\ leq_ I U)) -> (a_select2_ (tptp_update2_ X U VAL) I) = VAL)).
Variable ttrue_49 : true_.
Variable defuse_50 : def_ <> use_.
Variable gt_5_4_51 : gt_ n5_ n4_.
Variable gt_330_4_52 : gt_ n330_ n4_.
Variable gt_410_4_53 : gt_ n410_ n4_.
Variable gt_330_5_54 : gt_ n330_ n5_.
Variable gt_410_5_55 : gt_ n410_ n5_.
Variable gt_410_330_56 : gt_ n410_ n330_.
Variable gt_4_tptp_minus_1_57 : gt_ n4_ tptp_minus_1_.
Variable gt_5_tptp_minus_1_58 : gt_ n5_ tptp_minus_1_.
Variable gt_330_tptp_minus_1_59 : gt_ n330_ tptp_minus_1_.
Variable gt_410_tptp_minus_1_60 : gt_ n410_ tptp_minus_1_.
Variable gt_0_tptp_minus_1_61 : gt_ n0_ tptp_minus_1_.
Variable gt_1_tptp_minus_1_62 : gt_ n1_ tptp_minus_1_.
Variable gt_2_tptp_minus_1_63 : gt_ n2_ tptp_minus_1_.
Variable gt_3_tptp_minus_1_64 : gt_ n3_ tptp_minus_1_.
Variable gt_4_0_65 : gt_ n4_ n0_.
Variable gt_5_0_66 : gt_ n5_ n0_.
Variable gt_330_0_67 : gt_ n330_ n0_.
Variable gt_410_0_68 : gt_ n410_ n0_.
Variable gt_1_0_69 : gt_ n1_ n0_.
Variable gt_2_0_70 : gt_ n2_ n0_.
Variable gt_3_0_71 : gt_ n3_ n0_.
Variable gt_4_1_72 : gt_ n4_ n1_.
Variable gt_5_1_73 : gt_ n5_ n1_.
Variable gt_330_1_74 : gt_ n330_ n1_.
Variable gt_410_1_75 : gt_ n410_ n1_.
Variable gt_2_1_76 : gt_ n2_ n1_.
Variable gt_3_1_77 : gt_ n3_ n1_.
Variable gt_4_2_78 : gt_ n4_ n2_.
Variable gt_5_2_79 : gt_ n5_ n2_.
Variable gt_330_2_80 : gt_ n330_ n2_.
Variable gt_410_2_81 : gt_ n410_ n2_.
Variable gt_3_2_82 : gt_ n3_ n2_.
Variable gt_4_3_83 : gt_ n4_ n3_.
Variable gt_5_3_84 : gt_ n5_ n3_.
Variable gt_330_3_85 : gt_ n330_ n3_.
Variable gt_410_3_86 : gt_ n410_ n3_.
Variable finite_domain_4_87 : (forall X : Universe, ((leq_ n0_ X /\ leq_ X n4_) -> (X = n0_ \/ (X = n1_ \/ (X = n2_ \/ (X = n3_ \/ X = n4_)))))).
Variable finite_domain_5_88 : (forall X : Universe, ((leq_ n0_ X /\ leq_ X n5_) -> (X = n0_ \/ (X = n1_ \/ (X = n2_ \/ (X = n3_ \/ (X = n4_ \/ X = n5_))))))).
Variable finite_domain_0_89 : (forall X : Universe, ((leq_ n0_ X /\ leq_ X n0_) -> X = n0_)).
Variable finite_domain_1_90 : (forall X : Universe, ((leq_ n0_ X /\ leq_ X n1_) -> (X = n0_ \/ X = n1_))).
Variable finite_domain_2_91 : (forall X : Universe, ((leq_ n0_ X /\ leq_ X n2_) -> (X = n0_ \/ (X = n1_ \/ X = n2_)))).
Variable finite_domain_3_92 : (forall X : Universe, ((leq_ n0_ X /\ leq_ X n3_) -> (X = n0_ \/ (X = n1_ \/ (X = n2_ \/ X = n3_))))).
Variable successor_4_93 : (succ_ (succ_ (succ_ (succ_ n0_)))) = n4_.
Variable successor_5_94 : (succ_ (succ_ (succ_ (succ_ (succ_ n0_))))) = n5_.
Variable successor_1_95 : (succ_ n0_) = n1_.
Variable successor_2_96 : (succ_ (succ_ n0_)) = n2_.
Variable successor_3_97 : (succ_ (succ_ (succ_ n0_))) = n3_.

Theorem gauss_init_0021_98 : ((init_ = init_ /\ (s_best7_init_ = init_ /\ (s_sworst7_init_ = init_ /\ (s_worst7_init_ = init_ /\ (leq_ n0_ s_best7_ /\ (leq_ n0_ s_sworst7_ /\ (leq_ n0_ s_worst7_ /\ (leq_ n0_ pv19_ /\ (leq_ n0_ pv20_ /\ (leq_ n0_ pv1376_ /\ (leq_ s_best7_ n3_ /\ (leq_ s_sworst7_ n3_ /\ (leq_ s_worst7_ n3_ /\ (leq_ pv19_ (minus_ n410_ n1_) /\ (leq_ pv20_ (minus_ n330_ n1_) /\ (leq_ pv1376_ n3_ /\ ((forall A : Universe, ((leq_ n0_ A /\ leq_ A n2_) -> (forall B : Universe, ((leq_ n0_ B /\ leq_ B n3_) -> (a_select3_ simplex7_init_ B A) = init_)))) /\ ((forall C : Universe, ((leq_ n0_ C /\ leq_ C n3_) -> (a_select2_ s_values7_init_ C) = init_)) /\ ((forall D : Universe, ((leq_ n0_ D /\ leq_ D n2_) -> (a_select2_ s_center7_init_ D) = init_)) /\ ((forall E : Universe, ((leq_ n0_ E /\ leq_ E (minus_ n3_ n1_)) -> (a_select2_ s_try7_init_ E) = init_)) /\ (gt_ loopcounter_ n1_ -> (pvar1400_init_ = init_ /\ (pvar1401_init_ = init_ /\ pvar1402_init_ = init_))))))))))))))))))))))) -> (init_ = init_ /\ (s_best7_init_ = init_ /\ (s_sworst7_init_ = init_ /\ (s_worst7_init_ = init_ /\ (leq_ n0_ s_best7_ /\ (leq_ n0_ s_sworst7_ /\ (leq_ n0_ s_worst7_ /\ (leq_ n0_ pv19_ /\ (leq_ n0_ pv20_ /\ (leq_ n0_ pv1376_ /\ (leq_ s_best7_ n3_ /\ (leq_ s_sworst7_ n3_ /\ (leq_ s_worst7_ n3_ /\ (leq_ pv19_ (minus_ n410_ n1_) /\ (leq_ pv20_ (minus_ n330_ n1_) /\ (leq_ pv1376_ n3_ /\ ((forall F : Universe, ((leq_ n0_ F /\ leq_ F n2_) -> (forall G : Universe, ((leq_ n0_ G /\ leq_ G n3_) -> (a_select3_ simplex7_init_ G F) = init_)))) /\ ((forall H : Universe, ((leq_ n0_ H /\ leq_ H n3_) -> (a_select2_ s_values7_init_ H) = init_)) /\ ((forall I : Universe, ((leq_ n0_ I /\ leq_ I n2_) -> (a_select2_ s_center7_init_ I) = init_)) /\ ((forall J : Universe, ((leq_ n0_ J /\ leq_ J (minus_ n3_ n1_)) -> (a_select2_ s_try7_init_ J) = init_)) /\ (gt_ loopcounter_ n1_ -> (pvar1400_init_ = init_ /\ (pvar1401_init_ = init_ /\ pvar1402_init_ = init_)))))))))))))))))))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
