(*
% File     : SWV018+1 : ILTP v1.1.2
% Domain   : Software Verification
% Problem  : Fact 8 of the Neumann-Stubblebine analysis
% Version  : [Wei99] axioms.
% English  : 
% Refs     : [Wei99] Weidenbach (1999), Towards and Automatic Analysis of S
%            [Bau99] Baumgartner (1999), FTP'2000 - Problem Sets
% Source   : [Bau99]
% Names    : Fact 8 [Wei99]
% Status   : CounterSatisfiable
% Rating   : 0.00 v3.1.0, 0.50 v2.7.0, 0.33 v2.6.0, 0.75 v2.5.0, 0.67 v2.4.0
% Status (intuit.) : Unsolved
% Rating (intuit.) : 1.00 v1.1.0
% Syntax   : Number of formulae    :   34 (  14 unit)
%            Number of atoms       :   83 (   0 equality)
%            Maximal formula depth :   12 (   4 average)
%            Number of connectives :   51 (   2 ~  ;   0  |;  32  &)
%                                         (   0 <=>;  17 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   13 (   0 propositional; 1-1 arity)
%            Number of functors    :   17 (   7 constant; 0-4 arity)
%            Number of variables   :   59 (   0 singleton;  56 !;   3 ?)
%            Maximal term depth    :    6 (   2 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable t_holds_ : Universe -> Prop.
Variable party_of_protocol_ : Universe -> Prop.
Variable message_ : Universe -> Prop.
Variable intruder_message_ : Universe -> Prop.
Variable intruder_holds_ : Universe -> Prop.
Variable fresh_to_b_ : Universe -> Prop.
Variable fresh_intruder_nonce_ : Universe -> Prop.
Variable b_stored_ : Universe -> Prop.
Variable b_holds_ : Universe -> Prop.
Variable a_stored_ : Universe -> Prop.
Variable a_nonce_ : Universe -> Prop.
Variable a_key_ : Universe -> Prop.
Variable a_holds_ : Universe -> Prop.

Variable triple_ : Universe -> Universe -> Universe -> Universe.
Variable t_ : Universe.
Variable sent_ : Universe -> Universe -> Universe -> Universe.
Variable quadruple_ : Universe -> Universe -> Universe -> Universe -> Universe.
Variable pair_ : Universe -> Universe -> Universe.
Variable key_ : Universe -> Universe -> Universe.
Variable generate_key_ : Universe -> Universe.
Variable generate_intruder_nonce_ : Universe -> Universe.
Variable generate_expiration_time_ : Universe -> Universe.
Variable generate_b_nonce_ : Universe -> Universe.
Variable encrypt_ : Universe -> Universe -> Universe.
Variable bt_ : Universe.
Variable b_ : Universe.
Variable at_ : Universe.
Variable an_intruder_nonce_ : Universe.
Variable an_a_nonce_ : Universe.
Variable a_ : Universe.

Variable a_holds_key_at_for_t_1 : a_holds_ (key_ at_ t_).
Variable a_is_party_of_protocol_2 : party_of_protocol_ a_.
Variable a_sent_message_i_to_b_3 : message_ (sent_ a_ b_ (pair_ a_ an_a_nonce_)).
Variable a_stored_message_i_4 : a_stored_ (pair_ b_ an_a_nonce_).
Variable a_forwards_secure_5 : (forall U V W X Y Z : Universe, ((message_ (sent_ t_ a_ (triple_ (encrypt_ (quadruple_ Y Z W V) at_) X U)) /\ a_stored_ (pair_ Y Z)) -> (message_ (sent_ a_ Y (pair_ X (encrypt_ U W))) /\ a_holds_ (key_ W Y)))).
Variable b_hold_key_bt_for_t_6 : b_holds_ (key_ bt_ t_).
Variable b_is_party_of_protocol_7 : party_of_protocol_ b_.
Variable nonce_a_is_fresh_to_b_8 : fresh_to_b_ an_a_nonce_.
Variable b_creates_freash_nonces_in_time_9 : (forall U V : Universe, ((message_ (sent_ U b_ (pair_ U V)) /\ fresh_to_b_ V) -> (message_ (sent_ b_ t_ (triple_ b_ (generate_b_nonce_ V) (encrypt_ (triple_ U V (generate_expiration_time_ V)) bt_))) /\ b_stored_ (pair_ U V)))).
Variable b_accepts_secure_session_key_10 : (forall V X Y : Universe, ((message_ (sent_ X b_ (pair_ (encrypt_ (triple_ X V (generate_expiration_time_ Y)) bt_) (encrypt_ (generate_b_nonce_ Y) V))) /\ (a_key_ V /\ b_stored_ (pair_ X Y))) -> b_holds_ (key_ V X))).
Variable t_holds_key_at_for_a_11 : t_holds_ (key_ at_ a_).
Variable t_holds_key_bt_for_b_12 : t_holds_ (key_ bt_ b_).
Variable t_is_party_of_protocol_13 : party_of_protocol_ t_.
Variable server_t_generates_key_14 : (forall U V W X Y Z X1 : Universe, ((message_ (sent_ U t_ (triple_ U V (encrypt_ (triple_ W X Y) Z))) /\ (t_holds_ (key_ Z U) /\ (t_holds_ (key_ X1 W) /\ a_nonce_ X))) -> message_ (sent_ t_ W (triple_ (encrypt_ (quadruple_ U X (generate_key_ X) Y) X1) (encrypt_ (triple_ W (generate_key_ X) Y) Z) V)))).
Variable intruder_can_record_15 : (forall U V W : Universe, (message_ (sent_ U V W) -> intruder_message_ W)).
Variable intruder_decomposes_pairs_16 : (forall U V : Universe, (intruder_message_ (pair_ U V) -> (intruder_message_ U /\ intruder_message_ V))).
Variable intruder_decomposes_triples_17 : (forall U V W : Universe, (intruder_message_ (triple_ U V W) -> (intruder_message_ U /\ (intruder_message_ V /\ intruder_message_ W)))).
Variable intruder_decomposes_quadruples_18 : (forall U V W X : Universe, (intruder_message_ (quadruple_ U V W X) -> (intruder_message_ U /\ (intruder_message_ V /\ (intruder_message_ W /\ intruder_message_ X))))).
Variable intruder_composes_pairs_19 : (forall U V : Universe, ((intruder_message_ U /\ intruder_message_ V) -> intruder_message_ (pair_ U V))).
Variable intruder_composes_triples_20 : (forall U V W : Universe, ((intruder_message_ U /\ (intruder_message_ V /\ intruder_message_ W)) -> intruder_message_ (triple_ U V W))).
Variable intruder_composes_quadruples_21 : (forall U V W X : Universe, ((intruder_message_ U /\ (intruder_message_ V /\ (intruder_message_ W /\ intruder_message_ X))) -> intruder_message_ (quadruple_ U V W X))).
Variable intruder_interception_22 : (forall U V W : Universe, ((intruder_message_ (encrypt_ U V) /\ (intruder_holds_ (key_ V W) /\ party_of_protocol_ W)) -> intruder_message_ V)).
Variable intruder_message_sent_23 : (forall U V W : Universe, ((intruder_message_ U /\ (party_of_protocol_ V /\ party_of_protocol_ W)) -> message_ (sent_ V W U))).
Variable intruder_holds_key_24 : (forall V W : Universe, ((intruder_message_ V /\ party_of_protocol_ W) -> intruder_holds_ (key_ V W))).
Variable intruder_key_encrypts_25 : (forall U V W : Universe, ((intruder_message_ U /\ (intruder_holds_ (key_ V W) /\ party_of_protocol_ W)) -> intruder_message_ (encrypt_ U V))).
Variable an_a_nonce_is_a_nonce_26 : a_nonce_ an_a_nonce_.
Variable generated_keys_are_not_nonces_27 : (forall U : Universe, ~(a_nonce_ (generate_key_ U))).
Variable generated_times_and_nonces_are_nonces_28 : (forall U : Universe, (a_nonce_ (generate_expiration_time_ U) /\ a_nonce_ (generate_b_nonce_ U))).
Variable nothing_is_a_nonce_and_a_key_29 : (forall U : Universe, ~((a_key_ U /\ a_nonce_ U))).
Variable generated_keys_are_keys_30 : (forall U : Universe, a_key_ (generate_key_ U)).
Variable an_intruder_nonce_is_a_fresh_intruder_nonce_31 : fresh_intruder_nonce_ an_intruder_nonce_.
Variable can_generate_more_fresh_intruder_nonces_32 : (forall U : Universe, (fresh_intruder_nonce_ U -> fresh_intruder_nonce_ (generate_intruder_nonce_ U))).
Variable fresh_intruder_nonces_are_fresh_to_b_33 : (forall U : Universe, (fresh_intruder_nonce_ U -> (fresh_to_b_ U /\ intruder_message_ U))).

Theorem co1_34 : (exists X Y Z : Universe, (intruder_holds_ (key_ X Y) /\ b_holds_ (key_ X Z))).
Proof.
  time hprover.
Qed.

End FOFProblem.
