(*
% File     : SWV011+1 : ILTP v1.1.2
% Domain   : Software Verification
% Problem  : Fact 2 of the Neumann-Stubblebine analysis
% Version  : [Wei99] axioms.
% English  : 
% Refs     : [Wei99] Weidenbach (1999), Towards and Automatic Analysis of S
%            [Bau99] Baumgartner (1999), FTP'2000 - Problem Sets
% Source   : [Bau99]
% Names    : Fact 2 [Wei99]
% Status   : Theorem
% Rating   : 0.00 v2.4.0
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.00 v1.0.0
% Syntax   : Number of formulae    :   17 (  16 unit)
%            Number of atoms       :   18 (   0 equality)
%            Maximal formula depth :    3 (   1 average)
%            Number of connectives :    1 (   0 ~  ;   0  |;   1  &)
%                                         (   0 <=>;   0 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    8 (   0 propositional; 1-1 arity)
%            Number of functors    :   15 (   6 constant; 0-4 arity)
%            Number of variables   :    1 (   0 singleton;   0 !;   1 ?)
%            Maximal term depth    :    6 (   3 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable t_holds_ : Universe -> Prop.
Variable party_of_protocol_ : Universe -> Prop.
Variable message_ : Universe -> Prop.
Variable fresh_to_b_ : Universe -> Prop.
Variable b_stored_ : Universe -> Prop.
Variable b_holds_ : Universe -> Prop.
Variable a_stored_ : Universe -> Prop.
Variable a_holds_ : Universe -> Prop.

Variable triple_ : Universe -> Universe -> Universe -> Universe.
Variable t_ : Universe.
Variable sent_ : Universe -> Universe -> Universe -> Universe.
Variable quadruple_ : Universe -> Universe -> Universe -> Universe -> Universe.
Variable pair_ : Universe -> Universe -> Universe.
Variable key_ : Universe -> Universe -> Universe.
Variable generate_key_ : Universe -> Universe.
Variable generate_expiration_time_ : Universe -> Universe.
Variable generate_b_nonce_ : Universe -> Universe.
Variable encrypt_ : Universe -> Universe -> Universe.
Variable bt_ : Universe.
Variable b_ : Universe.
Variable at_ : Universe.
Variable an_a_nonce_ : Universe.
Variable a_ : Universe.

Variable a_holds_key_at_for_t_1 : a_holds_ (key_ at_ t_).
Variable a_is_party_of_protocol_2 : party_of_protocol_ a_.
Variable a_sent_message_i_to_b_3 : message_ (sent_ a_ b_ (pair_ a_ an_a_nonce_)).
Variable a_stored_message_i_4 : a_stored_ (pair_ b_ an_a_nonce_).
Variable b_hold_key_bt_for_t_5 : b_holds_ (key_ bt_ t_).
Variable b_is_party_of_protocol_6 : party_of_protocol_ b_.
Variable nonce_a_is_fresh_to_b_7 : fresh_to_b_ an_a_nonce_.
Variable t_holds_key_at_for_a_8 : t_holds_ (key_ at_ a_).
Variable t_holds_key_bt_for_b_9 : t_holds_ (key_ bt_ b_).
Variable t_is_party_of_protocol_10 : party_of_protocol_ t_.
Variable ax1_11 : b_holds_ (key_ (generate_key_ an_a_nonce_) a_).
Variable ax2_12 : message_ (sent_ a_ b_ (pair_ (encrypt_ (triple_ a_ (generate_key_ an_a_nonce_) (generate_expiration_time_ an_a_nonce_)) bt_) (encrypt_ (generate_b_nonce_ an_a_nonce_) (generate_key_ an_a_nonce_)))).
Variable ax3_13 : a_holds_ (key_ (generate_key_ an_a_nonce_) b_).
Variable ax4_14 : message_ (sent_ t_ a_ (triple_ (encrypt_ (quadruple_ b_ an_a_nonce_ (generate_key_ an_a_nonce_) (generate_expiration_time_ an_a_nonce_)) at_) (encrypt_ (triple_ a_ (generate_key_ an_a_nonce_) (generate_expiration_time_ an_a_nonce_)) bt_) (generate_b_nonce_ an_a_nonce_))).
Variable ax5_15 : message_ (sent_ b_ t_ (triple_ b_ (generate_b_nonce_ an_a_nonce_) (encrypt_ (triple_ a_ an_a_nonce_ (generate_expiration_time_ an_a_nonce_)) bt_))).
Variable ax6_16 : b_stored_ (pair_ a_ an_a_nonce_).

Theorem co1_17 : (exists U : Universe, (a_holds_ (key_ U b_) /\ b_holds_ (key_ U a_))).
Proof.
  time hprover.
Qed.

End FOFProblem.
