(*
% File     : SWC250+1 : ILTP v1.1.2
% Domain   : Software Creation
% Problem  : cond_pst_pivoted3_x_run_strict_ord_front2
% Version  : [Wei00] axioms.
% English  : Find components in a software library that match a given target
%            specification given in first-order logic. The components are
%            specified in first-order logic as well. The problem represents
%            a test of one library module specification against a target
%            specification.
% Refs     : [Wei00] Weidenbach (2000), Software Reuse of List Functions Ve
%          : [FSS98] Fischer et al. (1998), Deduction-Based Software Compon
% Source   : [Wei00]
% Names    : cond_pst_pivoted3_x_run_strict_ord_front2 [Wei00]
% Status   : Theorem
% Rating   : 0.82 v3.1.0, 0.78 v2.7.0, 0.83 v2.4.0
% Status (intuit.) : Open
% Rating (intuit.) : 1.00 v1.0.0
% Syntax   : Number of formulae    :   96 (   9 unit)
%            Number of atoms       :  422 (  80 equality)
%            Maximal formula depth :   28 (   7 average)
%            Number of connectives :  361 (  35 ~  ;  21  |;  49  &)
%                                         (  26 <=>; 230 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :   20 (   0 propositional; 1-2 arity)
%            Number of functors    :    5 (   1 constant; 0-2 arity)
%            Number of variables   :  216 (   0 singleton; 196 !;  20 ?)
%            Maximal term depth    :    4 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable totalorderedP_ : Universe -> Prop.
Variable totalorderP_ : Universe -> Prop.
Variable strictorderedP_ : Universe -> Prop.
Variable strictorderP_ : Universe -> Prop.
Variable ssList_ : Universe -> Prop.
Variable ssItem_ : Universe -> Prop.
Variable singletonP_ : Universe -> Prop.
Variable segmentP_ : Universe -> Universe -> Prop.
Variable rearsegP_ : Universe -> Universe -> Prop.
Variable neq_ : Universe -> Universe -> Prop.
Variable memberP_ : Universe -> Universe -> Prop.
Variable lt_ : Universe -> Universe -> Prop.
Variable leq_ : Universe -> Universe -> Prop.
Variable gt_ : Universe -> Universe -> Prop.
Variable geq_ : Universe -> Universe -> Prop.
Variable frontsegP_ : Universe -> Universe -> Prop.
Variable equalelemsP_ : Universe -> Prop.
Variable duplicatefreeP_ : Universe -> Prop.
Variable cyclefreeP_ : Universe -> Prop.

Variable tl_ : Universe -> Universe.
Variable nil_ : Universe.
Variable hd_ : Universe -> Universe.
Variable cons_ : Universe -> Universe -> Universe.
Variable app_ : Universe -> Universe -> Universe.

Variable ax1_1 : (forall U : Universe, (ssItem_ U -> (forall V : Universe, (ssItem_ V -> (neq_ U V <-> U <> V))))).
Variable ax2_2 : (exists U : Universe, (ssItem_ U /\ (exists V : Universe, (ssItem_ V /\ U <> V)))).
Variable ax3_3 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssItem_ V -> (memberP_ U V <-> (exists W : Universe, (ssList_ W /\ (exists X : Universe, (ssList_ X /\ (app_ W (cons_ V X)) = U))))))))).
Variable ax4_4 : (forall U : Universe, (ssList_ U -> (singletonP_ U <-> (exists V : Universe, (ssItem_ V /\ (cons_ V nil_) = U))))).
Variable ax5_5 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> (frontsegP_ U V <-> (exists W : Universe, (ssList_ W /\ (app_ V W) = U))))))).
Variable ax6_6 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> (rearsegP_ U V <-> (exists W : Universe, (ssList_ W /\ (app_ W V) = U))))))).
Variable ax7_7 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> (segmentP_ U V <-> (exists W : Universe, (ssList_ W /\ (exists X : Universe, (ssList_ X /\ (app_ (app_ W V) X) = U))))))))).
Variable ax8_8 : (forall U : Universe, (ssList_ U -> (cyclefreeP_ U <-> (forall V : Universe, (ssItem_ V -> (forall W : Universe, (ssItem_ W -> (forall X : Universe, (ssList_ X -> (forall Y : Universe, (ssList_ Y -> (forall Z : Universe, (ssList_ Z -> ((app_ (app_ X (cons_ V Y)) (cons_ W Z)) = U -> ~((leq_ V W /\ leq_ W V)))))))))))))))).
Variable ax9_9 : (forall U : Universe, (ssList_ U -> (totalorderP_ U <-> (forall V : Universe, (ssItem_ V -> (forall W : Universe, (ssItem_ W -> (forall X : Universe, (ssList_ X -> (forall Y : Universe, (ssList_ Y -> (forall Z : Universe, (ssList_ Z -> ((app_ (app_ X (cons_ V Y)) (cons_ W Z)) = U -> (leq_ V W \/ leq_ W V))))))))))))))).
Variable ax10_10 : (forall U : Universe, (ssList_ U -> (strictorderP_ U <-> (forall V : Universe, (ssItem_ V -> (forall W : Universe, (ssItem_ W -> (forall X : Universe, (ssList_ X -> (forall Y : Universe, (ssList_ Y -> (forall Z : Universe, (ssList_ Z -> ((app_ (app_ X (cons_ V Y)) (cons_ W Z)) = U -> (lt_ V W \/ lt_ W V))))))))))))))).
Variable ax11_11 : (forall U : Universe, (ssList_ U -> (totalorderedP_ U <-> (forall V : Universe, (ssItem_ V -> (forall W : Universe, (ssItem_ W -> (forall X : Universe, (ssList_ X -> (forall Y : Universe, (ssList_ Y -> (forall Z : Universe, (ssList_ Z -> ((app_ (app_ X (cons_ V Y)) (cons_ W Z)) = U -> leq_ V W)))))))))))))).
Variable ax12_12 : (forall U : Universe, (ssList_ U -> (strictorderedP_ U <-> (forall V : Universe, (ssItem_ V -> (forall W : Universe, (ssItem_ W -> (forall X : Universe, (ssList_ X -> (forall Y : Universe, (ssList_ Y -> (forall Z : Universe, (ssList_ Z -> ((app_ (app_ X (cons_ V Y)) (cons_ W Z)) = U -> lt_ V W)))))))))))))).
Variable ax13_13 : (forall U : Universe, (ssList_ U -> (duplicatefreeP_ U <-> (forall V : Universe, (ssItem_ V -> (forall W : Universe, (ssItem_ W -> (forall X : Universe, (ssList_ X -> (forall Y : Universe, (ssList_ Y -> (forall Z : Universe, (ssList_ Z -> ((app_ (app_ X (cons_ V Y)) (cons_ W Z)) = U -> V <> W)))))))))))))).
Variable ax14_14 : (forall U : Universe, (ssList_ U -> (equalelemsP_ U <-> (forall V : Universe, (ssItem_ V -> (forall W : Universe, (ssItem_ W -> (forall X : Universe, (ssList_ X -> (forall Y : Universe, (ssList_ Y -> ((app_ X (cons_ V (cons_ W Y))) = U -> V = W)))))))))))).
Variable ax15_15 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> (neq_ U V <-> U <> V))))).
Variable ax16_16 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssItem_ V -> ssList_ (cons_ V U))))).
Variable ax17_17 : ssList_ nil_.
Variable ax18_18 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssItem_ V -> (cons_ V U) <> U)))).
Variable ax19_19 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> (forall W : Universe, (ssItem_ W -> (forall X : Universe, (ssItem_ X -> ((cons_ W U) = (cons_ X V) -> (W = X /\ V = U)))))))))).
Variable ax20_20 : (forall U : Universe, (ssList_ U -> (nil_ = U \/ (exists V : Universe, (ssList_ V /\ (exists W : Universe, (ssItem_ W /\ (cons_ W V) = U))))))).
Variable ax21_21 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssItem_ V -> nil_ <> (cons_ V U))))).
Variable ax22_22 : (forall U : Universe, (ssList_ U -> (nil_ <> U -> ssItem_ (hd_ U)))).
Variable ax23_23 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssItem_ V -> (hd_ (cons_ V U)) = V)))).
Variable ax24_24 : (forall U : Universe, (ssList_ U -> (nil_ <> U -> ssList_ (tl_ U)))).
Variable ax25_25 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssItem_ V -> (tl_ (cons_ V U)) = U)))).
Variable ax26_26 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> ssList_ (app_ U V))))).
Variable ax27_27 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> (forall W : Universe, (ssItem_ W -> (cons_ W (app_ V U)) = (app_ (cons_ W V) U))))))).
Variable ax28_28 : (forall U : Universe, (ssList_ U -> (app_ nil_ U) = U)).
Variable ax29_29 : (forall U : Universe, (ssItem_ U -> (forall V : Universe, (ssItem_ V -> ((leq_ U V /\ leq_ V U) -> U = V))))).
Variable ax30_30 : (forall U : Universe, (ssItem_ U -> (forall V : Universe, (ssItem_ V -> (forall W : Universe, (ssItem_ W -> ((leq_ U V /\ leq_ V W) -> leq_ U W))))))).
Variable ax31_31 : (forall U : Universe, (ssItem_ U -> leq_ U U)).
Variable ax32_32 : (forall U : Universe, (ssItem_ U -> (forall V : Universe, (ssItem_ V -> (geq_ U V <-> leq_ V U))))).
Variable ax33_33 : (forall U : Universe, (ssItem_ U -> (forall V : Universe, (ssItem_ V -> (lt_ U V -> ~(lt_ V U)))))).
Variable ax34_34 : (forall U : Universe, (ssItem_ U -> (forall V : Universe, (ssItem_ V -> (forall W : Universe, (ssItem_ W -> ((lt_ U V /\ lt_ V W) -> lt_ U W))))))).
Variable ax35_35 : (forall U : Universe, (ssItem_ U -> (forall V : Universe, (ssItem_ V -> (gt_ U V <-> lt_ V U))))).
Variable ax36_36 : (forall U : Universe, (ssItem_ U -> (forall V : Universe, (ssList_ V -> (forall W : Universe, (ssList_ W -> (memberP_ (app_ V W) U <-> (memberP_ V U \/ memberP_ W U)))))))).
Variable ax37_37 : (forall U : Universe, (ssItem_ U -> (forall V : Universe, (ssItem_ V -> (forall W : Universe, (ssList_ W -> (memberP_ (cons_ V W) U <-> (U = V \/ memberP_ W U)))))))).
Variable ax38_38 : (forall U : Universe, (ssItem_ U -> ~(memberP_ nil_ U))).
Variable ax39_39 : ~(singletonP_ nil_).
Variable ax40_40 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> (forall W : Universe, (ssList_ W -> ((frontsegP_ U V /\ frontsegP_ V W) -> frontsegP_ U W))))))).
Variable ax41_41 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> ((frontsegP_ U V /\ frontsegP_ V U) -> U = V))))).
Variable ax42_42 : (forall U : Universe, (ssList_ U -> frontsegP_ U U)).
Variable ax43_43 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> (forall W : Universe, (ssList_ W -> (frontsegP_ U V -> frontsegP_ (app_ U W) V))))))).
Variable ax44_44 : (forall U : Universe, (ssItem_ U -> (forall V : Universe, (ssItem_ V -> (forall W : Universe, (ssList_ W -> (forall X : Universe, (ssList_ X -> (frontsegP_ (cons_ U W) (cons_ V X) <-> (U = V /\ frontsegP_ W X)))))))))).
Variable ax45_45 : (forall U : Universe, (ssList_ U -> frontsegP_ U nil_)).
Variable ax46_46 : (forall U : Universe, (ssList_ U -> (frontsegP_ nil_ U <-> nil_ = U))).
Variable ax47_47 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> (forall W : Universe, (ssList_ W -> ((rearsegP_ U V /\ rearsegP_ V W) -> rearsegP_ U W))))))).
Variable ax48_48 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> ((rearsegP_ U V /\ rearsegP_ V U) -> U = V))))).
Variable ax49_49 : (forall U : Universe, (ssList_ U -> rearsegP_ U U)).
Variable ax50_50 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> (forall W : Universe, (ssList_ W -> (rearsegP_ U V -> rearsegP_ (app_ W U) V))))))).
Variable ax51_51 : (forall U : Universe, (ssList_ U -> rearsegP_ U nil_)).
Variable ax52_52 : (forall U : Universe, (ssList_ U -> (rearsegP_ nil_ U <-> nil_ = U))).
Variable ax53_53 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> (forall W : Universe, (ssList_ W -> ((segmentP_ U V /\ segmentP_ V W) -> segmentP_ U W))))))).
Variable ax54_54 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> ((segmentP_ U V /\ segmentP_ V U) -> U = V))))).
Variable ax55_55 : (forall U : Universe, (ssList_ U -> segmentP_ U U)).
Variable ax56_56 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> (forall W : Universe, (ssList_ W -> (forall X : Universe, (ssList_ X -> (segmentP_ U V -> segmentP_ (app_ (app_ W U) X) V))))))))).
Variable ax57_57 : (forall U : Universe, (ssList_ U -> segmentP_ U nil_)).
Variable ax58_58 : (forall U : Universe, (ssList_ U -> (segmentP_ nil_ U <-> nil_ = U))).
Variable ax59_59 : (forall U : Universe, (ssItem_ U -> cyclefreeP_ (cons_ U nil_))).
Variable ax60_60 : cyclefreeP_ nil_.
Variable ax61_61 : (forall U : Universe, (ssItem_ U -> totalorderP_ (cons_ U nil_))).
Variable ax62_62 : totalorderP_ nil_.
Variable ax63_63 : (forall U : Universe, (ssItem_ U -> strictorderP_ (cons_ U nil_))).
Variable ax64_64 : strictorderP_ nil_.
Variable ax65_65 : (forall U : Universe, (ssItem_ U -> totalorderedP_ (cons_ U nil_))).
Variable ax66_66 : totalorderedP_ nil_.
Variable ax67_67 : (forall U : Universe, (ssItem_ U -> (forall V : Universe, (ssList_ V -> (totalorderedP_ (cons_ U V) <-> (nil_ = V \/ (nil_ <> V /\ (totalorderedP_ V /\ leq_ U (hd_ V))))))))).
Variable ax68_68 : (forall U : Universe, (ssItem_ U -> strictorderedP_ (cons_ U nil_))).
Variable ax69_69 : strictorderedP_ nil_.
Variable ax70_70 : (forall U : Universe, (ssItem_ U -> (forall V : Universe, (ssList_ V -> (strictorderedP_ (cons_ U V) <-> (nil_ = V \/ (nil_ <> V /\ (strictorderedP_ V /\ lt_ U (hd_ V))))))))).
Variable ax71_71 : (forall U : Universe, (ssItem_ U -> duplicatefreeP_ (cons_ U nil_))).
Variable ax72_72 : duplicatefreeP_ nil_.
Variable ax73_73 : (forall U : Universe, (ssItem_ U -> equalelemsP_ (cons_ U nil_))).
Variable ax74_74 : equalelemsP_ nil_.
Variable ax75_75 : (forall U : Universe, (ssList_ U -> (nil_ <> U -> (exists V : Universe, (ssItem_ V /\ (hd_ U) = V))))).
Variable ax76_76 : (forall U : Universe, (ssList_ U -> (nil_ <> U -> (exists V : Universe, (ssList_ V /\ (tl_ U) = V))))).
Variable ax77_77 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> ((nil_ <> V /\ (nil_ <> U /\ ((hd_ V) = (hd_ U) /\ (tl_ V) = (tl_ U)))) -> V = U))))).
Variable ax78_78 : (forall U : Universe, (ssList_ U -> (nil_ <> U -> (cons_ (hd_ U) (tl_ U)) = U))).
Variable ax79_79 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> (forall W : Universe, (ssList_ W -> ((app_ W V) = (app_ U V) -> W = U))))))).
Variable ax80_80 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> (forall W : Universe, (ssList_ W -> ((app_ V W) = (app_ V U) -> W = U))))))).
Variable ax81_81 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssItem_ V -> (cons_ V U) = (app_ (cons_ V nil_) U))))).
Variable ax82_82 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> (forall W : Universe, (ssList_ W -> (app_ (app_ U V) W) = (app_ U (app_ V W)))))))).
Variable ax83_83 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> (nil_ = (app_ U V) <-> (nil_ = V /\ nil_ = U)))))).
Variable ax84_84 : (forall U : Universe, (ssList_ U -> (app_ U nil_) = U)).
Variable ax85_85 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> (nil_ <> U -> (hd_ (app_ U V)) = (hd_ U)))))).
Variable ax86_86 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> (nil_ <> U -> (tl_ (app_ U V)) = (app_ (tl_ U) V)))))).
Variable ax87_87 : (forall U : Universe, (ssItem_ U -> (forall V : Universe, (ssItem_ V -> ((geq_ U V /\ geq_ V U) -> U = V))))).
Variable ax88_88 : (forall U : Universe, (ssItem_ U -> (forall V : Universe, (ssItem_ V -> (forall W : Universe, (ssItem_ W -> ((geq_ U V /\ geq_ V W) -> geq_ U W))))))).
Variable ax89_89 : (forall U : Universe, (ssItem_ U -> geq_ U U)).
Variable ax90_90 : (forall U : Universe, (ssItem_ U -> ~(lt_ U U))).
Variable ax91_91 : (forall U : Universe, (ssItem_ U -> (forall V : Universe, (ssItem_ V -> (forall W : Universe, (ssItem_ W -> ((leq_ U V /\ lt_ V W) -> lt_ U W))))))).
Variable ax92_92 : (forall U : Universe, (ssItem_ U -> (forall V : Universe, (ssItem_ V -> (leq_ U V -> (U = V \/ lt_ U V)))))).
Variable ax93_93 : (forall U : Universe, (ssItem_ U -> (forall V : Universe, (ssItem_ V -> (lt_ U V <-> (U <> V /\ leq_ U V)))))).
Variable ax94_94 : (forall U : Universe, (ssItem_ U -> (forall V : Universe, (ssItem_ V -> (gt_ U V -> ~(gt_ V U)))))).
Variable ax95_95 : (forall U : Universe, (ssItem_ U -> (forall V : Universe, (ssItem_ V -> (forall W : Universe, (ssItem_ W -> ((gt_ U V /\ gt_ V W) -> gt_ U W))))))).

Theorem co1_96 : (forall U : Universe, (ssList_ U -> (forall V : Universe, (ssList_ V -> (forall W : Universe, (ssList_ W -> (forall X : Universe, (~(ssList_ X) \/ (V <> X \/ (U <> W \/ (nil_ = U \/ ((exists Y : Universe, (ssItem_ Y /\ (exists Z : Universe, (ssList_ Z /\ (exists X1 : Universe, (ssList_ X1 /\ ((app_ (app_ Z (cons_ Y nil_)) X1) = U /\ (forall X2 : Universe, (~(ssItem_ X2) \/ (~(memberP_ Z X2) \/ (~(memberP_ X1 X2) \/ (~(lt_ Y X2) \/ leq_ Y X2)))))))))))) \/ ((forall X3 : Universe, (~(ssList_ X3) \/ ((app_ W X3) <> X \/ (~(strictorderedP_ W) \/ (exists X4 : Universe, (ssItem_ X4 /\ (exists X5 : Universe, (ssList_ X5 /\ ((app_ (cons_ X4 nil_) X5) = X3 /\ (exists X6 : Universe, (ssItem_ X6 /\ (exists X7 : Universe, (ssList_ X7 /\ ((app_ X7 (cons_ X6 nil_)) = W /\ lt_ X6 X4)))))))))))))) \/ (nil_ <> X /\ nil_ = W)))))))))))))).
Proof.
  time hprover.
Qed.

End FOFProblem.
