(*
% File     : SET767+4 : ILTP v1.1.2
% Domain   : Set Theory (Equivalence relations)
% Problem  : Equivalence classes on E are power_set E 
% Version  : [Pas99] axioms.
% English  :
% Refs     : [Pas99] Pastre (1999), Email to G. Sutcliffe
% Source   : [Pas99]
% Names    :
% Status   : Theorem
% Rating   : 0.36 v3.1.0, 0.33 v2.7.0, 0.17 v2.6.0, 0.29 v2.5.0, 0.38 v2.4.0, 0.25 v2.3.0, 0.00 v2.2.1
% Status (intuit.) : Theorem
% Rating (intuit.) : 0.75 v1.0.0
% Syntax   : Number of formulae    :   17 (   1 unit)
%            Number of atoms       :   70 (   4 equality)
%            Maximal formula depth :   12 (   7 average)
%            Number of connectives :   56 (   3 ~  ;   2  |;  21  &)
%                                         (  15 <=>;  15 =>;   0 <=)
%                                         (   0 <~>;   0 ~|;   0 ~&)
%            Number of predicates  :    9 (   0 propositional; 2-3 arity)
%            Number of functors    :   10 (   1 constant; 0-3 arity)
%            Number of variables   :   60 (   0 singleton;  56 !;   4 ?)
%            Maximal term depth    :    2 (   1 average)
% Comments : 
*)

From Hammer Require Import Tactics.

Section FOFProblem.

Variable Universe : Set.
Variable UniverseElement : Universe.

Variable subset_ : Universe -> Universe -> Prop.
Variable pre_order_ : Universe -> Universe -> Prop.
Variable partition_ : Universe -> Universe -> Prop.
Variable member_ : Universe -> Universe -> Prop.
Variable equivalence_ : Universe -> Universe -> Prop.
Variable equal_set_ : Universe -> Universe -> Prop.
Variable disjoint_ : Universe -> Universe -> Prop.
Variable apply_ : Universe -> Universe -> Universe -> Prop.

Variable unordered_pair_ : Universe -> Universe -> Universe.
Variable union_ : Universe -> Universe -> Universe.
Variable sum_ : Universe -> Universe.
Variable singleton_ : Universe -> Universe.
Variable product_ : Universe -> Universe.
Variable power_set_ : Universe -> Universe.
Variable intersection_ : Universe -> Universe -> Universe.
Variable equivalence_class_ : Universe -> Universe -> Universe -> Universe.
Variable empty_set_ : Universe.
Variable difference_ : Universe -> Universe -> Universe.

Variable subset_1 : (forall A B : Universe, (subset_ A B <-> (forall X : Universe, (member_ X A -> member_ X B)))).
Variable equal_set_2 : (forall A B : Universe, (equal_set_ A B <-> (subset_ A B /\ subset_ B A))).
Variable power_set_3 : (forall X A : Universe, (member_ X (power_set_ A) <-> subset_ X A)).
Variable intersection_4 : (forall X A B : Universe, (member_ X (intersection_ A B) <-> (member_ X A /\ member_ X B))).
Variable union_5 : (forall X A B : Universe, (member_ X (union_ A B) <-> (member_ X A \/ member_ X B))).
Variable empty_set_6 : (forall X : Universe, ~(member_ X empty_set_)).
Variable difference_7 : (forall B A E : Universe, (member_ B (difference_ E A) <-> (member_ B E /\ ~(member_ B A)))).
Variable singleton_8 : (forall X A : Universe, (member_ X (singleton_ A) <-> X = A)).
Variable unordered_pair_9 : (forall X A B : Universe, (member_ X (unordered_pair_ A B) <-> (X = A \/ X = B))).
Variable sum_10 : (forall X A : Universe, (member_ X (sum_ A) <-> (exists Y : Universe, (member_ Y A /\ member_ X Y)))).
Variable product_11 : (forall X A : Universe, (member_ X (product_ A) <-> (forall Y : Universe, (member_ Y A -> member_ X Y)))).
Variable disjoint_12 : (forall A B : Universe, (disjoint_ A B <-> ~((exists X : Universe, (member_ X A /\ member_ X B))))).
Variable partition_13 : (forall A E : Universe, (partition_ A E <-> ((forall X : Universe, (member_ X A -> subset_ X E)) /\ ((forall X : Universe, (member_ X E -> (exists Y : Universe, (member_ Y A /\ member_ X Y)))) /\ (forall X Y : Universe, ((member_ X A /\ member_ Y A) -> ((exists Z : Universe, (member_ Z X /\ member_ Z Y)) -> X = Y))))))).
Variable equivalence_14 : (forall A R : Universe, (equivalence_ R A <-> ((forall X : Universe, (member_ X A -> apply_ R X X)) /\ ((forall X Y : Universe, ((member_ X A /\ member_ Y A) -> (apply_ R X Y -> apply_ R Y X))) /\ (forall X Y Z : Universe, ((member_ X A /\ (member_ Y A /\ member_ Z A)) -> ((apply_ R X Y /\ apply_ R Y Z) -> apply_ R X Z))))))).
Variable equivalence_class_15 : (forall R E A X : Universe, (member_ X (equivalence_class_ A E R) <-> (member_ X E /\ apply_ R A X))).
Variable pre_order_16 : (forall R E : Universe, (pre_order_ R E <-> ((forall X : Universe, (member_ X E -> apply_ R X X)) /\ (forall X Y Z : Universe, ((member_ X E /\ (member_ Y E /\ member_ Z E)) -> ((apply_ R X Y /\ apply_ R Y Z) -> apply_ R X Z)))))).

Theorem thIII03_17 : (forall E R A : Universe, (equivalence_ R E -> subset_ (equivalence_class_ A E R) E)).
Proof.
  time hprover.
Qed.

End FOFProblem.
